/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutEvent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.VisualState;
import org.openide.util.ImageUtilities;

public class LayoutPainter
implements LayoutConstants {
    private LayoutModel layoutModel;
    private VisualState visualState;
    private Map<LayoutComponent, Collection<VisualState.GapInfo>> paintedGaps;
    private boolean rootSelection;
    private Collection<LayoutComponent> componentsOfPaintedGaps;
    private Image linkBadgeBoth = null;
    private Image linkBadgeHorizontal = null;
    private Image linkBadgeVertical = null;
    private static final int BOTH_DIMENSIONS = 2;
    private Image warningImage;
    private static boolean PAINT_RES_GAP_MIN_SIZE;
    private static final Color[] HANDLE_COLORS;
    private static final int HANDLE_WIDTH;
    private static Color fixedGapColor;
    private static Color resGapColor;
    private static Color minGapColor;
    private static Color gapBorderColor;
    private static Color sawColor;

    LayoutPainter(LayoutModel layoutModel, VisualState visualState) {
        this.layoutModel = layoutModel;
        this.visualState = visualState;
        layoutModel.addListener(new LayoutModel.Listener(){

            @Override
            public void layoutChanged(LayoutEvent ev) {
                int type = ev.getType();
                if (type != 7 && type != 13) {
                    if (LayoutPainter.this.paintedGaps != null) {
                        LayoutPainter.this.paintedGaps.clear();
                    }
                    LayoutPainter.this.componentsOfPaintedGaps = null;
                }
            }
        });
    }

    void paintComponents(Graphics2D g, Collection<LayoutComponent> selectedComponents, boolean paintAlignment) {
        Shape originalClip = g.getClip();
        LayoutComponent parent = null;
        for (LayoutComponent comp : selectedComponents) {
            if (this.isDesignRootSelected(comp)) continue;
            if (paintAlignment) {
                if (comp.getParent() != parent) {
                    Shape clip;
                    if (parent != null) {
                        g.setClip(originalClip);
                    }
                    if ((clip = this.visualState.getComponentVisibilityClip(parent = comp.getParent())) != null) {
                        g.clip(clip);
                    }
                }
                this.paintSelectedComponent(g, comp, 0);
                this.paintSelectedComponent(g, comp, 1);
            }
            if (!LayoutComponent.isUnplacedComponent(comp)) continue;
            this.paintUnplacedWarningImage(g, comp);
        }
        if (parent != null) {
            g.setClip(originalClip);
        }
    }

    private void paintSelectedComponent(Graphics2D g, LayoutComponent component, int dimension) {
        LayoutInterval interval = component.getLayoutInterval(dimension);
        if (component.isLinkSized(0) || component.isLinkSized(1)) {
            this.paintLinks(g, component);
        }
        if (interval.getAlignment() == 3) {
            LayoutInterval alignedParent = interval.getParent();
            int oppDimension = dimension == 0 ? 1 : 0;
            LayoutRegion region = alignedParent.getCurrentSpace();
            int x = region.positions[dimension][3];
            int y1 = region.positions[oppDimension][0];
            int y2 = region.positions[oppDimension][1];
            if (y1 != Integer.MIN_VALUE && y2 != Integer.MIN_VALUE) {
                if (dimension == 0) {
                    g.drawLine(x, y1, x, y2);
                } else {
                    g.drawLine(y1, x, y2, x);
                }
            }
        }
        int lastAlignment = -1;
        while (interval.getParent() != null) {
            int alignment;
            LayoutInterval parent = interval.getParent();
            if (parent.getType() == 102) {
                int end;
                alignment = LayoutInterval.getEffectiveAlignment(interval);
                int index = parent.indexOf(interval);
                block0 : switch (alignment) {
                    case 0: {
                        int start = 0;
                        end = index;
                        lastAlignment = 0;
                        break;
                    }
                    case 1: {
                        int start = index + 1;
                        end = parent.getSubIntervalCount();
                        lastAlignment = 1;
                        break;
                    }
                    default: {
                        int start;
                        switch (lastAlignment) {
                            case 0: {
                                start = 0;
                                end = index;
                                break block0;
                            }
                            case 1: {
                                start = index + 1;
                                end = parent.getSubIntervalCount();
                                break block0;
                            }
                        }
                        start = 0;
                        end = parent.getSubIntervalCount();
                    }
                }
                for (int i = start; i < end; ++i) {
                    LayoutInterval candidate = parent.getSubInterval(i);
                    if (!candidate.isEmptySpace()) continue;
                    this.paintAlignment(g, candidate, dimension, LayoutInterval.getEffectiveAlignment(candidate));
                }
            } else {
                alignment = interval.getAlignment();
                if (!LayoutInterval.wantResizeInLayout(interval)) {
                    lastAlignment = alignment;
                }
                this.paintAlignment(g, interval, dimension, lastAlignment);
            }
            interval = interval.getParent();
        }
    }

    private void paintUnplacedWarningImage(Graphics2D g, LayoutComponent comp) {
        LayoutRegion region = comp.getCurrentSpace();
        Rectangle rect = region.toRectangle(new Rectangle());
        Image image = this.getWarningImage();
        g.drawImage(image, rect.x + rect.width - image.getWidth(null), rect.y, null);
    }

    private Image getWarningImage() {
        if (this.warningImage == null) {
            this.warningImage = ImageUtilities.loadImage((String)"org/netbeans/modules/form/layoutsupport/resources/warning.png");
        }
        return this.warningImage;
    }

    private void paintLinks(Graphics2D g, LayoutComponent component) {
        if (component.isLinkSized(0) && component.isLinkSized(1)) {
            int i;
            Map<Integer, List<String>> linkGroupsH = this.layoutModel.getLinkSizeGroups(0);
            Map<Integer, List<String>> linkGroupsV = this.layoutModel.getLinkSizeGroups(1);
            Integer linkIdH = new Integer(component.getLinkSizeId(0));
            Integer linkIdV = new Integer(component.getLinkSizeId(1));
            List<String> lH = linkGroupsH.get(linkIdH);
            List<String> lV = linkGroupsV.get(linkIdV);
            HashSet<String> merged = new HashSet<String>();
            for (i = 0; i < lH.size(); ++i) {
                merged.add(lH.get(i));
            }
            for (i = 0; i < lV.size(); ++i) {
                merged.add(lV.get(i));
            }
            for (String id : merged) {
                LayoutComponent lc = this.layoutModel.getLayoutComponent(id);
                LayoutInterval interval = lc.getLayoutInterval(0);
                LayoutRegion region = interval.getCurrentSpace();
                Image badge = null;
                if (lV.contains(id) && lH.contains(id)) {
                    badge = this.getLinkBadge(2);
                } else {
                    if (lH.contains(lc.getId())) {
                        badge = this.getLinkBadge(0);
                    }
                    if (lV.contains(lc.getId())) {
                        badge = this.getLinkBadge(1);
                    }
                }
                int x = region.positions[0][1] - region.size(0) / 4 - badge.getWidth(null) / 2;
                int y = region.positions[1][0] - badge.getHeight(null);
                g.drawImage(badge, x, y, null);
            }
        } else {
            int dimension = component.isLinkSized(0) ? 0 : 1;
            Map<Integer, List<String>> map = this.layoutModel.getLinkSizeGroups(dimension);
            Integer linkId = new Integer(component.getLinkSizeId(dimension));
            List<String> l = map.get(linkId);
            for (String id : l) {
                LayoutComponent lc = this.layoutModel.getLayoutComponent(id);
                LayoutInterval interval = lc.getLayoutInterval(dimension);
                LayoutRegion region = interval.getCurrentSpace();
                Image badge = this.getLinkBadge(dimension);
                int x = region.positions[0][1] - region.size(0) / 4 - badge.getWidth(null) / 2;
                int y = region.positions[1][0] - badge.getHeight(null);
                g.drawImage(badge, x, y, null);
            }
        }
    }

    private Image getLinkBadge(int dimension) {
        if (dimension == 2) {
            if (this.linkBadgeBoth == null) {
                this.linkBadgeBoth = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/sameboth.png");
            }
            return this.linkBadgeBoth;
        }
        if (dimension == 0) {
            if (this.linkBadgeHorizontal == null) {
                this.linkBadgeHorizontal = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/samewidth.png");
            }
            return this.linkBadgeHorizontal;
        }
        if (dimension == 1) {
            if (this.linkBadgeVertical == null) {
                this.linkBadgeVertical = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/sameheight.png");
            }
            return this.linkBadgeVertical;
        }
        return null;
    }

    private void paintAlignment(Graphics2D g, LayoutInterval interval, int dimension, int alignment) {
        int y;
        int x2;
        int x1;
        int opposite;
        LayoutInterval parent = interval.getParent();
        boolean baseline = parent.isParallel() && parent.getGroupAlignment() == 3;
        LayoutRegion group = parent.getCurrentSpace();
        int n = opposite = dimension == 0 ? 1 : 0;
        if (interval.isEmptySpace()) {
            boolean x2group;
            int[] yb;
            boolean x1group;
            int[] ya;
            int index = parent.indexOf(interval);
            if (index == 0) {
                x1 = group.positions[dimension][baseline ? 3 : 0];
                ya = this.visualIntervalPosition(parent, opposite, 0);
                x1group = LayoutInterval.getFirstParent(interval, 103).getParent() != null;
            } else {
                LayoutInterval x1int = parent.getSubInterval(index - 1);
                if (x1int.isParallel() && x1int.getGroupAlignment() == 3) {
                    x1 = x1int.getCurrentSpace().positions[dimension][3];
                } else {
                    if (x1int.isEmptySpace()) {
                        return;
                    }
                    x1 = x1int.getCurrentSpace().positions[dimension][1];
                }
                ya = this.visualIntervalPosition(x1int, opposite, 1);
                x1group = x1int.isGroup();
            }
            if (index + 1 == parent.getSubIntervalCount()) {
                x2 = group.positions[dimension][baseline ? 3 : 1];
                yb = this.visualIntervalPosition(parent, opposite, 1);
                x2group = LayoutInterval.getFirstParent(interval, 103).getParent() != null;
            } else {
                LayoutInterval x2int = parent.getSubInterval(index + 1);
                if (x2int.isParallel() && x2int.getGroupAlignment() == 3) {
                    x2 = x2int.getCurrentSpace().positions[dimension][3];
                } else {
                    if (x2int.isEmptySpace()) {
                        return;
                    }
                    x2 = x2int.getCurrentSpace().positions[dimension][0];
                }
                yb = this.visualIntervalPosition(x2int, opposite, 0);
                x2group = x2int.isGroup();
            }
            if (x1 == Integer.MIN_VALUE || x2 == Integer.MIN_VALUE) {
                return;
            }
            int y1 = Math.min(ya[1], yb[1]);
            int y2 = Math.max(ya[0], yb[0]);
            y = (y1 + y2) / 2;
            if (ya[1] < yb[0] || yb[1] < ya[0]) {
                if (dimension == 0) {
                    g.drawLine(x1, ya[0], x1, y);
                    g.drawLine(x1, ya[0], x1, ya[1]);
                    g.drawLine(x2, yb[0], x2, y);
                    g.drawLine(x2, yb[0], x2, yb[1]);
                } else {
                    g.drawLine(ya[0], x1, y, x1);
                    g.drawLine(ya[0], x1, ya[1], x1);
                    g.drawLine(yb[0], x2, y, x2);
                    g.drawLine(yb[0], x2, yb[1], x2);
                }
            } else if (dimension == 0) {
                if (x1group) {
                    g.drawLine(x1, ya[0], x1, ya[1]);
                }
                if (x2group) {
                    g.drawLine(x2, yb[0], x2, yb[1]);
                }
            } else {
                if (x1group) {
                    g.drawLine(ya[0], x1, ya[1], x1);
                }
                if (x2group) {
                    g.drawLine(yb[0], x2, yb[1], x2);
                }
            }
        } else {
            LayoutRegion child = interval.getCurrentSpace();
            if (alignment == 0 || alignment == 1) {
                x1 = group.positions[dimension][baseline ? 3 : alignment];
                x2 = interval.isParallel() && interval.getAlignment() == 3 ? child.positions[dimension][3] : child.positions[dimension][alignment];
            } else {
                return;
            }
            if (x1 == Integer.MIN_VALUE || x2 == Integer.MIN_VALUE) {
                return;
            }
            int[] pos = this.visualIntervalPosition(parent, opposite, alignment);
            y = (pos[0] + pos[1]) / 2;
            int xa = group.positions[dimension][0];
            int xb = group.positions[dimension][1];
            if (parent.getParent() != null) {
                if (dimension == 0) {
                    if (alignment == 0) {
                        g.drawLine(xa, pos[0], xa, pos[1]);
                    } else if (alignment == 1) {
                        g.drawLine(xb, pos[0], xb, pos[1]);
                    }
                } else if (alignment == 0) {
                    g.drawLine(pos[0], xa, pos[1], xa);
                } else if (alignment == 1) {
                    g.drawLine(pos[0], xb, pos[1], xb);
                }
            }
        }
        if (x2 - x1 > 1 && Math.abs(y) <= Short.MAX_VALUE && Math.abs(x1) <= Short.MAX_VALUE && Math.abs(x2) <= Short.MAX_VALUE) {
            int angle;
            int x;
            if (alignment == 0) {
                x = x1;
                angle = 180;
            } else {
                x = x2;
                angle = 0;
            }
            int diam = Math.min(4, --x2 - x1);
            BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 1.0f}, 0.0f);
            Stroke oldStroke = g.getStroke();
            g.setStroke(stroke);
            if (dimension == 0) {
                g.drawLine(x1, y, x2, y);
                angle += 90;
            } else {
                g.drawLine(y, x1, y, x2);
                int temp = x;
                x = y;
                y = temp;
            }
            g.setStroke(oldStroke);
            if (alignment == 0 || alignment == 1) {
                Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.fillArc(x - diam, y - diam, 2 * diam, 2 * diam, angle, 180);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
            }
        }
    }

    private int[] visualIntervalPosition(LayoutInterval interval, int dimension, int alignment) {
        int min = Short.MAX_VALUE;
        int max = Short.MIN_VALUE;
        if (interval.isParallel() && interval.getGroupAlignment() != 3) {
            Iterator<LayoutInterval> iter = interval.getSubIntervals();
            while (iter.hasNext()) {
                int imax;
                int imin;
                int oppDim;
                LayoutInterval subInterval = iter.next();
                int n = oppDim = dimension == 0 ? 1 : 0;
                if (LayoutInterval.isPlacedAtBorder(subInterval, oppDim, alignment)) {
                    if (subInterval.isParallel()) {
                        int[] ipos = this.visualIntervalPosition(subInterval, dimension, alignment);
                        imin = ipos[0];
                        imax = ipos[1];
                    } else if (!subInterval.isEmptySpace()) {
                        LayoutRegion region = subInterval.getCurrentSpace();
                        imin = region.positions[dimension][0];
                        imax = region.positions[dimension][1];
                    } else {
                        imin = min;
                        imax = max;
                    }
                } else {
                    imin = min;
                    imax = max;
                }
                if (min > imin) {
                    min = imin;
                }
                if (max >= imax) continue;
                max = imax;
            }
        }
        if (!interval.isParallel() || min == Short.MAX_VALUE) {
            LayoutRegion region = interval.getCurrentSpace();
            min = region.positions[dimension][0];
            max = region.positions[dimension][1];
        }
        return new int[]{min, max};
    }

    Collection<VisualState.GapInfo> getPaintedGapsForContainer(LayoutComponent container) {
        return this.paintedGaps != null ? this.paintedGaps.get(container) : null;
    }

    void paintGaps(Graphics2D g, Collection<LayoutComponent> selectedComponents, VisualState.GapInfo selectedGap) {
        boolean newGaps;
        if (selectedComponents == null || selectedComponents.isEmpty()) {
            if (this.paintedGaps != null) {
                this.paintedGaps.clear();
            }
            this.rootSelection = false;
            this.componentsOfPaintedGaps = null;
            return;
        }
        LayoutComponent parent = null;
        boolean root = true;
        for (LayoutComponent selComp : selectedComponents) {
            if (this.isDesignRootSelected(selComp)) continue;
            root = false;
            break;
        }
        if (newGaps = this.newGapsForNewSelection(selectedComponents, selectedGap, root)) {
            this.rootSelection = root;
            if (this.paintedGaps == null) {
                this.paintedGaps = new HashMap<LayoutComponent, Collection<VisualState.GapInfo>>();
            } else {
                this.paintedGaps.clear();
            }
            this.componentsOfPaintedGaps = new ArrayList<LayoutComponent>(selectedComponents);
        }
        for (LayoutComponent comp : this.componentsOfPaintedGaps) {
            Collection<VisualState.GapInfo> gaps;
            if (!this.rootSelection && parent == null) {
                parent = comp.getParent();
            }
            if (!comp.isLayoutContainer() || (gaps = this.visualState.getContainerGaps(comp)) == null) continue;
            for (VisualState.GapInfo gapInfo : gaps) {
                if (!newGaps && gapInfo.paintRect != null) break;
                LayoutPainter.setPaintRectForGap(gapInfo);
            }
            if (this.paintedGaps.get(comp) == null) {
                this.paintedGaps.put(comp, gaps);
            }
            if (!selectedComponents.contains(comp)) continue;
            this.paintGapsInContainer(g, comp, gaps, selectedGap, null);
        }
        if (parent != null) {
            LinkedList<VisualState.GapInfo> cached = this.paintedGaps.get(parent);
            LinkedList<VisualState.GapInfo> gaps = cached != null ? cached : new LinkedList<VisualState.GapInfo>();
            HashMap<LayoutInterval, VisualState.GapInfo> gapMap = null;
            for (LayoutComponent comp : this.componentsOfPaintedGaps) {
                boolean cachedUpToDate = false;
                for (VisualState.GapInfo gapInfo : this.visualState.getComponentGaps(comp)) {
                    VisualState.GapInfo paintRep;
                    if (cached != null && gapInfo.paintRect != null) {
                        cachedUpToDate = true;
                        break;
                    }
                    LayoutPainter.setPaintRectForGap(gapInfo);
                    VisualState.GapInfo gapInfo2 = paintRep = gapMap != null ? (VisualState.GapInfo)gapMap.get(gapInfo.gap) : null;
                    if (paintRep != null) {
                        LayoutPainter.expandOrtPaintRect(paintRep, gapInfo);
                        continue;
                    }
                    if (gapMap == null) {
                        gapMap = new HashMap<LayoutInterval, VisualState.GapInfo>();
                    }
                    gapMap.put(gapInfo.gap, gapInfo);
                    if (cached != null) continue;
                    gaps.add(gapInfo);
                }
                if (!cachedUpToDate) continue;
                break;
            }
            if (cached == null) {
                this.paintedGaps.put(parent, gaps);
            }
            if (selectedGap == null || gaps.contains(selectedGap)) {
                this.paintGapsInContainer(g, parent, gaps, selectedGap, null);
            }
        }
    }

    private boolean isDesignRootSelected(LayoutComponent component) {
        if (component.getParent() != null) {
            Collection<VisualState.GapInfo> gapsInParent = this.visualState.getComponentGaps(component);
            return gapsInParent == null || gapsInParent.isEmpty();
        }
        return true;
    }

    private boolean newGapsForNewSelection(Collection<LayoutComponent> selectedComponents, VisualState.GapInfo selectedGap, boolean root) {
        Collection<VisualState.GapInfo> prevGaps;
        if (this.componentsOfPaintedGaps == null || this.componentsOfPaintedGaps.isEmpty()) {
            return true;
        }
        if (selectedComponents.size() == this.componentsOfPaintedGaps.size()) {
            boolean sameContentAndOrder = true;
            Iterator<LayoutComponent> it1 = selectedComponents.iterator();
            Iterator<LayoutComponent> it2 = this.componentsOfPaintedGaps.iterator();
            while (it1.hasNext()) {
                if (it1.next() == it2.next()) continue;
                sameContentAndOrder = false;
                break;
            }
            if (sameContentAndOrder) {
                return root != this.rootSelection;
            }
        }
        if (selectedGap == null) {
            return true;
        }
        LayoutComponent maybeParent = null;
        for (LayoutComponent selComp : selectedComponents) {
            if (!selComp.isLayoutContainer()) continue;
            for (LayoutComponent prevComp : this.componentsOfPaintedGaps) {
                if (prevComp.getParent() != selComp) continue;
                maybeParent = selComp;
                break;
            }
            if (maybeParent == null) continue;
            break;
        }
        if (maybeParent == null) {
            return true;
        }
        Collection<VisualState.GapInfo> collection = prevGaps = this.paintedGaps != null ? this.paintedGaps.get(maybeParent) : null;
        return prevGaps == null || !prevGaps.contains(selectedGap);
    }

    private static void setPaintRectForGap(VisualState.GapInfo gapInfo) {
        Rectangle r = gapInfo.dimension == 0 ? new Rectangle(gapInfo.position, gapInfo.ortPositions[0], gapInfo.currentSize, gapInfo.ortPositions[1] - gapInfo.ortPositions[0]) : new Rectangle(gapInfo.ortPositions[0], gapInfo.position, gapInfo.ortPositions[1] - gapInfo.ortPositions[0], gapInfo.currentSize);
        gapInfo.paintRect = r;
    }

    private static void expandOrtPaintRect(VisualState.GapInfo gapInfo, VisualState.GapInfo exp) {
        Rectangle r = gapInfo.paintRect;
        Rectangle er = exp.paintRect;
        if (exp.dimension == 0) {
            if (er.y < r.y) {
                r.height += r.y - er.y;
                r.y = er.y;
            }
            if (er.y + er.height > r.y + r.height) {
                r.height = er.y + er.height - r.y;
            }
        } else {
            if (er.x < r.x) {
                r.width += r.x - er.x;
                r.x = er.x;
            }
            if (er.x + er.width > r.x + r.width) {
                r.width = er.x + er.width - r.x;
            }
        }
    }

    private void paintGapsInContainer(Graphics2D g, LayoutComponent container, Collection<VisualState.GapInfo> gaps, VisualState.GapInfo selectedGap, Rectangle selectDragRect) {
        if (gaps == null || gaps.isEmpty()) {
            return;
        }
        Shape originalClip = g.getClip();
        Shape containerClip = this.visualState.getComponentVisibilityClip(container);
        if (containerClip != null) {
            g.clip(this.visualState.getClipForGapPainting(gaps, containerClip));
        }
        Color originalColor = g.getColor();
        boolean paintSelectedGap = false;
        for (VisualState.GapInfo gapInfo : gaps) {
            if (gapInfo == selectedGap) {
                paintSelectedGap = true;
                continue;
            }
            LayoutPainter.paintGap(g, gapInfo, false);
        }
        if (paintSelectedGap) {
            if (selectDragRect == null) {
                LayoutPainter.paintGap(g, selectedGap, true);
                this.paintGapResizeHandles(g, selectedGap);
            } else {
                g.setClip(originalClip);
                LayoutPainter.paintDraggedGap(g, selectDragRect, selectedGap.dimension, LayoutInterval.canResize(selectedGap.gap));
            }
        }
        g.setClip(originalClip);
        g.setColor(originalColor);
    }

    void paintGapResizing(Graphics2D g, VisualState.GapInfo resGap, Rectangle resRect) {
        if (this.paintedGaps == null || this.paintedGaps.isEmpty()) {
            return;
        }
        LayoutComponent parent = null;
        for (LayoutComponent comp : this.componentsOfPaintedGaps) {
            Collection<VisualState.GapInfo> gaps;
            if (parent == null) {
                parent = comp.getParent();
            }
            if (!comp.isLayoutContainer() || !(gaps = this.visualState.getContainerGaps(comp)).contains(resGap)) continue;
            parent = comp;
            break;
        }
        if (parent != null) {
            Collection<VisualState.GapInfo> gaps = this.paintedGaps.get(parent);
            this.paintGapsInContainer(g, parent, gaps, resGap, resRect);
        }
    }

    private static void paintGap(Graphics2D g, VisualState.GapInfo gapInfo, boolean selected) {
        int h2;
        int y2;
        int x2;
        int w2;
        int x1 = gapInfo.paintRect.x;
        int y1 = gapInfo.paintRect.y;
        int w1 = gapInfo.paintRect.width;
        int h1 = gapInfo.paintRect.height;
        if (gapInfo.dimension == 0) {
            w2 = gapInfo.minSize;
            x2 = x1 + (w1 - w2) / 2;
            if (h1 >= 4) {
                h1 -= 2;
                ++y1;
            }
            y2 = y1;
            h2 = h1;
        } else {
            h2 = gapInfo.minSize;
            y2 = y1 + (h1 - h2) / 2;
            if (w1 >= 4) {
                w1 -= 2;
                ++x1;
            }
            x2 = x1;
            w2 = w1;
        }
        boolean differentMinSize = w1 != w2 || h1 != h2;
        boolean resizing = LayoutInterval.canResize(gapInfo.gap);
        if (differentMinSize || resizing && !PAINT_RES_GAP_MIN_SIZE) {
            g.setColor(LayoutPainter.getResizingGapColor(selected));
            g.fillRect(x1 + 1, y1 + 1, w1 - 1, h1 - 1);
        }
        if (w2 > 0 && h2 > 0 && (!resizing || PAINT_RES_GAP_MIN_SIZE)) {
            g.setColor(differentMinSize ? LayoutPainter.getMinGapColor(selected) : LayoutPainter.getFixedGapColor(selected));
            g.fillRect(x2 + 1, y2 + 1, w2 - 1, h2 - 1);
        }
        if (resizing) {
            g.setColor(LayoutPainter.getSawColor(selected));
            if (gapInfo.dimension == 0 && h1 > 4) {
                int count;
                int step = h1 / count;
                int by = y1 + step / 2;
                for (count = h1 / 120 + 1; count > 0; --count) {
                    int x;
                    int d = h1 > 40 ? 4 : (h1 > 12 ? 3 : 2);
                    int d1 = -d;
                    int d2 = d;
                    int n = x = PAINT_RES_GAP_MIN_SIZE ? x2 : x1 + w1 / 2;
                    while (x - 4 >= x1) {
                        g.drawLine(x, by + d1, x - 4, by + d2);
                        x -= 4;
                        d1 *= -1;
                        d2 *= -1;
                    }
                    d1 = -d;
                    d2 = d;
                    x = PAINT_RES_GAP_MIN_SIZE ? x2 + w2 - 1 : x1 + w1 / 2;
                    int xx = x1 + w1;
                    while (x + 4 < xx) {
                        g.drawLine(x, by + d1, x + 4, by + d2);
                        x += 4;
                        d1 *= -1;
                        d2 *= -1;
                    }
                    by += step;
                }
            } else if (w1 > 4) {
                int count;
                int step = w1 / count;
                int bx = x1 + step / 2;
                for (count = w1 / 120 + 1; count > 0; --count) {
                    int y;
                    int d = w1 > 40 ? 4 : (w1 > 8 ? 3 : 2);
                    int d1 = -d;
                    int d2 = d;
                    int n = y = PAINT_RES_GAP_MIN_SIZE ? y2 : y1 + h1 / 2;
                    while (y - 4 >= y1) {
                        g.drawLine(bx + d1, y, bx + d2, y - 4);
                        y -= 4;
                        d1 *= -1;
                        d2 *= -1;
                    }
                    d1 = -d;
                    d2 = d;
                    y = PAINT_RES_GAP_MIN_SIZE ? y2 + h2 - 1 : y1 + h1 / 2;
                    int yy = y1 + h1;
                    while (y + 4 < yy) {
                        g.drawLine(bx + d1, y, bx + d2, y + 4);
                        y += 4;
                        d1 *= -1;
                        d2 *= -1;
                    }
                    bx += step;
                }
            }
        }
        g.setColor(LayoutPainter.getGapBorderColor(selected));
        g.drawRect(x1, y1, w1 - 1, h1 - 1);
    }

    private static void paintDraggedGap(Graphics2D g, Rectangle gapRect, int dimension, boolean resizing) {
        int x = gapRect.x;
        int y = gapRect.y;
        int w = gapRect.width;
        int h = gapRect.height;
        if (dimension == 0) {
            if (h >= 4) {
                h -= 2;
                ++y;
            }
        } else if (w >= 4) {
            w -= 2;
            ++x;
        }
        Color originalColor = g.getColor();
        Composite originalComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.8f));
        g.setColor(resizing ? LayoutPainter.getResizingGapColor(true) : LayoutPainter.getFixedGapColor(true));
        g.fillRect(x + 1, y + 1, w - 1, h - 1);
        g.setColor(LayoutPainter.getGapBorderColor(true));
        g.drawRect(x, y, w - 1, h - 1);
        g.setComposite(originalComposite);
        g.setColor(originalColor);
    }

    private void paintGapResizeHandles(Graphics2D g, VisualState.GapInfo gapInfo) {
        Rectangle r = gapInfo.paintRect;
        if (gapInfo.dimension == 0 && r.width > 5) {
            if (gapInfo.resizeLeading) {
                this.paintGapResizeHandle(g, r.x + 1, r.y, r.height, 1, 0);
            }
            if (gapInfo.resizeTrailing) {
                this.paintGapResizeHandle(g, r.x + r.width - HANDLE_WIDTH - 1, r.y, r.height, 1, 1);
            }
        } else if (gapInfo.dimension == 1 && r.height > 5) {
            if (gapInfo.resizeLeading) {
                this.paintGapResizeHandle(g, r.x, r.y + 1, r.width, 0, 0);
            }
            if (gapInfo.resizeTrailing) {
                this.paintGapResizeHandle(g, r.x, r.y + r.height - HANDLE_WIDTH - 1, r.width, 0, 1);
            }
        }
    }

    static int pointOnResizeHandler(VisualState.GapInfo gapInfo, Point p) {
        Rectangle r = gapInfo.paintRect;
        if (r != null) {
            if (gapInfo.dimension == 0) {
                int ll = r.x - 1;
                int lt = r.x + HANDLE_WIDTH + 2;
                int tl = r.x + r.width - HANDLE_WIDTH - 3;
                int tt = r.x + r.width;
                if (gapInfo.resizeTrailing) {
                    if (tl < r.x + r.width / 2) {
                        if (gapInfo.resizeLeading) {
                            tl = r.x + r.width / 2;
                        } else if (tl < r.x) {
                            tl = r.x;
                        }
                    }
                    if (LayoutPainter.pointInArea(p, tl, tt, r.y - 1, r.y + r.height + 1)) {
                        return 1;
                    }
                }
                if (gapInfo.resizeLeading) {
                    if (lt > r.x + r.width / 2) {
                        if (gapInfo.resizeTrailing) {
                            lt = r.x + r.width / 2;
                        } else if (lt > tt) {
                            lt = tt;
                        }
                    }
                    if (LayoutPainter.pointInArea(p, ll, lt, r.y - 1, r.y + r.height + 1)) {
                        return 0;
                    }
                }
            } else {
                int ll = r.y - 1;
                int lt = r.y + HANDLE_WIDTH + 2;
                int tl = r.y + r.height - HANDLE_WIDTH - 3;
                int tt = r.y + r.height;
                if (gapInfo.resizeTrailing) {
                    if (tl < r.y + r.height / 2) {
                        if (gapInfo.resizeLeading) {
                            tl = r.y + r.height / 2;
                        } else if (tl < ll) {
                            tl = ll;
                        }
                    }
                    if (LayoutPainter.pointInArea(p, r.x - 1, r.x + r.width + 1, tl, tt)) {
                        return 1;
                    }
                }
                if (gapInfo.resizeLeading) {
                    if (lt > r.y + r.height / 2) {
                        if (gapInfo.resizeTrailing) {
                            lt = r.y + r.height / 2;
                        } else if (lt > tt) {
                            lt = tt;
                        }
                    }
                    if (LayoutPainter.pointInArea(p, r.x - 1, r.x + r.width + 1, ll, lt)) {
                        return 0;
                    }
                }
            }
        }
        return -1;
    }

    private static boolean pointInArea(Point p, int x1, int x2, int y1, int y2) {
        return p.x >= x1 && p.x < x2 && p.y >= y1 && p.y < y2;
    }

    private void paintGapResizeHandle(Graphics2D g, int x, int y, int length, int dimension, int alignment) {
        int dy;
        int dx;
        int correction = length < 6 ? 6 - length : (length < 10 ? length - 6 : -4);
        length += correction;
        if (dimension == 0) {
            dx = 0;
            dy = 1;
            x -= correction / 2;
        } else {
            dx = 1;
            dy = 0;
            y -= correction / 2;
        }
        for (int i = 0; i < HANDLE_WIDTH; ++i) {
            g.setColor(HANDLE_COLORS[alignment == 0 ? i : HANDLE_WIDTH - i - 1]);
            int px = x + i * dx;
            int py = y + i * dy;
            g.drawLine(px, py, px + length * dy - dy, py + length * dx - dx);
        }
    }

    private static Color getFixedGapColor(boolean selected) {
        return selected ? LayoutPainter.selectedColor(fixedGapColor) : fixedGapColor;
    }

    private static Color getResizingGapColor(boolean selected) {
        return selected ? LayoutPainter.selectedColor(resGapColor) : resGapColor;
    }

    private static Color getMinGapColor(boolean selected) {
        return selected ? LayoutPainter.selectedColor(minGapColor) : minGapColor;
    }

    private static Color getGapBorderColor(boolean selected) {
        return selected ? LayoutPainter.selectedColor(gapBorderColor) : gapBorderColor;
    }

    private static Color getSawColor(boolean selected) {
        return selected ? LayoutPainter.selectedColor(sawColor) : sawColor;
    }

    private static Color selectedColor(Color c) {
        return LayoutPainter.transColor(c, 210, 270, 190);
    }

    private static Color transColor(Color c, int tr, int tg, int tb) {
        return new Color(LayoutPainter.transColor(c.getRed(), tr), LayoutPainter.transColor(c.getGreen(), tg), LayoutPainter.transColor(c.getBlue(), tb));
    }

    private static int transColor(int c, int t) {
        double change = (double)t / 256.0;
        int result = (int)Math.round((double)c * change);
        if (result > 255) {
            result = 255;
        } else if (result < 0) {
            result = 0;
        }
        return result;
    }

    static {
        HANDLE_COLORS = new Color[]{new Color(255, 255, 243), new Color(242, 238, 230), new Color(221, 217, 209)};
        HANDLE_WIDTH = HANDLE_COLORS.length;
        fixedGapColor = new Color(220, 220, 220);
        resGapColor = new Color(224, 224, 224);
        minGapColor = new Color(212, 212, 212);
        gapBorderColor = new Color(200, 200, 200);
        sawColor = new Color(208, 208, 208);
    }
}

