/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FormatSelector {
    public static final String PROP_FORMAT = "format";
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private FormatInfo[][] formats;
    private String[][] examples;
    private boolean formatChangeFromCode = false;
    private int lastFormat = 0;
    private int lastCategory = 0;
    private JList categoryList;
    private JScrollPane categoryPane;
    private JLabel categoryTitle;
    private JComboBox exampleCombo;
    private JLabel exampleLabel;
    private JPanel examplePanel;
    private JButton formatButton;
    private JTextField formatField;
    private JLabel formatLabel;
    private JList formatList;
    private JScrollPane formatPane;
    private JLabel formatTitle;
    private JTextField previewField;
    private JLabel previewLabel;
    private JPanel selector;

    public FormatSelector() {
        this.initComponents();
        this.initFormats();
        this.initExamples();
        this.formatList.setCellRenderer(new FormatInfoRenderer());
        this.initCategoryList();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    private void firePropertyChange() {
        this.changeSupport.firePropertyChange(PROP_FORMAT, null, null);
    }

    public FormatInfo getFormat() {
        FormatInfo format = (FormatInfo)this.formatList.getSelectedValue();
        format = new FormatInfo(format.getType(), format.getSubtype(), this.formatField.getText());
        return format;
    }

    public void setFormat(FormatInfo format) {
        this.categoryList.setSelectedIndex(format.getType());
        if (format.getSubtype() == -1) {
            FormatInfo info;
            int i;
            String f = format.getFormat();
            ListModel model = this.formatList.getModel();
            for (i = 0; !(i >= model.getSize() || (info = (FormatInfo)model.getElementAt(i)).isCustomizable() && f.equals(info.getFormat())); ++i) {
            }
            if (i == model.getSize()) {
                --i;
            }
            this.formatList.setSelectedIndex(i);
            this.formatField.setText(f);
        } else {
            this.formatList.setSelectedIndex(format.getSubtype());
            this.formatField.setText(((FormatInfo)this.formatList.getSelectedValue()).getFormat());
        }
    }

    private void initCategoryList() {
        ResourceBundle bundle = NbBundle.getBundle(this.getClass());
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement(bundle.getString("LBL_FormatSelector_Category_number"));
        model.addElement(bundle.getString("LBL_FormatSelector_Category_date"));
        model.addElement(bundle.getString("LBL_FormatSelector_Category_time"));
        model.addElement(bundle.getString("LBL_FormatSelector_Category_percent"));
        model.addElement(bundle.getString("LBL_FormatSelector_Category_currency"));
        model.addElement(bundle.getString("LBL_FormatSelector_Category_mask"));
        this.categoryList.setModel(model);
        this.categoryList.setSelectedIndex(0);
    }

    private void initExamples() {
        this.examples = new String[6][];
        int i = 0;
        DecimalFormat nf = new DecimalFormat("0.###");
        this.examples[i] = new String[]{nf.format(1234.567), nf.format(-1234.56), nf.format(0.123), nf.format(-0.123)};
        DateFormat df = DateFormat.getDateInstance();
        GregorianCalendar c1 = new GregorianCalendar(2000, 0, 1);
        GregorianCalendar c2 = new GregorianCalendar(1999, 11, 31);
        this.examples[++i] = new String[]{df.format(new Date()), df.format(c1.getTime()), df.format(c2.getTime())};
        DateFormat tf = DateFormat.getTimeInstance();
        GregorianCalendar c3 = new GregorianCalendar();
        c3.set(10, 12);
        c3.set(12, 34);
        c3.set(13, 56);
        c3.set(14, 789);
        GregorianCalendar c4 = new GregorianCalendar();
        c4.set(10, 23);
        c4.set(12, 59);
        c4.set(13, 59);
        c4.set(14, 999);
        GregorianCalendar c5 = new GregorianCalendar();
        c5.set(10, 1);
        c5.set(12, 2);
        c5.set(13, 3);
        c5.set(14, 4);
        this.examples[++i] = new String[]{tf.format(new Date()), tf.format(c3.getTime()), tf.format(c4.getTime()), tf.format(c5.getTime())};
        this.examples[++i] = this.examples[0];
        this.examples[++i] = this.examples[0];
        this.examples[++i] = new String[0];
    }

    private void initFormats() {
        ResourceBundle bundle = NbBundle.getBundle(this.getClass());
        this.formats = new FormatInfo[6][];
        int i = 0;
        this.formats[i] = new FormatInfo[8];
        this.formats[i][0] = new FormatInfo(0, 0, bundle.getString("LBL_FormatSelector_default"), new NumberFormatter());
        this.formats[i][1] = new FormatInfo(0, 1, bundle.getString("LBL_FormatSelector_default_integer"), new NumberFormatter(NumberFormat.getIntegerInstance()));
        this.formats[i][2] = new FormatInfo(0, -1, "0", new NumberFormatter(new DecimalFormat("0")));
        this.formats[i][3] = new FormatInfo(0, -1, "0.00", new NumberFormatter(new DecimalFormat("0.00")));
        this.formats[i][4] = new FormatInfo(0, -1, "#,##0", new NumberFormatter(new DecimalFormat("#,##0")));
        this.formats[i][5] = new FormatInfo(0, -1, "#,##0.00", new NumberFormatter(new DecimalFormat("#,##0.00")));
        this.formats[i][6] = new FormatInfo(0, -1, "#,###.00", new NumberFormatter(new DecimalFormat("#,###.00")));
        this.formats[i][7] = new FormatInfo(0, -1, bundle.getString("LBL_FormatSelector_custom"), null);
        this.formats[++i] = new FormatInfo[6];
        this.formats[i][0] = new FormatInfo(1, 0, bundle.getString("LBL_FormatSelector_default"), new DateFormatter());
        this.formats[i][1] = new FormatInfo(1, 1, bundle.getString("LBL_FormatSelector_short"), new DateFormatter(DateFormat.getDateInstance(3)));
        this.formats[i][2] = new FormatInfo(1, 2, bundle.getString("LBL_FormatSelector_medium"), new DateFormatter(DateFormat.getDateInstance(2)));
        this.formats[i][3] = new FormatInfo(1, 3, bundle.getString("LBL_FormatSelector_long"), new DateFormatter(DateFormat.getDateInstance(1)));
        this.formats[i][4] = new FormatInfo(1, 4, bundle.getString("LBL_FormatSelector_full"), new DateFormatter(DateFormat.getDateInstance(0)));
        this.formats[i][5] = new FormatInfo(1, -1, bundle.getString("LBL_FormatSelector_custom"), null);
        this.formats[++i] = new FormatInfo[6];
        this.formats[i][0] = new FormatInfo(2, 0, bundle.getString("LBL_FormatSelector_default"), new DateFormatter(DateFormat.getTimeInstance()));
        this.formats[i][1] = new FormatInfo(2, 1, bundle.getString("LBL_FormatSelector_short"), new DateFormatter(DateFormat.getTimeInstance(3)));
        this.formats[i][2] = new FormatInfo(2, 2, bundle.getString("LBL_FormatSelector_medium"), new DateFormatter(DateFormat.getTimeInstance(2)));
        this.formats[i][3] = new FormatInfo(2, 3, bundle.getString("LBL_FormatSelector_long"), new DateFormatter(DateFormat.getTimeInstance(1)));
        this.formats[i][4] = new FormatInfo(2, 4, bundle.getString("LBL_FormatSelector_full"), new DateFormatter(DateFormat.getTimeInstance(0)));
        this.formats[i][5] = new FormatInfo(2, -1, bundle.getString("LBL_FormatSelector_custom"), null);
        this.formats[++i] = new FormatInfo[4];
        this.formats[i][0] = new FormatInfo(3, 0, bundle.getString("LBL_FormatSelector_default"), new NumberFormatter(NumberFormat.getPercentInstance()));
        this.formats[i][1] = new FormatInfo(3, -1, "0%", new NumberFormatter(new DecimalFormat("0%")));
        this.formats[i][2] = new FormatInfo(3, -1, "0.00%", new NumberFormatter(new DecimalFormat("0.00%")));
        this.formats[i][3] = new FormatInfo(3, -1, bundle.getString("LBL_FormatSelector_custom"), null);
        this.formats[++i] = new FormatInfo[8];
        this.formats[i][0] = new FormatInfo(4, 0, bundle.getString("LBL_FormatSelector_default"), new NumberFormatter(NumberFormat.getCurrencyInstance()));
        this.formats[i][1] = new FormatInfo(4, -1, "\u00a4#,##0", new NumberFormatter(new DecimalFormat("\u00a4#,##0")));
        this.formats[i][2] = new FormatInfo(4, -1, "\u00a4#,##0.00", new NumberFormatter(new DecimalFormat("\u00a4#,##0.00")));
        this.formats[i][3] = new FormatInfo(4, -1, "\u00a4#,##0.--", new NumberFormatter(new DecimalFormat("\u00a4#,##0.--")));
        this.formats[i][4] = new FormatInfo(4, -1, "\u00a4\u00a4#,##0", new NumberFormatter(new DecimalFormat("\u00a4\u00a4#,##0")));
        this.formats[i][5] = new FormatInfo(4, -1, "\u00a4\u00a4#,##0.00", new NumberFormatter(new DecimalFormat("\u00a4\u00a4#,##0.00")));
        this.formats[i][6] = new FormatInfo(4, -1, "\u00a4\u00a4#,##0.--", new NumberFormatter(new DecimalFormat("\u00a4\u00a4#,##0.--")));
        this.formats[i][7] = new FormatInfo(4, -1, bundle.getString("LBL_FormatSelector_custom"), null);
        try {
            this.formats[++i] = new FormatInfo[2];
            this.formats[i][0] = new FormatInfo(5, -1, "###-####", new MaskFormatter("###-####"));
            this.formats[i][1] = new FormatInfo(5, -1, bundle.getString("LBL_FormatSelector_custom"), null);
            Date now = new Date();
            Double n = -1234.56;
            for (int k = 0; k < this.formats.length - 1; ++k) {
                for (int j = 0; j < this.formats[k].length; ++j) {
                    if (k == 1 || k == 2) {
                        this.formats[k][j].calculateExample(now);
                        continue;
                    }
                    this.formats[k][j].calculateExample(n);
                }
            }
        }
        catch (ParseException pex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, pex.getMessage(), pex);
        }
    }

    private void initComponents() {
        this.selector = new JPanel();
        this.categoryTitle = new JLabel();
        this.categoryPane = new JScrollPane();
        this.categoryList = new JList();
        this.formatPane = new JScrollPane();
        this.formatList = new JList();
        this.formatTitle = new JLabel();
        this.formatLabel = new JLabel();
        this.formatField = new JTextField();
        this.examplePanel = new JPanel();
        this.previewField = new JTextField();
        this.previewLabel = new JLabel();
        this.exampleCombo = new JComboBox();
        this.formatButton = new JButton();
        this.exampleLabel = new JLabel();
        this.categoryTitle.setLabelFor(this.categoryList);
        Mnemonics.setLocalizedText((JLabel)this.categoryTitle, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_CategoryTitle"));
        this.categoryList.setSelectionMode(0);
        this.categoryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FormatSelector.this.categoryListValueChanged(evt);
            }
        });
        this.categoryPane.setViewportView(this.categoryList);
        this.categoryList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_Category"));
        this.formatList.setSelectionMode(0);
        this.formatList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FormatSelector.this.formatListValueChanged(evt);
            }
        });
        this.formatPane.setViewportView(this.formatList);
        this.formatList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_Format"));
        this.formatTitle.setLabelFor(this.formatList);
        Mnemonics.setLocalizedText((JLabel)this.formatTitle, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_FormatTitle"));
        this.formatLabel.setLabelFor(this.formatField);
        Mnemonics.setLocalizedText((JLabel)this.formatLabel, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_Format"));
        this.formatField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FormatSelector.this.formatFieldFocusLost(evt);
            }
        });
        this.examplePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_Example")));
        this.previewField.setEditable(false);
        this.previewLabel.setLabelFor(this.previewField);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_Preview"));
        this.exampleCombo.setEditable(true);
        this.exampleCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FormatSelector.this.exampleComboItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.formatButton, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_Test"));
        this.formatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormatSelector.this.formatButtonActionPerformed(evt);
            }
        });
        this.exampleLabel.setLabelFor(this.exampleCombo);
        Mnemonics.setLocalizedText((JLabel)this.exampleLabel, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_ValueToFormat"));
        GroupLayout examplePanelLayout = new GroupLayout(this.examplePanel);
        this.examplePanel.setLayout(examplePanelLayout);
        examplePanelLayout.setHorizontalGroup(examplePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(examplePanelLayout.createSequentialGroup().addContainerGap().addGroup(examplePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exampleLabel).addComponent(this.previewLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(examplePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewField, -1, 20, Short.MAX_VALUE).addComponent(this.exampleCombo, 0, 20, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatButton).addContainerGap()));
        examplePanelLayout.setVerticalGroup(examplePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(examplePanelLayout.createSequentialGroup().addGroup(examplePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exampleLabel).addComponent(this.formatButton).addComponent(this.exampleCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(examplePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.previewLabel).addComponent(this.previewField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.previewField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_Preview"));
        this.exampleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_ValueToFormat"));
        this.formatButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_Test"));
        GroupLayout selectorLayout = new GroupLayout(this.selector);
        this.selector.setLayout(selectorLayout);
        selectorLayout.setHorizontalGroup(selectorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectorLayout.createSequentialGroup().addContainerGap().addGroup(selectorLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.categoryPane, -2, -1, -2).addComponent(this.categoryTitle)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(selectorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formatTitle).addGroup(selectorLayout.createSequentialGroup().addComponent(this.formatPane, -1, 24, Short.MAX_VALUE).addGroup(selectorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectorLayout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.formatLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatField, -1, 145, Short.MAX_VALUE)).addGroup(selectorLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.examplePanel, -1, -1, Short.MAX_VALUE))))).addContainerGap()));
        selectorLayout.setVerticalGroup(selectorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectorLayout.createSequentialGroup().addContainerGap().addGroup(selectorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.categoryTitle).addComponent(this.formatTitle)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(selectorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectorLayout.createSequentialGroup().addGroup(selectorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.formatField, -2, -1, -2).addComponent(this.formatLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.examplePanel, -2, -1, -2)).addGroup(selectorLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.formatPane, 0, 0, Short.MAX_VALUE).addComponent(this.categoryPane))).addContainerGap(-1, Short.MAX_VALUE)));
        this.formatField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_Format2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatFieldFocusLost(FocusEvent evt) {
        FormatInfo info = (FormatInfo)this.formatList.getSelectedValue();
        int size = this.formatList.getModel().getSize();
        if (this.formatList.getSelectedIndex() != size - 1 && !this.formatField.getText().equals(info.getFormat())) {
            try {
                this.formatChangeFromCode = true;
                this.formatList.setSelectedIndex(size - 1);
            }
            finally {
                this.formatChangeFromCode = false;
            }
        }
        this.firePropertyChange();
    }

    private void formatButtonActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void exampleComboItemStateChanged(ItemEvent evt) {
        this.updatePreview();
    }

    private void formatListValueChanged(ListSelectionEvent evt) {
        if (this.formatChangeFromCode) {
            return;
        }
        FormatInfo info = (FormatInfo)this.formatList.getSelectedValue();
        if (info == null) {
            this.formatList.setSelectedIndex(this.lastFormat);
            return;
        }
        this.lastFormat = this.formatList.getSelectedIndex();
        if (info == null) {
            this.formatField.setText(null);
            this.formatField.setEnabled(false);
            this.previewField.setText(null);
        } else {
            String format = info.getFormat();
            if (format == null && !info.isCustomizable()) {
                this.formatField.setText(info.getDisplayName());
                this.formatField.setEnabled(false);
            } else {
                this.formatField.setText(info.getFormat());
                this.formatField.setEnabled(true);
                this.updatePreview();
            }
        }
        this.firePropertyChange();
    }

    private void categoryListValueChanged(ListSelectionEvent evt) {
        this.fillExampleCombo();
        this.fillFormatList();
    }

    private void updatePreview() {
        int category = this.categoryList.getSelectedIndex();
        try {
            Object selectedItem = this.exampleCombo.getSelectedItem();
            String preview = "";
            if (selectedItem != null) {
                String selected = selectedItem.toString();
                if (category == 1) {
                    DateFormat original = DateFormat.getDateInstance();
                    SimpleDateFormat f = new SimpleDateFormat(this.formatField.getText());
                    preview = f.format(original.parse(selected));
                } else if (category == 2) {
                    DateFormat original = DateFormat.getTimeInstance();
                    SimpleDateFormat f = new SimpleDateFormat(this.formatField.getText());
                    preview = f.format(original.parse(selected));
                } else if (category == 5) {
                    MaskFormatter f = new MaskFormatter(this.formatField.getText());
                    preview = f.valueToString(selected);
                } else {
                    DecimalFormat original = new DecimalFormat("0.###");
                    DecimalFormat f = new DecimalFormat(this.formatField.getText());
                    preview = f.format(original.parse(selected));
                }
            }
            this.previewField.setText(preview);
        }
        catch (ParseException pex) {
            this.previewField.setText(pex.getMessage());
        }
        catch (IllegalArgumentException iaex) {
            this.previewField.setText(iaex.getMessage());
        }
    }

    private void fillFormatList() {
        int index = this.categoryList.getSelectedIndex();
        if (index == -1) {
            this.categoryList.setSelectedIndex(this.lastCategory);
            return;
        }
        this.lastCategory = index;
        DefaultListModel<FormatInfo> model = new DefaultListModel<FormatInfo>();
        for (FormatInfo format : this.formats[index]) {
            model.addElement(format);
        }
        ((FormatInfoRenderer)this.formatList.getCellRenderer()).reinitialize(model);
        this.formatList.setModel(model);
        this.formatList.setSelectedIndex(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillExampleCombo() {
        int index = this.categoryList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String example : this.examples[index]) {
            model.addElement(example);
        }
        this.formatChangeFromCode = true;
        try {
            this.exampleCombo.setModel(model);
        }
        finally {
            this.formatChangeFromCode = false;
        }
    }

    public JPanel getSelectorPanel() {
        return this.selector;
    }

    public static class FormatInfo {
        public static final int NUMBER = 0;
        public static final int DATE = 1;
        public static final int TIME = 2;
        public static final int PERCENT = 3;
        public static final int CURRENCY = 4;
        public static final int MASK = 5;
        public static final int NONE = -1;
        public static final int DEFAULT = 0;
        public static final int SHORT = 1;
        public static final int MEDIUM = 2;
        public static final int LONG = 3;
        public static final int FULL = 4;
        public static final int INTEGER = 1;
        private int type;
        private int subtype;
        private String displayName;
        private String example;
        private String format;
        private JFormattedTextField.AbstractFormatter formatter;

        FormatInfo(int type, int subtype, String displayName, JFormattedTextField.AbstractFormatter formatter) {
            this.type = type;
            this.subtype = subtype;
            this.displayName = displayName;
            this.formatter = formatter;
        }

        public FormatInfo(int type, int subtype, String format) {
            this.type = type;
            this.subtype = subtype;
            this.format = format;
        }

        boolean isCustomizable() {
            return this.subtype == -1;
        }

        String getDisplayName() {
            return this.displayName;
        }

        String getExample() {
            return this.example;
        }

        void calculateExample(Object value) {
            if (this.formatter == null) {
                return;
            }
            try {
                this.example = this.formatter.valueToString(value);
            }
            catch (ParseException pex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, pex.getMessage(), pex);
            }
        }

        public String getFormat() {
            if (this.format != null) {
                return this.format;
            }
            String fmt = null;
            if (this.formatter instanceof MaskFormatter) {
                fmt = ((MaskFormatter)this.formatter).getMask();
            } else if (this.formatter instanceof InternationalFormatter) {
                Format f = ((InternationalFormatter)this.formatter).getFormat();
                if (f instanceof DecimalFormat) {
                    fmt = ((DecimalFormat)f).toPattern();
                } else if (f instanceof SimpleDateFormat) {
                    fmt = ((SimpleDateFormat)f).toPattern();
                }
            }
            return fmt;
        }

        public int getType() {
            return this.type;
        }

        public int getSubtype() {
            return this.subtype;
        }
    }

    static class FormatInfoRenderer
    implements ListCellRenderer {
        private DefaultListCellRenderer delegate;
        private JPanel panel = new JPanel();
        private JLabel label;
        private int width1;
        private int width2;

        FormatInfoRenderer() {
            BoxLayout layout = new BoxLayout(this.panel, 0);
            this.panel.setLayout(layout);
            this.label = new JLabel();
            this.label.setOpaque(false);
            this.delegate = new DefaultListCellRenderer();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            FormatInfo info = (FormatInfo)value;
            Component comp = this.delegate.getListCellRendererComponent((JList<?>)list, info.getDisplayName(), index, isSelected, cellHasFocus);
            if (comp instanceof JComponent) {
                JComponent jcomp = (JComponent)comp;
                Border border = jcomp.getBorder();
                if (border != null && border.getBorderInsets(this.panel) != null) {
                    this.panel.setBorder(border);
                } else {
                    this.panel.setBorder(BorderFactory.createEmptyBorder());
                }
                this.panel.setOpaque(jcomp.isOpaque());
                jcomp.setBorder(null);
            }
            this.panel.removeAll();
            this.panel.setBackground(comp.getBackground());
            comp.setPreferredSize(null);
            Dimension prefSize = comp.getPreferredSize();
            comp.setPreferredSize(new Dimension(this.width1, prefSize.height));
            comp.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.panel.add(comp);
            this.panel.add(Box.createHorizontalStrut(5));
            this.label.setText(info.getExample());
            this.label.setForeground(comp.getForeground());
            this.label.setFont(comp.getFont());
            this.label.setPreferredSize(null);
            prefSize = this.label.getPreferredSize();
            this.label.setPreferredSize(new Dimension(this.width2, prefSize.height));
            this.label.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.panel.add(this.label);
            return this.panel;
        }

        private void reinitialize(ListModel model) {
            this.label.setPreferredSize(null);
            this.width1 = 0;
            this.width2 = 0;
            for (int i = 0; i < model.getSize(); ++i) {
                FormatInfo info = (FormatInfo)model.getElementAt(i);
                this.label.setText(info.getDisplayName());
                this.width1 = Math.max(this.width1, this.label.getPreferredSize().width);
                this.label.setText(info.getExample());
                this.width2 = Math.max(this.width2, this.label.getPreferredSize().width);
            }
        }
    }
}

