/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClassPathFileChooser
extends JPanel
implements ExplorerManager.Provider {
    private boolean choosingFolder;
    private ExplorerManager explorerManager;
    private List<FileObject> packageRoots;
    private FileObject selectedFile;
    private FileObject selectedFolder;
    private boolean confirmed;
    private BeanTreeView treeView;
    private JButton newButton;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField fileNameTextField;
    public static final String PROP_SELECTED_FILE = "selectedFile";

    public ClassPathFileChooser(FileObject fileInProject, Filter filter, boolean choosingFolder, boolean okCancelButtons) {
        this.choosingFolder = choosingFolder;
        Listener listener = new Listener();
        Node root = this.getRootNode(fileInProject, filter);
        this.explorerManager = new ExplorerManager();
        this.explorerManager.setRootContext(root);
        try {
            this.explorerManager.setSelectedNodes(new Node[]{root});
        }
        catch (PropertyVetoException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)listener);
        if (choosingFolder) {
            this.newButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)NbBundle.getMessage(ClassPathFileChooser.class, (String)"CTL_CreateNewButton"));
            this.newButton.addActionListener(listener);
            this.newButton.setEnabled(false);
            this.newButton.setToolTipText(NbBundle.getMessage(ClassPathFileChooser.class, (String)"CTL_CreateNewButtonHint"));
        }
        if (okCancelButtons) {
            this.okButton = new JButton(NbBundle.getMessage(ClassPathFileChooser.class, (String)"CTL_OKButton"));
            this.okButton.addActionListener(listener);
            this.okButton.setEnabled(false);
            this.cancelButton = new JButton(NbBundle.getMessage(ClassPathFileChooser.class, (String)"CTL_CancelButton"));
        }
        this.treeView = new BeanTreeView();
        this.treeView.setPopupAllowed(false);
        this.treeView.setDefaultActionAllowed(false);
        this.treeView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClassPathFileChooser.class, (String)"ACSN_FileSelectorTreeView"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClassPathFileChooser.class, (String)"ACSD_FileSelectorTreeView"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClassPathFileChooser.class, (String)"ACSD_FileSelectorPanel"));
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(ClassPathFileChooser.class, (String)(choosingFolder ? "LBL_FolderName" : "LBL_FileName")));
        this.fileNameTextField = new JTextField();
        this.fileNameTextField.getDocument().addDocumentListener(listener);
        this.fileNameTextField.addActionListener(listener);
        label.setLabelFor(this.fileNameTextField);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        GroupLayout.SequentialGroup sq = layout.createSequentialGroup().addComponent(label).addComponent(this.fileNameTextField);
        if (!okCancelButtons && this.newButton != null) {
            sq.addComponent(this.newButton);
        }
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent((Component)this.treeView, -1, -1, Short.MAX_VALUE).addGroup(sq));
        GroupLayout.ParallelGroup pq = layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.fileNameTextField);
        if (!okCancelButtons && this.newButton != null) {
            pq.addComponent(this.newButton);
        }
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)this.treeView, -1, -1, Short.MAX_VALUE).addGroup(pq));
    }

    public Dialog getDialog(String title, ActionListener listener) {
        Object[] objectArray;
        if (this.okButton == null) {
            throw new IllegalStateException("Can't create dialog for a chooser without OK and Cancel buttons.");
        }
        ((GroupLayout)this.getLayout()).setAutoCreateContainerGaps(true);
        if (this.newButton != null) {
            JButton[] jButtonArray = new JButton[3];
            jButtonArray[0] = this.newButton;
            jButtonArray[1] = this.okButton;
            objectArray = jButtonArray;
            jButtonArray[2] = this.cancelButton;
        } else {
            Object[] objectArray2 = new JButton[2];
            objectArray2[0] = this.okButton;
            objectArray = objectArray2;
            objectArray2[1] = this.cancelButton;
        }
        DialogDescriptor dd = new DialogDescriptor((Object)this, title, true, objectArray, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, null);
        dd.setClosingOptions((Object[])new JButton[]{this.okButton, this.cancelButton});
        if (listener != null) {
            this.okButton.addActionListener(listener);
        }
        return DialogDisplayer.getDefault().createDialog(dd);
    }

    @Override
    public void addNotify() {
        this.confirmed = false;
        super.addNotify();
        this.treeView.requestFocusInWindow();
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public FileObject getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(FileObject file) {
        if (file != null) {
            if (this.getRoot(file) == null) {
                throw new IllegalArgumentException("File not within the classpath.");
            }
            this.selectFileNode(file);
        }
        this.selectedFile = file;
    }

    public FileObject getSelectedPackageRoot() {
        return this.getRoot(this.getSelectedFile());
    }

    private void checkNameField() {
        if (this.selectedFolder != null) {
            FileObject fo;
            this.selectedFile = null;
            String fileName = this.fileNameTextField.getText();
            Node[] nodes = this.explorerManager.getSelectedNodes();
            if (nodes.length == 1 && (fo = ClassPathFileChooser.fileFromNode(nodes[0])) != null) {
                if (!fo.isFolder()) {
                    fo = fo.getParent();
                }
                this.selectedFile = fo.getFileObject(fileName);
                this.selectedFolder = fo;
            }
            if (this.okButton != null) {
                this.okButton.setEnabled(this.selectedFile != null && (!this.selectedFile.isFolder() || this.choosingFolder));
            }
            if (this.newButton != null) {
                this.newButton.setEnabled(this.selectedFile == null && this.choosingFolder && Utilities.isJavaIdentifier((String)fileName));
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private static FileObject fileFromNode(Node n) {
        DataObject dobj = (DataObject)n.getCookie(DataObject.class);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    private void selectFileNode(FileObject fo) {
        this.selectNode(this.explorerManager.getRootContext(), fo);
    }

    private void selectNode(Node parent, FileObject fo) {
        for (Node n : parent.getChildren().getNodes(true)) {
            FileObject nodeFO = ClassPathFileChooser.fileFromNode(n);
            if (nodeFO == fo) {
                try {
                    this.explorerManager.setSelectedNodes(new Node[]{n});
                }
                catch (PropertyVetoException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                break;
            }
            if (!FileUtil.isParentOf((FileObject)nodeFO, (FileObject)fo)) continue;
            this.selectNode(n, fo);
            break;
        }
    }

    private FileObject getRoot(FileObject fo) {
        if (fo != null) {
            for (FileObject root : this.packageRoots) {
                if (root != fo && !FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
                return root;
            }
        }
        return null;
    }

    private Node getRootNode(FileObject fileInProject, Filter filter) {
        Children.Array children = new Children.Array();
        children.add(this.createPackageRootNodes(fileInProject, this.choosingFolder, filter));
        AbstractNode root = new AbstractNode((Children)children);
        root.setIconBaseWithExtension("org/netbeans/modules/form/editors2/iconResourceRoot.gif");
        root.setDisplayName(NbBundle.getMessage(ClassPathFileChooser.class, (String)"CTL_ClassPathName"));
        return root;
    }

    private Node[] createPackageRootNodes(FileObject fileInProject, boolean onlySources, Filter filter) {
        ClassPath cp = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/execute");
        Project project = FileOwnerQuery.getOwner((FileObject)fileInProject);
        if (cp == null || project == null) {
            return new Node[0];
        }
        this.packageRoots = new LinkedList<FileObject>();
        LinkedList<Node> nodeList = new LinkedList<Node>();
        for (ClassPath.Entry e : cp.entries()) {
            FileObject fo;
            Node n;
            ClassPath.Entry cpEntry = e;
            URL url = cpEntry.getURL();
            SourceForBinaryQuery.Result r = SourceForBinaryQuery.findSourceRoots((URL)url);
            FileObject[] roots = r.getRoots();
            if (roots.length > 0) {
                for (FileObject fo2 : roots) {
                    Node n2;
                    if (onlySources && !fo2.canWrite() || (n2 = ClassPathFileChooser.createPackageRootNode(fo2, project, filter)) == null) continue;
                    this.packageRoots.add(fo2);
                    nodeList.add(n2);
                }
                continue;
            }
            if (onlySources || (n = (fo = cpEntry.getRoot()) != null ? ClassPathFileChooser.createPackageRootNode(fo, project, filter) : null) == null) continue;
            this.packageRoots.add(fo);
            nodeList.add(n);
        }
        Node[] nodes = new Node[nodeList.size()];
        nodeList.toArray(nodes);
        return nodes;
    }

    private static Node createPackageRootNode(FileObject rootFO, Project project, Filter filter) {
        String displayName;
        Node origNode;
        try {
            origNode = DataObject.find((FileObject)rootFO).getNodeDelegate();
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)rootFO);
        if (owner != null) {
            SourceGroup g = ClassPathFileChooser.getSourceGroup(rootFO, owner);
            String string = displayName = g != null ? g.getDisplayName() : FileUtil.getFileDisplayName((FileObject)rootFO);
            if (project != owner) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)owner);
                displayName = displayName + " [" + pi.getDisplayName() + "]";
            }
        } else {
            displayName = FileUtil.getFileDisplayName((FileObject)rootFO);
        }
        return new FilteredNode(origNode, displayName, filter);
    }

    private static SourceGroup getSourceGroup(FileObject file, Project prj) {
        Sources src = ProjectUtils.getSources((Project)prj);
        for (SourceGroup g : src.getSourceGroups("java")) {
            if (file != g.getRootFolder()) continue;
            return g;
        }
        return null;
    }

    public static interface Filter {
        public boolean accept(FileObject var1);
    }

    public static class FilteredChildren
    extends FilterNode.Children {
        private Filter filter;

        public FilteredChildren(Node original, Filter filter) {
            super(original);
            this.filter = filter;
        }

        protected Node copyNode(Node node) {
            return this.filter != null ? new FilteredNode(node, null, this.filter) : super.copyNode(node);
        }

        protected Node[] createNodes(Node key) {
            FileObject fo;
            if (!(this.filter == null || (fo = ClassPathFileChooser.fileFromNode(key)) != null && this.filter.accept(fo))) {
                return new Node[0];
            }
            return super.createNodes(key);
        }
    }

    private static class FilteredNode
    extends FilterNode {
        FilteredNode(Node original, String displayName, Filter filter) {
            super(original, (Children)new FilteredChildren(original, filter));
            if (displayName != null) {
                this.disableDelegation(12);
                this.setDisplayName(displayName);
            }
        }
    }

    private class Listener
    implements PropertyChangeListener,
    ActionListener,
    DocumentListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ClassPathFileChooser.this.okButton) {
                ClassPathFileChooser.this.confirmed = true;
            } else if (e.getSource() == ClassPathFileChooser.this.newButton) {
                if (ClassPathFileChooser.this.selectedFolder == null || ClassPathFileChooser.this.selectedFile != null) {
                    return;
                }
                String fileName = ClassPathFileChooser.this.fileNameTextField.getText();
                try {
                    ClassPathFileChooser.this.selectedFile = ClassPathFileChooser.this.selectedFolder.createFolder(fileName);
                    ClassPathFileChooser.this.selectFileNode(ClassPathFileChooser.this.selectedFile);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                if (ClassPathFileChooser.this.choosingFolder && ClassPathFileChooser.this.selectedFile != null) {
                    ClassPathFileChooser.this.firePropertyChange(ClassPathFileChooser.PROP_SELECTED_FILE, null, ClassPathFileChooser.this.selectedFile);
                }
            } else if (e.getSource() == ClassPathFileChooser.this.fileNameTextField) {
                if (ClassPathFileChooser.this.selectedFile == null) {
                    String fileName = ClassPathFileChooser.this.fileNameTextField.getText();
                    if (fileName.startsWith("/")) {
                        fileName = fileName.substring(1);
                    }
                    for (FileObject root : ClassPathFileChooser.this.packageRoots) {
                        FileObject fo = root.getFileObject(fileName);
                        if (fo == null) continue;
                        ClassPathFileChooser.this.selectedFile = fo;
                        ClassPathFileChooser.this.selectedFolder = fo.getParent();
                        break;
                    }
                }
                if (ClassPathFileChooser.this.selectedFile != null) {
                    Node[] nodes = ClassPathFileChooser.this.explorerManager.getSelectedNodes();
                    if (nodes.length != 1 || ClassPathFileChooser.fileFromNode(nodes[0]) != ClassPathFileChooser.this.selectedFile) {
                        ClassPathFileChooser.this.selectFileNode(ClassPathFileChooser.this.selectedFile);
                        ClassPathFileChooser.this.treeView.requestFocus();
                    } else if (ClassPathFileChooser.this.okButton != null) {
                        ClassPathFileChooser.this.okButton.doClick();
                        return;
                    }
                    if (ClassPathFileChooser.this.okButton != null) {
                        ClassPathFileChooser.this.okButton.setEnabled(ClassPathFileChooser.this.selectedFile != null && (!ClassPathFileChooser.this.selectedFile.isFolder() || ClassPathFileChooser.this.choosingFolder));
                    }
                    if (ClassPathFileChooser.this.newButton != null) {
                        ClassPathFileChooser.this.newButton.setEnabled(false);
                    }
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("selectedNodes")) {
                FileObject fo;
                Node[] nodes = ClassPathFileChooser.this.explorerManager.getSelectedNodes();
                FileObject oldSelected = ClassPathFileChooser.this.selectedFile;
                ClassPathFileChooser.this.selectedFile = null;
                ClassPathFileChooser.this.selectedFolder = null;
                if (nodes.length == 1 && (fo = ClassPathFileChooser.fileFromNode(nodes[0])) != null) {
                    ClassPathFileChooser.this.fileNameTextField.setText(!fo.isFolder() || ClassPathFileChooser.this.choosingFolder ? fo.getNameExt() : "");
                    ClassPathFileChooser.this.selectedFile = fo;
                    ClassPathFileChooser.this.selectedFolder = fo.getParent();
                }
                if (ClassPathFileChooser.this.okButton != null) {
                    ClassPathFileChooser.this.okButton.setEnabled(ClassPathFileChooser.this.selectedFile != null && (!ClassPathFileChooser.this.selectedFile.isFolder() || ClassPathFileChooser.this.choosingFolder));
                }
                if (ClassPathFileChooser.this.newButton != null) {
                    ClassPathFileChooser.this.newButton.setEnabled(false);
                }
                ClassPathFileChooser.this.firePropertyChange(ClassPathFileChooser.PROP_SELECTED_FILE, oldSelected, ClassPathFileChooser.this.selectedFile);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ClassPathFileChooser.this.checkNameField();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ClassPathFileChooser.this.checkNameField();
        }
    }
}

