/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthLookAndFeel;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.actions.SelectLayoutAction;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;

public class TestAction
extends CallableSystemAction
implements Runnable {
    private static String name;
    private Map<String, Map<String, Frame>> previews = new HashMap<String, Map<String, Frame>>();
    private Class selectedLaf;

    public boolean isEnabled() {
        FormDesigner designer = FormDesigner.getSelectedDesigner();
        return designer != null && designer.getTopDesignComponent() != null;
    }

    public void updateEnabled() {
        this.firePropertyChange("enabled", null, null);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        if (name == null) {
            name = NbBundle.getBundle(TestAction.class).getString("ACT_TestMode");
        }
        return name;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.testing");
    }

    protected String iconResource() {
        return "org/netbeans/modules/form/resources/test_form.png";
    }

    public void performAction() {
        if (FormDesigner.getSelectedDesigner() != null) {
            this.selectedLaf = null;
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                EventQueue.invokeLater(this);
            }
        }
    }

    @Override
    public void run() {
        RADVisualComponent topComp;
        FormDesigner designer = FormDesigner.getSelectedDesigner();
        RADVisualComponent rADVisualComponent = topComp = designer != null ? designer.getTopDesignComponent() : null;
        if (topComp == null) {
            return;
        }
        RADVisualContainer parent = topComp.getParentContainer();
        while (parent != null) {
            topComp = parent;
            parent = topComp.getParentContainer();
        }
        RADVisualFormContainer formContainer = topComp instanceof RADVisualFormContainer ? (RADVisualFormContainer)topComp : null;
        this.createPreview(topComp, formContainer);
    }

    public Frame createPreview(RADVisualComponent componentToPreview, RADVisualFormContainer formContainer) {
        try {
            Frame previousFrame;
            FileObject formFile;
            Map<String, Frame> map;
            FormModel formModel = componentToPreview.getFormModel();
            if (this.selectedLaf == null) {
                this.selectedLaf = UIManager.getLookAndFeel().getClass();
            }
            if ((map = this.previews.get((formFile = FormEditor.getFormDataObject(formModel).getFormFile()).getPath())) == null) {
                map = new HashMap<String, Frame>();
                this.previews.put(formFile.getPath(), map);
            }
            if ((previousFrame = map.get(this.selectedLaf.getName())) != null) {
                previousFrame.dispose();
            }
            final ClassLoader classLoader = ClassPathUtils.getProjectClassLoader(formFile);
            final FormLAF.PreviewInfo previewInfo = FormLAF.initPreviewLaf(this.selectedLaf, classLoader);
            final Frame frame = (Frame)FormDesigner.createFormView(componentToPreview, previewInfo);
            frame.setEnabled(true);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    frame.dispose();
                }
            });
            map.put(this.selectedLaf.getName(), frame);
            String title = frame.getTitle();
            if (title == null || "".equals(title)) {
                title = componentToPreview == formModel.getTopRADComponent() ? formModel.getName() : componentToPreview.getName();
                frame.setTitle(MessageFormat.format(NbBundle.getBundle(TestAction.class).getString("FMT_TestingForm"), title));
            }
            if (frame instanceof JFrame) {
                ((JFrame)frame).setDefaultCloseOperation(2);
                HelpCtx.setHelpIDString((JComponent)((JFrame)frame).getRootPane(), (String)"gui.modes");
            } else {
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        frame.dispose();
                    }
                });
            }
            boolean shouldPack = false;
            if (formContainer != null && formContainer.getFormSizePolicy() == 0 && formContainer.getGenerateSize()) {
                Dimension size = formContainer.getFormSize();
                if (frame.isUndecorated()) {
                    Dimension diffSize = RADVisualFormContainer.getDecoratedWindowContentDimensionDiff();
                    size = new Dimension(size.width + diffSize.width, size.height + diffSize.height);
                }
                frame.setSize(size);
            } else {
                shouldPack = true;
            }
            frame.setUndecorated(false);
            frame.setFocusableWindowState(true);
            frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
            final boolean pack = shouldPack;
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (pack) {
                        try {
                            FormLAF.setUsePreviewDefaults(classLoader, previewInfo);
                            frame.pack();
                        }
                        finally {
                            FormLAF.setUsePreviewDefaults(null, null);
                        }
                    }
                    frame.setBounds(Utilities.findCenterBounds((Dimension)frame.getSize()));
                    frame.setVisible(true);
                }
            });
            return frame;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        LAFMenu layoutMenu = new LAFMenu(this.getName());
        layoutMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)layoutMenu, (String)SelectLayoutAction.class.getName());
        return layoutMenu;
    }

    private class LAFMenu
    extends JMenu
    implements ActionListener {
        private boolean initialized;

        private LAFMenu(String name) {
            super(name);
            this.initialized = false;
        }

        @Override
        public JPopupMenu getPopupMenu() {
            JPopupMenu popup = super.getPopupMenu();
            if (!this.initialized) {
                JMenuItem mi;
                popup.removeAll();
                boolean isSynthLAF = UIManager.getLookAndFeel() instanceof SynthLookAndFeel;
                String lafName = UIManager.getLookAndFeel().getClass().getName();
                UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < lafs.length; ++i) {
                    String className = lafs[i].getClassName();
                    if (isSynthLAF) {
                        try {
                            Class<?> lafClass = Class.forName(className);
                            if (!lafName.equals(className) && SynthLookAndFeel.class.isAssignableFrom(lafClass)) {
                                continue;
                            }
                        }
                        catch (ClassNotFoundException cnfex) {
                            ErrorManager.getDefault().notify(1, (Throwable)cnfex);
                        }
                    }
                    mi = new JMenuItem(lafs[i].getName());
                    mi.putClientProperty("lafInfo", new LookAndFeelItem(lafs[i].getClassName()));
                    mi.addActionListener(this);
                    popup.add(mi);
                }
                Node[] cats = PaletteUtils.getCategoryNodes(PaletteUtils.getPaletteNode(), false);
                for (int i = 0; i < cats.length; ++i) {
                    if (!"LookAndFeels".equals(cats[i].getName())) continue;
                    Node lafNode = cats[i];
                    Node[] items = PaletteUtils.getItemNodes(lafNode, true);
                    if (items.length != 0) {
                        popup.add(new JSeparator());
                    }
                    for (int j = 0; j < items.length; ++j) {
                        PaletteItem pitem = (PaletteItem)items[j].getLookup().lookup(PaletteItem.class);
                        boolean supported = false;
                        try {
                            LookAndFeel laf;
                            Class clazz = pitem.getComponentClass();
                            if (clazz != null && LookAndFeel.class.isAssignableFrom(clazz) && (supported = (laf = (LookAndFeel)clazz.newInstance()).isSupportedLookAndFeel()) && isSynthLAF && !lafName.equals(pitem.getComponentClassName()) && SynthLookAndFeel.class.isAssignableFrom(clazz)) {
                                supported = false;
                            }
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                        catch (LinkageError ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                        if (!supported) continue;
                        mi = new JMenuItem(items[j].getDisplayName());
                        mi.putClientProperty("lafInfo", new LookAndFeelItem(pitem));
                        mi.addActionListener(this);
                        popup.add(mi);
                    }
                }
                this.initialized = true;
            }
            return popup;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o instanceof JComponent) {
                JComponent source = (JComponent)o;
                LookAndFeelItem item = (LookAndFeelItem)source.getClientProperty("lafInfo");
                try {
                    TestAction.this.selectedLaf = item.getLAFClass();
                    TestAction.this.run();
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }

    static class LookAndFeelItem {
        private String className;
        private PaletteItem pitem;

        public LookAndFeelItem(String className) {
            this.className = className;
        }

        public LookAndFeelItem(PaletteItem pitem) {
            this.pitem = pitem;
            this.className = pitem.getComponentClassName();
        }

        public String getClassName() {
            return this.className;
        }

        public Class getLAFClass() throws ClassNotFoundException {
            Class<?> clazz;
            if (this.pitem == null) {
                if (this.className == null) {
                    clazz = UIManager.getLookAndFeel().getClass();
                } else {
                    ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    clazz = Class.forName(this.className, true, classLoader);
                }
            } else {
                clazz = this.pitem.getComponentClass();
            }
            return clazz;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LookAndFeelItem)) {
                return false;
            }
            LookAndFeelItem item = (LookAndFeelItem)obj;
            return this.pitem == item.pitem && (this.pitem != null || (this.className == null ? item.className == null : this.className.equals(item.className)));
        }

        public int hashCode() {
            return this.className == null ? this.pitem.hashCode() : this.className.hashCode();
        }
    }
}

