/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ChooseSameSizeAction
extends NodeAction {
    private ActionListener menuItemListener;

    protected boolean enable(Node[] nodes) {
        List<RADComponent> comps = FormUtils.getSelectedLayoutComponents(nodes);
        return comps != null && comps.size() > 1;
    }

    public String getName() {
        return NbBundle.getMessage(ChooseSameSizeAction.class, (String)"ACT_ChooseSameSize");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] activatedNodes) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu popupMenu = new JMenu(NbBundle.getMessage(ChooseSameSizeAction.class, (String)"ACT_ChooseSameSize"));
        popupMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)popupMenu, (String)ChooseSameSizeAction.class.getName());
        popupMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JMenu menu = (JMenu)e.getSource();
                ChooseSameSizeAction.this.createSameSizeSubmenu(menu);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return popupMenu;
    }

    private void createSameSizeSubmenu(JMenu menu) {
        Node[] nodes;
        List<RADComponent> components;
        if (menu.getMenuComponentCount() > 0) {
            menu.removeAll();
        }
        if ((components = FormUtils.getSelectedLayoutComponents(nodes = this.getActivatedNodes())) == null || components.size() < 1) {
            return;
        }
        ResourceBundle bundle = NbBundle.getBundle(ChooseSameSizeAction.class);
        SameSizeMenuItem sameSizeItemH = new SameSizeMenuItem(bundle.getString("CTL_SameSizeHorizontal"), components, 0);
        SameSizeMenuItem sameSizeItemV = new SameSizeMenuItem(bundle.getString("CTL_SameSizeVertical"), components, 1);
        RADComponent c = components.get(0);
        LayoutModel lModel = c.getFormModel().getLayoutModel();
        int hLinked = lModel.areComponentsLinkSized(ChooseSameSizeAction.getComponentIds(components), 0);
        int vLinked = lModel.areComponentsLinkSized(ChooseSameSizeAction.getComponentIds(components), 1);
        if (components.size() > 1) {
            if (hLinked != -1) {
                sameSizeItemH.setSelected(hLinked == 1);
            } else {
                sameSizeItemH.setEnabled(false);
            }
            if (vLinked != -1) {
                sameSizeItemV.setSelected(vLinked == 1);
            } else {
                sameSizeItemV.setEnabled(false);
            }
        } else {
            sameSizeItemH.setSelected(hLinked == 1);
            if (hLinked != 1) {
                sameSizeItemH.setEnabled(false);
            }
            sameSizeItemV.setSelected(vLinked == 1);
            if (vLinked != 1) {
                sameSizeItemV.setEnabled(false);
            }
        }
        sameSizeItemH.addActionListener(this.getMenuItemListener());
        sameSizeItemV.addActionListener(this.getMenuItemListener());
        HelpCtx.setHelpIDString((JComponent)sameSizeItemH, (String)ChooseSameSizeAction.class.getName());
        HelpCtx.setHelpIDString((JComponent)sameSizeItemV, (String)ChooseSameSizeAction.class.getName());
        menu.add(sameSizeItemH);
        menu.add(sameSizeItemV);
    }

    private ActionListener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new SameSizeMenuItemListener();
        }
        return this.menuItemListener;
    }

    private static List<String> getComponentIds(List components) {
        ArrayList<String> ids = new ArrayList<String>();
        for (RADComponent rc : components) {
            if (rc == null) continue;
            ids.add(rc.getId());
        }
        return ids;
    }

    private static class SameSizeMenuItem
    extends JCheckBoxMenuItem {
        private int dimension;
        private List components;

        SameSizeMenuItem(String text, List components, int direction) {
            super(text);
            this.components = components;
            this.dimension = direction;
        }

        int getDimension() {
            return this.dimension;
        }

        List getRADComponents() {
            return this.components;
        }
    }

    private static class SameSizeMenuItemListener
    implements ActionListener {
        private SameSizeMenuItemListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (!(source instanceof SameSizeMenuItem)) {
                return;
            }
            SameSizeMenuItem mi = (SameSizeMenuItem)source;
            if (!mi.isEnabled()) {
                return;
            }
            List radComponents = mi.getRADComponents();
            RADComponent rc = (RADComponent)radComponents.get(0);
            RADVisualContainer visCont = ((RADVisualComponent)rc).getParentContainer();
            for (int i = 0; i < radComponents.size(); ++i) {
                RADComponent rcomp = (RADComponent)radComponents.get(i);
                if (((RADVisualComponent)rcomp).getParentContainer().equals(visCont)) continue;
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ChooseSameSizeAction.class, (String)"TXT_ComponentsNotInOneContainer")));
                return;
            }
            FormModel formModel = rc.getFormModel();
            LayoutModel layoutModel = formModel.getLayoutModel();
            Object layoutUndoMark = layoutModel.getChangeMark();
            UndoableEdit ue = layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            try {
                List compIds = ChooseSameSizeAction.getComponentIds(mi.getRADComponents());
                int dimension = mi.getDimension();
                if (mi.isSelected()) {
                    FormDesigner designer = FormEditor.getFormDesigner(formModel);
                    LayoutDesigner lDesigner = designer.getLayoutDesigner();
                    for (String compId : compIds) {
                        LayoutComponent lc = layoutModel.getLayoutComponent(compId);
                        if (!lDesigner.isComponentResizing(lc, dimension)) continue;
                        lDesigner.setComponentResizing(lc, dimension, false);
                    }
                    layoutModel.setSameSize(compIds, dimension);
                } else {
                    layoutModel.unsetSameSize(compIds, dimension);
                }
                autoUndo = false;
            }
            finally {
                formModel.fireContainerLayoutChanged(visCont, null, null, null);
                if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                    formModel.addUndoableEdit(ue);
                }
                if (autoUndo) {
                    formModel.forceUndoOfCompoundEdit();
                }
            }
        }
    }
}

