/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JTable;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.CopySupport;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyCookie;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.actions.AddAction;
import org.netbeans.modules.form.actions.AlignAction;
import org.netbeans.modules.form.actions.BindAction;
import org.netbeans.modules.form.actions.ChooseSameSizeAction;
import org.netbeans.modules.form.actions.CustomCodeAction;
import org.netbeans.modules.form.actions.CustomizeEmptySpaceAction;
import org.netbeans.modules.form.actions.CustomizeLayoutAction;
import org.netbeans.modules.form.actions.DefaultSizeAction;
import org.netbeans.modules.form.actions.DesignParentAction;
import org.netbeans.modules.form.actions.DuplicateAction;
import org.netbeans.modules.form.actions.EditContainerAction;
import org.netbeans.modules.form.actions.EncloseAction;
import org.netbeans.modules.form.actions.EventsAction;
import org.netbeans.modules.form.actions.InPlaceEditAction;
import org.netbeans.modules.form.actions.PropertyAction;
import org.netbeans.modules.form.actions.SelectLayoutAction;
import org.netbeans.modules.form.actions.SetAnchoringAction;
import org.netbeans.modules.form.actions.SetResizabilityAction;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.editors.TableCustomizer;
import org.netbeans.modules.form.layoutsupport.LayoutNode;
import org.netbeans.modules.form.menu.AddSubItemAction;
import org.netbeans.modules.form.menu.InsertMenuAction;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CustomizeAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.explorer.propertysheet.editors.NodeCustomizer;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class RADComponentNode
extends FormNode
implements RADComponentCookie,
FormPropertyCookie {
    private static final MessageFormat nodeNameFormat = new MessageFormat(FormUtils.getBundleString("FMT_ComponentNodeName"));
    private static final MessageFormat nodeNoNameFormat = new MessageFormat(FormUtils.getBundleString("FMT_UnnamedComponentNodeName"));
    private RADComponent component;
    private boolean highlightDisplayName;
    private Map<Integer, Image> img = new HashMap<Integer, Image>();
    private static boolean iconsInitialized;

    public RADComponentNode(RADComponent component) {
        this((Children)(component instanceof ComponentContainer ? new RADChildren((ComponentContainer)((Object)component)) : Children.LEAF), component);
    }

    public RADComponentNode(Children children, RADComponent component) {
        super(children, component.getFormModel());
        this.component = component;
        component.setNodeReference(this);
        if (component instanceof ComponentContainer) {
            this.getCookieSet().add((Node.Cookie)new ComponentsIndex());
        }
        this.updateName();
    }

    void updateName() {
        String compClassName = Utilities.getShortClassName(this.component.getBeanClass());
        if (this.component == this.component.getFormModel().getTopRADComponent()) {
            this.setDisplayName(nodeNoNameFormat.format(new Object[]{compClassName}));
        } else {
            this.setDisplayName(nodeNameFormat.format(new Object[]{this.getName(), compClassName}));
        }
    }

    public void fireComponentPropertiesChange() {
        this.firePropertyChange(null, null, null);
    }

    public void fireComponentPropertySetsChange() {
        this.firePropertySetsChange(null, null);
    }

    public Image getIcon(final int iconType) {
        Image icon = this.img.get(iconType);
        if (icon != null) {
            return icon;
        }
        icon = BeanSupport.getBeanIcon(this.component.getBeanClass(), iconType);
        if (icon == null) {
            final String className = this.component.getBeanClass().getName();
            final String classDetails = (String)this.component.getAuxValue("classDetails");
            if (!iconsInitialized) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Image icon = PaletteUtils.getIconForClass(className, classDetails, iconType, true);
                        iconsInitialized = true;
                        if (icon != null) {
                            RADComponentNode.this.img.put(iconType, icon);
                            RADComponentNode.this.fireIconChange();
                        }
                    }
                });
            } else {
                icon = PaletteUtils.getIconForClass(className, classDetails, iconType, false);
            }
            if (icon == null) {
                BeanInfo bi = this.component.getBeanInfo();
                if (bi != null) {
                    icon = bi.getIcon(iconType);
                }
                if (icon == null) {
                    icon = super.getIcon(iconType);
                }
            }
        }
        this.img.put(iconType, icon);
        return icon;
    }

    public Image getOpenedIcon(int iconType) {
        return this.getIcon(iconType);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.components.editing");
    }

    public Node.PropertySet[] getPropertySets() {
        final Node.PropertySet[][] props = new Node.PropertySet[1][];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FormLAF.executeWithLAFLocks(new Runnable(){

                    @Override
                    public void run() {
                        props[0] = RADComponentNode.this.component.getProperties();
                    }
                });
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException iex) {
                FormUtils.LOGGER.log(Level.INFO, iex.getMessage(), iex);
            }
            catch (InvocationTargetException itex) {
                FormUtils.LOGGER.log(Level.INFO, itex.getMessage(), itex);
            }
        }
        return props[0];
    }

    public NewType[] getNewTypes() {
        return this.component.getNewTypes();
    }

    public Action getPreferredAction() {
        FormEditor formEditor = FormEditor.getFormEditor(this.component.getFormModel());
        if (formEditor == null) {
            return null;
        }
        for (Action action : formEditor.getDefaultComponentActions()) {
            if (!action.isEnabled()) continue;
            return action;
        }
        return null;
    }

    @Override
    public Action[] getActions(boolean context) {
        if (this.actions == null) {
            int i;
            ArrayList<Action> actions = new ArrayList<Action>(20);
            RADComponent topComp = this.component.getFormModel().getTopRADComponent();
            if (this.component.isReadOnly()) {
                if (this.component == topComp) {
                    actions.add((Action)SystemAction.get(TestAction.class));
                    actions.add(null);
                }
                Event[] events = this.component.getKnownEvents();
                for (i = 0; i < events.length; ++i) {
                    if (!events[i].hasEventHandlers()) continue;
                    actions.add((Action)SystemAction.get(EventsAction.class));
                    actions.add(null);
                    break;
                }
                actions.add((Action)SystemAction.get(CopyAction.class));
            } else {
                if (InPlaceEditLayer.supportsEditingFor(this.component.getBeanClass(), false)) {
                    actions.add((Action)SystemAction.get(InPlaceEditAction.class));
                }
                if (JTable.class.isAssignableFrom(this.component.getBeanClass())) {
                    actions.add((Action)SystemAction.get(CustomizeTableAction.class));
                }
                if (this.component != topComp) {
                    actions.add((Action)SystemAction.get(ChangeVariableNameAction.class));
                } else {
                    actions.add((Action)SystemAction.get(TestAction.class));
                }
                if (FormEditor.getBindingSupport(this.component.getFormModel()) != null) {
                    actions.add((Action)SystemAction.get(BindAction.class));
                }
                actions.add((Action)SystemAction.get(EventsAction.class));
                actions.add(null);
                List actionProps = this.component.getActionProperties();
                for (RADProperty prop : actionProps) {
                    PropertyAction action = PropertyAction.createIfEditable(prop);
                    if (action == null) continue;
                    actions.add(action);
                }
                RADComponentNode.addSeparator(actions);
                if (this.component instanceof ComponentContainer) {
                    this.addContainerActions(actions);
                    this.addLayoutActions(actions);
                } else {
                    this.addLayoutActions(actions);
                    this.addContainerActions(actions);
                }
                if (this.component != topComp) {
                    actions.add((Action)SystemAction.get(MoveUpAction.class));
                    actions.add((Action)SystemAction.get(MoveDownAction.class));
                }
                if (this.component instanceof ComponentContainer) {
                    actions.add((Action)SystemAction.get(ReorderAction.class));
                }
                RADComponentNode.addSeparator(actions);
                if (this.component != topComp) {
                    actions.add((Action)SystemAction.get(CutAction.class));
                }
                actions.add((Action)SystemAction.get(CopyAction.class));
                if (this.component instanceof ComponentContainer) {
                    actions.add((Action)SystemAction.get(PasteAction.class));
                }
                if (this.component != topComp) {
                    actions.add((Action)SystemAction.get(DuplicateAction.class));
                    actions.add((Action)SystemAction.get(DeleteAction.class));
                }
                actions.add(null);
                actions.add((Action)SystemAction.get(CustomCodeAction.class));
            }
            actions.add(null);
            Action[] superActions = super.getActions(context);
            for (i = 0; i < superActions.length; ++i) {
                actions.add(superActions[i]);
            }
            this.actions = new Action[actions.size()];
            actions.toArray(this.actions);
        }
        return this.actions;
    }

    private void addLayoutActions(List<Action> actions) {
        if (this.component.getParentComponent() instanceof RADVisualContainer) {
            actions.add((Action)SystemAction.get(AlignAction.class));
            actions.add((Action)SystemAction.get(SetAnchoringAction.class));
            actions.add((Action)SystemAction.get(SetResizabilityAction.class));
            actions.add((Action)SystemAction.get(ChooseSameSizeAction.class));
            actions.add((Action)SystemAction.get(DefaultSizeAction.class));
            actions.add((Action)SystemAction.get(EncloseAction.class));
            actions.add((Action)SystemAction.get(CustomizeEmptySpaceAction.class));
            actions.add(null);
        }
    }

    private void addContainerActions(List<Action> actions) {
        if (this.component instanceof RADVisualContainer) {
            if (!((RADVisualContainer)this.component).hasDedicatedLayoutSupport()) {
                actions.add((Action)SystemAction.get(SelectLayoutAction.class));
                actions.add((Action)SystemAction.get(CustomizeLayoutAction.class));
            }
            if (MenuEditLayer.isMenuBarContainer(this.component)) {
                actions.add((Action)SystemAction.get(InsertMenuAction.class));
            } else if (MenuEditLayer.isMenuRelatedContainer(this.component)) {
                actions.add((Action)SystemAction.get(AddSubItemAction.class));
            } else {
                actions.add((Action)SystemAction.get(AddAction.class));
            }
        }
        if (this.getNewTypes().length != 0) {
            actions.add(null);
            actions.add((Action)SystemAction.get(NewAction.class));
        }
        if (EditContainerAction.isEditableComponent(this.component)) {
            actions.add((Action)SystemAction.get(EditContainerAction.class));
        }
        if (DesignParentAction.isParentEditableComponent(this.component)) {
            actions.add((Action)SystemAction.get(DesignParentAction.class));
        }
        if (this.component.getParentComponent() == null) {
            if (this.component instanceof RADVisualComponent) {
                actions.add((Action)SystemAction.get(DefaultSizeAction.class));
            }
            if (this.component instanceof RADVisualContainer && !((RADVisualContainer)this.component).hasDedicatedLayoutSupport()) {
                actions.add((Action)SystemAction.get(CustomizeEmptySpaceAction.class));
            }
        }
        RADComponentNode.addSeparator(actions);
    }

    private static void addSeparator(List<Action> actions) {
        int n = actions.size();
        if (n > 0 && actions.get(n - 1) != null) {
            actions.add(null);
        }
    }

    public String getName() {
        return this.component.getName();
    }

    public void setName(String s) {
        this.component.rename(s);
    }

    public boolean canRename() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public boolean canDestroy() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public void destroy() throws IOException {
        if (this.component.getNodeReference() == this) {
            if (MetaComponentCreator.isTransparentLayoutComponent(this.component.getParentComponent())) {
                this.component = this.component.getParentComponent();
            }
            if (EventQueue.isDispatchThread()) {
                this.component.getFormModel().removeComponent(this.component, true);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RADComponentNode.this.component.getFormModel().removeComponent(RADComponentNode.this.component, true);
                    }
                });
            }
        }
        super.destroy();
    }

    public boolean hasCustomizer() {
        return !this.component.isReadOnly() && this.component.getBeanInfo().getBeanDescriptor().getCustomizerClass() != null;
    }

    @Override
    protected Component createCustomizer() {
        Object customizerObject;
        Class<Object> customizerClass = this.component.getBeanInfo().getBeanDescriptor().getCustomizerClass();
        if (customizerClass == null) {
            if (JTable.class.isAssignableFrom(this.component.getBeanClass())) {
                customizerClass = TableCustomizer.class;
            } else {
                return null;
            }
        }
        try {
            customizerObject = customizerClass.newInstance();
        }
        catch (InstantiationException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
            return null;
        }
        if (!(customizerObject instanceof Component) || !(customizerObject instanceof Customizer)) {
            return null;
        }
        if (customizerObject instanceof NodeCustomizer) {
            ((NodeCustomizer)customizerObject).attach((Node)this.component.getNodeReference());
        }
        this.component.ensureDefaultPropertyValuesInitialization();
        Customizer customizer = (Customizer)customizerObject;
        customizer.setObject(this.component.getBeanInstance());
        if (customizerObject instanceof FormAwareEditor) {
            Node.Property prop = this.component.getProperties()[0].getProperties()[0];
            ((FormAwareEditor)customizerObject).setContext(this.component.getFormModel(), (FormProperty)prop);
        }
        customizer.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FormProperty[] properties;
                if (evt.getPropertyName() != null) {
                    RADProperty changedProperty = RADComponentNode.this.component.getBeanProperty(evt.getPropertyName());
                    if (changedProperty == null) return;
                    properties = new FormProperty[]{changedProperty};
                } else {
                    properties = RADComponentNode.this.component.getAllBeanProperties();
                    evt = null;
                }
                RADComponentNode.this.updatePropertiesFromCustomizer(properties, evt);
            }
        });
        return (Component)customizerObject;
    }

    private void updatePropertiesFromCustomizer(final FormProperty[] properties, final PropertyChangeEvent evt) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Object oldValue = evt != null ? evt.getOldValue() : null;
                Object newValue = evt != null ? evt.getNewValue() : null;
                for (int i = 0; i < properties.length; ++i) {
                    FormProperty prop = properties[i];
                    try {
                        prop.reinstateProperty();
                        prop.propertyValueChanged(oldValue, newValue);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public Transferable clipboardCopy() throws IOException {
        return new CopySupport.RADTransferable(CopySupport.getComponentCopyFlavor(), this.component);
    }

    public Transferable clipboardCut() throws IOException {
        return new CopySupport.RADTransferable(CopySupport.getComponentCutFlavor(), this.component);
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        CopySupport.createPasteTypes(t, s, this.component.getFormModel(), this.component);
    }

    @Override
    public RADComponent getRADComponent() {
        return this.component;
    }

    @Override
    public FormProperty getProperty(String name) {
        return this.component.getPropertyByName(name, FormProperty.class, true);
    }

    public String getHtmlDisplayName() {
        if (this.highlightDisplayName) {
            return "<html><b>" + this.getDisplayName() + "</b></html>";
        }
        return "<html>" + this.getDisplayName() + "</html>";
    }

    void highlightDisplayName(boolean highlight) {
        if (highlight != this.highlightDisplayName) {
            this.highlightDisplayName = highlight;
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
    }

    private static final class ChangeVariableNameAction
    extends RenameAction {
        private ChangeVariableNameAction() {
        }

        public String getName() {
            return NbBundle.getMessage(ChangeVariableNameAction.class, (String)"ChangeVariableNameAction");
        }
    }

    private final class ComponentsIndex
    extends Index.Support {
        private ComponentsIndex() {
        }

        public Node[] getNodes() {
            Object comps = RADComponentNode.this.component instanceof RADVisualContainer ? ((RADVisualContainer)RADComponentNode.this.component).getSubComponents() : (RADComponentNode.this.component instanceof ComponentContainer ? ((ComponentContainer)((Object)RADComponentNode.this.component)).getSubBeans() : null);
            Node[] nodes = new Node[comps != null ? ((RADVisualComponent[])comps).length : 0];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = comps[i].getNodeReference();
            }
            return nodes;
        }

        public int getNodesCount() {
            return this.getNodes().length;
        }

        public void reorder(int[] perm) {
            if (RADComponentNode.this.component instanceof ComponentContainer) {
                ComponentContainer cont = (ComponentContainer)((Object)RADComponentNode.this.component);
                cont.reorderSubComponents(perm);
                RADComponentNode.this.component.getFormModel().fireComponentsReordered(cont, perm);
            }
        }
    }

    private static final class CustomizeTableAction
    extends CustomizeAction {
        private CustomizeTableAction() {
        }

        public String getName() {
            return FormUtils.getBundleString("NAME_CustomizeTableAction");
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }
    }

    public static class RADChildren
    extends FormNode.FormNodeChildren {
        private ComponentContainer container;
        private Object keyLayout;

        public RADChildren(ComponentContainer container) {
            this.container = container;
            this.updateKeys();
        }

        @Override
        protected void updateKeys() {
            RADComponent[] subComps = this.container.getSubBeans();
            ArrayList<Object> keys = new ArrayList<Object>(subComps.length + 2);
            if (this.container instanceof RADVisualContainer) {
                RADVisualContainer visualCont = (RADVisualContainer)this.container;
                RADComponent menuComp = visualCont.getContainerMenu();
                if (menuComp != null) {
                    keys.add(menuComp);
                }
                if (visualCont.shouldHaveLayoutNode()) {
                    this.keyLayout = visualCont.getLayoutSupport().getLayoutDelegate();
                    keys.add(this.keyLayout);
                }
                for (int i = 0; i < subComps.length; ++i) {
                    if (subComps[i] == menuComp) continue;
                    keys.add(subComps[i]);
                }
            } else {
                for (int i = 0; i < subComps.length; ++i) {
                    keys.add(subComps[i]);
                }
            }
            this.setKeys(keys);
        }

        protected Node[] createNodes(Object key) {
            FormNode node;
            if (key == this.keyLayout) {
                node = new LayoutNode((RADVisualContainer)this.container);
            } else {
                node = new RADComponentNode((RADComponent)key);
                node.getChildren().getNodes();
            }
            return new Node[]{node};
        }
    }
}

