/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.ComponentConverter;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormServices;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.form.ViewConverter;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class FormUtils {
    public static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.form");
    private static final RequestProcessor RP = new RequestProcessor("GUI Builder", 10, false);
    public static final int CHANGED_ONLY = 1;
    public static final int DISABLE_CHANGE_FIRING = 2;
    public static final int PASS_DESIGN_VALUES = 4;
    public static final int DONT_CLONE_VALUES = 8;
    private static final Object CLASS_EXACTLY = new Object();
    private static final Object CLASS_AND_SUBCLASSES = new Object();
    private static final Object CLASS_AND_SWING_SUBCLASSES = new Object();
    public static final Object PROP_PREFERRED = new Object();
    public static final Object PROP_NORMAL = new Object();
    public static final Object PROP_EXPERT = new Object();
    public static final Object PROP_HIDDEN = new Object();
    static final String PROP_REQUIRES_PARENT = "thisPropertyRequiresParent";
    static final String PROP_REQUIRES_CHILDREN = "thisPropertyRequiresChildren";
    private static Object[][] propertyCategories = new Object[][]{{"java.awt.Component", CLASS_AND_SUBCLASSES, "locale", PROP_HIDDEN, "locationOnScreen", PROP_HIDDEN, "showing", PROP_HIDDEN}, {"java.awt.Component", CLASS_AND_SWING_SUBCLASSES, "accessibleContext", PROP_HIDDEN, "components", PROP_HIDDEN, "containerListeners", PROP_HIDDEN, "focusTraversalPolicySet", PROP_HIDDEN, "focusCycleRootAncestor", PROP_HIDDEN, "focusOwner", PROP_HIDDEN}, {"java.awt.Container", CLASS_AND_SUBCLASSES, "componentCount", PROP_HIDDEN, "layout", PROP_HIDDEN}, {"javax.swing.JComponent", CLASS_AND_SUBCLASSES, "debugGraphicsOptions", PROP_EXPERT, "preferredSize", PROP_NORMAL, "componentPopupMenu", PROP_NORMAL, "actionMap", PROP_HIDDEN}, {"javax.swing.JComponent", CLASS_AND_SWING_SUBCLASSES, "graphics", PROP_HIDDEN, "height", PROP_HIDDEN, "inputMap", PROP_HIDDEN, "maximumSizeSet", PROP_HIDDEN, "minimumSizeSet", PROP_HIDDEN, "preferredSizeSet", PROP_HIDDEN, "registeredKeyStrokes", PROP_HIDDEN, "rootPane", PROP_HIDDEN, "topLevelAncestor", PROP_HIDDEN, "validateRoot", PROP_HIDDEN, "visibleRect", PROP_HIDDEN, "width", PROP_HIDDEN, "x", PROP_HIDDEN, "y", PROP_HIDDEN, "ancestorListeners", PROP_HIDDEN, "propertyChangeListeners", PROP_HIDDEN, "vetoableChangeListeners", PROP_HIDDEN, "actionListeners", PROP_HIDDEN, "changeListeners", PROP_HIDDEN, "itemListeners", PROP_HIDDEN, "managingFocus", PROP_HIDDEN, "optimizedDrawingEnabled", PROP_HIDDEN, "paintingTile", PROP_HIDDEN}, {"java.awt.Window", CLASS_AND_SWING_SUBCLASSES, "focusCycleRootAncestor", PROP_HIDDEN, "focusOwner", PROP_HIDDEN, "active", PROP_HIDDEN, "alignmentX", PROP_HIDDEN, "alignmentY", PROP_HIDDEN, "bufferStrategy", PROP_HIDDEN, "focused", PROP_HIDDEN, "graphicsConfiguration", PROP_HIDDEN, "mostRecentFocusOwner", PROP_HIDDEN, "inputContext", PROP_HIDDEN, "ownedWindows", PROP_HIDDEN, "owner", PROP_HIDDEN, "windowFocusListeners", PROP_HIDDEN, "windowListeners", PROP_HIDDEN, "windowStateListeners", PROP_HIDDEN, "warningString", PROP_HIDDEN, "toolkit", PROP_HIDDEN, "focusableWindow", PROP_HIDDEN, "locationRelativeTo", PROP_HIDDEN}, {"javax.swing.text.JTextComponent", CLASS_AND_SUBCLASSES, "document", PROP_PREFERRED, "text", PROP_PREFERRED, "editable", PROP_PREFERRED, "disabledTextColor", PROP_NORMAL, "selectedTextColor", PROP_NORMAL, "selectionColor", PROP_NORMAL, "caretColor", PROP_NORMAL}, {"javax.swing.text.JTextComponent", CLASS_AND_SWING_SUBCLASSES, "actions", PROP_HIDDEN, "caretListeners", PROP_HIDDEN, "inputMethodRequests", PROP_HIDDEN}, {"javax.swing.JTextField", CLASS_AND_SUBCLASSES, "columns", PROP_PREFERRED}, {"javax.swing.JTextField", CLASS_AND_SWING_SUBCLASSES, "horizontalVisibility", PROP_HIDDEN}, {"javax.swing.JFormattedTextField", CLASS_EXACTLY, "formatterFactory", PROP_PREFERRED, "formatter", PROP_HIDDEN}, {"javax.swing.JPasswordField", CLASS_EXACTLY, "password", PROP_HIDDEN}, {"javax.swing.JTextArea", CLASS_AND_SUBCLASSES, "columns", PROP_PREFERRED, "rows", PROP_PREFERRED, "lineWrap", PROP_PREFERRED, "wrapStyleWord", PROP_PREFERRED}, {"javax.swing.JEditorPane", CLASS_AND_SUBCLASSES, "border", PROP_PREFERRED, "font", PROP_PREFERRED, "contentType", PROP_PREFERRED, "editorKit", PROP_PREFERRED}, {"javax.swing.JEditorPane", CLASS_AND_SWING_SUBCLASSES, "hyperlinkListeners", PROP_HIDDEN}, {"javax.swing.JTextPane", CLASS_EXACTLY, "characterAttributes", PROP_HIDDEN, "paragraphAttributes", PROP_HIDDEN}, {"javax.swing.JTree", CLASS_AND_SUBCLASSES, "border", PROP_PREFERRED, "model", PROP_PREFERRED}, {"javax.swing.JTree", CLASS_EXACTLY, "editing", PROP_HIDDEN, "editingPath", PROP_HIDDEN, "selectionCount", PROP_HIDDEN, "selectionEmpty", PROP_HIDDEN, "lastSelectedPathComponent", PROP_HIDDEN, "leadSelectionRow", PROP_HIDDEN, "maxSelectionRow", PROP_HIDDEN, "minSelectionRow", PROP_HIDDEN, "treeExpansionListeners", PROP_HIDDEN, "treeSelectionListeners", PROP_HIDDEN, "treeWillExpandListeners", PROP_HIDDEN}, {"javax.swing.AbstractButton", CLASS_AND_SUBCLASSES, "mnemonic", PROP_PREFERRED, "action", PROP_PREFERRED}, {"javax.swing.AbstractButton", CLASS_AND_SWING_SUBCLASSES, "selectedObjects", PROP_HIDDEN}, {"javax.swing.JToggleButton", CLASS_AND_SUBCLASSES, "icon", PROP_PREFERRED, "selected", PROP_PREFERRED, "buttonGroup", PROP_PREFERRED}, {"javax.swing.JButton", CLASS_AND_SUBCLASSES, "icon", PROP_PREFERRED, "defaultButton", PROP_HIDDEN}, {"javax.swing.JCheckBox", CLASS_EXACTLY, "icon", PROP_NORMAL, "model", PROP_PREFERRED}, {"javax.swing.JRadioButton", CLASS_EXACTLY, "icon", PROP_NORMAL, "model", PROP_PREFERRED}, {"javax.swing.JMenuItem", CLASS_AND_SUBCLASSES, "icon", PROP_PREFERRED}, {"javax.swing.JMenuItem", CLASS_AND_SWING_SUBCLASSES, "menuDragMouseListeners", PROP_HIDDEN, "menuKeyListeners", PROP_HIDDEN}, {"javax.swing.JCheckBoxMenuItem", CLASS_AND_SUBCLASSES, "selected", PROP_PREFERRED, "buttonGroup", PROP_PREFERRED, "icon", PROP_NORMAL}, {"javax.swing.JRadioButtonMenuItem", CLASS_AND_SUBCLASSES, "selected", PROP_PREFERRED, "buttonGroup", PROP_PREFERRED, "icon", PROP_NORMAL}, {"javax.swing.JTabbedPane", CLASS_EXACTLY, "selectedComponent", PROP_EXPERT}, {"javax.swing.JSplitPane", CLASS_AND_SUBCLASSES, "dividerLocation", PROP_PREFERRED, "dividerSize", PROP_PREFERRED, "orientation", PROP_PREFERRED, "resizeWeight", PROP_PREFERRED}, {"javax.swing.JSplitPane", CLASS_EXACTLY, "leftComponent", PROP_HIDDEN, "rightComponent", PROP_HIDDEN, "topComponent", PROP_HIDDEN, "bottomComponent", PROP_HIDDEN}, {"javax.swing.JSlider", CLASS_AND_SUBCLASSES, "majorTickSpacing", PROP_PREFERRED, "minorTickSpacing", PROP_PREFERRED, "paintLabels", PROP_PREFERRED, "paintTicks", PROP_PREFERRED, "paintTrack", PROP_PREFERRED, "snapToTicks", PROP_PREFERRED}, {"javax.swing.JLabel", CLASS_AND_SUBCLASSES, "horizontalAlignment", PROP_PREFERRED, "verticalAlignment", PROP_PREFERRED, "displayedMnemonic", PROP_PREFERRED, "labelFor", PROP_PREFERRED}, {"javax.swing.JList", CLASS_AND_SUBCLASSES, "model", PROP_PREFERRED, "border", PROP_PREFERRED, "selectionMode", PROP_PREFERRED}, {"javax.swing.JList", CLASS_AND_SWING_SUBCLASSES, "listData", PROP_HIDDEN}, {"javax.swing.JComboBox", CLASS_AND_SUBCLASSES, "model", PROP_PREFERRED}, {"javax.swing.JComboBox", CLASS_EXACTLY, "popupVisible", PROP_HIDDEN, "popupMenuListeners", PROP_HIDDEN, "selectedObjects", PROP_HIDDEN}, {"javax.swing.Scrollable", CLASS_AND_SWING_SUBCLASSES, "preferredScrollableViewportSize", PROP_HIDDEN, "scrollableTracksViewportWidth", PROP_HIDDEN, "scrollableTracksViewportHeight", PROP_HIDDEN}, {"javax.swing.JScrollBar", CLASS_EXACTLY, "adjustmentListeners", PROP_HIDDEN}, {"javax.swing.JTable", CLASS_AND_SUBCLASSES, "model", PROP_PREFERRED, "border", PROP_PREFERRED, "autoCreateColumnsFromModel", PROP_PREFERRED}, {"javax.swing.JTable", CLASS_EXACTLY, "editing", PROP_HIDDEN, "editorComponent", PROP_HIDDEN, "selectedColumn", PROP_HIDDEN, "selectedColumnCount", PROP_HIDDEN, "selectedColumns", PROP_HIDDEN, "selectedRow", PROP_HIDDEN, "selectedRowCount", PROP_HIDDEN, "selectedRows", PROP_HIDDEN}, {"javax.swing.JSeparator", CLASS_EXACTLY, "font", PROP_NORMAL}, {"javax.swing.JInternalFrame", CLASS_AND_SUBCLASSES, "defaultCloseOperation", PROP_PREFERRED, "visible", PROP_NORMAL}, {"javax.swing.JInternalFrame", CLASS_EXACTLY, "menuBar", PROP_HIDDEN, "JMenuBar", PROP_HIDDEN, "desktopPane", PROP_HIDDEN, "internalFrameListeners", PROP_HIDDEN, "mostRecentFocusOwner", PROP_HIDDEN, "warningString", PROP_HIDDEN, "closed", PROP_HIDDEN}, {"javax.swing.JMenu", CLASS_EXACTLY, "accelerator", PROP_HIDDEN, "tearOff", PROP_HIDDEN, "menuComponents", PROP_HIDDEN, "menuListeners", PROP_HIDDEN, "popupMenu", PROP_HIDDEN, "topLevelMenu", PROP_HIDDEN}, {"javax.swing.JPopupMenu", CLASS_AND_SWING_SUBCLASSES, "popupMenuListeners", PROP_HIDDEN}, {"java.awt.Frame", CLASS_AND_SWING_SUBCLASSES, "cursorType", PROP_HIDDEN, "menuBar", PROP_HIDDEN}, {"javax.swing.JFrame", CLASS_AND_SUBCLASSES, "title", PROP_PREFERRED}, {"javax.swing.JFrame", CLASS_EXACTLY, "menuBar", PROP_HIDDEN, "layout", PROP_HIDDEN}, {"javax.swing.JDialog", CLASS_AND_SUBCLASSES, "title", PROP_PREFERRED}, {"javax.swing.JDialog", CLASS_EXACTLY, "layout", PROP_HIDDEN}, {"javax.swing.MenuElement", CLASS_AND_SWING_SUBCLASSES, "component", PROP_HIDDEN, "subElements", PROP_HIDDEN}, {"javax.swing.JMenuBar", CLASS_EXACTLY, "helpMenu", PROP_HIDDEN, "menuCount", PROP_HIDDEN, "selected", PROP_HIDDEN}, {"javax.swing.JSpinner", CLASS_AND_SUBCLASSES, "model", PROP_PREFERRED}, {"javax.swing.JSpinner", CLASS_AND_SWING_SUBCLASSES, "foreground", PROP_HIDDEN, "background", PROP_HIDDEN}, {"java.applet.Applet", CLASS_AND_SUBCLASSES, "appletContext", PROP_HIDDEN, "codeBase", PROP_HIDDEN, "documentBase", PROP_HIDDEN}, {"javax.swing.JFileChooser", CLASS_EXACTLY, "acceptAllFileFilter", PROP_HIDDEN, "choosableFileFilters", PROP_HIDDEN}, {"javax.swing.Box$Filler", CLASS_EXACTLY, "minimumSize", PROP_PREFERRED, "preferredSize", PROP_PREFERRED, "maximumSize", PROP_PREFERRED, "background", PROP_NORMAL, "border", PROP_NORMAL, "foreground", PROP_NORMAL, "toolTipText", PROP_NORMAL}};
    private static Object[][] propertiesAccess = new Object[][]{{"javax.swing.JFrame", CLASS_AND_SUBCLASSES, "defaultCloseOperation", new Integer(2)}};
    private static Object[][] propertyContainerDeps = new Object[][]{{"javax.swing.JTabbedPane", CLASS_AND_SUBCLASSES, "selectedIndex", "thisPropertyRequiresChildren", "selectedComponent", "thisPropertyRequiresChildren"}, {"javax.swing.JInternalFrame", CLASS_AND_SUBCLASSES, "maximum", "thisPropertyRequiresParent", "icon", "thisPropertyRequiresParent"}, {"javax.swing.JTable", CLASS_AND_SUBCLASSES, "columnModel", "thisPropertyRequiresParent"}};
    private static Object[][] propertyOrder = new Object[][]{{"javax.swing.text.JTextComponent", "document", "text", "editable", "background"}, {"javax.swing.JSpinner", "model", "editor"}, {"javax.swing.AbstractButton", "action", "actionCommand", "action", "enabled", "action", "mnemonic", "action", "icon", "action", "text", "action", "toolTipText"}, {"javax.swing.JMenuItem", "action", "accelerator"}, {"javax.swing.JList", "model", "selectedIndex", "model", "selectedValues"}, {"javax.swing.JComboBox", "model", "selectedIndex", "model", "selectedItem"}, {"java.awt.TextComponent", "text", "selectionStart", "text", "selectionEnd"}, {"javax.swing.JEditorPane", "contentType", "text", "editorKit", "text"}, {"javax.swing.JTable", "autoCreateColumnsFromModel", "model"}, {"javax.swing.JCheckBox", "model", "mnemonic", "model", "text"}, {"javax.swing.JRadioButton", "model", "buttonGroup"}, {"java.awt.Dialog", "undecorated", "opacity", "undecorated", "shape"}, {"java.awt.Frame", "undecorated", "opacity", "undecorated", "shape"}, {"javax.swing.JFileChooser", "dialogType", "approveButtonText"}};
    private static Object[][] swingTextProperties = new Object[][]{{"javax.swing.JComponent", CLASS_AND_SUBCLASSES, "toolTipText", Boolean.TRUE}, {"javax.swing.JLabel", CLASS_AND_SUBCLASSES, "text", Boolean.TRUE}, {"javax.swing.AbstractButton", CLASS_AND_SUBCLASSES, "text", Boolean.TRUE}};
    private static String[] forbiddenContainers = new String[]{"javax.swing.JLabel", "javax.swing.JButton", "javax.swing.JToggleButton", "javax.swing.JCheckBox", "javax.swing.JRadioButton", "javax.swing.JComboBox", "javax.swing.JList", "javax.swing.JTextField", "javax.swing.JTextArea", "javax.swing.JScrollBar", "javax.swing.JSlider", "javax.swing.JProgressBar", "javax.swing.JFormattedTextField", "javax.swing.JPasswordField", "javax.swing.JSpinner", "javax.swing.JSeparator", "javax.swing.JTextPane", "javax.swing.JEditorPane", "javax.swing.JTree", "javax.swing.JTable", "javax.swing.JOptionPane", "javax.swing.JColorChooser", "javax.swing.JFileChooser", "javax.swing.Box$Filler"};
    private static Map<Class<?>, Map<String, DefaultValueDeviation>> defaultValueDeviations;

    public static ResourceBundle getBundle() {
        return NbBundle.getBundle(FormUtils.class);
    }

    public static String getBundleString(String key) {
        return NbBundle.getBundle(FormUtils.class).getString(key);
    }

    public static String getFormattedBundleString(String key, Object ... arguments) {
        return NbBundle.getMessage(FormUtils.class, (String)key, (Object[])arguments);
    }

    public static Object cloneObject(Object o, FormModel formModel) throws CloneNotSupportedException {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double || o instanceof Boolean || o instanceof Character || o instanceof String) {
            return o;
        }
        if (o.getClass() == Font.class) {
            return o;
        }
        if (o.getClass() == TitledBorder.class) {
            TitledBorder border = (TitledBorder)o;
            return new TitledBorder(border.getBorder(), border.getTitle(), border.getTitleJustification(), border.getTitlePosition(), border.getTitleFont(), border.getTitleColor());
        }
        if (o instanceof Dimension) {
            return new Dimension((Dimension)o);
        }
        if (o instanceof Point) {
            return new Point((Point)o);
        }
        if (o instanceof Rectangle) {
            return new Rectangle((Rectangle)o);
        }
        if (o instanceof Insets) {
            return ((Insets)o).clone();
        }
        if (o instanceof Paint) {
            return o;
        }
        if (o.getClass() == DefaultListModel.class) {
            ListModel listModel = (ListModel)o;
            DefaultListModel<Object> newListModel = new DefaultListModel<Object>();
            for (int i = 0; i < listModel.getSize(); ++i) {
                newListModel.addElement(FormUtils.cloneObject(listModel.getElementAt(i), formModel));
            }
            return newListModel;
        }
        if (o.getClass() == DefaultComboBoxModel.class) {
            ListModel comboModel = (ListModel)o;
            DefaultComboBoxModel<Object> newComboModel = new DefaultComboBoxModel<Object>();
            for (int i = 0; i < comboModel.getSize(); ++i) {
                newComboModel.addElement(FormUtils.cloneObject(comboModel.getElementAt(i), formModel));
            }
            return newComboModel;
        }
        if (o.getClass() == DefaultTreeModel.class) {
            TreeModelListener[] listeners;
            DefaultTreeModel model = (DefaultTreeModel)o;
            for (TreeModelListener listener : listeners = model.getTreeModelListeners()) {
                model.removeTreeModelListener(listener);
            }
            Object clone = FormUtils.cloneBeanInstance(o, null, formModel);
            for (TreeModelListener listener : listeners) {
                model.addTreeModelListener(listener);
            }
            return clone;
        }
        if (o instanceof Serializable) {
            return FormUtils.cloneBeanInstance(o, null, formModel);
        }
        throw new CloneNotSupportedException();
    }

    public static Object cloneBeanInstance(Object bean, BeanInfo bInfo, FormModel formModel) throws CloneNotSupportedException {
        Object clone;
        if (bean == null) {
            return null;
        }
        if (bean instanceof Serializable) {
            Object object;
            block18: {
                OOS oos = null;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    oos = new OOS(baos);
                    oos.writeObject(bean);
                    oos.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    object = new OIS(bais, bean.getClass().getClassLoader(), formModel).readObject();
                    if (oos == null) break block18;
                }
                catch (Exception ex) {
                    try {
                        LOGGER.log(Level.INFO, "Cannot clone " + bean.getClass().getName(), ex);
                        throw new CloneNotSupportedException();
                    }
                    catch (Throwable throwable) {
                        if (oos != null) {
                            oos.checkJComponentSerialization();
                        }
                        throw throwable;
                    }
                }
                oos.checkJComponentSerialization();
            }
            return object;
        }
        try {
            clone = CreationFactory.createDefaultInstance(bean.getClass());
            if (clone == null) {
                throw new CloneNotSupportedException();
            }
            if (bInfo == null) {
                bInfo = Utilities.getBeanInfo(bean.getClass());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Cannot clone " + bean.getClass().getName(), ex);
            throw new CloneNotSupportedException();
        }
        PropertyDescriptor[] pds = bInfo.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            Object propertyValue;
            Method getter = pds[i].getReadMethod();
            Method setter = pds[i].getWriteMethod();
            if (getter == null || setter == null) continue;
            try {
                propertyValue = getter.invoke(bean, new Object[0]);
            }
            catch (Exception e1) {
                continue;
            }
            try {
                propertyValue = FormUtils.cloneObject(propertyValue, formModel);
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                setter.invoke(clone, propertyValue);
                continue;
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        return clone;
    }

    public static void copyProperties(Node.Property[] sourceProperties, Node.Property[] targetProperties, int mode) {
        for (int i = 0; i < sourceProperties.length; ++i) {
            FormProperty sfProp;
            Node.Property snProp = sourceProperties[i];
            FormProperty formProperty = sfProp = snProp instanceof FormProperty ? (FormProperty)snProp : null;
            if (sfProp != null && (mode & 1) != 0 && !sfProp.isChanged()) continue;
            Node.Property tnProp = targetProperties[i];
            if (!tnProp.getName().equals(snProp.getName())) {
                int j;
                for (j = 0; j < targetProperties.length && !(tnProp = targetProperties[i]).getName().equals(snProp.getName()); ++j) {
                }
                if (j == targetProperties.length) continue;
            }
            FormProperty tfProp = tnProp instanceof FormProperty ? (FormProperty)tnProp : null;
            try {
                Object propertyValue;
                Object copiedValue = propertyValue = snProp.getValue();
                if ((mode & 8) == 0) {
                    if (!(propertyValue instanceof FormDesignValue)) {
                        try {
                            FormModel formModel = sfProp == null ? null : sfProp.getPropertyContext().getFormModel();
                            copiedValue = FormUtils.cloneObject(propertyValue, formModel);
                        }
                        catch (CloneNotSupportedException ex) {}
                    } else {
                        Object val = ((FormDesignValue)propertyValue).copy(tfProp);
                        if (val != null) {
                            copiedValue = val;
                        } else if ((mode & 4) == 0) continue;
                    }
                }
                if (tfProp != null) {
                    boolean firing = tfProp.isChangeFiring();
                    tfProp.setChangeFiring((mode & 2) == 0);
                    tfProp.setValue(copiedValue);
                    tfProp.setChangeFiring(firing);
                } else {
                    tnProp.setValue(copiedValue);
                }
                if (sfProp != null && tfProp != null) {
                    PropertyEditor sPrEd = sfProp.getCurrentEditor();
                    PropertyEditor tPrEd = tfProp.getCurrentEditor();
                    if (sPrEd != null && (tPrEd == null || sPrEd.getClass() != tPrEd.getClass()) && (propertyValue == copiedValue || propertyValue != null && copiedValue != null && propertyValue.getClass() == copiedValue.getClass())) {
                        tPrEd = sPrEd instanceof RADConnectionPropertyEditor ? new RADConnectionPropertyEditor(tfProp.getValueType()) : (PropertyEditor)CreationFactory.createDefaultInstance(sPrEd.getClass());
                        tfProp.setCurrentEditor(tPrEd);
                    }
                }
                FormUtils.copyPropertyAttrs(snProp, tnProp, ResourceSupport.getPropertyAttrNames());
                continue;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private static void copyPropertyAttrs(Node.Property sourceProp, Node.Property targetProp, String[] attrs) {
        for (String attr : attrs) {
            Object value = sourceProp.getValue(attr);
            if (value == null) continue;
            targetProp.setValue(attr, value);
        }
    }

    public static void copyPropertiesToBean(RADProperty[] props, Object targetBean, Collection<RADProperty> relativeProperties) {
        FormUtils.copyPropertiesToBean(Arrays.asList(props).iterator(), targetBean, relativeProperties);
    }

    public static void copyPropertiesToBean(Iterator<RADProperty> props, Object targetBean, Collection<RADProperty> relativeProperties) {
        while (props.hasNext()) {
            RADProperty prop = props.next();
            if (!prop.isChanged() || !prop.canWriteToTarget() && !(prop instanceof RADComponent.ButtonGroupProperty)) continue;
            try {
                Object value;
                if (relativeProperties != null && ((value = prop.getValue()) instanceof RADComponent || value instanceof RADComponent.ComponentReference || FormUtils.isRelativeConnectionValue(value))) {
                    relativeProperties.add(prop);
                    continue;
                }
                Method writeMethod = FormUtils.getPropertyWriteMethod(prop, targetBean.getClass());
                if (writeMethod == null) continue;
                Object value2 = prop.getValue();
                Object newValue = null;
                if (value2 instanceof FormDesignValue) {
                    newValue = ((FormDesignValue)value2).getDesignValue(targetBean);
                }
                if (newValue == null) {
                    Object realValue = prop.getRealValue();
                    if (realValue == FormDesignValue.IGNORED_VALUE) continue;
                    newValue = FormUtils.cloneObject(realValue, prop.getPropertyContext().getFormModel());
                }
                writeMethod.invoke(targetBean, newValue);
            }
            catch (CloneNotSupportedException ex) {
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    static boolean isRelativeConnectionValue(Object value) {
        if (value instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) {
            RADConnectionPropertyEditor.RADConnectionDesignValue conValue = (RADConnectionPropertyEditor.RADConnectionDesignValue)value;
            return conValue.type == 4 || conValue.type == 1 || conValue.type == 0;
        }
        return false;
    }

    public static Method getPropertyWriteMethod(RADProperty property, Class targetClass) {
        Method method = property.getPropertyDescriptor().getWriteMethod();
        if (method != null && targetClass != null && !method.getDeclaringClass().isAssignableFrom(targetClass)) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception ex) {
                method = null;
            }
        }
        return method;
    }

    public static void setupEditorPane(JEditorPane editor, FileObject srcFile, int ccPosition) {
        FormServices services = (FormServices)Lookup.getDefault().lookup(FormServices.class);
        services.setupCodeEditorPane(editor, srcFile, ccPosition);
    }

    public static void setupTextUndoRedo(JTextComponent editor) {
    }

    public static boolean isContainer(Class beanClass) {
        int containerStatus = FormUtils.canBeContainer(beanClass);
        if (containerStatus == -1) {
            containerStatus = 1;
            for (Class cls = beanClass.getSuperclass(); cls != null && !cls.equals(Container.class); cls = cls.getSuperclass()) {
                int i;
                String beanClassName = cls.getName();
                for (i = 0; i < forbiddenContainers.length && !beanClassName.equals(forbiddenContainers[i]); ++i) {
                }
                if (i >= forbiddenContainers.length) continue;
                containerStatus = 0;
                break;
            }
        }
        return containerStatus == 1;
    }

    public static int canBeContainer(Class beanClass) {
        if (beanClass == null || !Container.class.isAssignableFrom(beanClass)) {
            return 0;
        }
        String beanClassName = beanClass.getName();
        if ("javax.swing.JPopupMenu".equals(beanClassName)) {
            return 1;
        }
        for (int i = 0; i < forbiddenContainers.length; ++i) {
            if (!beanClassName.equals(forbiddenContainers[i])) continue;
            return 0;
        }
        Object isContainerValue = null;
        try {
            BeanDescriptor desc = Utilities.getBeanInfo((Class)beanClass).getBeanDescriptor();
            if (desc != null) {
                isContainerValue = desc.getValue("isContainer");
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (Error ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        if (isContainerValue instanceof Boolean) {
            return (Boolean)isContainerValue != false ? 1 : 0;
        }
        return -1;
    }

    public static boolean isVisualizableClass(Class cls) {
        if (Component.class.isAssignableFrom(cls)) {
            return true;
        }
        for (ViewConverter c : FormUtils.getViewConverters()) {
            if (!c.canVisualize(cls)) continue;
            return true;
        }
        return false;
    }

    public static ViewConverter[] getViewConverters() {
        Lookup.Result result = Lookup.getDefault().lookupResult(ViewConverter.class);
        Collection all = result.allInstances();
        ViewConverter[] converters = new ViewConverter[all.size()];
        int i = all.size();
        for (ViewConverter c : all) {
            converters[--i] = c;
        }
        return converters;
    }

    static ComponentConverter[] getClassConverters() {
        Lookup.Result result = Lookup.getDefault().lookupResult(ComponentConverter.class);
        Collection all = result.allInstances();
        ComponentConverter[] converters = new ComponentConverter[all.size()];
        int i = all.size();
        for (ComponentConverter c : all) {
            converters[--i] = c;
        }
        return converters;
    }

    public static Object[] getPropertiesCategoryClsf(Class beanClass, BeanDescriptor beanDescriptor) {
        ArrayList<Object> reClsf = null;
        if (JComponent.class.isAssignableFrom(beanClass)) {
            reClsf = new ArrayList<Object>(8);
            Object isContainerValue = beanDescriptor.getValue("isContainer");
            if (isContainerValue == null || Boolean.TRUE.equals(isContainerValue)) {
                reClsf.add("font");
                reClsf.add(PROP_NORMAL);
            } else {
                reClsf.add("border");
                reClsf.add(PROP_NORMAL);
            }
        }
        return FormUtils.collectPropertiesClsf(beanClass, propertyCategories, reClsf);
    }

    public static Object getPropertyCategory(FeatureDescriptor pd, Object[] propsClsf) {
        Object cat = FormUtils.findPropertyClsf(pd.getName(), propsClsf);
        if (cat != null) {
            return cat;
        }
        if (pd.isHidden()) {
            return PROP_HIDDEN;
        }
        if (pd.isExpert()) {
            return PROP_EXPERT;
        }
        if (pd.isPreferred() || Boolean.TRUE.equals(pd.getValue("preferred"))) {
            return PROP_PREFERRED;
        }
        return PROP_NORMAL;
    }

    static Object[] getPropertiesAccessClsf(Class beanClass) {
        return FormUtils.collectPropertiesClsf(beanClass, propertiesAccess, null);
    }

    static int getPropertyAccess(PropertyDescriptor pd, Object[] propsClsf) {
        Object access = FormUtils.findPropertyClsf(pd.getName(), propsClsf);
        return access == null ? 0 : (Integer)access;
    }

    static Object[] getPropertiesParentChildDepsClsf(Class beanClass) {
        return FormUtils.collectPropertiesClsf(beanClass, propertyContainerDeps, null);
    }

    static String getPropertyParentChildDependency(PropertyDescriptor pd, Object[] propClsf) {
        return (String)FormUtils.findPropertyClsf(pd.getName(), propClsf);
    }

    public static boolean isHTMLTextProperty(Node.Property property) {
        if (property.getValueType() == String.class) {
            if (property instanceof RADProperty) {
                Class<? extends Object> beanClass = ((RADProperty)property).getRADComponent().getBeanClass();
                Object[] clsf = FormUtils.collectPropertiesClsf(beanClass, swingTextProperties, null);
                return FormUtils.findPropertyClsf(property.getName(), clsf) != null;
            }
            if (property.getName().equals("TabConstraints.tabTitle")) {
                return true;
            }
        }
        return false;
    }

    private static Object[] collectPropertiesClsf(Class beanClass, Object[][] table, List<Object> list) {
        Set<String> superClasses = FormUtils.superClasses(beanClass);
        for (int i = 0; i < table.length; ++i) {
            Object[] clsf = table[i];
            String refClass = (String)clsf[0];
            Object subclasses = clsf[1];
            if (!refClass.equals(beanClass.getName()) && (subclasses != CLASS_AND_SUBCLASSES || !superClasses.contains(refClass)) && (subclasses != CLASS_AND_SWING_SUBCLASSES || !superClasses.contains(refClass) || !beanClass.getName().startsWith("javax.swing."))) continue;
            if (list == null) {
                list = new ArrayList<Object>(8);
            }
            for (int j = 2; j < clsf.length; ++j) {
                list.add(clsf[j]);
            }
        }
        if (list != null) {
            Object[] array = new Object[list.size()];
            list.toArray(array);
            return array;
        }
        return null;
    }

    private static Object findPropertyClsf(String name, Object[] clsf) {
        if (clsf != null) {
            for (int i = clsf.length; i > 0; i -= 2) {
                if (!clsf[i - 2].equals(name)) continue;
                return clsf[i - 1];
            }
        }
        return null;
    }

    static boolean isMarkedParentDependentProperty(Node.Property prop) {
        return Boolean.TRUE.equals(prop.getValue(PROP_REQUIRES_PARENT));
    }

    static boolean isMarkedChildrenDependentProperty(Node.Property prop) {
        return Boolean.TRUE.equals(prop.getValue(PROP_REQUIRES_CHILDREN));
    }

    private static Map<String, DefaultValueDeviation> getDefaultValueDeviations(Object bean) {
        Map<String, DefaultValueDeviation> deviationMap;
        if (defaultValueDeviations == null) {
            defaultValueDeviations = new HashMap();
        }
        if ((deviationMap = defaultValueDeviations.get(bean.getClass())) == null && bean instanceof JTextField) {
            Object[] values = new Color[2];
            JTextField jtf = new JTextField();
            values[0] = jtf.getBackground();
            jtf.setEditable(false);
            values[1] = jtf.getBackground();
            deviationMap = new HashMap<String, DefaultValueDeviation>();
            deviationMap.put("background", new DefaultValueDeviation(values){

                @Override
                Object getValue(Object beanInstance) {
                    return ((JTextField)beanInstance).isEditable() ? this.values[0] : this.values[1];
                }
            });
            defaultValueDeviations.put(bean.getClass(), deviationMap);
        }
        return deviationMap;
    }

    static Object getSpecialDefaultPropertyValue(Object bean, String propName) {
        DefaultValueDeviation deviation;
        Map<String, DefaultValueDeviation> deviationMap = FormUtils.getDefaultValueDeviations(bean);
        if (deviationMap != null && (deviation = deviationMap.get(propName)) != null) {
            return deviation.getValue(bean);
        }
        return BeanSupport.NO_VALUE;
    }

    public static String getMethodName(MethodDescriptor desc) {
        return FormUtils.getMethodName(desc.getName(), desc.getMethod().getParameterTypes());
    }

    public static String getMethodName(String name, Class[] params) {
        StringBuilder sb = new StringBuilder(name);
        if (params == null || params.length == 0) {
            sb.append("()");
        } else {
            for (int i = 0; i < params.length; ++i) {
                if (i == 0) {
                    sb.append("(");
                } else {
                    sb.append(", ");
                }
                sb.append(Utilities.getShortClassName((Class)params[i]));
            }
            sb.append(")");
        }
        return sb.toString();
    }

    static void sortProperties(Node.Property[] properties) {
        Arrays.sort(properties, new Comparator<Node.Property>(){

            @Override
            public int compare(Node.Property o1, Node.Property o2) {
                String n1 = o1.getDisplayName();
                String n2 = o2.getDisplayName();
                return n1.compareTo(n2);
            }
        });
    }

    static void reorderProperties(Class beanClass, RADProperty[] properties) {
        FormUtils.sortProperties(properties);
        Object[] order = FormUtils.collectPropertiesOrder(beanClass, propertyOrder);
        for (int i = 0; i < order.length / 2; ++i) {
            FormUtils.updatePropertiesOrder(properties, (String)order[2 * i], (String)order[2 * i + 1]);
        }
    }

    private static void updatePropertiesOrder(RADProperty[] properties, String firstProp, String secondProp) {
        int firstIndex = FormUtils.findPropertyIndex(properties, firstProp);
        int secondIndex = FormUtils.findPropertyIndex(properties, secondProp);
        if (firstIndex != -1 && secondIndex != -1 && firstIndex > secondIndex) {
            RADProperty first = properties[firstIndex];
            for (int i = firstIndex; i > secondIndex; --i) {
                properties[i] = properties[i - 1];
            }
            properties[secondIndex] = first;
        }
    }

    private static int findPropertyIndex(RADProperty[] properties, String property) {
        int index = -1;
        for (int i = 0; i < properties.length; ++i) {
            if (!property.equals(properties[i].getName())) continue;
            index = i;
            break;
        }
        return index;
    }

    private static Object[] collectPropertiesOrder(Class beanClass, Object[][] table) {
        Set<String> superClasses = FormUtils.superClasses(beanClass);
        LinkedList<Object> list = new LinkedList<Object>();
        for (int i = 0; i < table.length; ++i) {
            Object[] order = table[i];
            String refClass = (String)order[0];
            if (!superClasses.contains(refClass)) continue;
            for (int j = 1; j < order.length; ++j) {
                list.add(order[j]);
            }
        }
        return list.toArray();
    }

    public static void checkVersionLevelForProperty(FormProperty property, Object value, PropertyEditor editor) {
        FormPropertyContext context = property.getPropertyContext();
        FormModel formModel = context.getFormModel();
        if (formModel != null) {
            if (editor instanceof FormAwareEditor) {
                ((FormAwareEditor)((Object)editor)).updateFormVersionLevel();
            } else if (value instanceof ResourceValue) {
                formModel.raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
            }
            Object owner = context.getOwner();
            if (owner instanceof RADComponent) {
                String propName = property.getName();
                Class<? extends Object> beanClass = ((RADComponent)owner).getBeanClass();
                if ("alignOnBaseline".equals(propName) && beanClass.equals(FlowLayout.class) || beanClass.equals(GridBagLayout.class)) {
                    formModel.raiseVersionLevel(FormModel.FormVersion.NB71, FormModel.FormVersion.NB71);
                }
            }
        }
    }

    public static Class loadClass(String name, FileObject formFile) throws ClassNotFoundException {
        return ClassPathUtils.loadClass(name, formFile);
    }

    public static Class loadClass(String name, FormModel form) throws ClassNotFoundException {
        FormDataObject dobj = FormEditor.getFormDataObject(form);
        return dobj != null ? FormUtils.loadClass(name, dobj.getFormFile()) : FormUtils.loadSystemClass(name);
    }

    public static Class loadSystemClass(String name) throws ClassNotFoundException {
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (loader == null) {
            throw new ClassNotFoundException();
        }
        return Class.forName(name, true, loader);
    }

    public static List<RADComponent> getSelectedLayoutComponents(Node[] nodes) {
        if (nodes == null || nodes.length < 1) {
            return null;
        }
        ArrayList<RADComponent> components = new ArrayList<RADComponent>();
        for (int i = 0; i < nodes.length; ++i) {
            RADComponentCookie radCookie = (RADComponentCookie)nodes[i].getCookie(RADComponentCookie.class);
            if (radCookie == null) continue;
            RADComponent metacomp = radCookie.getRADComponent();
            if (metacomp instanceof RADVisualComponent) {
                RADVisualComponent visComp = (RADVisualComponent)metacomp;
                RADVisualContainer visCont = visComp.getParentContainer();
                if (visCont != null && JScrollPane.class.isAssignableFrom(visCont.getBeanInstance().getClass())) {
                    visComp = visCont;
                    visCont = visCont.getParentContainer();
                }
                if (FormUtils.isVisualInDesigner(visComp) && visCont != null && visCont.getLayoutSupport() == null && !visComp.isMenuComponent()) {
                    components.add(visComp);
                    continue;
                }
                return null;
            }
            return null;
        }
        return components;
    }

    public static boolean isVisualInDesigner(RADComponent comp) {
        FormDesigner designer;
        if (comp instanceof RADVisualComponent && (designer = FormEditor.getFormDesigner(comp.getFormModel())) != null) {
            return designer.isInDesigner((RADVisualComponent)comp);
        }
        return false;
    }

    private static Set<String> superClasses(Class beanClass) {
        HashSet<String> superClasses = new HashSet<String>();
        Class<?>[] infaces = beanClass.getInterfaces();
        for (int i = 0; i < infaces.length; ++i) {
            superClasses.add(infaces[i].getName());
        }
        Class superClass = beanClass;
        do {
            superClasses.add(superClass.getName());
        } while ((superClass = superClass.getSuperclass()) != null);
        return superClasses;
    }

    public static Class typeToClass(TypeHelper type) {
        Class clazz = Object.class;
        if (type == null) {
            return clazz;
        }
        Type t = type.getType();
        if (t instanceof Class) {
            clazz = (Class)t;
        } else if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            clazz = (Class)pt.getRawType();
        } else if (t instanceof WildcardType) {
            Type bound;
            WildcardType wt = (WildcardType)t;
            Type[] arr$ = wt.getUpperBounds();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (Object.class.equals((Object)(clazz = FormUtils.typeToClass(new TypeHelper(bound = arr$[i$], type.getActualTypeArgs())))) || clazz.isInterface()); ++i$) {
            }
        } else if (t instanceof TypeVariable) {
            TypeHelper tt;
            TypeVariable tv = (TypeVariable)t;
            Map<String, TypeHelper> actualTypeArgs = type.getActualTypeArgs();
            if (actualTypeArgs != null && (tt = actualTypeArgs.get(tv.getName())) != null) {
                Class typ = FormUtils.typeToClass(tt);
                clazz = FormUtils.typeToClass(new TypeHelper(typ, actualTypeArgs));
            }
        }
        return clazz;
    }

    public static String autobox(String className) {
        if (className.equals("byte") || className.equals("short") || className.equals("long") || className.equals("float") || className.equals("double") || className.equals("boolean")) {
            className = "java.lang." + Character.toUpperCase(className.charAt(0)) + className.substring(1);
        } else if (className.equals("int")) {
            className = "java.lang.Integer";
        } else if (className.equals("char")) {
            className = "java.lang.Character";
        }
        return className;
    }

    public static String escapeCharactersInString(String str) {
        StringBuilder buf = new StringBuilder(str.length() * 6);
        char[] chars = str.toCharArray();
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ') {
                        buf.append(c);
                        continue block9;
                    }
                    buf.append("\\u");
                    String hex = Integer.toHexString(c);
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        buf.append('0');
                    }
                    buf.append(hex);
                }
            }
        }
        return buf.toString();
    }

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        try {
            return Utilities.getBeanInfo((Class)clazz);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return FormUtils.getBeanInfo(clazz, 2);
        }
        catch (Error err) {
            ErrorManager.getDefault().notify(1, (Throwable)err);
            return FormUtils.getBeanInfo(clazz, 2);
        }
    }

    public static BeanInfo getBeanInfo(Class clazz, int mode) throws IntrospectionException {
        if (mode == 2) {
            try {
                return Introspector.getBeanInfo(clazz, 2);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return FormUtils.getBeanInfo(clazz, 3);
            }
            catch (Error err) {
                ErrorManager.getDefault().notify(1, (Throwable)err);
                return FormUtils.getBeanInfo(clazz, 3);
            }
        }
        assert (mode == 3);
        return Introspector.getBeanInfo(clazz, 3);
    }

    public static RequestProcessor getRequestProcessor() {
        return RP;
    }

    static boolean isStandardJavaComponent(Class clazz) {
        boolean standard = false;
        if (Component.class.isAssignableFrom(clazz)) {
            String name = clazz.getName();
            standard = name.startsWith("java.awt.") || name.startsWith("javax.swing.");
        }
        return standard;
    }

    static Rectangle getVisibleRect(Component comp) {
        Rectangle rect = new Rectangle();
        FormUtils.computeVisibleRect(comp, rect);
        return rect;
    }

    private static void computeVisibleRect(Component c, Rectangle visibleRect) {
        Container p = c.getParent();
        Rectangle bounds = c.getBounds();
        if (p == null || p instanceof Window || p instanceof Applet) {
            visibleRect.setBounds(0, 0, bounds.width, bounds.height);
        } else {
            FormUtils.computeVisibleRect(p, visibleRect);
            visibleRect.x -= bounds.x;
            visibleRect.y -= bounds.y;
            SwingUtilities.computeIntersection(0, 0, bounds.width, bounds.height, visibleRect);
        }
    }

    private static abstract class DefaultValueDeviation {
        protected Object[] values;

        DefaultValueDeviation(Object[] values) {
            this.values = values;
        }

        abstract Object getValue(Object var1);
    }

    private static class OIS
    extends ObjectInputStream {
        private ClassLoader classLoader;
        private FormModel formModel;

        public OIS(InputStream is, ClassLoader loader, FormModel formModel) throws IOException {
            super(is);
            this.formModel = formModel;
            this.classLoader = loader;
        }

        protected Class resolveClass(ObjectStreamClass streamCls) throws IOException, ClassNotFoundException {
            String name = streamCls.getName();
            return this.loadClass(name);
        }

        private Class loadClass(String name) throws ClassNotFoundException {
            if (this.classLoader != null) {
                try {
                    return Class.forName(name, true, this.classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return FormUtils.loadClass(name, this.formModel);
        }
    }

    private static class OOS
    extends ObjectOutputStream {
        private Set<SerializationMarker> placedMarkers = new HashSet<SerializationMarker>();

        private OOS(OutputStream os) throws IOException {
            super(os);
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof JComponent) {
                JComponent comp = (JComponent)obj;
                SerializationMarker sm = new SerializationMarker(comp);
                comp.putClientProperty(SerializationMarker.KEY, sm);
                this.placedMarkers.add(sm);
            }
            return obj;
        }

        private void checkJComponentSerialization() {
            for (SerializationMarker sm : this.placedMarkers) {
                JComponent comp = sm.component;
                if (!sm.serialized) {
                    OOS.fixUnserializedJComponent(comp);
                }
                comp.putClientProperty(SerializationMarker.KEY, null);
            }
        }

        private static void fixUnserializedJComponent(JComponent comp) {
            try {
                Method getWriteObjCounter_Method = JComponent.class.getDeclaredMethod("getWriteObjCounter", JComponent.class);
                getWriteObjCounter_Method.setAccessible(true);
                Method setWriteObjCounter_Method = JComponent.class.getDeclaredMethod("setWriteObjCounter", JComponent.class, Byte.TYPE);
                setWriteObjCounter_Method.setAccessible(true);
                Field ui_Field = JComponent.class.getDeclaredField("ui");
                ui_Field.setAccessible(true);
                byte count = (Byte)getWriteObjCounter_Method.invoke(null, comp);
                if (count > 0) {
                    count = 0;
                    setWriteObjCounter_Method.invoke(null, comp, count);
                    LOGGER.log(Level.INFO, "Reinstalling ComponentUI after interrupted serialization of component: {0}", comp);
                    ComponentUI ui = (ComponentUI)ui_Field.get(comp);
                    ui.installUI(comp);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "Reinstalling ComponentUI after interrupted serialization of JComponent failed", ex);
            }
        }
    }

    private static class SerializationMarker
    implements Serializable {
        private static final Object KEY = new Object();
        transient boolean serialized;
        transient JComponent component;

        private SerializationMarker(JComponent comp) {
            this.component = comp;
        }

        public Object writeReplace() {
            this.serialized = true;
            return new Object();
        }
    }

    public static class TypeHelper {
        private Type type;
        private String name;
        private Map<String, TypeHelper> actualTypeArgs;

        public TypeHelper() {
            this((Type)((Object)Object.class), null);
        }

        public TypeHelper(String name) {
            this(name, null);
        }

        public TypeHelper(String name, Map<String, TypeHelper> actualTypeArgs) {
            this.name = name;
            this.actualTypeArgs = actualTypeArgs;
        }

        public TypeHelper(Type type) {
            this(type, null);
        }

        public TypeHelper(Type type, Map<String, TypeHelper> actualTypeArgs) {
            this.type = type;
            this.actualTypeArgs = actualTypeArgs;
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, TypeHelper> getActualTypeArgs() {
            return this.actualTypeArgs;
        }

        public TypeHelper normalize() {
            TypeHelper t = this;
            if (this.type instanceof TypeVariable) {
                if (this.actualTypeArgs != null) {
                    TypeVariable tv = (TypeVariable)this.type;
                    t = this.actualTypeArgs.get(tv.getName());
                }
            } else if (this.type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)this.type;
                Class clazz = (Class)pt.getRawType();
                HashMap<String, TypeHelper> newMap = new HashMap<String, TypeHelper>();
                Type[] args = pt.getActualTypeArguments();
                TypeVariable<Class<T>>[] tvar = clazz.getTypeParameters();
                for (int i = 0; i < tvar.length; ++i) {
                    Type arg = args[i];
                    TypeHelper sub = new TypeHelper(arg, this.actualTypeArgs).normalize();
                    newMap.put(tvar[i].getName(), new TypeHelper(sub.getType()));
                }
                t = new TypeHelper(clazz, newMap);
            } else if (this.type instanceof WildcardType) {
                WildcardType wt = (WildcardType)this.type;
                TypeHelper sub = new TypeHelper(wt.getUpperBounds()[0], this.actualTypeArgs).normalize();
                t = new TypeHelper(sub.getType());
            }
            return t;
        }

        public TypeHelper typeOfElement() {
            Type t = this.getType();
            TypeHelper elemType = new TypeHelper();
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                if (args.length == 1) {
                    Type tt = args[0];
                    elemType = new TypeHelper(tt, this.actualTypeArgs);
                }
            } else if (t instanceof Class) {
                TypeHelper tt;
                Class classa = (Class)t;
                TypeVariable<Class<T>>[] tvar = classa.getTypeParameters();
                if (this.actualTypeArgs != null && tvar.length == 1 && (tt = this.actualTypeArgs.get(tvar[0].getName())) != null) {
                    if (tt.getType() == null) {
                        elemType = tt;
                    } else {
                        Class typ = FormUtils.typeToClass(tt);
                        elemType = new TypeHelper(typ, this.actualTypeArgs);
                    }
                }
            }
            return elemType;
        }

        public boolean equals(Object o) {
            if (o instanceof TypeHelper) {
                TypeHelper t = (TypeHelper)o;
                return (this.name == null ? t.name == null : this.name.equals(t.name)) && (this.type == null ? t.type == null : this.type.equals(t.type));
            }
            return false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + (this.type != null ? this.type.hashCode() : 0);
            hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }
}

