/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.form.BindingCustomizer;
import org.netbeans.modules.form.BindingDescriptor;
import org.netbeans.modules.form.BindingDesignSupport;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADProperty;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

public class BindingProperty
extends PropertySupport.ReadWrite<MetaBinding> {
    public static final String PROP_NAME = "name";
    public static final String PROP_NULL_VALUE = "nullValue";
    public static final String PROP_INCOMPLETE_VALUE = "incompleteValue";
    public static final String PROP_VALIDATOR = "validator";
    public static final String PROP_CONVERTER = "converter";
    private RADComponent bindingComponent;
    private BindingDescriptor bindingDescriptor;
    private MetaBinding binding;
    private Property nameProperty;
    private Property nullValueProperty;
    private Property incompleteValueProperty;
    private Property validatorProperty;
    private Property converterProperty;

    public BindingProperty(RADComponent metacomp, BindingDescriptor desc) {
        super(desc.getPath(), MetaBinding.class, desc.getDisplayName(), FormProperty.getDescriptionWithType(desc.getShortDescription(), desc.getValueType()));
        RADProperty[] props;
        this.bindingComponent = metacomp;
        this.bindingDescriptor = desc;
        FormProperty prop = (FormProperty)this.bindingComponent.getPropertyByName(this.bindingDescriptor.getPath());
        if (prop == null && (props = this.bindingComponent.getAllBeanProperties()).length > 0) {
            prop = props[0];
        }
        if (prop != null) {
            BindingDesignSupport bindingSupport = FormEditor.getBindingSupport(this.getFormModel());
            String name = FormUtils.getBundleString("MSG_Binding_NullProperty");
            this.nullValueProperty = new Property(prop, PROP_NULL_VALUE, desc.getValueType(), name, name, false);
            name = FormUtils.getBundleString("MSG_Binding_IncompletePathProperty");
            this.incompleteValueProperty = new Property(prop, "incompletePathValue", desc.getValueType(), name, name, false);
            name = FormUtils.getBundleString("MSG_Binding_Validator");
            this.validatorProperty = new Property(prop, PROP_VALIDATOR, bindingSupport.getValidatorClass(), name, name, true);
            name = FormUtils.getBundleString("MSG_Binding_Converter");
            this.converterProperty = new Property(prop, PROP_CONVERTER, bindingSupport.getConverterClass(), name, name, true);
            name = FormUtils.getBundleString("MSG_Binding_Name");
            this.nameProperty = new Property(prop, PROP_NAME, String.class, name, name, true);
        }
    }

    public String getHtmlDisplayName() {
        return this.binding != null ? "<b>" + this.getDisplayName() : null;
    }

    public MetaBinding getValue() {
        return this.binding;
    }

    public void setValue(MetaBinding val) {
        MetaBinding old = this.binding;
        if (old == null && val != null) {
            FormEditor.updateProjectForBeansBinding(this.bindingComponent.getFormModel());
            this.getFormModel().raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
            Node.Property prop = this.bindingComponent.getPropertyByName(this.bindingDescriptor.getPath());
            if (prop instanceof FormProperty) {
                FormProperty fprop = (FormProperty)prop;
                if (fprop.isChanged()) {
                    try {
                        fprop.restoreDefaultValue();
                    }
                    catch (Exception ex) {}
                }
            } else {
                try {
                    prop.restoreDefaultValue();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (val != null && !this.bindingComponent.equals(val.getTarget())) {
            MetaBinding clone = new MetaBinding(val.getSource(), val.getSourcePath(), this.bindingComponent, val.getTargetPath());
            clone.setBindImmediately(val.isBindImmediately());
            clone.setIncompletePathValueSpecified(val.isIncompletePathValueSpecified());
            clone.setNullValueSpecified(val.isNullValueSpecified());
            clone.setUpdateStrategy(val.getUpdateStrategy());
            Map<String, String> params = val.getParameters();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                clone.setParameter(entry.getKey(), entry.getValue());
            }
            Collection<MetaBinding> subs = val.getSubBindings();
            if (subs != null) {
                for (MetaBinding sub : subs) {
                    clone.addSubBinding(sub.getSourcePath(), sub.getTargetPath());
                }
            }
            RADComponent comp = val.getTarget();
            BindingProperty original = comp.getBindingProperty(this.getName());
            this.copy(original.getNameProperty(), this.getNameProperty());
            this.copy(original.getConverterProperty(), this.getConverterProperty());
            this.copy(original.getValidatorProperty(), this.getValidatorProperty());
            if (val.isNullValueSpecified()) {
                this.copy(original.getNullValueProperty(), this.getNullValueProperty());
            }
            if (val.isIncompletePathValueSpecified()) {
                this.copy(original.getIncompleteValueProperty(), this.getIncompleteValueProperty());
            }
            val = clone;
        }
        this.binding = val;
        FormEditor.getBindingSupport(this.getFormModel()).changeBindingInModel(old, this.binding);
        this.getFormModel().fireBindingChanged(this.getBindingComponent(), this.getBindingPath(), null, old, this.binding);
        RADComponentNode node = this.getBindingComponent().getNodeReference();
        if (node != null) {
            node.firePropertyChangeHelper(null, null, null);
        }
    }

    private void copy(FormProperty src, FormProperty dst) {
        try {
            PropertyEditor propEd = src.getCurrentEditor();
            Object value = src.getValue();
            dst.setValue(new FormProperty.ValueWithEditor(value, propEd));
        }
        catch (Exception ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
        }
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public void restoreDefaultValue() {
        this.setValue(null);
        try {
            this.validatorProperty.restoreDefaultValue();
            this.converterProperty.restoreDefaultValue();
            this.nameProperty.restoreDefaultValue();
            this.nullValueProperty.setValue(null);
            this.incompleteValueProperty.setValue(null);
        }
        catch (Exception ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        Node.Property prop = this.bindingComponent.getPropertyByName(this.bindingDescriptor.getPath());
        if (prop != null && prop.supportsDefaultValue()) {
            try {
                prop.restoreDefaultValue();
            }
            catch (Exception ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }
    }

    public boolean isDefaultValue() {
        return this.getValue() == null;
    }

    public PropertyEditor getPropertyEditor() {
        return new BindingPropertyEditor();
    }

    public RADComponent getBindingComponent() {
        return this.bindingComponent;
    }

    public BindingDescriptor getBindingDescriptor() {
        return this.bindingDescriptor;
    }

    String getBindingPath() {
        return this.bindingDescriptor.getPath();
    }

    Class getBindingValueType() {
        return this.bindingDescriptor.getValueType();
    }

    private FormModel getFormModel() {
        return this.bindingComponent.getFormModel();
    }

    public FormProperty getNullValueProperty() {
        return this.nullValueProperty;
    }

    public FormProperty getIncompleteValueProperty() {
        return this.incompleteValueProperty;
    }

    public FormProperty getValidatorProperty() {
        return this.validatorProperty;
    }

    public FormProperty getConverterProperty() {
        return this.converterProperty;
    }

    public FormProperty getNameProperty() {
        return this.nameProperty;
    }

    public FormProperty getSubProperty(String propName) {
        if (PROP_NAME.equals(propName)) {
            return this.getNameProperty();
        }
        if (PROP_NULL_VALUE.equals(propName)) {
            return this.getNullValueProperty();
        }
        if (PROP_INCOMPLETE_VALUE.equals(propName)) {
            return this.getIncompleteValueProperty();
        }
        if (PROP_CONVERTER.equals(propName)) {
            return this.getConverterProperty();
        }
        if (PROP_VALIDATOR.equals(propName)) {
            return this.getValidatorProperty();
        }
        return null;
    }

    private class BindingPropertyEditor
    extends PropertyEditorSupport {
        private BindingCustomizer customizer;
        private ActionListener customizerListener;

        private BindingPropertyEditor() {
        }

        @Override
        public String getAsText() {
            RADComponent boundComp = null;
            String path = null;
            if (BindingProperty.this.binding != null) {
                boundComp = BindingProperty.this.binding.getSource();
                path = BindingProperty.this.binding.getSourcePath();
            }
            if (boundComp == null) {
                return "";
            }
            return path != null ? boundComp.getName() + "[" + path + "]" : boundComp.getName();
        }

        @Override
        public void setAsText(String text) {
            if ("".equals(text)) {
                this.setValue(null);
            } else {
                int idx = text.indexOf(91);
                String compName = idx >= 0 ? text.substring(0, idx) : text;
                RADComponent boundComp = BindingProperty.this.getFormModel().findRADComponent(compName);
                if (boundComp != null) {
                    String path;
                    String string = path = idx >= 0 ? text.substring(idx + 1, text.length() - 1) : "";
                    if (!path.equals("")) {
                        if (boundComp != BindingProperty.this.getBindingComponent() || !path.equals(BindingProperty.this.getBindingPath())) {
                            this.setValue(new MetaBinding(boundComp, path, BindingProperty.this.getBindingComponent(), BindingProperty.this.getBindingPath()));
                        }
                    } else if (boundComp != BindingProperty.this.getBindingComponent() && Collection.class.isAssignableFrom(BindingProperty.this.getBindingValueType()) && BindingProperty.this.getBindingValueType().equals(boundComp.getBeanClass())) {
                        this.setValue(new MetaBinding(boundComp, null, BindingProperty.this.getBindingComponent(), BindingProperty.this.getBindingPath()));
                    }
                }
            }
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            if (this.customizer == null) {
                this.customizer = new BindingCustomizer(BindingProperty.this);
                this.customizerListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        BindingPropertyEditor.this.setValue(BindingPropertyEditor.this.customizer.getBinding());
                    }
                };
            }
            this.customizer.setBinding((MetaBinding)this.getValue());
            return this.customizer.getDialog(this.customizerListener);
        }
    }

    static class Property
    extends FormProperty {
        private Object value;
        private boolean supportsDefaultValue;

        Property(FormProperty prop, String name, Class type, String displayName, String description, boolean supportsDefaultValue) {
            super(new FormPropertyContext.SubProperty(prop), name, type, displayName, description);
            this.supportsDefaultValue = supportsDefaultValue;
        }

        @Override
        public Object getTargetValue() throws IllegalAccessException, InvocationTargetException {
            if (this.getValueType().equals(Boolean.TYPE) && this.value == null) {
                return false;
            }
            return this.value;
        }

        @Override
        public void setTargetValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.value = value;
        }

        @Override
        public boolean supportsDefaultValue() {
            return this.supportsDefaultValue;
        }

        @Override
        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            super.restoreDefaultValue();
            this.getCurrentEditor().setValue(this.getValue());
        }
    }
}

