/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.TcpTransport;
import org.eclipse.jgit.transport.URIish;

public abstract class SshTransport
extends TcpTransport {
    private SshSessionFactory sch = SshSessionFactory.getInstance();
    private RemoteSession sock;

    protected SshTransport(Repository local, URIish uri) {
        super(local, uri);
    }

    public void setSshSessionFactory(SshSessionFactory factory) {
        if (factory == null) {
            throw new NullPointerException(JGitText.get().theFactoryMustNotBeNull);
        }
        if (this.sock != null) {
            throw new IllegalStateException(JGitText.get().anSSHSessionHasBeenAlreadyCreated);
        }
        this.sch = factory;
    }

    public SshSessionFactory getSshSessionFactory() {
        return this.sch;
    }

    protected RemoteSession getSession() throws TransportException {
        if (this.sock != null) {
            return this.sock;
        }
        int tms = this.getTimeout() > 0 ? this.getTimeout() * 1000 : 0;
        this.sock = this.sch.getSession(this.uri, this.getCredentialsProvider(), this.local.getFS(), tms);
        return this.sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.sock != null) {
            try {
                this.sch.releaseSession(this.sock);
                Object var2_1 = null;
                this.sock = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.sock = null;
                throw throwable;
            }
        }
    }
}

