/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.ThreadSafeProgressMonitor;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.storage.file.PackIndex;
import org.eclipse.jgit.storage.file.PackIndexWriter;
import org.eclipse.jgit.storage.pack.BaseSearch;
import org.eclipse.jgit.storage.pack.CachedPack;
import org.eclipse.jgit.storage.pack.DeltaCache;
import org.eclipse.jgit.storage.pack.DeltaIndex;
import org.eclipse.jgit.storage.pack.DeltaTask;
import org.eclipse.jgit.storage.pack.DeltaWindow;
import org.eclipse.jgit.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackOutputStream;
import org.eclipse.jgit.storage.pack.StoredObjectRepresentation;
import org.eclipse.jgit.storage.pack.ThreadSafeDeltaCache;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.TemporaryBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackWriter {
    private static final int PACK_VERSION_GENERATED = 2;
    private static final Map<WeakReference<PackWriter>, Boolean> instances = new ConcurrentHashMap<WeakReference<PackWriter>, Boolean>();
    private static final Iterable<PackWriter> instancesIterable = new Iterable<PackWriter>(){

        @Override
        public Iterator<PackWriter> iterator() {
            return new Iterator<PackWriter>(){
                private final Iterator<WeakReference<PackWriter>> it = PackWriter.access$000().keySet().iterator();
                private PackWriter next;

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    while (this.it.hasNext()) {
                        WeakReference<PackWriter> ref = this.it.next();
                        this.next = (PackWriter)ref.get();
                        if (this.next != null) {
                            return true;
                        }
                        this.it.remove();
                    }
                    return false;
                }

                @Override
                public PackWriter next() {
                    if (this.hasNext()) {
                        PackWriter result = this.next;
                        this.next = null;
                        return result;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };
    private final BlockList<ObjectToPack>[] objectsLists = new BlockList[5];
    private final ObjectIdOwnerMap<ObjectToPack> objectsMap;
    private List<ObjectToPack> edgeObjects;
    private List<CachedPack> cachedPacks;
    private Set<ObjectId> tagTargets;
    private PackIndex[] excludeInPacks;
    private PackIndex excludeInPackLast;
    private Deflater myDeflater;
    private final ObjectReader reader;
    private final ObjectReuseAsIs reuseSupport;
    private final PackConfig config;
    private final Statistics stats;
    private final MutableState state;
    private final WeakReference<PackWriter> selfRef;
    private Statistics.ObjectType typeStats;
    private List<ObjectToPack> sortedByName;
    private byte[] packcsum;
    private boolean deltaBaseAsOffset;
    private boolean reuseDeltas;
    private boolean reuseDeltaCommits;
    private boolean reuseValidate;
    private boolean thin;
    private boolean useCachedPacks;
    private boolean ignoreMissingUninteresting;
    private boolean pruneCurrentObjectList;
    private boolean shallowPack;
    private int depth;
    private Collection<? extends ObjectId> unshallowObjects;

    public static Iterable<PackWriter> getInstances() {
        return instancesIterable;
    }

    public PackWriter(Repository repo) {
        this(repo, repo.newObjectReader());
    }

    public PackWriter(ObjectReader reader) {
        this(new PackConfig(), reader);
    }

    public PackWriter(Repository repo, ObjectReader reader) {
        this(new PackConfig(repo), reader);
    }

    public PackWriter(PackConfig config, ObjectReader reader) {
        this.objectsLists[1] = new BlockList();
        this.objectsLists[2] = new BlockList();
        this.objectsLists[3] = new BlockList();
        this.objectsLists[4] = new BlockList();
        this.objectsMap = new ObjectIdOwnerMap();
        this.edgeObjects = new BlockList<ObjectToPack>();
        this.cachedPacks = new ArrayList<CachedPack>(2);
        this.tagTargets = Collections.emptySet();
        this.ignoreMissingUninteresting = true;
        this.config = config;
        this.reader = reader;
        this.reuseSupport = reader instanceof ObjectReuseAsIs ? (ObjectReuseAsIs)((Object)reader) : null;
        this.deltaBaseAsOffset = config.isDeltaBaseAsOffset();
        this.reuseDeltas = config.isReuseDeltas();
        this.reuseValidate = true;
        this.stats = new Statistics();
        this.state = new MutableState();
        this.selfRef = new WeakReference<PackWriter>(this);
        instances.put(this.selfRef, Boolean.TRUE);
    }

    public boolean isDeltaBaseAsOffset() {
        return this.deltaBaseAsOffset;
    }

    public void setDeltaBaseAsOffset(boolean deltaBaseAsOffset) {
        this.deltaBaseAsOffset = deltaBaseAsOffset;
    }

    public boolean isReuseDeltaCommits() {
        return this.reuseDeltaCommits;
    }

    public void setReuseDeltaCommits(boolean reuse) {
        this.reuseDeltaCommits = reuse;
    }

    public boolean isReuseValidatingObjects() {
        return this.reuseValidate;
    }

    public void setReuseValidatingObjects(boolean validate) {
        this.reuseValidate = validate;
    }

    public boolean isThin() {
        return this.thin;
    }

    public void setThin(boolean packthin) {
        this.thin = packthin;
    }

    public boolean isUseCachedPacks() {
        return this.useCachedPacks;
    }

    public void setUseCachedPacks(boolean useCached) {
        this.useCachedPacks = useCached;
    }

    public boolean isIgnoreMissingUninteresting() {
        return this.ignoreMissingUninteresting;
    }

    public void setIgnoreMissingUninteresting(boolean ignore) {
        this.ignoreMissingUninteresting = ignore;
    }

    public void setTagTargets(Set<ObjectId> objects) {
        this.tagTargets = objects;
    }

    public void setShallowPack(int depth, Collection<? extends ObjectId> unshallow) {
        this.shallowPack = true;
        this.depth = depth;
        this.unshallowObjects = unshallow;
    }

    public long getObjectCount() throws IOException {
        if (this.stats.totalObjects == 0L) {
            long objCnt = 0L;
            objCnt += (long)this.objectsLists[1].size();
            objCnt += (long)this.objectsLists[2].size();
            objCnt += (long)this.objectsLists[3].size();
            objCnt += (long)this.objectsLists[4].size();
            for (CachedPack pack : this.cachedPacks) {
                objCnt += pack.getObjectCount();
            }
            return objCnt;
        }
        return this.stats.totalObjects;
    }

    public void excludeObjects(PackIndex idx) {
        if (this.excludeInPacks == null) {
            this.excludeInPacks = new PackIndex[]{idx};
            this.excludeInPackLast = idx;
        } else {
            int cnt = this.excludeInPacks.length;
            PackIndex[] newList = new PackIndex[cnt + 1];
            System.arraycopy(this.excludeInPacks, 0, newList, 0, cnt);
            newList[cnt] = idx;
            this.excludeInPacks = newList;
        }
    }

    public void preparePack(Iterator<RevObject> objectsSource) throws IOException {
        while (objectsSource.hasNext()) {
            this.addObject(objectsSource.next());
        }
    }

    @Deprecated
    public void preparePack(ProgressMonitor countingMonitor, Collection<? extends ObjectId> want, Collection<? extends ObjectId> have) throws IOException {
        this.preparePack(countingMonitor, PackWriter.ensureSet(want), PackWriter.ensureSet(have));
    }

    @Deprecated
    public void preparePack(ProgressMonitor countingMonitor, ObjectWalk walk, Collection<? extends ObjectId> interestingObjects, Collection<? extends ObjectId> uninterestingObjects) throws IOException {
        this.preparePack(countingMonitor, walk, PackWriter.ensureSet(interestingObjects), PackWriter.ensureSet(uninterestingObjects));
    }

    private static Set<ObjectId> ensureSet(Collection<? extends ObjectId> objs) {
        Set<ObjectId> set = objs instanceof Set ? (Set<ObjectId>)objs : (objs == null ? Collections.emptySet() : new HashSet<ObjectId>(objs));
        return set;
    }

    public void preparePack(ProgressMonitor countingMonitor, Set<? extends ObjectId> want, Set<? extends ObjectId> have) throws IOException {
        ObjectWalk ow = this.shallowPack ? new DepthWalk.ObjectWalk(this.reader, this.depth) : new ObjectWalk(this.reader);
        this.preparePack(countingMonitor, ow, want, have);
    }

    public void preparePack(ProgressMonitor countingMonitor, ObjectWalk walk, Set<? extends ObjectId> interestingObjects, Set<? extends ObjectId> uninterestingObjects) throws IOException {
        if (countingMonitor == null) {
            countingMonitor = NullProgressMonitor.INSTANCE;
        }
        if (this.shallowPack && !(walk instanceof DepthWalk.ObjectWalk)) {
            walk = new DepthWalk.ObjectWalk(this.reader, this.depth);
        }
        this.findObjectsToPack(countingMonitor, walk, interestingObjects, uninterestingObjects);
    }

    public boolean willInclude(AnyObjectId id) throws IOException {
        ObjectToPack obj = this.objectsMap.get(id);
        return obj != null && !obj.isEdge();
    }

    public ObjectToPack get(AnyObjectId id) {
        ObjectToPack obj = this.objectsMap.get(id);
        return obj != null && !obj.isEdge() ? obj : null;
    }

    public ObjectId computeName() {
        byte[] buf = new byte[20];
        MessageDigest md = Constants.newMessageDigest();
        for (ObjectToPack otp : this.sortByName()) {
            otp.copyRawTo(buf, 0);
            md.update(buf, 0, 20);
        }
        return ObjectId.fromRaw(md.digest());
    }

    public void writeIndex(OutputStream indexStream) throws IOException {
        if (!this.cachedPacks.isEmpty()) {
            throw new IOException(JGitText.get().cachedPacksPreventsIndexCreation);
        }
        long writeStart = System.currentTimeMillis();
        List<ObjectToPack> list = this.sortByName();
        int indexVersion = this.config.getIndexVersion();
        PackIndexWriter iw = indexVersion <= 0 ? PackIndexWriter.createOldestPossible(indexStream, list) : PackIndexWriter.createVersion(indexStream, indexVersion);
        iw.write(list, this.packcsum);
        this.stats.timeWriting += System.currentTimeMillis() - writeStart;
    }

    private List<ObjectToPack> sortByName() {
        if (this.sortedByName == null) {
            int cnt = 0;
            cnt += this.objectsLists[1].size();
            cnt += this.objectsLists[2].size();
            cnt += this.objectsLists[3].size();
            this.sortedByName = new BlockList<ObjectToPack>(cnt += this.objectsLists[4].size());
            this.sortedByName.addAll(this.objectsLists[1]);
            this.sortedByName.addAll(this.objectsLists[2]);
            this.sortedByName.addAll(this.objectsLists[3]);
            this.sortedByName.addAll(this.objectsLists[4]);
            Collections.sort(this.sortedByName);
        }
        return this.sortedByName;
    }

    private void beginPhase(PackingPhase phase, ProgressMonitor monitor, long cnt) {
        String task;
        this.state.phase = phase;
        switch (phase) {
            case COUNTING: {
                task = JGitText.get().countingObjects;
                break;
            }
            case GETTING_SIZES: {
                task = JGitText.get().searchForSizes;
                break;
            }
            case FINDING_SOURCES: {
                task = JGitText.get().searchForReuse;
                break;
            }
            case COMPRESSING: {
                task = JGitText.get().compressingObjects;
                break;
            }
            case WRITING: {
                task = JGitText.get().writingObjects;
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalPackingPhase, new Object[]{phase}));
            }
        }
        monitor.beginTask(task, (int)cnt);
    }

    private void endPhase(ProgressMonitor monitor) {
        monitor.endTask();
    }

    public void writePack(ProgressMonitor compressMonitor, ProgressMonitor writeMonitor, OutputStream packStream) throws IOException {
        long objCnt;
        boolean needSearchForReuse;
        if (compressMonitor == null) {
            compressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (writeMonitor == null) {
            writeMonitor = NullProgressMonitor.INSTANCE;
        }
        this.excludeInPacks = null;
        this.excludeInPackLast = null;
        boolean bl = needSearchForReuse = this.reuseSupport != null && (this.reuseDeltas || this.config.isReuseObjects() || !this.cachedPacks.isEmpty());
        if (compressMonitor instanceof BatchingProgressMonitor) {
            long delay = 1000L;
            if (needSearchForReuse && this.config.isDeltaCompress()) {
                delay = 500L;
            }
            ((BatchingProgressMonitor)compressMonitor).setDelayStart(delay, TimeUnit.MILLISECONDS);
        }
        if (needSearchForReuse) {
            this.searchForReuse(compressMonitor);
        }
        if (this.config.isDeltaCompress()) {
            this.searchForDeltas(compressMonitor);
        }
        PackOutputStream out = new PackOutputStream(writeMonitor, packStream, this);
        this.stats.totalObjects = objCnt = this.getObjectCount();
        this.beginPhase(PackingPhase.WRITING, writeMonitor, objCnt);
        long writeStart = System.currentTimeMillis();
        out.writeFileHeader(2, objCnt);
        out.flush();
        this.writeObjects(out);
        if (!this.edgeObjects.isEmpty() || !this.cachedPacks.isEmpty()) {
            for (Statistics.ObjectType typeStat : this.stats.objectTypes) {
                if (typeStat == null) continue;
                this.stats.thinPackBytes += typeStat.bytes;
            }
        }
        for (CachedPack pack : this.cachedPacks) {
            long deltaCnt = pack.getDeltaCount();
            this.stats.reusedObjects += pack.getObjectCount();
            this.stats.reusedDeltas += deltaCnt;
            this.stats.totalDeltas += deltaCnt;
            this.reuseSupport.copyPackAsIs(out, pack, this.reuseValidate);
        }
        this.writeChecksum(out);
        out.flush();
        this.stats.timeWriting = System.currentTimeMillis() - writeStart;
        this.stats.totalBytes = out.length();
        this.stats.reusedPacks = Collections.unmodifiableList(this.cachedPacks);
        this.stats.depth = this.depth;
        for (Statistics.ObjectType typeStat : this.stats.objectTypes) {
            if (typeStat == null) continue;
            typeStat.cntDeltas += typeStat.reusedDeltas;
            this.stats.reusedObjects += typeStat.reusedObjects;
            this.stats.reusedDeltas += typeStat.reusedDeltas;
            this.stats.totalDeltas += typeStat.cntDeltas;
        }
        this.reader.release();
        this.endPhase(writeMonitor);
    }

    public Statistics getStatistics() {
        return this.stats;
    }

    public State getState() {
        return this.state.snapshot();
    }

    public void release() {
        this.reader.release();
        if (this.myDeflater != null) {
            this.myDeflater.end();
            this.myDeflater = null;
        }
        instances.remove(this.selfRef);
    }

    private void searchForReuse(ProgressMonitor monitor) throws IOException {
        long cnt = 0L;
        cnt += (long)this.objectsLists[1].size();
        cnt += (long)this.objectsLists[2].size();
        cnt += (long)this.objectsLists[3].size();
        long start = System.currentTimeMillis();
        this.beginPhase(PackingPhase.FINDING_SOURCES, monitor, cnt += (long)this.objectsLists[4].size());
        if (cnt <= 4096L) {
            BlockList<ObjectToPack> tmp = new BlockList<ObjectToPack>((int)cnt);
            tmp.addAll(this.objectsLists[4]);
            tmp.addAll(this.objectsLists[1]);
            tmp.addAll(this.objectsLists[2]);
            tmp.addAll(this.objectsLists[3]);
            this.searchForReuse(monitor, tmp);
            if (this.pruneCurrentObjectList) {
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[1]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[2]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[3]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[4]);
            }
        } else {
            this.searchForReuse(monitor, this.objectsLists[4]);
            this.searchForReuse(monitor, this.objectsLists[1]);
            this.searchForReuse(monitor, this.objectsLists[2]);
            this.searchForReuse(monitor, this.objectsLists[3]);
        }
        this.endPhase(monitor);
        this.stats.timeSearchingForReuse = System.currentTimeMillis() - start;
    }

    private void searchForReuse(ProgressMonitor monitor, List<ObjectToPack> list) throws IOException, MissingObjectException {
        this.pruneCurrentObjectList = false;
        this.reuseSupport.selectObjectRepresentation(this, monitor, list);
        if (this.pruneCurrentObjectList) {
            PackWriter.pruneEdgesFromObjectList(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForDeltas(ProgressMonitor monitor) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectToPack[] list = new ObjectToPack[this.objectsLists[2].size() + this.objectsLists[3].size() + this.edgeObjects.size()];
        int cnt = 0;
        cnt = this.findObjectsNeedingDelta(list, cnt, 2);
        if ((cnt = this.findObjectsNeedingDelta(list, cnt, 3)) == 0) {
            return;
        }
        int nonEdgeCnt = cnt;
        for (ObjectToPack eo : this.edgeObjects) {
            eo.setWeight(0);
            list[cnt++] = eo;
        }
        long sizingStart = System.currentTimeMillis();
        this.beginPhase(PackingPhase.GETTING_SIZES, monitor, cnt);
        AsyncObjectSizeQueue<ObjectToPack> sizeQueue = this.reader.getObjectSize(Arrays.asList(list).subList(0, cnt), false);
        try {
            long limit = this.config.getBigFileThreshold();
            while (true) {
                long sz;
                block20: {
                    try {
                        if (sizeQueue.next()) break block20;
                        break;
                    }
                    catch (MissingObjectException notFound) {
                        monitor.update(1);
                        if (this.ignoreMissingUninteresting) {
                            ObjectToPack otp = sizeQueue.getCurrent();
                            if (otp != null && otp.isEdge()) {
                                otp.setDoNotDelta(true);
                                continue;
                            }
                            otp = this.objectsMap.get(notFound.getObjectId());
                            if (otp != null && otp.isEdge()) {
                                otp.setDoNotDelta(true);
                                continue;
                            }
                        }
                        throw notFound;
                    }
                }
                ObjectToPack otp = sizeQueue.getCurrent();
                if (otp == null) {
                    otp = this.objectsMap.get(sizeQueue.getObjectId());
                }
                if (limit <= (sz = sizeQueue.getSize()) || Integer.MAX_VALUE <= sz) {
                    otp.setDoNotDelta(true);
                } else if (sz <= 16L) {
                    otp.setDoNotDelta(true);
                } else {
                    otp.setWeight((int)sz);
                }
                monitor.update(1);
            }
        }
        finally {
            sizeQueue.release();
        }
        this.endPhase(monitor);
        this.stats.timeSearchingForSizes = System.currentTimeMillis() - sizingStart;
        Arrays.sort(list, 0, cnt, new Comparator<ObjectToPack>(){

            @Override
            public int compare(ObjectToPack a, ObjectToPack b) {
                int cmp = (a.isDoNotDelta() ? 1 : 0) - (b.isDoNotDelta() ? 1 : 0);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = a.getType() - b.getType();
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.getPathHash() >>> 1) - (b.getPathHash() >>> 1);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.getPathHash() & 1) - (b.getPathHash() & 1);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.isEdge() ? 0 : 1) - (b.isEdge() ? 0 : 1);
                if (cmp != 0) {
                    return cmp;
                }
                return b.getWeight() - a.getWeight();
            }
        });
        while (0 < cnt && list[cnt - 1].isDoNotDelta()) {
            if (!list[cnt - 1].isEdge()) {
                --nonEdgeCnt;
            }
            --cnt;
        }
        if (cnt == 0) {
            return;
        }
        long searchStart = System.currentTimeMillis();
        this.beginPhase(PackingPhase.COMPRESSING, monitor, nonEdgeCnt);
        this.searchForDeltas(monitor, list, cnt);
        this.endPhase(monitor);
        this.stats.deltaSearchNonEdgeObjects = nonEdgeCnt;
        this.stats.timeCompressing = System.currentTimeMillis() - searchStart;
        for (int i = 0; i < cnt; ++i) {
            if (list[i].isEdge() || !list[i].isDeltaRepresentation()) continue;
            ++this.stats.deltasFound;
        }
    }

    private int findObjectsNeedingDelta(ObjectToPack[] list, int cnt, int type) {
        for (ObjectToPack otp : this.objectsLists[type]) {
            if (otp.isDoNotDelta() || otp.isDeltaRepresentation()) continue;
            otp.setWeight(0);
            list[cnt++] = otp;
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForDeltas(ProgressMonitor monitor, ObjectToPack[] list, int cnt) throws MissingObjectException, IncorrectObjectTypeException, LargeObjectException, IOException {
        List<Throwable> errors;
        block25: {
            int batchSize;
            int threads = this.config.getThreads();
            if (threads == 0) {
                threads = Runtime.getRuntime().availableProcessors();
            }
            if (threads <= 1 || cnt <= 2 * this.config.getDeltaSearchWindowSize()) {
                DeltaCache dc = new DeltaCache(this.config);
                DeltaWindow dw = new DeltaWindow(this.config, dc, this.reader);
                dw.search(monitor, list, 0, cnt);
                return;
            }
            ThreadSafeDeltaCache dc = new ThreadSafeDeltaCache(this.config);
            ThreadSafeProgressMonitor pm = new ThreadSafeProgressMonitor(monitor);
            int estSize = cnt / (threads * 2);
            if (estSize < 2 * this.config.getDeltaSearchWindowSize()) {
                estSize = 2 * this.config.getDeltaSearchWindowSize();
            }
            ArrayList<DeltaTask> myTasks = new ArrayList<DeltaTask>(threads * 2);
            for (int i = 0; i < cnt; i += batchSize) {
                int start = i;
                if (cnt - i < estSize) {
                    batchSize = cnt - i;
                } else {
                    int end;
                    for (end = start + estSize; end < cnt; ++end) {
                        ObjectToPack a = list[end - 1];
                        ObjectToPack b = list[end];
                        if (a.getPathHash() != b.getPathHash()) break;
                    }
                    batchSize = end - start;
                }
                myTasks.add(new DeltaTask(this.config, this.reader, dc, pm, batchSize, start, list));
            }
            pm.startWorkers(myTasks.size());
            Executor executor = this.config.getExecutor();
            errors = Collections.synchronizedList(new ArrayList());
            if (executor instanceof ExecutorService) {
                this.runTasks((ExecutorService)executor, pm, myTasks, errors);
            } else {
                if (executor == null) {
                    ExecutorService pool = Executors.newFixedThreadPool(threads);
                    try {
                        this.runTasks(pool, pm, myTasks, errors);
                    }
                    finally {
                        pool.shutdown();
                        try {
                            while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                            }
                            break block25;
                        }
                        catch (InterruptedException e) {
                            throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                        }
                    }
                }
                for (final DeltaTask task : myTasks) {
                    executor.execute(new Runnable(){

                        public void run() {
                            try {
                                task.call();
                            }
                            catch (Throwable failure) {
                                errors.add(failure);
                            }
                        }
                    });
                }
                try {
                    pm.waitForCompletion();
                }
                catch (InterruptedException ie) {
                    throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                }
            }
        }
        if (!errors.isEmpty()) {
            Throwable err = errors.get(0);
            if (err instanceof Error) {
                throw (Error)err;
            }
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof IOException) {
                throw (IOException)err;
            }
            IOException fail = new IOException(err.getMessage());
            fail.initCause(err);
            throw fail;
        }
    }

    private void runTasks(ExecutorService pool, ThreadSafeProgressMonitor pm, List<DeltaTask> tasks, List<Throwable> errors) throws IOException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(tasks.size());
        for (DeltaTask deltaTask : tasks) {
            futures.add(pool.submit(deltaTask));
        }
        try {
            pm.waitForCompletion();
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {
                    errors.add(executionException.getCause());
                }
            }
        }
        catch (InterruptedException ie) {
            for (Future future : futures) {
                future.cancel(true);
            }
            throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
        }
    }

    private void writeObjects(PackOutputStream out) throws IOException {
        this.writeObjects(out, this.objectsLists[1]);
        this.writeObjects(out, this.objectsLists[4]);
        this.writeObjects(out, this.objectsLists[2]);
        this.writeObjects(out, this.objectsLists[3]);
    }

    private void writeObjects(PackOutputStream out, List<ObjectToPack> list) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        this.typeStats = this.stats.objectTypes[list.get(0).getType()];
        long beginOffset = out.length();
        if (this.reuseSupport != null) {
            this.reuseSupport.writeObjects(out, list);
        } else {
            for (ObjectToPack otp : list) {
                out.writeObject(otp);
            }
        }
        this.typeStats.bytes += out.length() - beginOffset;
        this.typeStats.cntObjects = list.size();
    }

    void writeObject(PackOutputStream out, ObjectToPack otp) throws IOException {
        if (!otp.isWritten()) {
            this.writeObjectImpl(out, otp);
        }
    }

    private void writeObjectImpl(PackOutputStream out, ObjectToPack otp) throws IOException {
        if (otp.wantWrite()) {
            this.reuseDeltas = false;
            otp.clearDeltaBase();
            otp.clearReuseAsIs();
            this.reuseSupport.selectObjectRepresentation(this, NullProgressMonitor.INSTANCE, Collections.singleton(otp));
        }
        otp.markWantWrite();
        while (otp.isReuseAsIs()) {
            this.writeBase(out, otp.getDeltaBase());
            if (otp.isWritten()) {
                return;
            }
            out.resetCRC32();
            otp.setOffset(out.length());
            try {
                this.reuseSupport.copyObjectAsIs(out, otp, this.reuseValidate);
                out.endObject();
                otp.setCRC(out.getCRC32());
                ++this.typeStats.reusedObjects;
                if (otp.isDeltaRepresentation()) {
                    ++this.typeStats.reusedDeltas;
                    this.typeStats.deltaBytes += out.length() - otp.getOffset();
                }
                return;
            }
            catch (StoredObjectRepresentationNotAvailableException gone) {
                if (otp.getOffset() == out.length()) {
                    otp.setOffset(0L);
                    otp.clearDeltaBase();
                    otp.clearReuseAsIs();
                    this.reuseSupport.selectObjectRepresentation(this, NullProgressMonitor.INSTANCE, Collections.singleton(otp));
                    continue;
                }
                CorruptObjectException coe = new CorruptObjectException(otp, "");
                coe.initCause(gone);
                throw coe;
            }
        }
        if (otp.isDeltaRepresentation()) {
            this.writeDeltaObjectDeflate(out, otp);
        } else {
            this.writeWholeObjectDeflate(out, otp);
        }
        out.endObject();
        otp.setCRC(out.getCRC32());
    }

    private void writeBase(PackOutputStream out, ObjectToPack base) throws IOException {
        if (base != null && !base.isWritten() && !base.isEdge()) {
            this.writeObjectImpl(out, base);
        }
    }

    private void writeWholeObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        Deflater deflater = this.deflater();
        ObjectLoader ldr = this.reader.open(otp, otp.getType());
        out.resetCRC32();
        otp.setOffset(out.length());
        out.writeHeader(otp, ldr.getSize());
        deflater.reset();
        DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
        ldr.copyTo(dst);
        dst.finish();
    }

    private void writeDeltaObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        byte[] zbuf;
        this.writeBase(out, otp.getDeltaBase());
        out.resetCRC32();
        otp.setOffset(out.length());
        DeltaCache.Ref ref = otp.popCachedDelta();
        if (ref != null && (zbuf = (byte[])ref.get()) != null) {
            out.writeHeader(otp, otp.getCachedSize());
            out.write(zbuf);
            return;
        }
        TemporaryBuffer.Heap delta = this.delta(otp);
        out.writeHeader(otp, delta.length());
        Deflater deflater = this.deflater();
        deflater.reset();
        DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
        delta.writeTo(dst, null);
        dst.finish();
        ++this.typeStats.cntDeltas;
        this.typeStats.deltaBytes += out.length() - otp.getOffset();
    }

    private TemporaryBuffer.Heap delta(ObjectToPack otp) throws IOException {
        DeltaIndex index = new DeltaIndex(this.buffer(otp.getDeltaBaseId()));
        byte[] res = this.buffer(otp);
        TemporaryBuffer.Heap delta = new TemporaryBuffer.Heap(res.length);
        index.encode(delta, res);
        return delta;
    }

    private byte[] buffer(AnyObjectId objId) throws IOException {
        return PackWriter.buffer(this.config, this.reader, objId);
    }

    static byte[] buffer(PackConfig config, ObjectReader or, AnyObjectId objId) throws IOException {
        return or.open(objId).getCachedBytes(config.getBigFileThreshold());
    }

    private Deflater deflater() {
        if (this.myDeflater == null) {
            this.myDeflater = new Deflater(this.config.getCompressionLevel());
        }
        return this.myDeflater;
    }

    private void writeChecksum(PackOutputStream out) throws IOException {
        this.packcsum = out.getDigest();
        out.write(this.packcsum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void findObjectsToPack(ProgressMonitor countingMonitor, ObjectWalk walker, Set<? extends ObjectId> want, Set<? extends ObjectId> have) throws MissingObjectException, IOException, IncorrectObjectTypeException {
        void var20_26;
        RevCommit c;
        AsyncRevObjectQueue q;
        ArrayList<RevTag> wantTags;
        ArrayList<RevObject> haveObjs;
        ArrayList<RevObject> wantObjs;
        RevFlagSet keepOnRestart;
        RevFlag added;
        RevFlag include;
        RevFlag inCachedPack;
        HashMap<ObjectId, CachedPack> tipToPack;
        ArrayList<? extends ObjectId> all;
        long countingStart;
        block48: {
            countingStart = System.currentTimeMillis();
            this.beginPhase(PackingPhase.COUNTING, countingMonitor, 0L);
            if (have == null) {
                have = Collections.emptySet();
            }
            this.stats.interestingObjects = Collections.unmodifiableSet(new HashSet<ObjectId>(want));
            this.stats.uninterestingObjects = Collections.unmodifiableSet(new HashSet<ObjectId>(have));
            all = new ArrayList<ObjectId>(want.size() + have.size());
            all.addAll(want);
            all.addAll(have);
            tipToPack = new HashMap<ObjectId, CachedPack>();
            inCachedPack = walker.newFlag("inCachedPack");
            include = walker.newFlag("include");
            added = walker.newFlag("added");
            keepOnRestart = new RevFlagSet();
            keepOnRestart.add(inCachedPack);
            walker.setRetainBody(false);
            walker.carry(include);
            int haveEst = have.size();
            if (have.isEmpty()) {
                walker.sort(RevSort.COMMIT_TIME_DESC);
                if (this.useCachedPacks && this.reuseSupport != null) {
                    HashSet<? extends ObjectId> need = new HashSet<ObjectId>(want);
                    LinkedList<CachedPack> shortCircuit = new LinkedList<CachedPack>();
                    for (CachedPack pack : this.reuseSupport.getCachedPacks()) {
                        if (need.containsAll(pack.getTips())) {
                            need.removeAll(pack.getTips());
                            shortCircuit.add(pack);
                        }
                        for (ObjectId id : pack.getTips()) {
                            tipToPack.put(id, pack);
                            all.add(id);
                        }
                    }
                    if (need.isEmpty() && !shortCircuit.isEmpty()) {
                        this.cachedPacks.addAll(shortCircuit);
                        for (CachedPack pack : shortCircuit) {
                            countingMonitor.update((int)pack.getObjectCount());
                        }
                        this.endPhase(countingMonitor);
                        this.stats.timeCounting = System.currentTimeMillis() - countingStart;
                        return;
                    }
                    haveEst += tipToPack.size();
                }
            } else {
                walker.sort(RevSort.TOPO);
                if (this.thin) {
                    walker.sort(RevSort.BOUNDARY, true);
                }
            }
            wantObjs = new ArrayList<RevObject>(want.size());
            haveObjs = new ArrayList<RevObject>(haveEst);
            wantTags = new ArrayList<RevTag>(want.size());
            q = walker.parseAny(all, true);
            try {
                while (true) {
                    try {
                        while (true) {
                            RevObject o;
                            if ((o = q.next()) == null) {
                                break block48;
                            }
                            if (tipToPack.containsKey(o)) {
                                o.add(inCachedPack);
                            }
                            if (have.contains(o)) {
                                haveObjs.add(o);
                            }
                            if (!want.contains(o)) continue;
                            o.add(include);
                            wantObjs.add(o);
                            if (!(o instanceof RevTag)) continue;
                            wantTags.add((RevTag)o);
                        }
                    }
                    catch (MissingObjectException e) {
                        if (this.ignoreMissingUninteresting && have.contains(e.getObjectId())) continue;
                        throw e;
                    }
                    break;
                }
            }
            finally {
                q.release();
            }
        }
        if (!wantTags.isEmpty()) {
            all = new ArrayList(wantTags.size());
            for (RevTag tag : wantTags) {
                all.add(tag.getObject());
            }
            q = walker.parseAny(all, true);
            try {
                while (q.next() != null) {
                }
            }
            finally {
                q.release();
            }
        }
        if (walker instanceof DepthWalk.ObjectWalk) {
            DepthWalk.ObjectWalk depthWalk = (DepthWalk.ObjectWalk)walker;
            for (RevObject revObject : wantObjs) {
                depthWalk.markRoot(revObject);
            }
            if (this.unshallowObjects != null) {
                for (ObjectId objectId : this.unshallowObjects) {
                    depthWalk.markUnshallow(walker.parseAny(objectId));
                }
            }
        } else {
            for (RevObject obj : wantObjs) {
                walker.markStart(obj);
            }
        }
        for (RevObject obj : haveObjs) {
            walker.markUninteresting(obj);
        }
        int maxBases = this.config.getDeltaSearchWindowSize();
        HashSet<RevTree> baseTrees = new HashSet<RevTree>();
        BlockList blockList = new BlockList();
        while ((c = walker.next()) != null) {
            CachedPack pack;
            if (this.exclude(c)) continue;
            if (c.has(inCachedPack) && PackWriter.includesAllTips(pack = (CachedPack)tipToPack.get(c), include, walker)) {
                this.useCachedPack(walker, keepOnRestart, wantObjs, haveObjs, pack);
                BlockList blockList2 = new BlockList();
                this.endPhase(countingMonitor);
                this.beginPhase(PackingPhase.COUNTING, countingMonitor, 0L);
                continue;
            }
            if (c.has(RevFlag.UNINTERESTING)) {
                if (baseTrees.size() > maxBases) continue;
                baseTrees.add(c.getTree());
                continue;
            }
            var20_26.add(c);
            countingMonitor.update(1);
        }
        if (this.shallowPack) {
            for (RevCommit cmit : var20_26) {
                this.addObject(cmit, 0);
            }
        } else {
            int commitCnt = 0;
            boolean putTagTargets = false;
            for (RevCommit cmit : var20_26) {
                if (!cmit.has(added)) {
                    cmit.add(added);
                    this.addObject(cmit, 0);
                    ++commitCnt;
                }
                for (int i = 0; i < cmit.getParentCount(); ++i) {
                    RevCommit p = cmit.getParent(i);
                    if (p.has(added) || p.has(RevFlag.UNINTERESTING)) continue;
                    p.add(added);
                    this.addObject(p, 0);
                    ++commitCnt;
                }
                if (putTagTargets || 4096 >= commitCnt) continue;
                for (ObjectId id : this.tagTargets) {
                    RevObject obj = walker.lookupOrNull(id);
                    if (!(obj instanceof RevCommit) || !obj.has(include) || obj.has(RevFlag.UNINTERESTING) || obj.has(added)) continue;
                    obj.add(added);
                    this.addObject(obj, 0);
                }
                putTagTargets = true;
            }
        }
        Object var20_28 = null;
        if (this.thin && !baseTrees.isEmpty()) {
            RevObject o;
            BaseSearch bases = new BaseSearch(countingMonitor, baseTrees, this.objectsMap, this.edgeObjects, this.reader);
            while ((o = walker.nextObject()) != null) {
                if (o.has(RevFlag.UNINTERESTING) || this.exclude(o)) continue;
                int pathHash = walker.getPathHashCode();
                byte[] pathBuf = walker.getPathBuffer();
                int pathLen = walker.getPathLength();
                bases.addBase(o.getType(), pathBuf, pathLen, pathHash);
                this.addObject(o, pathHash);
                countingMonitor.update(1);
            }
        } else {
            RevObject o;
            while ((o = walker.nextObject()) != null) {
                if (o.has(RevFlag.UNINTERESTING) || this.exclude(o)) continue;
                this.addObject(o, walker.getPathHashCode());
                countingMonitor.update(1);
            }
        }
        for (CachedPack pack : this.cachedPacks) {
            countingMonitor.update((int)pack.getObjectCount());
        }
        this.endPhase(countingMonitor);
        this.stats.timeCounting = System.currentTimeMillis() - countingStart;
    }

    private static void pruneEdgesFromObjectList(List<ObjectToPack> list) {
        int size = list.size();
        int dst = 0;
        for (int src = 0; src < size; ++src) {
            ObjectToPack obj = list.get(src);
            if (obj.isEdge()) continue;
            if (dst != src) {
                list.set(dst, obj);
            }
            ++dst;
        }
        while (dst < list.size()) {
            list.remove(list.size() - 1);
        }
    }

    private void useCachedPack(ObjectWalk walker, RevFlagSet keepOnRestart, List<RevObject> wantObj, List<RevObject> baseObj, CachedPack pack) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.cachedPacks.add(pack);
        for (ObjectId objectId : pack.getTips()) {
            baseObj.add(walker.lookupOrNull(objectId));
        }
        this.setThin(true);
        walker.resetRetain(keepOnRestart);
        walker.sort(RevSort.TOPO);
        walker.sort(RevSort.BOUNDARY, true);
        for (RevObject revObject : wantObj) {
            walker.markStart(revObject);
        }
        for (RevObject revObject : baseObj) {
            walker.markUninteresting(revObject);
        }
    }

    private static boolean includesAllTips(CachedPack pack, RevFlag include, ObjectWalk walker) {
        for (ObjectId id : pack.getTips()) {
            if (walker.lookupOrNull(id).has(include)) continue;
            return false;
        }
        return true;
    }

    public void addObject(RevObject object) throws IncorrectObjectTypeException {
        if (!this.exclude(object)) {
            this.addObject(object, 0);
        }
    }

    private void addObject(RevObject object, int pathHashCode) {
        ObjectToPack otp = this.reuseSupport != null ? this.reuseSupport.newObjectToPack(object) : new ObjectToPack(object);
        otp.setPathHash(pathHashCode);
        this.objectsLists[object.getType()].add(otp);
        this.objectsMap.add(otp);
    }

    private boolean exclude(AnyObjectId objectId) {
        if (this.excludeInPacks == null) {
            return false;
        }
        if (this.excludeInPackLast.hasObject(objectId)) {
            return true;
        }
        for (PackIndex idx : this.excludeInPacks) {
            if (!idx.hasObject(objectId)) continue;
            this.excludeInPackLast = idx;
            return true;
        }
        return false;
    }

    public void select(ObjectToPack otp, StoredObjectRepresentation next) {
        int nFmt = next.getFormat();
        if (!this.cachedPacks.isEmpty()) {
            if (otp.isEdge()) {
                return;
            }
            if (nFmt == 1 | nFmt == 0) {
                for (CachedPack pack : this.cachedPacks) {
                    if (!pack.hasObject(otp, next)) continue;
                    otp.setEdge();
                    otp.clearDeltaBase();
                    otp.clearReuseAsIs();
                    this.pruneCurrentObjectList = true;
                    return;
                }
            }
        }
        if (nFmt == 0 && this.reuseDeltas && this.reuseDeltaFor(otp)) {
            ObjectId baseId = next.getDeltaBase();
            ObjectToPack ptr = this.objectsMap.get(baseId);
            if (ptr != null && !ptr.isEdge()) {
                otp.setDeltaBase(ptr);
                otp.setReuseAsIs();
            } else if (this.thin && ptr != null && ptr.isEdge()) {
                otp.setDeltaBase(baseId);
                otp.setReuseAsIs();
            } else {
                otp.clearDeltaBase();
                otp.clearReuseAsIs();
            }
        } else if (nFmt == 1 && this.config.isReuseObjects()) {
            int nWeight = next.getWeight();
            if (otp.isReuseAsIs() && !otp.isDeltaRepresentation() && otp.getWeight() <= nWeight) {
                return;
            }
            otp.clearDeltaBase();
            otp.setReuseAsIs();
            otp.setWeight(nWeight);
        } else {
            otp.clearDeltaBase();
            otp.clearReuseAsIs();
        }
        otp.select(next);
    }

    private boolean reuseDeltaFor(ObjectToPack otp) {
        switch (otp.getType()) {
            case 1: {
                return this.reuseDeltaCommits;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Map access$000() {
        return instances;
    }

    private class MutableState {
        private static final long OBJECT_TO_PACK_SIZE = 120L;
        private final long totalDeltaSearchBytes;
        private volatile PackingPhase phase = PackingPhase.COUNTING;

        MutableState() {
            if (PackWriter.this.config.isDeltaCompress()) {
                int threads = PackWriter.this.config.getThreads();
                if (threads <= 0) {
                    threads = Runtime.getRuntime().availableProcessors();
                }
                this.totalDeltaSearchBytes = (long)threads * PackWriter.this.config.getDeltaSearchMemoryLimit() + (long)PackWriter.this.config.getBigFileThreshold();
            } else {
                this.totalDeltaSearchBytes = 0L;
            }
        }

        State snapshot() {
            long objCnt = 0L;
            objCnt += (long)PackWriter.this.objectsLists[1].size();
            objCnt += (long)PackWriter.this.objectsLists[2].size();
            objCnt += (long)PackWriter.this.objectsLists[3].size();
            long bytesUsed = 120L * (objCnt += (long)PackWriter.this.objectsLists[4].size());
            PackingPhase curr = this.phase;
            if (curr == PackingPhase.COMPRESSING) {
                bytesUsed += this.totalDeltaSearchBytes;
            }
            return new State(curr, bytesUsed);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PackingPhase {
        COUNTING,
        GETTING_SIZES,
        FINDING_SOURCES,
        COMPRESSING,
        WRITING;

    }

    public class State {
        private final PackingPhase phase;
        private final long bytesUsed;

        State(PackingPhase phase, long bytesUsed) {
            this.phase = phase;
            this.bytesUsed = bytesUsed;
        }

        public PackConfig getConfig() {
            return PackWriter.this.config;
        }

        public PackingPhase getPhase() {
            return this.phase;
        }

        public long estimateBytesUsed() {
            return this.bytesUsed;
        }

        public String toString() {
            return "PackWriter.State[" + (Object)((Object)this.phase) + ", memory=" + this.bytesUsed + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Statistics {
        Set<ObjectId> interestingObjects;
        Set<ObjectId> uninterestingObjects;
        Collection<CachedPack> reusedPacks;
        int depth;
        int deltaSearchNonEdgeObjects;
        int deltasFound;
        long totalObjects;
        long totalDeltas;
        long reusedObjects;
        long reusedDeltas;
        long totalBytes;
        long thinPackBytes;
        long timeCounting;
        long timeSearchingForReuse;
        long timeSearchingForSizes;
        long timeCompressing;
        long timeWriting;
        ObjectType[] objectTypes = new ObjectType[5];

        public Statistics() {
            this.objectTypes[1] = new ObjectType();
            this.objectTypes[2] = new ObjectType();
            this.objectTypes[3] = new ObjectType();
            this.objectTypes[4] = new ObjectType();
        }

        public Set<ObjectId> getInterestingObjects() {
            return this.interestingObjects;
        }

        public Set<ObjectId> getUninterestingObjects() {
            return this.uninterestingObjects;
        }

        public Collection<CachedPack> getReusedPacks() {
            return this.reusedPacks;
        }

        public int getDeltaSearchNonEdgeObjects() {
            return this.deltaSearchNonEdgeObjects;
        }

        public int getDeltasFound() {
            return this.deltasFound;
        }

        public long getTotalObjects() {
            return this.totalObjects;
        }

        public long getTotalDeltas() {
            return this.totalDeltas;
        }

        public long getReusedObjects() {
            return this.reusedObjects;
        }

        public long getReusedDeltas() {
            return this.reusedDeltas;
        }

        public long getTotalBytes() {
            return this.totalBytes;
        }

        public long getThinPackBytes() {
            return this.thinPackBytes;
        }

        public ObjectType byObjectType(int typeCode) {
            return this.objectTypes[typeCode];
        }

        public boolean isShallow() {
            return this.depth > 0;
        }

        public int getDepth() {
            return this.depth;
        }

        public long getTimeCounting() {
            return this.timeCounting;
        }

        public long getTimeSearchingForReuse() {
            return this.timeSearchingForReuse;
        }

        public long getTimeSearchingForSizes() {
            return this.timeSearchingForSizes;
        }

        public long getTimeCompressing() {
            return this.timeCompressing;
        }

        public long getTimeWriting() {
            return this.timeWriting;
        }

        public long getTimeTotal() {
            return this.timeCounting + this.timeSearchingForReuse + this.timeSearchingForSizes + this.timeCompressing + this.timeWriting;
        }

        public double getTransferRate() {
            return (double)this.getTotalBytes() / ((double)this.getTimeWriting() / 1000.0);
        }

        public String getMessage() {
            return MessageFormat.format(JGitText.get().packWriterStatistics, this.totalObjects, this.totalDeltas, this.reusedObjects, this.reusedDeltas);
        }

        public static class ObjectType {
            long cntObjects;
            long cntDeltas;
            long reusedObjects;
            long reusedDeltas;
            long bytes;
            long deltaBytes;

            public long getObjects() {
                return this.cntObjects;
            }

            public long getDeltas() {
                return this.cntDeltas;
            }

            public long getReusedObjects() {
                return this.reusedObjects;
            }

            public long getReusedDeltas() {
                return this.reusedDeltas;
            }

            public long getBytes() {
                return this.bytes;
            }

            public long getDeltaBytes() {
                return this.deltaBytes;
            }
        }
    }
}

