/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.nodes;

import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.Database;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseServerManager;
import org.netbeans.modules.db.mysql.actions.AdministerAction;
import org.netbeans.modules.db.mysql.actions.ConnectServerAction;
import org.netbeans.modules.db.mysql.actions.CreateDatabaseAction;
import org.netbeans.modules.db.mysql.actions.DisconnectServerAction;
import org.netbeans.modules.db.mysql.actions.PropertiesAction;
import org.netbeans.modules.db.mysql.actions.RefreshServerAction;
import org.netbeans.modules.db.mysql.actions.StartAction;
import org.netbeans.modules.db.mysql.actions.StopAction;
import org.netbeans.modules.db.mysql.impl.ServerNodeProvider;
import org.netbeans.modules.db.mysql.nodes.DatabaseNode;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public class ServerNode
extends AbstractNode
implements ChangeListener,
Comparable {
    private final DatabaseServer server;
    private static final String ICON = "org/netbeans/modules/db/mysql/resources/catalog.gif";
    private static final HelpCtx HELP_CONTEXT = new HelpCtx(ServerNode.class.getName());

    public static ServerNode create(DatabaseServer server) {
        ChildFactory factory = new ChildFactory(server);
        return new ServerNode(factory, server);
    }

    private ServerNode(ChildFactory factory, DatabaseServer server) {
        super(Children.create((org.openide.nodes.ChildFactory)factory, (boolean)true));
        this.server = server;
        this.setName("");
        this.setDisplayName(server.getDisplayName());
        this.setShortDescription(server.getShortDescription());
        this.setIconBaseWithExtension(ICON);
        this.registerListeners();
    }

    public Node.Cookie getCookie(Class cls) {
        if (cls == DatabaseServer.class) {
            return this.server;
        }
        return super.getCookie(cls);
    }

    public HelpCtx getHelpCtx() {
        return HELP_CONTEXT;
    }

    private void registerListeners() {
        DatabaseServer server = DatabaseServerManager.getDatabaseServer();
        server.addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this, (Object)server));
        this.stateChanged(new ChangeEvent(server));
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        String oldName = this.getDisplayName();
        String oldShortDescription = this.getShortDescription();
        this.setDisplayName(this.server.getDisplayName());
        this.fireNameChange(oldName, this.getDisplayName());
        this.setShortDescription(this.server.getShortDescription());
        this.fireShortDescriptionChange(oldShortDescription, this.getShortDescription());
        this.fireIconChange();
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return super.getActions(context);
        }
        return new SystemAction[]{SystemAction.get(CreateDatabaseAction.class), SystemAction.get(StartAction.class), SystemAction.get(StopAction.class), SystemAction.get(ConnectServerAction.class), SystemAction.get(DisconnectServerAction.class), SystemAction.get(DeleteAction.class), SystemAction.get(RefreshServerAction.class), SystemAction.get(AdministerAction.class), SystemAction.get(PropertiesAction.class)};
    }

    public boolean canDestroy() {
        return true;
    }

    public Image getIcon(int type) {
        return this.server.getIcon();
    }

    public void destroy() {
        ServerNodeProvider.getDefault().setRegistered(false);
    }

    public int compareTo(Object other) {
        Node othernode = (Node)other;
        return this.getDisplayName().compareTo(othernode.getDisplayName());
    }

    private static class ChildFactory
    extends org.openide.nodes.ChildFactory<Database>
    implements ChangeListener {
        private static final Comparator<Database> COMPARATOR = new InstanceComparator();
        private final DatabaseServer server;

        public ChildFactory(DatabaseServer server) {
            this.server = server;
            server.addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this, (Object)server));
            this.stateChanged(new ChangeEvent(server));
        }

        protected Node createNodeForKey(Database db) {
            return new DatabaseNode(db);
        }

        protected boolean createKeys(List<Database> toPopulate) {
            ArrayList<Database> fresh = new ArrayList<Database>();
            try {
                fresh.addAll(this.server.getDatabases());
            }
            catch (DatabaseException ex) {
                Utils.displayError(Utils.getMessage("MSG_UnableToGetDatabaseList", new Object[0]), (Exception)((Object)ex));
                return true;
            }
            Collections.sort(fresh, COMPARATOR);
            toPopulate.addAll(fresh);
            return true;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }
    }

    private static class InstanceComparator
    implements Comparator<Database>,
    Serializable {
        private InstanceComparator() {
        }

        @Override
        public int compare(Database o1, Database o2) {
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        }
    }
}

