/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class LogDate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final long timeMicros;
    private final String cachedString;
    private final Calendar cachedDate;

    public LogDate(String string) throws ParseException {
        if (string == null || string.length() != 27 || string.charAt(26) != 'Z') {
            throw new ParseException("String is not a valid Subversion date", 0);
        }
        Date date = formatter.parse(string.substring(0, 23) + " UTC");
        this.cachedString = string;
        this.cachedDate = Calendar.getInstance(UTC);
        this.cachedDate.setTime(date);
        this.timeMicros = this.cachedDate.getTimeInMillis() * 1000L + (long)Integer.parseInt(string.substring(23, 26));
    }

    public long getTimeMicros() {
        return this.timeMicros;
    }

    public long getTimeMillis() {
        return this.cachedDate.getTimeInMillis();
    }

    public Calendar getCalender() {
        return this.cachedDate;
    }

    public Date getDate() {
        return this.cachedDate.getTime();
    }

    public String toString() {
        return this.cachedString;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.timeMicros ^ this.timeMicros >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LogDate logDate = (LogDate)object;
        return this.timeMicros == logDate.getTimeMicros();
    }
}

