/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.ui.views.VariablesViewButtons;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.CheckNodeModel;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.DnDNodeModel;
import org.netbeans.spi.viewmodel.DnDNodeModelFilter;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.ReorderableTreeModel;
import org.netbeans.spi.viewmodel.ReorderableTreeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TableRendererModel;
import org.netbeans.spi.viewmodel.TableRendererModelFilter;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class ViewModelListener
extends DebuggerManagerAdapter {
    private static final Class[] TREE_MODELS = new Class[]{TreeModel.class, ReorderableTreeModel.class};
    private static final Class[] TREE_MODEL_FILTERS = new Class[]{TreeModelFilter.class, ReorderableTreeModelFilter.class};
    private static final Class[] NODE_MODELS = new Class[]{NodeModel.class, CheckNodeModel.class, DnDNodeModel.class, ExtendedNodeModel.class};
    private static final Class[] NODE_MODEL_FILTERS = new Class[]{NodeModelFilter.class, CheckNodeModelFilter.class, DnDNodeModelFilter.class, ExtendedNodeModelFilter.class};
    private static final String VIEW_PREFERENCES_NAME = "view_preferences";
    private static final String VIEW_TYPE = "view_type";
    private static final String VIEW_TREE_DISPLAY_FORMAT = "view_tree_display_format";
    private static final String VIEW_TYPE_TABLE = "table";
    private static final String VIEW_TYPE_TREE = "tree";
    private String viewType;
    private JComponent view;
    private JComponent buttonsPane;
    private List models = new ArrayList(11);
    private List hyperModels;
    private List<? extends SessionProvider> sessionProviders;
    private Session currentSession;
    private List[] treeModels = new List[TREE_MODELS.length];
    private List[] treeModelFilters = new List[TREE_MODEL_FILTERS.length];
    private List treeExpansionModels;
    private List treeExpansionModelFilters;
    private List[] nodeModels = new List[NODE_MODELS.length];
    private List[] nodeModelFilters = new List[NODE_MODEL_FILTERS.length];
    private List tableModels;
    private List tableModelFilters;
    private List nodeActionsProviders;
    private List nodeActionsProviderFilters;
    private List columnModels;
    private List mm;
    private List asynchModelFilters;
    private List tableRenderers;
    private List tableRendererFilters;
    private List<AbstractButton> buttons;
    private JTabbedPane tabbedPane;
    private Image viewIcon;
    private SessionProvider providerToDisplay;
    private List<ViewModelListener> subListeners = new ArrayList<ViewModelListener>();
    private final Object destroyLock = new Object();
    private boolean isUp;
    private Preferences preferences = NbPreferences.forModule(ContextProvider.class).node("variables_view");
    private Preferences viewPreferences;
    private MessageFormat viewTreeDisplayFormat;
    private ViewPreferenceChangeListener prefListener = new ViewPreferenceChangeListener();
    private static final RequestProcessor RP = new RequestProcessor(ViewModelListener.class.getName(), 1);
    private String propertiesHelpID = null;

    ViewModelListener(String viewType, JComponent view, JComponent buttonsPane, String propertiesHelpID, Image viewIcon) {
        this.viewType = viewType;
        this.view = view;
        this.buttonsPane = buttonsPane;
        buttonsPane.setLayout(new GridBagLayout());
        this.propertiesHelpID = propertiesHelpID;
        this.viewIcon = viewIcon;
        this.viewPreferences = NbPreferences.forModule(ContextProvider.class).node(VIEW_PREFERENCES_NAME).node(viewType);
        this.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUp() {
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ViewModelListener.this.setUp();
                }
            });
            return;
        }
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.preferences.addPreferenceChangeListener(this.prefListener);
        this.viewPreferences.addPreferenceChangeListener(this.prefListener);
        ViewModelListener viewModelListener = this;
        synchronized (viewModelListener) {
            this.isUp = true;
            ((Object)((Object)this)).notifyAll();
        }
        this.updateModelLazily();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        ArrayList<ViewModelListener> sls;
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ViewModelListener.this.destroy();
                }
            });
            return;
        }
        ViewModelListener viewModelListener = this;
        synchronized (viewModelListener) {
            JComponent tree;
            boolean haveModels;
            if (!this.isUp) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            this.preferences.removePreferenceChangeListener(this.prefListener);
            this.viewPreferences.removePreferenceChangeListener(this.prefListener);
            boolean haveTreeModels = false;
            for (List tms : this.treeModels) {
                if (tms == null || tms.size() <= 0) continue;
                haveTreeModels = true;
                break;
            }
            boolean haveNodeModels = false;
            for (List nms : this.nodeModels) {
                if (nms == null || nms.size() <= 0) continue;
                haveNodeModels = true;
                break;
            }
            boolean bl = haveModels = haveTreeModels || haveNodeModels || this.tableModels != null && this.tableModels.size() > 0;
            if (haveModels && this.view.getComponentCount() > 0 && !((tree = (JComponent)this.view.getComponent(0)) instanceof JTabbedPane)) {
                Models.setModelsToView((JComponent)tree, null);
            }
            Object object = this.destroyLock;
            synchronized (object) {
                this.models.clear();
                this.treeModels = new List[TREE_MODELS.length];
                this.treeModelFilters = new List[TREE_MODEL_FILTERS.length];
                this.treeExpansionModels = null;
                this.treeExpansionModelFilters = null;
                this.nodeModels = new List[NODE_MODELS.length];
                this.nodeModelFilters = new List[NODE_MODEL_FILTERS.length];
                this.tableModels = null;
                this.tableModelFilters = null;
                this.nodeActionsProviders = null;
                this.nodeActionsProviderFilters = null;
                this.columnModels = null;
                this.mm = null;
                this.asynchModelFilters = null;
                this.sessionProviders = null;
                this.currentSession = null;
                this.providerToDisplay = null;
                this.buttons = null;
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ViewModelListener.this.destroyLock;
                        synchronized (object) {
                            if (ViewModelListener.this.buttons == null) {
                                ViewModelListener.this.buttonsPane.removeAll();
                                ViewModelListener.this.view.removeAll();
                            }
                        }
                    }
                });
                sls = new ArrayList<ViewModelListener>(this.subListeners);
                this.subListeners.clear();
                this.isUp = false;
            }
        }
        for (ViewModelListener l : sls) {
            l.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getNewValue() != null) {
            ViewModelListener viewModelListener = this;
            synchronized (viewModelListener) {
                this.providerToDisplay = null;
            }
        }
        this.updateModel();
    }

    private static void getMultiModels(ContextProvider cp, String viewPath, List[] models, Class[] classTypes) {
        for (int i = 0; i < classTypes.length; ++i) {
            models[i] = cp.lookup(viewPath, classTypes[i]);
        }
    }

    private synchronized void updateModel() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                ViewModelListener.this.updateModelLazily();
            }
        });
    }

    private synchronized void updateModelLazily() {
        String viewPath;
        DebuggerManager cp;
        if (!this.isUp) {
            return;
        }
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        DebuggerEngine e = dm.getCurrentEngine();
        this.sessionProviders = e == null ? dm.lookup(this.viewType, SessionProvider.class) : DebuggerManager.join((ContextProvider)e, (ContextProvider)dm).lookup(this.viewType, SessionProvider.class);
        if (!this.sessionProviders.contains(this.providerToDisplay)) {
            this.providerToDisplay = null;
        }
        if (e == null && this.providerToDisplay == null && this.sessionProviders.size() > 0) {
            this.providerToDisplay = this.sessionProviders.get(0);
        }
        if (this.providerToDisplay != null) {
            e = null;
            cp = dm;
            viewPath = this.viewType + "/" + this.providerToDisplay.getTypeID();
        } else {
            cp = e != null ? DebuggerManager.join((ContextProvider)e, (ContextProvider)dm) : dm;
            viewPath = this.viewType;
        }
        this.currentSession = dm.getCurrentSession();
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, this.treeModels, TREE_MODELS);
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, this.treeModelFilters, TREE_MODEL_FILTERS);
        this.treeExpansionModels = cp.lookup(viewPath, TreeExpansionModel.class);
        this.treeExpansionModelFilters = cp.lookup(this.viewType, TreeExpansionModelFilter.class);
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, this.nodeModels, NODE_MODELS);
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, this.nodeModelFilters, NODE_MODEL_FILTERS);
        this.tableModels = cp.lookup(viewPath, TableModel.class);
        this.tableModelFilters = cp.lookup(viewPath, TableModelFilter.class);
        this.nodeActionsProviders = cp.lookup(viewPath, NodeActionsProvider.class);
        this.nodeActionsProviderFilters = cp.lookup(viewPath, NodeActionsProviderFilter.class);
        this.columnModels = cp.lookup(viewPath, ColumnModel.class);
        this.mm = cp.lookup(viewPath, Model.class);
        this.asynchModelFilters = cp.lookup(viewPath, AsynchronousModelFilter.class);
        this.tableRenderers = cp.lookup(viewPath, TableRendererModel.class);
        this.tableRendererFilters = cp.lookup(viewPath, TableRendererModelFilter.class);
        String searchPath = viewPath;
        while (this.asynchModelFilters.isEmpty() && searchPath != null) {
            int i = searchPath.lastIndexOf(47);
            searchPath = i > 0 ? searchPath.substring(0, i) : null;
            this.asynchModelFilters = cp.lookup(searchPath, AsynchronousModelFilter.class);
        }
        if ("LocalsView".equals(this.viewType) && (VariablesViewButtons.isResultsViewNested() || VariablesViewButtons.isWatchesViewNested())) {
            this.hyperModels = new ArrayList();
            if (VariablesViewButtons.isResultsViewNested()) {
                this.hyperModels.add(this.createCompound("ResultsView"));
            }
            if (VariablesViewButtons.isWatchesViewNested()) {
                this.hyperModels.add(this.createCompound("WatchesView"));
            }
            Models.CompoundModel main = this.createCompound("LocalsView");
            this.hyperModels.add(main);
            this.hyperModels.add(main);
            this.hyperModels.add(new TreeModelFilter(){

                public Object getRoot(TreeModel original) {
                    return original.getRoot();
                }

                public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
                    Object[] ch = original.getChildren(parent, from, to);
                    if (ch != null) {
                        for (int x = 0; x < ch.length; ++x) {
                            if (ch[x] != null && !"HistoryNode".equals(ch[x].getClass().getSimpleName())) continue;
                            if (ch[x] == null) {
                                Exceptions.printStackTrace((Throwable)new NullPointerException("Null child at index " + x + ", parent: " + parent + ", model: " + original));
                            }
                            Object[] nch = new Object[ch.length - 1];
                            System.arraycopy(ch, 0, nch, 0, x);
                            if (x + 1 < ch.length) {
                                System.arraycopy(ch, x + 1, nch, x, ch.length - x - 1);
                            }
                            ch = nch;
                        }
                    }
                    return ch;
                }

                public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
                    return original.getChildrenCount(node);
                }

                public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
                    return false;
                }

                public void addModelListener(ModelListener l) {
                }

                public void removeModelListener(ModelListener l) {
                }
            });
        } else {
            this.hyperModels = null;
        }
        List bList = cp.lookup(viewPath, AbstractButton.class);
        ArrayList<AbstractButton> theButtons = new ArrayList<AbstractButton>();
        ArrayList<AbstractButton> tempList = new ArrayList<AbstractButton>();
        for (AbstractButton b : bList) {
            if (b instanceof JToggleButton) {
                theButtons.add(b);
                continue;
            }
            tempList.add(b);
        }
        theButtons.addAll(tempList);
        this.buttons = theButtons;
        this.tabbedPane = (JTabbedPane)cp.lookupFirst(viewPath, JTabbedPane.class);
        ModelsChangeRefresher mcr = new ModelsChangeRefresher();
        Customizer[] modelListCustomizers = new Customizer[]{(Customizer)((Object)this.treeExpansionModels), (Customizer)((Object)this.treeExpansionModelFilters), (Customizer)((Object)this.tableModels), (Customizer)((Object)this.tableModelFilters), (Customizer)((Object)this.nodeActionsProviders), (Customizer)((Object)this.nodeActionsProviderFilters), (Customizer)((Object)this.columnModels), (Customizer)((Object)this.mm), (Customizer)((Object)this.asynchModelFilters), (Customizer)((Object)this.tableRenderers), (Customizer)((Object)this.tableRendererFilters)};
        ArrayList<Customizer> modelListCustomizerLists = new ArrayList<Customizer>(50);
        modelListCustomizerLists.addAll(Arrays.asList(modelListCustomizers));
        ViewModelListener.addAsCustomizers(modelListCustomizerLists, this.treeModels);
        ViewModelListener.addAsCustomizers(modelListCustomizerLists, this.treeModelFilters);
        ViewModelListener.addAsCustomizers(modelListCustomizerLists, this.nodeModels);
        ViewModelListener.addAsCustomizers(modelListCustomizerLists, this.nodeModelFilters);
        for (int i = 0; i < modelListCustomizers.length; ++i) {
            Customizer c = modelListCustomizers[i];
            if (c == null) continue;
            c.addPropertyChangeListener(mcr);
            c.setObject("load first");
            c.setObject("unload last");
        }
        this.refreshModel();
    }

    private static void addAsCustomizers(List<Customizer> modelListCustomizerLists, Object[] modelLists) {
        for (int i = 0; i < modelLists.length; ++i) {
            modelListCustomizerLists.add((Customizer)modelLists[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List joinLists(List[] modelLists) {
        ArrayList models = new ArrayList();
        List[] arr$ = modelLists;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            List l;
            List list = l = arr$[i$];
            synchronized (list) {
                for (Object o : l) {
                    if (models.contains(o)) continue;
                    models.add(o);
                }
                continue;
            }
        }
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshModel() {
        this.models.clear();
        if (this.mm == null) {
            return;
        }
        Object object = this.treeModels;
        synchronized (this.treeModels) {
            this.models.add(ViewModelListener.joinLists(this.treeModels));
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            object = this.treeModelFilters;
            synchronized (this.treeModelFilters) {
                this.models.add(ViewModelListener.joinLists(this.treeModelFilters));
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                object = this.treeExpansionModels;
                synchronized (object) {
                    this.models.add(new ArrayList(this.treeExpansionModels));
                }
                object = this.nodeModels;
                synchronized (this.nodeModels) {
                    this.models.add(ViewModelListener.joinLists(this.nodeModels));
                    // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                    object = this.nodeModelFilters;
                    synchronized (this.nodeModelFilters) {
                        Models.CompoundModel newModel;
                        boolean haveModels;
                        this.models.add(ViewModelListener.joinLists(this.nodeModelFilters));
                        // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                        object = this.tableModels;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.tableModels));
                        }
                        object = this.tableModelFilters;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.tableModelFilters));
                        }
                        object = this.nodeActionsProviders;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.nodeActionsProviders));
                        }
                        object = this.nodeActionsProviderFilters;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.nodeActionsProviderFilters));
                        }
                        object = this.columnModels;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.columnModels));
                        }
                        object = this.mm;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.mm));
                        }
                        object = this.treeExpansionModelFilters;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.treeExpansionModelFilters));
                        }
                        object = this.asynchModelFilters;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.asynchModelFilters));
                        }
                        object = this.tableRenderers;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.tableRenderers));
                        }
                        object = this.tableRendererFilters;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.tableRendererFilters));
                        }
                        boolean haveTreeModels = false;
                        for (List tms : this.treeModels) {
                            if (tms.size() <= 0) continue;
                            haveTreeModels = true;
                            break;
                        }
                        boolean haveNodeModels = false;
                        for (List nms : this.nodeModels) {
                            if (nms.size() <= 0) continue;
                            haveNodeModels = true;
                            break;
                        }
                        boolean bl = haveModels = haveTreeModels || haveNodeModels || this.tableModels.size() > 0 || this.hyperModels != null;
                        if (this.hyperModels != null) {
                            newModel = Models.createCompoundModel((List)this.hyperModels, (String)this.propertiesHelpID);
                        } else if (haveModels) {
                            ArrayList<MessageFormat> theModels;
                            this.viewTreeDisplayFormat = ViewModelListener.createTreeDisplayFormat(this.viewPreferences, this.columnModels);
                            if (this.viewTreeDisplayFormat != null) {
                                theModels = new ArrayList<MessageFormat>(this.models);
                                theModels.add(this.viewTreeDisplayFormat);
                            } else {
                                theModels = this.models;
                            }
                            newModel = Models.createCompoundModel(theModels, (String)this.propertiesHelpID);
                        } else {
                            newModel = null;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                JPanel buttonsSubPane;
                                Object object = ViewModelListener.this.destroyLock;
                                synchronized (object) {
                                    List theButtons = ViewModelListener.this.buttons;
                                    if (theButtons == null) {
                                        return;
                                    }
                                    ViewModelListener.this.buttonsPane.removeAll();
                                    if (theButtons.size() == 0 && ViewModelListener.this.sessionProviders.size() == 0) {
                                        ViewModelListener.this.buttonsPane.setVisible(false);
                                        buttonsSubPane = null;
                                    } else {
                                        GridBagConstraints c;
                                        int i = 0;
                                        if (ViewModelListener.this.sessionProviders.size() > 0) {
                                            JButton b = ViewModelListener.this.createSessionsSwitchButton();
                                            GridBagConstraints c2 = new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 0, 3), 0, 0);
                                            ViewModelListener.this.buttonsPane.add((Component)b, c2);
                                            JSeparator s = new JSeparator(0);
                                            c2 = new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 0, 3, 0), 0, 0);
                                            ViewModelListener.this.buttonsPane.add((Component)s, c2);
                                            ++i;
                                        }
                                        if (ViewModelListener.this.tabbedPane != null) {
                                            buttonsSubPane = new JPanel();
                                            buttonsSubPane.setLayout(new GridBagLayout());
                                            c = new GridBagConstraints(0, i, 1, 1, 0.0, 1.0, 11, 3, new Insets(3, 0, 3, 0), 0, 0);
                                            ViewModelListener.this.buttonsPane.add((Component)buttonsSubPane, c);
                                            ++i;
                                        } else {
                                            buttonsSubPane = null;
                                            for (AbstractButton b : ViewModelListener.this.buttons) {
                                                GridBagConstraints c3 = new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 0, 3), 0, 0);
                                                ViewModelListener.this.buttonsPane.add((Component)b, c3);
                                                ++i;
                                            }
                                        }
                                        c = new GridBagConstraints(0, i, 1, 1, 0.0, 1.0, 11, 3, new Insets(3, 3, 3, 3), 0, 0);
                                        JPanel pushUpPanel = new JPanel();
                                        pushUpPanel.setBackground(ViewModelListener.this.buttonsPane.getBackground());
                                        ViewModelListener.this.buttonsPane.add((Component)pushUpPanel, c);
                                        ViewModelListener.this.buttonsPane.revalidate();
                                        ViewModelListener.this.buttonsPane.setVisible(true);
                                        ViewModelListener.this.buttonsPane.repaint();
                                        ViewModelListener.this.view.revalidate();
                                    }
                                }
                                if (ViewModelListener.this.view.getComponentCount() > 0) {
                                    if (ViewModelListener.this.tabbedPane == null && ViewModelListener.this.view.getComponent(0) instanceof JTabbedPane) {
                                        ViewModelListener.this.view.removeAll();
                                    } else if (ViewModelListener.this.tabbedPane != null) {
                                        ViewModelListener.this.view.removeAll();
                                    }
                                }
                                if (ViewModelListener.this.view.getComponentCount() == 0) {
                                    if (haveModels) {
                                        ViewModelListener.this.view.add(Models.createView((Models.CompoundModel)newModel));
                                        ViewModelListener.this.view.revalidate();
                                        ViewModelListener.this.view.repaint();
                                    } else if (ViewModelListener.this.tabbedPane != null) {
                                        int n = ViewModelListener.this.tabbedPane.getTabCount();
                                        for (int i = 0; i < n; ++i) {
                                            Component c = ViewModelListener.this.tabbedPane.getComponentAt(i);
                                            if (c instanceof JPanel) {
                                                c = (Component)((JPanel)c).getClientProperty(JLabel.class.getName());
                                            }
                                            if (!(c instanceof JLabel)) continue;
                                            String id = ((JLabel)c).getText();
                                            if (ViewModelListener.this.providerToDisplay != null) {
                                                id = ViewModelListener.this.providerToDisplay.getTypeID() + "/" + id;
                                            }
                                            JPanel contentComponent = new JPanel(new BorderLayout());
                                            ViewModelListener.this.subListeners.add(new ViewModelListener(ViewModelListener.this.viewType + "/" + id, contentComponent, buttonsSubPane, ViewModelListener.this.propertiesHelpID, ViewModelListener.this.viewIcon));
                                            ViewModelListener.this.tabbedPane.setComponentAt(i, contentComponent);
                                            contentComponent.putClientProperty(JLabel.class.getName(), c);
                                        }
                                        ViewModelListener.this.view.add(ViewModelListener.this.tabbedPane);
                                        ViewModelListener.this.view.revalidate();
                                        ViewModelListener.this.view.repaint();
                                    }
                                } else if (ViewModelListener.this.tabbedPane == null) {
                                    if (!haveModels) {
                                        ViewModelListener.this.view.removeAll();
                                        ViewModelListener.this.view.revalidate();
                                        ViewModelListener.this.view.repaint();
                                    } else {
                                        JComponent tree = (JComponent)ViewModelListener.this.view.getComponent(0);
                                        Models.setModelsToView((JComponent)tree, (Models.CompoundModel)newModel);
                                    }
                                }
                            }
                        });
                        return;
                    }
                }
            }
        }
    }

    private JButton createSessionsSwitchButton() {
        final JButton b = VariablesViewButtons.createButton(new ImageIcon(this.viewIcon), NbBundle.getMessage(ViewModelListener.class, (String)"Tooltip_SelectSrc"));
        b.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == b) {
                    JPopupMenu m = new JPopupMenu();
                    if (ViewModelListener.this.currentSession != null) {
                        JMenuItem mi = new JMenuItem(ViewModelListener.this.currentSession.getName());
                        mi.putClientProperty("SESSION", ViewModelListener.this.currentSession);
                        mi.addActionListener(this);
                        m.add(mi);
                    }
                    for (SessionProvider sp : ViewModelListener.this.sessionProviders) {
                        JMenuItem mi = new JMenuItem(sp.getSessionName());
                        mi.putClientProperty("SESSION", sp);
                        mi.addActionListener(this);
                        m.add(mi);
                    }
                    Point pos = b.getMousePosition();
                    if (pos == null) {
                        pos = new Point(b.getWidth(), b.getHeight());
                    }
                    m.show(b, pos.x, pos.y);
                } else {
                    JMenuItem mi = (JMenuItem)e.getSource();
                    Object s = mi.getClientProperty("SESSION");
                    ViewModelListener viewModelListener = ViewModelListener.this;
                    synchronized (viewModelListener) {
                        if (s instanceof Session) {
                            ViewModelListener.this.providerToDisplay = null;
                        } else {
                            ViewModelListener.this.providerToDisplay = (SessionProvider)s;
                        }
                    }
                    ViewModelListener.this.updateModel();
                }
            }
        });
        return b;
    }

    private Models.CompoundModel createCompound(String viewName) {
        String viewPath;
        DebuggerManager cp;
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        DebuggerEngine e = dm.getCurrentEngine();
        List localSessionProviders = e == null ? dm.lookup(viewName, SessionProvider.class) : DebuggerManager.join((ContextProvider)e, (ContextProvider)dm).lookup(viewName, SessionProvider.class);
        if (!localSessionProviders.contains(this.providerToDisplay)) {
            this.providerToDisplay = null;
        }
        if (e == null && this.providerToDisplay == null && localSessionProviders.size() > 0) {
            this.providerToDisplay = (SessionProvider)localSessionProviders.get(0);
        }
        if (this.providerToDisplay != null) {
            e = null;
            cp = dm;
            viewPath = viewName + "/" + this.providerToDisplay.getTypeID();
        } else {
            cp = e != null ? DebuggerManager.join((ContextProvider)e, (ContextProvider)dm) : dm;
            viewPath = viewName;
        }
        List[] treeModels = new List[TREE_MODELS.length];
        List[] treeModelFilters = new List[TREE_MODEL_FILTERS.length];
        List[] nodeModels = new List[NODE_MODELS.length];
        List[] nodeModelFilters = new List[NODE_MODEL_FILTERS.length];
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, treeModels, TREE_MODELS);
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, treeModelFilters, TREE_MODEL_FILTERS);
        List treeExpansionModels = cp.lookup(viewPath, TreeExpansionModel.class);
        List treeExpansionModelFilters = cp.lookup(viewPath, TreeExpansionModelFilter.class);
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, nodeModels, NODE_MODELS);
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, nodeModelFilters, NODE_MODEL_FILTERS);
        List tableModels = cp.lookup(viewPath, TableModel.class);
        List tableModelFilters = cp.lookup(viewPath, TableModelFilter.class);
        List nodeActionsProviders = cp.lookup(viewPath, NodeActionsProvider.class);
        List nodeActionsProviderFilters = cp.lookup(viewPath, NodeActionsProviderFilter.class);
        List columnModels = cp.lookup(viewPath, ColumnModel.class);
        List mm = cp.lookup(viewPath, Model.class);
        List asynchModelFilters = cp.lookup(viewPath, AsynchronousModelFilter.class);
        List tableRenderers = cp.lookup(viewPath, TableRendererModel.class);
        List tableRendererFilters = cp.lookup(viewPath, TableRendererModelFilter.class);
        String searchPath = viewPath;
        while (asynchModelFilters.isEmpty() && searchPath != null) {
            int i = searchPath.lastIndexOf(47);
            searchPath = i > 0 ? searchPath.substring(0, i) : null;
            asynchModelFilters = cp.lookup(searchPath, AsynchronousModelFilter.class);
        }
        ArrayList<Object> treeNodeModelsCompound = new ArrayList<Object>(13);
        treeNodeModelsCompound.add(ViewModelListener.joinLists(treeModels));
        treeNodeModelsCompound.add(ViewModelListener.joinLists(treeModelFilters));
        treeNodeModelsCompound.add(treeExpansionModels);
        treeNodeModelsCompound.add(ViewModelListener.joinLists(nodeModels));
        treeNodeModelsCompound.add(ViewModelListener.joinLists(nodeModelFilters));
        treeNodeModelsCompound.add(tableModels);
        treeNodeModelsCompound.add(tableModelFilters);
        treeNodeModelsCompound.add(nodeActionsProviders);
        treeNodeModelsCompound.add(nodeActionsProviderFilters);
        treeNodeModelsCompound.add(columnModels);
        treeNodeModelsCompound.add(mm);
        treeNodeModelsCompound.add(treeExpansionModelFilters);
        treeNodeModelsCompound.add(asynchModelFilters);
        treeNodeModelsCompound.add(tableRenderers);
        treeNodeModelsCompound.add(tableRendererFilters);
        Preferences viewPref = NbPreferences.forModule(ContextProvider.class).node(VIEW_PREFERENCES_NAME).node(viewName);
        MessageFormat treeFormat = ViewModelListener.createTreeDisplayFormat(viewPref, columnModels);
        if (treeFormat != null) {
            treeNodeModelsCompound.add(treeFormat);
        }
        Models.CompoundModel treeNodeModel = Models.createCompoundModel(treeNodeModelsCompound);
        return treeNodeModel;
    }

    private List findTreeColumn(List columnModels) {
        for (Object cmo : columnModels) {
            ColumnModel cm = (ColumnModel)cmo;
            if (cm.getType() != null) continue;
            return Collections.singletonList(cm);
        }
        return Collections.emptyList();
    }

    private static MessageFormat createTreeDisplayFormat(Preferences viewPreferences, List columnModels) {
        String displayFormat = viewPreferences.get(VIEW_TREE_DISPLAY_FORMAT, null);
        MessageFormat format = null;
        if (displayFormat != null) {
            for (int i = 0; i < columnModels.size(); ++i) {
                ColumnModel cm = (ColumnModel)columnModels.get(i);
                String name = cm.getID();
                displayFormat = displayFormat.replace("{" + name, "{" + Integer.toString(i));
            }
            try {
                format = new MessageFormat(displayFormat);
            }
            catch (IllegalArgumentException iaex) {
                Exceptions.printStackTrace((Throwable)iaex);
            }
        }
        return format;
    }

    private class ModelsChangeRefresher
    implements PropertyChangeListener,
    Runnable {
        private RequestProcessor.Task task;

        private ModelsChangeRefresher() {
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            if (this.task == null) {
                this.task = new RequestProcessor(ModelsChangeRefresher.class.getName(), 1).create((Runnable)this);
            }
            this.task.schedule(1);
        }

        @Override
        public void run() {
            ViewModelListener.this.refreshModel();
        }
    }

    private class ViewPreferenceChangeListener
    implements PreferenceChangeListener {
        private ViewPreferenceChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key = evt.getKey();
            if ("show_watches".equals(key) || "show_evaluator_result".equals(key)) {
                ViewModelListener.this.updateModel();
            }
            if (ViewModelListener.VIEW_TYPE.equals(key)) {
                ViewModelListener.this.updateModel();
            }
        }
    }
}

