/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.hyperlink;

import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.IssueFinderUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EditorHyperlinkProviderImpl
implements HyperlinkProviderExt,
LookupListener {
    private static final Logger LOG = Logger.getLogger(EditorHyperlinkProviderImpl.class.getName());
    private IssueFinder[] issueFinders;

    public EditorHyperlinkProviderImpl() {
        this.refreshIssueFinders();
    }

    public void resultChanged(LookupEvent ev) {
        this.refreshIssueFinders();
    }

    private void refreshIssueFinders() {
        Collection allInstances = IssueFinderUtils.getIssueFinders();
        IssueFinder[] newResult = new IssueFinder[allInstances.size()];
        allInstances.toArray(newResult);
        this.issueFinders = newResult;
    }

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getIssueSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        int[] nArray;
        IssueFinderUtils.HyperlinkSpanInfo spanInfo = this.getIssueSpan(doc, offset, type);
        if (spanInfo != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = spanInfo.startOffset;
            nArray = nArray2;
            nArray2[1] = spanInfo.endOffset;
        } else {
            nArray = null;
        }
        return nArray;
    }

    public void performClickAction(final Document doc, int offset, HyperlinkType type) {
        final String issueId = this.getIssueId(doc, offset, type);
        if (issueId == null) {
            return;
        }
        class IssueDisplayer
        implements Runnable {
            IssueDisplayer() {
            }

            @Override
            public void run() {
                FileObject fileObject;
                DataObject dobj = (DataObject)doc.getProperty("stream");
                File file = null;
                if (dobj != null && (fileObject = dobj.getPrimaryFile()) != null) {
                    file = FileUtil.toFile((FileObject)fileObject);
                }
                if (file == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "EditorHyperlinkProviderImpl - no file found for given document");
                    return;
                }
                BugtrackingUtil.openIssue(file, (String)issueId);
            }
        }
        RequestProcessor.getDefault().post((Runnable)new IssueDisplayer());
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        return NbBundle.getMessage(EditorHyperlinkProviderImpl.class, (String)"LBL_OpenIssue", (Object[])new Object[]{this.getIssueId(doc, offset, type)});
    }

    private String getIssueId(Document doc, int offset, HyperlinkType type) {
        IssueFinderUtils.HyperlinkSpanInfo spanInfo = this.getIssueSpan(doc, offset, type);
        if (spanInfo == null) {
            return null;
        }
        String issueId = null;
        try {
            int length;
            String text;
            int[] spans;
            if (spanInfo.startOffset <= offset && offset <= spanInfo.endOffset && (spans = spanInfo.issueFinder.getIssueSpans((CharSequence)(text = doc.getText(spanInfo.startOffset, length = spanInfo.endOffset - spanInfo.startOffset)))).length == 2) {
                issueId = spanInfo.issueFinder.getIssueId(text);
            }
        }
        catch (BadLocationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        if (issueId == null) {
            try {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "No issue found for {0}", doc.getText(spanInfo.startOffset, spanInfo.endOffset - spanInfo.startOffset));
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return issueId;
    }

    private IssueFinderUtils.HyperlinkSpanInfo getIssueSpan(Document doc, int offset, HyperlinkType type) {
        if (this.issueFinders.length == 0) {
            return null;
        }
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        List list = th.embeddedTokenSequences(offset, false);
        for (TokenSequence ts : list) {
            String name;
            String primCategory;
            if (ts == null) {
                return null;
            }
            ts.move(offset);
            if (!ts.moveNext()) {
                return null;
            }
            Token t = ts.token();
            TokenId tokenId = t.id();
            if (tokenId == null || (primCategory = tokenId.primaryCategory()) == null || (name = tokenId.name()) == null || primCategory.toUpperCase().indexOf("COMMENT") <= -1 && name.toUpperCase().indexOf("COMMENT") <= -1) continue;
            CharSequence text = t.text();
            for (IssueFinder issueFinder : this.issueFinders) {
                int[] span = issueFinder.getIssueSpans(text);
                for (int i = 1; i < span.length; i += 2) {
                    if (ts.offset() + span[i - 1] > offset || offset > ts.offset() + span[i]) continue;
                    return new IssueFinderUtils.HyperlinkSpanInfo(issueFinder, ts.offset() + span[i - 1], ts.offset() + span[i]);
                }
            }
        }
        return null;
    }
}

