/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.javahint;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.javahint.JavaHintDataPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.javahint.JavaHintLocationPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;

public class NewJavaHintIterator
extends BasicWizardIterator {
    private DataModel data;

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new JavaHintDataPanel(wiz, this.data), new JavaHintLocationPanel(wiz, this.data)};
    }

    public Set<?> instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return NewJavaHintIterator.getCreatedFiles(cmf, this.data.getProject());
    }

    static void generateFileChanges(DataModel model) {
        CreatedModifiedFiles cmf = new CreatedModifiedFiles(model.getProject());
        cmf.add(cmf.addModuleDependency("org.netbeans.modules.java.source"));
        cmf.add(cmf.addModuleDependency("org.netbeans.spi.java.hints"));
        cmf.add(cmf.addModuleDependency("org.netbeans.spi.editor.hints"));
        cmf.add(cmf.addModuleDependency("org.openide.util"));
        cmf.add(cmf.addModuleDependency("org.netbeans.libs.javacapi"));
        String className = model.getClassName();
        FileObject hintTemplate = CreatedModifiedFiles.getTemplate("javaHint.java");
        assert (hintTemplate != null);
        String hintPath = model.getDefaultPackagePath(className + ".java", false);
        HashMap<String, String> replaceTokens = new HashMap<String, String>();
        replaceTokens.put("CLASS_NAME", className);
        replaceTokens.put("PACKAGE_NAME", model.getPackageName());
        replaceTokens.put("GENERATE_FIX", model.isDoFix() ? "true" : null);
        replaceTokens.put("DISPLAY_NAME", model.getDisplayName());
        replaceTokens.put("DESCRIPTION", model.getDescription());
        replaceTokens.put("WARNING_MESSAGE", model.getWarningMessage());
        if (model.isDoFix()) {
            replaceTokens.put("FIX_MESSAGE", model.getFixText());
        }
        cmf.add(cmf.createFileWithSubstitutions(hintPath, hintTemplate, replaceTokens));
        String testPath = model.getDefaultPackagePath(className + "Test.java", false, true);
        FileObject testTemplate = CreatedModifiedFiles.getTemplate("javaHintTest.java");
        assert (testTemplate != null);
        cmf.add(cmf.createFileWithSubstitutions(testPath, testTemplate, replaceTokens));
        model.setCreatedModifiedFiles(cmf);
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private CreatedModifiedFiles files;
        private String className;
        private String displayName;
        private String descriptor;
        private String warningMessage;
        private boolean doFix;
        private String fixText;
        private String codeNameBase;

        DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.files;
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getDescription() {
            return this.descriptor;
        }

        public void setDescription(String descriptor) {
            this.descriptor = descriptor;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public CreatedModifiedFiles getFiles() {
            return this.files;
        }

        public void setFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        public boolean isDoFix() {
            return this.doFix;
        }

        public void setDoFix(boolean doFix) {
            this.doFix = doFix;
        }

        public String getFixText() {
            return this.fixText;
        }

        public void setFixText(String fixText) {
            this.fixText = fixText;
        }

        public String getWarningMessage() {
            return this.warningMessage;
        }

        public void setWarningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
        }

        @Override
        public String getPackageName() {
            String retValue = super.getPackageName();
            if (retValue == null) {
                retValue = this.getCodeNameBase();
                super.setPackageName(retValue);
            }
            return retValue;
        }

        private String getCodeNameBase() {
            if (this.codeNameBase == null) {
                NbModuleProvider mod = (NbModuleProvider)this.getProject().getLookup().lookup(NbModuleProvider.class);
                this.codeNameBase = mod.getCodeNameBase();
            }
            return this.codeNameBase;
        }
    }
}

