/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.netbeans.modules.apisupport.project.ui.wizard.common.WizardUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ShortcutEnterPanel
extends JPanel {
    private final Listener listener = new Listener();
    private final JButton bTab;
    private final JButton bClear;
    private JTextField tfShortcut;
    private final JLabel tfShortcutLabel = new JLabel();

    public ShortcutEnterPanel() {
        this.initComponents();
        this.bTab = new JButton();
        this.bClear = new JButton();
        ShortcutEnterPanel.loc(this.bTab, "CTL_Tab");
        ShortcutEnterPanel.loc(this.bClear, "CTL_Clear");
        this.tfShortcut.setFocusTraversalKeys(1, Collections.emptySet());
        this.tfShortcut.setFocusTraversalKeys(3, Collections.emptySet());
        this.tfShortcut.setFocusTraversalKeys(2, Collections.emptySet());
        this.tfShortcut.addKeyListener(this.listener);
    }

    private String getTitle() {
        return ShortcutEnterPanel.loc("LBL_AddShortcutTitle");
    }

    private Object[] getAdditionalOptions() {
        return new Object[]{this.bClear, this.bTab};
    }

    private String getShortcutText() {
        return this.tfShortcut.getText();
    }

    static KeyStroke[] showDialog() {
        Object[] buttons = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
        ShortcutEnterPanel sepPanel = new ShortcutEnterPanel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)sepPanel, sepPanel.getTitle(), true, buttons, DialogDescriptor.OK_OPTION, 0, null, (ActionListener)sepPanel.listener);
        descriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        descriptor.setAdditionalOptions(sepPanel.getAdditionalOptions());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        String shortcut = sepPanel.getShortcutText();
        if (descriptor.getValue() == DialogDescriptor.OK_OPTION && shortcut != null && shortcut.trim().length() > 0) {
            return WizardUtils.stringToKeyStrokes(shortcut);
        }
        return null;
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)ShortcutEnterPanel.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)ShortcutEnterPanel.loc(key));
        }
    }

    private static String loc(String key) {
        return NbBundle.getMessage(ShortcutEnterPanel.class, (String)key);
    }

    private void initComponents() {
        this.tfShortcut = new JTextField();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/action/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.tfShortcutLabel, (String)bundle.getString("LBL_Shortcut"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tfShortcutLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfShortcut, -1, 300, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfShortcutLabel).addComponent(this.tfShortcut, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class Listener
    implements ActionListener,
    KeyListener {
        private KeyStroke backspaceKS = KeyStroke.getKeyStroke(8, 0);
        private KeyStroke tabKS = KeyStroke.getKeyStroke(9, 0);
        private String key = "";

        private Listener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void keyPressed(KeyEvent e) {
            keyStroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
            if (e.getKeyCode() == 16) ** GOTO lbl-1000
            if (e.getKeyCode() == 17) ** GOTO lbl-1000
            if (e.getKeyCode() == 18) ** GOTO lbl-1000
            if (e.getKeyCode() == 157) ** GOTO lbl-1000
            if (e.getKeyCode() != 65406) {
                v0 = true;
            } else lbl-1000:
            // 5 sources

            {
                v0 = add = false;
            }
            if (keyStroke.equals(this.backspaceKS) && !this.key.equals("")) {
                i = this.key.lastIndexOf(32);
                this.key = i < 0 ? "" : this.key.substring(0, i);
                ShortcutEnterPanel.access$100(ShortcutEnterPanel.this).setText(this.key);
            } else {
                this.addKeyStroke(keyStroke, add);
            }
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ShortcutEnterPanel.this.bClear) {
                this.key = "";
                ShortcutEnterPanel.this.tfShortcut.setText(this.key);
                ShortcutEnterPanel.this.tfShortcut.requestFocusInWindow();
            } else if (e.getSource() == ShortcutEnterPanel.this.bTab) {
                this.addKeyStroke(this.tabKS, true);
                ShortcutEnterPanel.this.tfShortcut.requestFocusInWindow();
            }
        }

        private void addKeyStroke(KeyStroke keyStroke, boolean add) {
            String k = WizardUtils.keyStrokeToString(keyStroke);
            if (this.key.equals("")) {
                ShortcutEnterPanel.this.tfShortcut.setText(k);
                if (add) {
                    this.key = k;
                }
            } else {
                ShortcutEnterPanel.this.tfShortcut.setText(this.key + " " + k);
                if (add) {
                    this.key = this.key + " " + k;
                }
            }
        }
    }
}

