/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.richfaces;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.JsfComponentUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.richfaces.Richfaces4Customizer;
import org.netbeans.modules.web.jsf.richfaces.ui.Richfaces4CustomizerPanelVisual;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentImplementation;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class Richfaces4Implementation
implements JsfComponentImplementation {
    public static final Logger LOGGER = Logger.getLogger(Richfaces4Implementation.class.getName());
    private Richfaces4Customizer customizer;
    private static final String RICHFACES_NAME = "RichFaces";
    private static final String richfacesUiPom = "https://repository.jboss.org/nexus/content/groups/public-jboss/org/richfaces/ui/richfaces-components-ui/4.2.0.Final/richfaces-components-ui-4.2.0.Final.pom";
    private static final String richfacesCorePom = "https://repository.jboss.org/nexus/content/groups/public-jboss/org/richfaces/core/richfaces-core-impl/4.2.0.Final/richfaces-core-impl-4.2.0.Final.pom";
    public static final Set<String> RF_LIBRARIES = new HashSet<String>();
    public static final Map<String, String> RF_DEPENDENCIES = new HashMap<String, String>();
    public static final String PREF_RICHFACES_NODE = "richfaces";
    public static final String PREF_RICHFACES_LIBRARY = "base-library";

    public String getName() {
        return RICHFACES_NAME;
    }

    public String getDescription() {
        return NbBundle.getMessage(Richfaces4Implementation.class, (String)"LBL_RichFaces_Description");
    }

    public void remove(WebModule webModule) {
        try {
            List<Library> list = Richfaces4Customizer.getRichfacesLibraries();
            ProjectClassPathModifier.removeLibraries((Library[])list.toArray(new Library[list.size()]), (FileObject)webModule.getJavaSources()[0], (String)"classpath/compile");
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", iOException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", unsupportedOperationException);
        }
    }

    public Set<FileObject> extend(WebModule webModule, JsfComponentCustomizer jsfComponentCustomizer) {
        try {
            FileObject[] fileObjectArray;
            ArrayList<Library> arrayList = new ArrayList<Library>(1);
            Library library = null;
            if (jsfComponentCustomizer != null) {
                fileObjectArray = (Richfaces4CustomizerPanelVisual)jsfComponentCustomizer.getComponent();
                library = LibraryManager.getDefault().getLibrary(fileObjectArray.getRichFacesLibrary());
            }
            if (library == null) {
                fileObjectArray = Richfaces4Implementation.getRichfacesPreferences();
                library = LibraryManager.getDefault().getLibrary(fileObjectArray.get(PREF_RICHFACES_LIBRARY, ""));
            }
            if (library == null) {
                library = Richfaces4Customizer.getRichfacesLibraries().get(0);
            }
            if (library != null) {
                Object object;
                fileObjectArray = webModule.getJavaSources();
                Project project = FileOwnerQuery.getOwner((FileObject)webModule.getDocumentBase());
                AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
                if (antArtifactProvider == null) {
                    try {
                        object = Arrays.asList(new URI(richfacesUiPom), new URI(richfacesCorePom));
                        library = JsfComponentUtils.enhanceLibraryWithPomContent((Library)library, (List)object);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        LOGGER.log(Level.SEVERE, null, uRISyntaxException);
                    }
                }
                arrayList.add(library);
                ProjectClassPathModifier.addLibraries((Library[])arrayList.toArray(new Library[1]), (FileObject)fileObjectArray[0], (String)"classpath/compile");
                object = Richfaces4Implementation.generateWelcomePage(webModule);
                return Collections.singleton(object);
            }
            LOGGER.log(Level.SEVERE, "No RichFaces library was found.");
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", iOException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", unsupportedOperationException);
        }
        return Collections.emptySet();
    }

    private static FileObject generateWelcomePage(WebModule webModule) throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)"Templates/Other/welcomeRichfaces.xhtml");
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        DataObject dataObject2 = dataObject.createFromTemplate(DataFolder.findFolder((FileObject)webModule.getDocumentBase()), "welcomeRichfaces");
        JsfComponentUtils.reformat((DataObject)dataObject2);
        Richfaces4Implementation.updateIndexPage(webModule);
        return dataObject2.getPrimaryFile();
    }

    private static void updateIndexPage(WebModule webModule) throws DataObjectNotFoundException {
        FileObject fileObject = webModule.getDocumentBase().getFileObject("index.xhtml");
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        JsfComponentUtils.enhanceFileBody((DataObject)dataObject, (String)"</h:body>", (String)"<br />\n<h:link outcome=\"welcomeRichfaces\" value=\"Richfaces welcome page\" />");
        if (fileObject.isValid() && fileObject.canWrite()) {
            JsfComponentUtils.reformat((DataObject)dataObject);
        }
    }

    public Set<JSFVersion> getJsfVersion() {
        return EnumSet.of(JSFVersion.JSF_2_0, JSFVersion.JSF_2_1);
    }

    public boolean isInWebModule(WebModule webModule) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        for (String string : RF_LIBRARIES) {
            if (classPath.findResource(string.replace('.', '/') + ".class") != null) continue;
            return false;
        }
        return true;
    }

    public JsfComponentCustomizer createJsfComponentCustomizer(WebModule webModule) {
        if (this.customizer == null) {
            this.customizer = new Richfaces4Customizer();
        }
        return this.customizer;
    }

    public static Preferences getRichfacesPreferences() {
        return NbPreferences.forModule(Richfaces4Implementation.class).node(PREF_RICHFACES_NODE);
    }

    static {
        RF_LIBRARIES.add("org.richfaces.application.Module");
        RF_LIBRARIES.add("org.richfaces.application.ServiceLoader");
        RF_LIBRARIES.add("org.richfaces.el.ValueDescriptor");
        RF_LIBRARIES.add("org.richfaces.el.ValueReference");
        RF_DEPENDENCIES.put("com.google.common.base.Functions", "guava.jar");
        RF_DEPENDENCIES.put("org.w3c.css.sac.Parser", "sac.jar");
        RF_DEPENDENCIES.put("com.steadystate.css.parser.ParseException", "cssparser.jar");
    }
}

