/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.owsm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PoliciesVisualPanel
extends JPanel {
    private static final long serialVersionUID = -1918005169365122961L;
    static final String OWSM_SECURITY_POLICY = "weblogic.wsee.jws.jaxws.owsm.SecurityPolicy";
    static final String OWSM_SECURITY_POLICIES = "weblogic.wsee.jws.jaxws.owsm.SecurityPolicies";
    static final String VALUE = "value";
    static final String URI = "uri";
    static final RequestProcessor JAVA_PROCESSOR = new RequestProcessor(PoliciesVisualPanel.class);
    private JScrollPane jScrollPane1;
    private JLabel myLabel;
    private JList myPoliciesList;
    private PoliciesListCellRenderer myRenderer;
    private FileObject myWsJavaFile;
    private String wsFqn;

    public PoliciesVisualPanel(final List<String> policyIds, FileObject javaFile) {
        this.myWsJavaFile = javaFile;
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)javaFile);
        if (javaSource == null) {
            this.showLabel(NbBundle.getMessage(PoliciesVisualPanel.class, (String)"ERR_NoWSAccess"));
            return;
        }
        this.showLabel(NbBundle.getMessage(PoliciesVisualPanel.class, (String)"LBL_Wait"));
        JAVA_PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                final Set chosenIds = PoliciesVisualPanel.this.getWsPolicyIds(javaSource);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PoliciesVisualPanel.this.initUI(policyIds, chosenIds);
                    }
                });
            }
        });
    }

    List<String> getPolicyIds() {
        return this.myRenderer.getPolicyIds();
    }

    String getWsFqn() {
        return this.wsFqn;
    }

    private void showLabel(String message) {
        this.setLayout(new FlowLayout(1){
            private static final long serialVersionUID = -1572219951957864402L;

            @Override
            public void layoutContainer(Container target) {
                super.layoutContainer(target);
                Component[] components = target.getComponents();
                double height = target.getSize().getHeight() / 2.0;
                for (Component component : components) {
                    Point location = component.getLocation();
                    component.setLocation((int)location.getX(), (int)height);
                }
            }
        });
        this.add(new JLabel(message));
    }

    private Set<String> getWsPolicyIds(JavaSource wsJava) {
        final HashSet<String> result = new HashSet<String>();
        try {
            wsJava.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    List topLevelElements = controller.getTopLevelElements();
                    if (topLevelElements.size() == 1) {
                        PoliciesVisualPanel.this.isWebService((TypeElement)topLevelElements.get(0), controller, result);
                        PoliciesVisualPanel.this.wsFqn = ((TypeElement)topLevelElements.get(0)).getQualifiedName().toString();
                        return;
                    }
                    for (TypeElement typeElement : topLevelElements) {
                        Set<Modifier> modifiers = typeElement.getModifiers();
                        if (!modifiers.contains((Object)Modifier.PUBLIC) || !PoliciesVisualPanel.this.isWebService(typeElement, controller, result)) continue;
                        PoliciesVisualPanel.this.wsFqn = typeElement.getQualifiedName().toString();
                        break;
                    }
                }
            }, true);
        }
        catch (IOException e) {
            Logger.getLogger(PoliciesVisualPanel.class.getName()).log(Level.INFO, null, e);
        }
        return result;
    }

    private boolean isWebService(TypeElement typeElement, CompilationController controller, Set<String> result) {
        boolean isWebService = false;
        List<? extends AnnotationMirror> allAnnotationMirrors = controller.getElements().getAllAnnotationMirrors(typeElement);
        for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (!(annotationElement instanceof TypeElement)) continue;
            String fqn = null;
            if (annotationElement instanceof TypeElement) {
                fqn = ((TypeElement)annotationElement).getQualifiedName().toString();
            }
            if ("javax.jws.WebService".equals(fqn)) {
                isWebService = true;
                continue;
            }
            if (OWSM_SECURITY_POLICY.equals(fqn)) {
                this.addId(result, annotationMirror);
                continue;
            }
            if (!OWSM_SECURITY_POLICIES.equals(fqn)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                this.handleList(result, entry);
            }
        }
        return isWebService;
    }

    private void handleList(Set<String> result, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry) {
        Object policies;
        ExecutableElement method = entry.getKey();
        AnnotationValue value = entry.getValue();
        if (VALUE.contentEquals(method.getSimpleName()) && (policies = value.getValue()) instanceof List) {
            List policiesList = (List)policies;
            for (Object policy : policiesList) {
                String fqn;
                AnnotationMirror annotation;
                Element annotationElement;
                if (!(policy instanceof AnnotationMirror) || !((annotationElement = (annotation = (AnnotationMirror)policy).getAnnotationType().asElement()) instanceof TypeElement) || !(fqn = ((TypeElement)annotationElement).getQualifiedName().toString()).equals(OWSM_SECURITY_POLICY)) continue;
                this.addId(result, (AnnotationMirror)policy);
            }
        }
    }

    private void addId(Set<String> result, AnnotationMirror annotationMirror) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement method = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!URI.contentEquals(method.getSimpleName()) || value.getValue() == null) continue;
            result.add(value.getValue().toString());
        }
    }

    private void initUI(List<String> policyIds, Set<String> selectedIds) {
        this.removeAll();
        this.initComponents();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(policyIds.toArray(new String[policyIds.size()]));
        this.myPoliciesList.setModel(model);
        this.myRenderer = new PoliciesListCellRenderer(selectedIds);
        this.myPoliciesList.setCellRenderer(this.myRenderer);
        this.myPoliciesList.setSelectionMode(0);
        this.myPoliciesList.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = PoliciesVisualPanel.this.myPoliciesList.getSelectedIndex();
                ListUI listUi = PoliciesVisualPanel.this.myPoliciesList.getUI();
                Rectangle bounds = listUi.getCellBounds(PoliciesVisualPanel.this.myPoliciesList, index, index + 1);
                Point listLocatoin = PoliciesVisualPanel.this.myPoliciesList.getLocationOnScreen();
                Point location = bounds.getLocation();
                Point clickPoint = e.getLocationOnScreen();
                PoliciesVisualPanel.this.myRenderer.click(clickPoint.getX() - listLocatoin.getX() - location.getX(), clickPoint.getY() - listLocatoin.getY() - location.getY(), index);
                PoliciesVisualPanel.this.myPoliciesList.repaint(bounds);
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.myPoliciesList = new JList();
        this.myLabel = new JLabel();
        this.jScrollPane1.setViewportView(this.myPoliciesList);
        this.myLabel.setLabelFor(this.myPoliciesList);
        Mnemonics.setLocalizedText((JLabel)this.myLabel, (String)NbBundle.getMessage(PoliciesVisualPanel.class, (String)"LBL_Policies"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 380, Short.MAX_VALUE).addComponent(this.myLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.myLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 258, Short.MAX_VALUE).addContainerGap()));
    }

    private class PoliciesListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private JCheckBox myCheckBox;
        private JLabel myLbl;
        private Color mySelectedBckgrnd;
        private Rectangle myLocation;
        private boolean[] mySelected;

        PoliciesListCellRenderer(Set<String> selected) {
            JList<Object> list = new JList<Object>(new Object[]{""});
            Component comp = new DefaultListCellRenderer().getListCellRendererComponent(list, "", 0, true, true);
            this.mySelectedBckgrnd = comp.getBackground();
            this.setOpaque(true);
            this.setLayout(new FlowLayout(0));
            this.myCheckBox = new JCheckBox();
            this.myCheckBox.setBackground(Color.WHITE);
            this.add(this.myCheckBox);
            this.myLbl = new JLabel();
            this.myLbl.setBackground(Color.WHITE);
            this.add(this.myLbl);
            this.setBackground(Color.WHITE);
            this.mySelected = new boolean[PoliciesVisualPanel.this.myPoliciesList.getModel().getSize()];
            for (int i = 0; i < this.mySelected.length; ++i) {
                String id = PoliciesVisualPanel.this.myPoliciesList.getModel().getElementAt(i).toString();
                this.mySelected[i] = selected.contains(id);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.myLbl.setText(value.toString());
            if (isSelected) {
                this.setBackground(this.mySelectedBckgrnd);
                this.myLbl.setBackground(this.mySelectedBckgrnd);
                this.myCheckBox.setBackground(this.mySelectedBckgrnd);
            } else {
                this.setBackground(Color.WHITE);
                this.myLbl.setBackground(Color.WHITE);
                this.myCheckBox.setBackground(Color.WHITE);
            }
            this.myCheckBox.setSelected(this.mySelected[index]);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.myLocation == null) {
                this.myLocation = this.myCheckBox.getBounds();
            }
        }

        List<String> getPolicyIds() {
            ArrayList<String> result = new ArrayList<String>(PoliciesVisualPanel.this.myPoliciesList.getModel().getSize());
            for (int i = 0; i < this.mySelected.length; ++i) {
                if (!this.mySelected[i]) continue;
                result.add(PoliciesVisualPanel.this.myPoliciesList.getModel().getElementAt(i).toString());
            }
            return result;
        }

        void click(double x, double y, int index) {
            if (this.myLocation.contains(new Point((int)x, (int)y))) {
                this.mySelected[index] = !this.mySelected[index];
            }
        }
    }
}

