/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.owsm;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javaee.specs.support.api.JaxWsPoliciesSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.core.jaxws.policies.JaxWsPoliciesCodeGenerator;
import org.netbeans.modules.websvc.owsm.OWSMPolicyCodeGenerator;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class OWSMPoliciesCodeGenerator
implements JaxWsPoliciesCodeGenerator {
    private static final String ORACLE = "oracle/";
    private static final String SECURITY_POLICY_FEATURE = "weblogic.wsee.jws.jaxws.owsm.SecurityPolicyFeature";
    private static final String SECURITY_FEATURE_INIT = "private static final SecurityPolicyFeature[] securityFeature = new SecurityPolicyFeature[] { new SecurityPolicyFeature(\"";
    private static Map<String, OWSMPolicyCodeGenerator> GENERATORS = new HashMap<String, OWSMPolicyCodeGenerator>();

    public Collection<String> getRequiredClasses(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(SECURITY_POLICY_FEATURE);
        linkedList.add("com.sun.xml.ws.developer.WSBindingProvider");
        linkedList.add("javax.xml.ws.BindingProvider");
        linkedList.add("javax.xml.ws.WebServiceFeature");
        linkedList.add(Map.class.getCanonicalName());
        OWSMPolicyCodeGenerator oWSMPolicyCodeGenerator = GENERATORS.get(string);
        if (oWSMPolicyCodeGenerator != null) {
            oWSMPolicyCodeGenerator.addRequiredClassesFqns(linkedList);
        }
        return linkedList;
    }

    public String generatePolicyAccessCode(Set<String> set, Client client, StringBuilder stringBuilder) {
        if (set.isEmpty()) {
            return "";
        }
        HashMap<String, OWSMPolicyCodeGenerator> hashMap = new HashMap<String, OWSMPolicyCodeGenerator>(GENERATORS);
        Set set2 = hashMap.keySet();
        set2.retainAll(set);
        if (set2.isEmpty()) {
            String string = set.iterator().next();
            this.generateDefaultCode(string, client, stringBuilder);
            return string;
        }
        String string = null;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string2 = (String)entry.getKey();
            OWSMPolicyCodeGenerator oWSMPolicyCodeGenerator = (OWSMPolicyCodeGenerator)entry.getValue();
            if (string == null) {
                string = string2;
                oWSMPolicyCodeGenerator.generatePolicyAccessCode(stringBuilder, client);
                continue;
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            oWSMPolicyCodeGenerator.generatePolicyAccessCode(stringBuilder2, client);
            stringBuilder.append("/* ");
            stringBuilder.append(stringBuilder2.toString());
            stringBuilder.append(" */");
        }
        return string;
    }

    public boolean isApplicable(Set<String> set, J2eePlatform j2eePlatform, FileObject fileObject) {
        boolean bl;
        JaxWsPoliciesSupport jaxWsPoliciesSupport = JaxWsPoliciesSupport.getInstance((J2eePlatform)j2eePlatform);
        if (jaxWsPoliciesSupport == null) {
            return false;
        }
        String string = jaxWsPoliciesSupport.getId();
        boolean bl2 = bl = string != null && ORACLE.startsWith(string) && string.length() == ORACLE.length() - 1;
        if (bl) {
            set.retainAll(GENERATORS.keySet());
        }
        return bl;
    }

    public Tree createSecurityFeatureType(WorkingCopy workingCopy, TreeMaker treeMaker) {
        return treeMaker.ArrayType(this.createSecurityFeatureComponentType(workingCopy, treeMaker));
    }

    private Tree createSecurityFeatureComponentType(WorkingCopy workingCopy, TreeMaker treeMaker) {
        TypeElement typeElement = workingCopy.getElements().getTypeElement(SECURITY_POLICY_FEATURE);
        Tree tree = typeElement != null ? treeMaker.Type(typeElement.asType()) : treeMaker.Identifier((CharSequence)SECURITY_POLICY_FEATURE);
        return tree;
    }

    private void generateDefaultCode(String string, Client client, StringBuilder stringBuilder) {
        stringBuilder.append("WSBindingProvider wsbp = (WSBindingProvider)port;\n");
        stringBuilder.append("Map<String, Object> requestContext = wsbp.getRequestContext();\n");
        stringBuilder.append("// Override the endpoint - useful when switching target environments without regenerating the jax-ws client\n");
        stringBuilder.append("requestContext.put(WSBindingProvider.ENDPOINT_ADDRESS_PROPERTY, \"");
        stringBuilder.append(client.getWsdlUrl());
        stringBuilder.append("\");\n");
        stringBuilder.append("// Use request context to initialize poliy access \n");
        stringBuilder.append("//requestContext.put( some_property_key,  some_property_value );\n");
    }

    public ExpressionTree createSecurityFeatureInitializer(WorkingCopy workingCopy, TreeMaker treeMaker, String string) {
        String string2 = string;
        OWSMPolicyCodeGenerator oWSMPolicyCodeGenerator = GENERATORS.get(string);
        if (oWSMPolicyCodeGenerator != null) {
            string2 = oWSMPolicyCodeGenerator.getClientId();
        }
        if (!string2.startsWith(ORACLE)) {
            string2 = ORACLE + string2;
        }
        TypeElement typeElement = workingCopy.getElements().getTypeElement(SECURITY_POLICY_FEATURE);
        NewClassTree newClassTree = treeMaker.NewClass(null, Collections.emptyList(), (ExpressionTree)(typeElement != null ? treeMaker.Identifier((Element)typeElement) : treeMaker.Identifier((CharSequence)SECURITY_POLICY_FEATURE)), Collections.singletonList(treeMaker.Literal((Object)string2)), null);
        return treeMaker.NewArray(this.createSecurityFeatureComponentType(workingCopy, treeMaker), Collections.emptyList(), Collections.singletonList(newClassTree));
    }

    public void modifySecurityFeatureAttribute(VariableTree variableTree, WorkingCopy workingCopy, TreeMaker treeMaker, String string, Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        HashSet<String> hashSet = new HashSet<String>(set);
        hashSet.remove(string);
        HashMap<String, OWSMPolicyCodeGenerator> hashMap = new HashMap<String, OWSMPolicyCodeGenerator>(GENERATORS);
        Set set2 = hashMap.keySet();
        set2.retainAll(hashSet);
        for (Object object : hashMap.values()) {
            linkedList.add(object.getClientId());
        }
        OWSMPolicyCodeGenerator oWSMPolicyCodeGenerator = GENERATORS.get(string);
        if (oWSMPolicyCodeGenerator != null) {
            for (String string2 : oWSMPolicyCodeGenerator.getRelatedPolicyIds()) {
                linkedList.add(string2);
            }
        }
        this.addComments(variableTree, treeMaker, linkedList);
    }

    private void addComments(VariableTree variableTree, TreeMaker treeMaker, Collection<String> collection) {
        for (String string : collection) {
            if (!string.startsWith(ORACLE)) {
                string = ORACLE + string;
            }
            StringBuilder stringBuilder = new StringBuilder(SECURITY_FEATURE_INIT);
            stringBuilder.append(string);
            stringBuilder.append("\")};\n");
            treeMaker.addComment((Tree)variableTree, Comment.create((Comment.Style)Comment.Style.LINE, (String)stringBuilder.toString()), true);
        }
    }

    private static void initGenerators() {
        Collection collection = Lookup.getDefault().lookupAll(OWSMPolicyCodeGenerator.class);
        for (OWSMPolicyCodeGenerator oWSMPolicyCodeGenerator : collection) {
            GENERATORS.put(oWSMPolicyCodeGenerator.getId(), oWSMPolicyCodeGenerator);
        }
    }

    static {
        OWSMPoliciesCodeGenerator.initGenerators();
    }
}

