/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi.customizer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.osgi.customizer.InstructionsConverter;
import org.netbeans.modules.maven.spi.customizer.SelectedItemsTablePersister;

public class FelixExportPersister
implements SelectedItemsTablePersister {
    private final ModelHandle2 handle;
    private final Project project;
    private ModelOperation<POMModel> operation;

    public FelixExportPersister(Project project, ModelHandle2 handle) {
        this.project = project;
        this.handle = handle;
    }

    public SortedMap<String, Boolean> read() {
        String[] exports = PluginPropertyUtils.getPluginPropertyList((Project)this.project, (String)"org.apache.felix", (String)"maven-bundle-plugin", (String)"instructions", (String)"Export-Package", (String)"manifest");
        String exportInstruction = null;
        if (exports != null && exports.length == 1) {
            exportInstruction = exports[0];
        }
        String[] privates = PluginPropertyUtils.getPluginPropertyList((Project)this.project, (String)"org.apache.felix", (String)"maven-bundle-plugin", (String)"instructions", (String)"Private-Package", (String)"manifest");
        String privateInstruction = null;
        if (privates != null && privates.length == 1) {
            privateInstruction = privates[0];
        }
        HashMap<Integer, String> instructions = new HashMap<Integer, String>(2);
        instructions.put(InstructionsConverter.EXPORT_PACKAGE, exportInstruction);
        instructions.put(InstructionsConverter.PRIVATE_PACKAGE, privateInstruction);
        return InstructionsConverter.computeExportList(instructions, this.project);
    }

    public void write(SortedMap<String, Boolean> selItems) {
        if (this.operation != null) {
            this.handle.removePOMModification(this.operation);
        }
        final Map<Integer, String> exportIns = InstructionsConverter.computeExportInstructions(selItems, this.project);
        this.operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel pomModel) {
                Build build = pomModel.getProject().getBuild();
                Plugin felixPlugin = null;
                if (build != null) {
                    felixPlugin = build.findPluginById("org.apache.felix", "maven-bundle-plugin");
                } else {
                    build = pomModel.getFactory().createBuild();
                    pomModel.getProject().setBuild(build);
                }
                Configuration config = null;
                if (felixPlugin != null) {
                    config = felixPlugin.getConfiguration();
                } else {
                    felixPlugin = pomModel.getFactory().createPlugin();
                    felixPlugin.setGroupId("org.apache.felix");
                    felixPlugin.setArtifactId("maven-bundle-plugin");
                    felixPlugin.setExtensions(Boolean.TRUE);
                    build.addPlugin(felixPlugin);
                }
                if (config == null) {
                    config = pomModel.getFactory().createConfiguration();
                    felixPlugin.setConfiguration(config);
                }
                POMExtensibilityElement instructionsEl = null;
                List confEls = config.getConfigurationElements();
                for (POMExtensibilityElement el : confEls) {
                    if (!"instructions".equals(el.getQName().getLocalPart())) continue;
                    instructionsEl = el;
                    break;
                }
                if (instructionsEl == null) {
                    instructionsEl = pomModel.getFactory().createPOMExtensibilityElement(new QName("instructions"));
                    config.addExtensibilityElement(instructionsEl);
                }
                POMExtensibilityElement exportEl = ModelUtils.getOrCreateChild(instructionsEl, (String)"Export-Package", (POMModel)pomModel);
                POMExtensibilityElement privateEl = ModelUtils.getOrCreateChild((POMComponent)instructionsEl, (String)"Private-Package", (POMModel)pomModel);
                exportEl.setElementText((String)exportIns.get(InstructionsConverter.EXPORT_PACKAGE));
                privateEl.setElementText((String)exportIns.get(InstructionsConverter.PRIVATE_PACKAGE));
            }
        };
        this.handle.addPOMModification(this.operation);
    }
}

