/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.support;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesFactory;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public final class PersistenceScopesHelper {
    private static final Logger LOG = Logger.getLogger(PersistenceScopesHelper.class.getName());
    private final PersistenceScopes persistenceScopes = PersistenceScopesFactory.createPersistenceScopes(new PersistenceScopesImpl());
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private final FileChangeListener fileChangeListener = new FileListener();
    private PersistenceScope persistenceScope;
    private File persistenceXml;
    private boolean persistenceExists;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePersistenceScope(PersistenceScope newPersistenceScope, File newPersistenceXml) {
        boolean newPersistenceExists;
        PersistenceScope oldPersistenceScope;
        boolean oldPersistenceExists;
        if (newPersistenceScope == null && newPersistenceXml != null) {
            throw new IllegalArgumentException("The persistenceScope parameter cannot be null when newPersistenceXml is non-null");
        }
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            oldPersistenceExists = this.persistenceExists;
            oldPersistenceScope = this.persistenceScope;
            LOG.fine("changePersistenceScope: newPersistenceXml=" + newPersistenceXml);
            if (this.persistenceXml != null) {
                FileUtil.removeFileChangeListener((FileChangeListener)this.fileChangeListener, (File)this.persistenceXml);
            }
            if (newPersistenceXml != null) {
                this.persistenceXml = newPersistenceXml;
                FileUtil.addFileChangeListener((FileChangeListener)this.fileChangeListener, (File)this.persistenceXml);
            } else {
                this.persistenceXml = null;
            }
            this.persistenceScope = newPersistenceScope;
            this.persistenceXml = newPersistenceXml;
            this.change();
            newPersistenceExists = this.persistenceExists;
            LOG.fine("changePersistenceScope: oldPersistenceExists=" + oldPersistenceExists + ", newPersistenceExists=" + newPersistenceExists);
        }
        if (oldPersistenceExists != newPersistenceExists || oldPersistenceScope != newPersistenceScope && newPersistenceExists) {
            LOG.fine("changePersistenceScope: firing PROP_PERSISTENCE_SCOPES change");
            this.propChangeSupport.firePropertyChange("persistenceScopes", null, null);
        }
    }

    public PersistenceScopes getPersistenceScopes() {
        return this.persistenceScopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change() {
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            this.persistenceExists = false;
            if (this.persistenceXml != null) {
                this.persistenceExists = FileUtil.toFileObject((File)this.persistenceXml) != null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileEvent() {
        boolean newPersistenceExists;
        boolean oldPersistenceExists;
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            oldPersistenceExists = this.persistenceExists;
            this.change();
            newPersistenceExists = this.persistenceExists;
        }
        LOG.fine("fileEvent: oldPersistenceExists=" + oldPersistenceExists + ", newPersistenceExists=" + newPersistenceExists);
        if (oldPersistenceExists != newPersistenceExists) {
            LOG.fine("fileEvent: firing PROP_PERSISTENCE_SCOPES change");
            this.propChangeSupport.firePropertyChange("persistenceScopes", oldPersistenceExists, newPersistenceExists);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceScope[] getPersistenceScopeList() {
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            if (this.persistenceExists) {
                return new PersistenceScope[]{this.persistenceScope};
            }
            return new PersistenceScope[0];
        }
    }

    private void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    private void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    private class FileListener
    implements FileChangeListener {
        private FileListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            LOG.fine("fileCreated: " + fe.getFile().getPath());
            PersistenceScopesHelper.this.fileEvent();
        }

        public void fileChanged(FileEvent fe) {
            LOG.fine("fileModified: " + fe.getFile().getPath());
        }

        public void fileDeleted(FileEvent fe) {
            LOG.fine("fileDeleted: " + fe.getFile().getPath());
            PersistenceScopesHelper.this.fileEvent();
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private class PersistenceScopesImpl
    implements PersistenceScopesImplementation {
        private PersistenceScopesImpl() {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            PersistenceScopesHelper.this.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            PersistenceScopesHelper.this.removePropertyChangeListener(listener);
        }

        @Override
        public PersistenceScope[] getPersistenceScopes() {
            return PersistenceScopesHelper.this.getPersistenceScopeList();
        }
    }
}

