/*
 * Decompiled with CFR 0.152.
 */
package br.com.autbank.criptografia;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

class XMLDOMDocument {
    private static final int NAOFORMATA = 0;
    private static final int FORMATAECOM = 1;
    private static final int FORMATAECOMMENORMAIOR = 2;
    private Document xmldom;
    private boolean verificado = false;

    public XMLDOMDocument(String file, int a) throws Exception {
        try {
            SAXBuilder builder = new SAXBuilder();
            this.xmldom = builder.build(file);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public XMLDOMDocument(String xmlin) throws Exception {
        this(xmlin, false);
    }

    public XMLDOMDocument(String xmlin, boolean verifica) throws Exception {
        if (xmlin == null || xmlin.trim().equals("")) {
            throw new Exception("XML nulo ou branco.");
        }
        String msg = "";
        SAXBuilder builder = new SAXBuilder();
        xmlin = this.formata(xmlin);
        try {
            this.xmldom = builder.build((Reader)new StringReader(xmlin));
        }
        catch (JDOMException e) {
            throw new Exception("Xml inv\u00e1lido. " + msg + ". " + e.getMessage() + " " + (xmlin.length() > 1000 ? xmlin.substring(0, 1000) + " ..." : xmlin));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new Exception("Xml inv\u00e1lido. " + msg + ". " + e.getClass().toString() + " " + e.getMessage() + " " + (xmlin.length() > 1000 ? xmlin.substring(0, 1000) + " ..." : xmlin));
        }
    }

    private String formata(String string) {
        String str = XMLDOMDocument.formata(string, 1);
        return str;
    }

    private static String formata(String valor, int tipo) {
        if (valor == null || tipo == 0) {
            return valor;
        }
        StringBuffer rs = new StringBuffer("");
        for (int i = 0; i < valor.length(); ++i) {
            if (valor.charAt(i) == '&') {
                String frag = valor.substring(i, i + 6);
                if (frag.equals("&apos;")) {
                    rs.append("&apos;");
                    i += 5;
                    continue;
                }
                if (frag.equals("&quot;")) {
                    rs.append("&quot;");
                    i += 5;
                    continue;
                }
                if ((frag = frag.substring(0, 5)).equals("&amp;")) {
                    rs.append("&amp;");
                    i += 4;
                    continue;
                }
                if ((frag = frag.substring(0, 4)).equals("&gt;")) {
                    rs.append("&gt;");
                    i += 3;
                    continue;
                }
                if (frag.equals("&lt;")) {
                    rs.append("&lt;");
                    i += 3;
                    continue;
                }
                rs.append("&amp;");
                continue;
            }
            if (valor.charAt(i) == '>' && tipo == 2) {
                rs.append("&gt;");
                continue;
            }
            if (valor.charAt(i) == '<' && tipo == 2) {
                rs.append("&lt;");
                continue;
            }
            rs.append(valor.charAt(i));
        }
        return rs.toString();
    }

    public XMLDOMDocument addRoot(String root) throws Exception {
        StringBuffer str = new StringBuffer("<");
        str.append(root);
        str.append(">");
        str.append(this.toString());
        str.append("</");
        str.append(root);
        str.append(">");
        return new XMLDOMDocument(str.toString());
    }

    public String getTagName() {
        return this.getRootName();
    }

    public String getRootName() {
        return this.xmldom.getRootElement().getName();
    }

    public String toString() {
        return this.formata(XMLDOMDocument.buscaXML(this.xmldom.getRootElement()));
    }

    public String selectSingleNode(String tag) {
        return this.buscaTag(tag);
    }

    public String selectDocumentElement() {
        return this.selectDocumentElement(this.getRootName());
    }

    public String selectDocumentElement(String tag) {
        return this.buscaXML(tag, false);
    }

    public XMLDOMDocument[] selectNodes(String tag) throws Exception {
        Vector v = new Vector();
        XMLDOMDocument.buscaNodes(this.xmldom.getRootElement(), tag, v);
        XMLDOMDocument[] r = new XMLDOMDocument[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            Object o = v.get(i);
            r[i] = new XMLDOMDocument(XMLDOMDocument.buscaXML((Element)o));
        }
        return r;
    }

    private static void buscaNodes(Element element, String tag, Vector v) {
        if (element == null) {
            return;
        }
        List content = element.getChildren();
        Iterator iterator = content.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof Element)) continue;
            if (tag.equals(((Element)o).getName())) {
                v.add(o);
            }
            XMLDOMDocument.buscaNodes((Element)o, tag, v);
        }
    }

    public XMLDOMDocument[] selectNodesStartsWith(String tag) throws Exception {
        Vector v = new Vector();
        XMLDOMDocument.buscaNodesComecamCom(this.xmldom.getRootElement(), tag, v);
        XMLDOMDocument[] r = new XMLDOMDocument[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            Object o = v.get(i);
            r[i] = new XMLDOMDocument(XMLDOMDocument.buscaXML((Element)o));
        }
        return r;
    }

    private static void buscaNodesComecamCom(Element element, String tag, Vector v) {
        if (element == null) {
            return;
        }
        List content = element.getChildren();
        Iterator iterator = content.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof Element)) continue;
            if (((Element)o).getName().startsWith(tag)) {
                v.add(o);
            }
            XMLDOMDocument.buscaNodesComecamCom((Element)o, tag, v);
        }
    }

    public String buscaTag(String tag) {
        return this.buscaTag(tag, false);
    }

    public String buscaTag(String tag, boolean tratado) {
        String r = XMLDOMDocument.buscaTag(this.xmldom.getRootElement(), tag, tratado);
        return r == null ? "" : r;
    }

    private static String buscaTag(Element element, String tag, boolean tratado) {
        if (element == null) {
            return null;
        }
        if (tag.equals(element.getName())) {
            return tratado ? XMLDOMDocument.formata(element.getText(), 2) : element.getText();
        }
        List content = element.getChildren();
        Iterator iterator = content.iterator();
        while (iterator.hasNext()) {
            String r;
            Object o = iterator.next();
            if (!(o instanceof Element) || (r = XMLDOMDocument.buscaTag((Element)o, tag, tratado)) == null) continue;
            return r;
        }
        return null;
    }

    public String buscaConteudoTag(String tag) throws Exception {
        return this.buscaXML(tag, false);
    }

    private static String buscaElementoAtributo(Element element, String tag, String atributo) {
        if (element == null) {
            return null;
        }
        if (element.getName().equals(tag)) {
            List attrs = element.getAttributes();
            Iterator iterator = attrs.iterator();
            while (iterator.hasNext()) {
                Attribute a;
                Object o = iterator.next();
                if (!(o instanceof Attribute) || !(a = (Attribute)o).getName().equals(atributo)) continue;
                return a.getValue();
            }
            return null;
        }
        List content = element.getChildren();
        Iterator iterator = content.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof Element)) continue;
            return XMLDOMDocument.buscaElementoAtributo((Element)o, tag, atributo);
        }
        return null;
    }

    public String buscaElementoAtributo(String tag, String atributo) {
        String v = XMLDOMDocument.buscaElementoAtributo(this.xmldom.getRootElement(), tag, atributo);
        return v == null ? "" : v;
    }

    public String buscaXML(String tag) {
        return this.buscaXML(tag, true);
    }

    private String buscaXML(String tag, boolean comRaiz) {
        String r = XMLDOMDocument.buscaXML(this.xmldom.getRootElement(), tag, comRaiz);
        return r == null ? "" : r;
    }

    private static String buscaXML(Element element, String tag) {
        return XMLDOMDocument.buscaXML(element, tag, true);
    }

    private static String buscaXML(Element element, String tag, boolean comRaiz) {
        if (element == null) {
            return null;
        }
        if (tag.equals(element.getName())) {
            return XMLDOMDocument.buscaXML(element, comRaiz);
        }
        List content = element.getChildren();
        Iterator iterator = content.iterator();
        while (iterator.hasNext()) {
            String r;
            Object o = iterator.next();
            if (!(o instanceof Element) || (r = XMLDOMDocument.buscaXML((Element)o, tag, comRaiz)) == null) continue;
            return r;
        }
        return null;
    }

    private static String buscaXML(Element element) {
        return XMLDOMDocument.buscaXML(element, true);
    }

    private static String buscaXML(Element element, boolean comRaiz) {
        Object o;
        Iterator iterator;
        if (element == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (comRaiz) {
            sb.append("<");
            sb.append(element.getName());
            List attrs = element.getAttributes();
            iterator = attrs.iterator();
            while (iterator.hasNext()) {
                o = iterator.next();
                if (!(o instanceof Attribute)) continue;
                Attribute a = (Attribute)o;
                sb.append(" ");
                sb.append(a.getName());
                sb.append("=\"");
                sb.append(a.getValue());
                sb.append("\"");
            }
            sb.append(">");
        }
        sb.append(XMLDOMDocument.formata(element.getText(), 2));
        List content = element.getChildren();
        iterator = content.iterator();
        while (iterator.hasNext()) {
            o = iterator.next();
            if (!(o instanceof Element)) continue;
            sb.append(XMLDOMDocument.buscaXML((Element)o));
        }
        if (comRaiz) {
            sb.append("</");
            sb.append(element.getName());
            sb.append(">");
        }
        return sb.toString();
    }

    public String buscaTagRaiz(String tag) {
        List content = this.xmldom.getRootElement().getChildren();
        Iterator iterator = content.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof Element) || !((Element)o).getName().equals(tag)) continue;
            return XMLDOMDocument.formata(((Element)o).getText(), 2);
        }
        return "";
    }

    public void setTag(String tag, String valor, boolean todos) {
        List content = this.xmldom.getRootElement().getChildren();
        Iterator iterator = content.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof Element) || !((Element)o).getName().equals(tag)) continue;
            ((Element)o).setText(valor);
            if (todos) continue;
            return;
        }
    }

    public void setTag(String tag, String value) {
        this.setTag(tag, value, false);
    }

    public void setTagAll(String tag, String value) {
        this.setTag(tag, value, true);
    }

    public XMLDOMDocument concat(String raiz, String xml) throws Exception {
        boolean mesmaRaiz = this.getRootName().equals(raiz);
        StringBuffer str = new StringBuffer("<");
        str.append(raiz);
        str.append(">");
        if (mesmaRaiz) {
            str.append(this.selectDocumentElement());
        } else {
            str.append(this.toString());
        }
        str.append(xml);
        str.append("</");
        str.append(raiz);
        str.append(">");
        XMLDOMDocument ret = new XMLDOMDocument(str.toString());
        return ret;
    }

    public String buscaConteudoSemRoot() throws Exception {
        return this.buscaConteudoTag(this.xmldom.getRootElement().getName());
    }
}

