/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks.ui;

import java.beans.PropertyVetoException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManager;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkNode;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class BookmarksNodeTree {
    private Node rootNode;

    BookmarksNodeTree() {
    }

    public Node rootNode() {
        return this.rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(ExplorerManager explorerManager) {
        block15: {
            BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
            try {
                Node selNode = this.getSelectedNode(explorerManager);
                BookmarkInfo selectedBookmark = null;
                ProjectBookmarks selectedProjectBookmarks = null;
                FilterNode selectedProjectNode = null;
                FileBookmarks selectedFileBookmarks = null;
                if (selNode instanceof BookmarkNode) {
                    selectedBookmark = ((BookmarkNode)selNode).getBookmarkInfo();
                    selectedFileBookmarks = selectedBookmark.getFileBookmarks();
                    selectedProjectBookmarks = selectedFileBookmarks.getProjectBookmarks();
                }
                List<ProjectBookmarks> loadedProjectBookmarks = lockedBookmarkManager.allLoadedProjectBookmarks();
                ArrayList<1> projectNodeList = new ArrayList<1>(loadedProjectBookmarks.size());
                for (ProjectBookmarks projectBookmarks : loadedProjectBookmarks) {
                    Node prjNode;
                    if (!projectBookmarks.containsAnyBookmarks()) continue;
                    FileObject[] sortedFileObjects = lockedBookmarkManager.getSortedFileObjects(projectBookmarks);
                    ProjectBookmarksChildren children = new ProjectBookmarksChildren(projectBookmarks, sortedFileObjects);
                    URI prjURI = projectBookmarks.getProjectURI();
                    Project prj = BookmarkUtils.findProject(prjURI);
                    LogicalViewProvider lvp = prj != null ? (LogicalViewProvider)prj.getLookup().lookup(LogicalViewProvider.class) : null;
                    Node node = prjNode = lvp != null ? lvp.createLogicalView() : null;
                    if (prjNode == null) {
                        prjNode = new AbstractNode(Children.LEAF);
                        prjNode.setDisplayName(children.getProjectDisplayName());
                    }
                    FilterNode n = new FilterNode(prjNode, (Children)children){

                        public boolean canCopy() {
                            return false;
                        }

                        public boolean canCut() {
                            return false;
                        }

                        public boolean canDestroy() {
                            return false;
                        }

                        public boolean canRename() {
                            return false;
                        }
                    };
                    projectNodeList.add(n);
                    if (projectBookmarks != selectedProjectBookmarks) continue;
                    selectedProjectNode = n;
                }
                Node[] projectNodes = new Node[projectNodeList.size()];
                projectNodeList.toArray(projectNodes);
                Arrays.sort(projectNodes, new Comparator<Node>(){

                    @Override
                    public int compare(Node n1, Node n2) {
                        return ((ProjectBookmarksChildren)n1.getChildren()).getProjectDisplayName().compareTo(((ProjectBookmarksChildren)n2.getChildren()).getProjectDisplayName());
                    }
                });
                Children.Array rootChildren = new Children.Array();
                rootChildren.add(projectNodes);
                this.rootNode = new AbstractNode((Children)rootChildren);
                if (explorerManager != null) {
                    explorerManager.setRootContext(this.rootNode);
                }
                if (selectedProjectNode != null) {
                    for (Node fileNodes : selectedProjectNode.getChildren().snapshot()) {
                        FileBookmarksChildren ch = (FileBookmarksChildren)fileNodes.getChildren();
                        if (ch.fileBookmarks != selectedFileBookmarks) continue;
                        for (Node bookmarkNode : ch.snapshot()) {
                            if (((BookmarkNode)bookmarkNode).getBookmarkInfo() != selectedBookmark) continue;
                            try {
                                selNode = bookmarkNode;
                                if (explorerManager == null) continue;
                                explorerManager.setSelectedNodes(new Node[]{bookmarkNode});
                            }
                            catch (PropertyVetoException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                }
                if (selNode != null || projectNodes.length <= 0) break block15;
                try {
                    if (explorerManager != null) {
                        explorerManager.setSelectedNodes(new Node[]{projectNodes[0]});
                    }
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            finally {
                lockedBookmarkManager.unlock();
            }
        }
    }

    public Map<BookmarkInfo, BookmarkNode> bookmark2NodeMap() {
        List<BookmarkNode> bNodes = this.bookmarkNodes(true);
        HashMap<BookmarkInfo, BookmarkNode> bookmark2NodeMap = new HashMap<BookmarkInfo, BookmarkNode>(bNodes.size() << 1, 0.5f);
        for (BookmarkNode bNode : bNodes) {
            bookmark2NodeMap.put(bNode.getBookmarkInfo(), bNode);
        }
        return bookmark2NodeMap;
    }

    public List<BookmarkNode> bookmarkNodes(boolean addBookmarksWindowNode) {
        ArrayList<BookmarkNode> bookmarkNodes = new ArrayList<BookmarkNode>();
        if (addBookmarksWindowNode) {
            bookmarkNodes.add(new BookmarkNode(BookmarkInfo.BOOKMARKS_WINDOW));
        }
        this.collectBookmarkNodes(bookmarkNodes, this.rootNode);
        return bookmarkNodes;
    }

    public Node findFirstBookmarkNode(ProjectBookmarks projectBookmarks, FileObject fo) {
        FileBookmarks fileBookmarks = projectBookmarks.get(fo.toURL());
        if (fileBookmarks != null && fileBookmarks.containsAnyBookmarks() && this.rootNode != null) {
            List projectNodes = this.rootNode.getChildren().snapshot();
            for (Node pNode : projectNodes) {
                ProjectBookmarksChildren pChildren = (ProjectBookmarksChildren)pNode.getChildren();
                if (pChildren.projectBookmarks != projectBookmarks) continue;
                for (Node fNode : pChildren.snapshot()) {
                    List bNodes;
                    FileBookmarksChildren fChildren = (FileBookmarksChildren)fNode.getChildren();
                    if (fChildren.fileBookmarks != fileBookmarks || (bNodes = fChildren.snapshot()).isEmpty()) continue;
                    return (Node)bNodes.get(0);
                }
            }
        }
        return null;
    }

    private void collectBookmarkNodes(List<BookmarkNode> bookmarkNodes, Node n) {
        if (n instanceof BookmarkNode) {
            bookmarkNodes.add((BookmarkNode)n);
        } else {
            for (Node cn : n.getChildren().snapshot()) {
                this.collectBookmarkNodes(bookmarkNodes, cn);
            }
        }
    }

    private Node getSelectedNode(ExplorerManager explorerManager) {
        Node[] selectedNodes;
        if (explorerManager != null && (selectedNodes = explorerManager.getSelectedNodes()).length > 0) {
            return selectedNodes[0];
        }
        return null;
    }

    static final class FileBookmarksChildren
    extends Children.Array {
        final FileBookmarks fileBookmarks;

        FileBookmarksChildren(FileBookmarks fileBookmarks, FileObject fo) {
            super(FileBookmarksChildren.toNodes(fileBookmarks));
            this.fileBookmarks = fileBookmarks;
        }

        public FileBookmarks getFileBookmarks() {
            return this.fileBookmarks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Node[] arr) {
            boolean ret = super.remove(arr);
            if (ret) {
                BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
                try {
                    ArrayList<BookmarkInfo> removedBookmarks = new ArrayList<BookmarkInfo>(arr.length);
                    for (Node n : arr) {
                        removedBookmarks.add(((BookmarkNode)n).getBookmarkInfo());
                    }
                    lockedBookmarkManager.removeBookmarks(removedBookmarks);
                }
                finally {
                    lockedBookmarkManager.unlock();
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static List<Node> toNodes(FileBookmarks fb) {
            BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
            try {
                List<BookmarkInfo> bookmarks = fb.getBookmarks();
                ArrayList<Node> nodes = new ArrayList<Node>(bookmarks.size());
                for (int i = 0; i < bookmarks.size(); ++i) {
                    BookmarkInfo bookmark = bookmarks.get(i);
                    BookmarkNode bookmarkNode = new BookmarkNode(bookmark);
                    nodes.add((Node)bookmarkNode);
                }
                ArrayList<Node> arrayList = nodes;
                return arrayList;
            }
            finally {
                lockedBookmarkManager.unlock();
            }
        }
    }

    static final class ProjectBookmarksChildren
    extends Children.Keys<FileObject> {
        final String projectDisplayName;
        final ProjectBookmarks projectBookmarks;

        ProjectBookmarksChildren(ProjectBookmarks projectBookmarks, FileObject[] sortedFileObjects) {
            this.projectBookmarks = projectBookmarks;
            URI prjURI = projectBookmarks.getProjectURI();
            Project prj = BookmarkUtils.findProject(prjURI);
            this.projectDisplayName = prj != null ? ProjectUtils.getInformation((Project)prj).getDisplayName() : NbBundle.getMessage(BookmarksView.class, (String)"LBL_NullProjectDisplayName");
            this.setKeys(sortedFileObjects);
        }

        String getProjectDisplayName() {
            return this.projectDisplayName;
        }

        protected Node[] createNodes(FileObject fo) {
            Node foNode;
            try {
                DataObject dob = DataObject.find((FileObject)fo);
                foNode = dob.getNodeDelegate().cloneNode();
            }
            catch (DataObjectNotFoundException ex) {
                foNode = new AbstractNode(Children.LEAF);
                foNode.setDisplayName(fo.getNameExt());
            }
            URL url = fo.toURL();
            FileBookmarks urlBookmarks = this.projectBookmarks.get(url);
            return new Node[]{new FilterNode(foNode, (Children)new FileBookmarksChildren(urlBookmarks, fo))};
        }
    }
}

