/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;

public final class ProjectBookmarks {
    private final URI projectURI;
    private volatile int lastBookmarkId;
    private final Map<URL, FileBookmarks> url2FileBookmarks;
    private boolean removed;

    public ProjectBookmarks(URI projectURI) {
        this(projectURI, 0);
    }

    public ProjectBookmarks(URI projectURI, int lastBookmarkId) {
        this.projectURI = projectURI;
        this.lastBookmarkId = lastBookmarkId;
        this.url2FileBookmarks = new HashMap<URL, FileBookmarks>();
    }

    public URI getProjectURI() {
        return this.projectURI;
    }

    public int getLastBookmarkId() {
        return this.lastBookmarkId;
    }

    public int generateBookmarkId() {
        return ++this.lastBookmarkId;
    }

    public void ensureBookmarkIdSkip(int bookmarkId) {
        this.lastBookmarkId = Math.max(this.lastBookmarkId, bookmarkId);
    }

    public FileBookmarks get(URL url) {
        return this.url2FileBookmarks.get(url);
    }

    public void remove(URL url) {
        this.url2FileBookmarks.remove(url);
    }

    public void add(FileBookmarks fileBookmarks) {
        this.url2FileBookmarks.put(fileBookmarks.getUrl(), fileBookmarks);
    }

    public Collection<URL> allURLs() {
        return this.url2FileBookmarks.keySet();
    }

    public boolean containsAnyBookmarks() {
        for (FileBookmarks fileBookmarks : this.url2FileBookmarks.values()) {
            if (!fileBookmarks.containsAnyBookmarks()) continue;
            return true;
        }
        return false;
    }

    public Collection<FileBookmarks> allFileBookmarks() {
        return this.url2FileBookmarks.values();
    }

    public List<BookmarkInfo> allBookmarks() {
        ArrayList<BookmarkInfo> allBookmarks = new ArrayList<BookmarkInfo>();
        for (FileBookmarks fileBookmarks : this.url2FileBookmarks.values()) {
            allBookmarks.addAll(fileBookmarks.getBookmarks());
        }
        return allBookmarks;
    }

    public void markRemoved() {
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public String toString() {
        return "project=" + this.projectURI + ", lastBId=" + this.lastBookmarkId + ", removed=" + this.removed;
    }
}

