/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class FileBookmarks {
    private final ProjectBookmarks projectBookmarks;
    private final URL url;
    private FileObject fileObject;
    private List<BookmarkInfo> bookmarks;

    FileBookmarks(ProjectBookmarks projectBookmarks, URL url, FileObject fileObject, List<BookmarkInfo> bookmarks) {
        this.projectBookmarks = projectBookmarks;
        this.url = url;
        this.fileObject = fileObject;
        this.bookmarks = new ArrayList<BookmarkInfo>(bookmarks);
        for (BookmarkInfo bookmark : bookmarks) {
            bookmark.setFileBookmarks(this);
        }
    }

    public ProjectBookmarks getProjectBookmarks() {
        return this.projectBookmarks;
    }

    public URL getUrl() {
        return this.url;
    }

    public FileObject getFileObject() {
        if (this.fileObject == null) {
            this.fileObject = URLMapper.findFileObject((URL)this.url);
        }
        return this.fileObject;
    }

    public boolean containsAnyBookmarks() {
        return !this.bookmarks.isEmpty();
    }

    public List<BookmarkInfo> getBookmarks() {
        return this.bookmarks;
    }

    public void add(BookmarkInfo bookmark) {
        this.bookmarks.add(bookmark);
        Collections.sort(this.bookmarks, BookmarkInfo.CURRENT_LINE_COMPARATOR);
    }

    public boolean remove(BookmarkInfo bookmark) {
        if (!this.projectBookmarks.isRemoved()) {
            return this.bookmarks.remove(bookmark);
        }
        return false;
    }
}

