/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManager;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BookmarksPersistence
implements PropertyChangeListener,
Runnable {
    private static final String EDITOR_BOOKMARKS_1_NAMESPACE_URI = "http://www.netbeans.org/ns/editor-bookmarks/1";
    private static final String EDITOR_BOOKMARKS_2_NAMESPACE_URI = "http://www.netbeans.org/ns/editor-bookmarks/2";
    private static RequestProcessor RP = new RequestProcessor("Bookmarks saver");
    private static final BookmarksPersistence INSTANCE = new BookmarksPersistence();
    private final List<Project> lastOpenProjects = new ArrayList<Project>();
    private boolean ensureProjectsBookmarksLoadedUponProjectsLoad;

    public static BookmarksPersistence get() {
        return INSTANCE;
    }

    private BookmarksPersistence() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initProjectsListening() {
        OpenProjects openProjects = OpenProjects.getDefault();
        List<Project> projects = Arrays.asList(openProjects.getOpenProjects());
        List<Project> list = this.lastOpenProjects;
        synchronized (list) {
            this.lastOpenProjects.addAll(projects);
        }
        openProjects.addPropertyChangeListener((PropertyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endProjectsListening() {
        OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            ArrayList<Project> projects;
            List<Project> list = this.lastOpenProjects;
            synchronized (list) {
                projects = new ArrayList<Project>(this.lastOpenProjects);
            }
            for (Project project : projects) {
                ProjectBookmarks projectBookmarks;
                URI projectURI = BookmarkUtils.toURI(project);
                if (projectURI == null || (projectBookmarks = lockedBookmarkManager.getProjectBookmarks(project, projectURI, false, false)) == null) continue;
                this.saveProjectBookmarks(project, projectBookmarks);
                lockedBookmarkManager.removeProjectBookmarks(projectBookmarks);
            }
            for (ProjectBookmarks projectBookmarks : lockedBookmarkManager.allLoadedProjectBookmarks()) {
                URI prjURI = projectBookmarks.getProjectURI();
                Project prj = BookmarkUtils.findProject(prjURI);
                if (prj == null) continue;
                this.saveProjectBookmarks(prj, projectBookmarks);
                lockedBookmarkManager.removeProjectBookmarks(projectBookmarks);
            }
        }
        finally {
            lockedBookmarkManager.unlock();
        }
        List<Project> list = this.lastOpenProjects;
        synchronized (list) {
            this.lastOpenProjects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureAllOpenedProjectsBookmarksLoaded() {
        ArrayList<Project> projects;
        this.ensureProjectsBookmarksLoadedUponProjectsLoad = true;
        List<Project> list = this.lastOpenProjects;
        synchronized (list) {
            projects = new ArrayList<Project>(this.lastOpenProjects);
        }
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            lockedBookmarkManager.ensureProjectBookmarksLoaded(projects);
        }
        finally {
            lockedBookmarkManager.unlock();
        }
    }

    ProjectBookmarks loadProjectBookmarks(final Project project) {
        return (ProjectBookmarks)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ProjectBookmarks>(){

            public ProjectBookmarks run() {
                int version = 2;
                AuxiliaryConfiguration ac = ProjectUtils.getAuxiliaryConfiguration((Project)project);
                Element bookmarksElement = ac.getConfigurationFragment("editor-bookmarks", BookmarksPersistence.EDITOR_BOOKMARKS_2_NAMESPACE_URI, false);
                int lastBookmarkId = 0;
                if (bookmarksElement != null) {
                    String lastBookmarkIdText = bookmarksElement.getAttribute("lastBookmarkId");
                    try {
                        lastBookmarkId = Integer.parseInt(lastBookmarkIdText);
                    }
                    catch (NumberFormatException ex) {}
                } else {
                    version = 1;
                    bookmarksElement = ac.getConfigurationFragment("editor-bookmarks", BookmarksPersistence.EDITOR_BOOKMARKS_1_NAMESPACE_URI, false);
                    if (bookmarksElement == null) {
                        return null;
                    }
                }
                URI projectURI = BookmarkUtils.toURI(project);
                ProjectBookmarks projectBookmarks = new ProjectBookmarks(projectURI, lastBookmarkId);
                URL projectFolderURL = project.getProjectDirectory().toURL();
                Node fileElem = BookmarksPersistence.skipNonElementNode(bookmarksElement.getFirstChild());
                while (fileElem != null) {
                    assert ("file".equals(fileElem.getNodeName()));
                    Node urlElem = BookmarksPersistence.skipNonElementNode(fileElem.getFirstChild());
                    assert ("url".equals(urlElem.getNodeName()));
                    Node lineOrBookmarkElem = BookmarksPersistence.skipNonElementNode(urlElem.getNextSibling());
                    ArrayList<BookmarkInfo> bookmarkInfos = new ArrayList<BookmarkInfo>();
                    while (lineOrBookmarkElem != null) {
                        String nodeName = lineOrBookmarkElem.getNodeName();
                        try {
                            BookmarkInfo bookmarkInfo;
                            int id;
                            if (version == 2) {
                                assert ("bookmark".equals(nodeName));
                                assert (lineOrBookmarkElem.getNodeType() == 1);
                                Element bookmarkElem = (Element)lineOrBookmarkElem;
                                id = -1;
                                if (bookmarkElem.hasAttributes()) {
                                    String idText = bookmarkElem.getAttribute("id");
                                    try {
                                        id = Integer.parseInt(idText);
                                        projectBookmarks.ensureBookmarkIdSkip(id);
                                    }
                                    catch (NumberFormatException ex) {
                                        // empty catch block
                                    }
                                }
                                if (id == -1) {
                                    id = projectBookmarks.generateBookmarkId();
                                }
                                Node nameElem = BookmarksPersistence.skipNonElementNode(lineOrBookmarkElem.getFirstChild());
                                assert ("name".equals(nameElem.getNodeName()));
                                Node nameTextNode = nameElem.getFirstChild();
                                String name = nameTextNode != null ? nameTextNode.getNodeValue() : "";
                                Node lineElem = BookmarksPersistence.skipNonElementNode(nameElem.getNextSibling());
                                int lineIndex = BookmarksPersistence.parseLineIndex(lineElem);
                                Node keyElem = BookmarksPersistence.skipNonElementNode(lineElem.getNextSibling());
                                Node keyTextNode = keyElem.getFirstChild();
                                String key = keyTextNode != null ? keyTextNode.getNodeValue() : "";
                                bookmarkInfo = BookmarkInfo.create(id, name, lineIndex, key);
                            } else {
                                int lineIndex = BookmarksPersistence.parseLineIndex(lineOrBookmarkElem);
                                id = projectBookmarks.getLastBookmarkId();
                                bookmarkInfo = BookmarkInfo.create(id, "", lineIndex, "");
                            }
                            bookmarkInfos.add(bookmarkInfo);
                        }
                        catch (DOMException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        catch (NumberFormatException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        lineOrBookmarkElem = BookmarksPersistence.skipNonElementNode(lineOrBookmarkElem.getNextSibling());
                    }
                    bookmarkInfos.trimToSize();
                    try {
                        try {
                            Node urlElemText = urlElem.getFirstChild();
                            String relOrAbsURLString = urlElemText.getNodeValue();
                            URI uri = new URI(relOrAbsURLString);
                            URL url = !uri.isAbsolute() && projectFolderURL != null ? new URL(projectFolderURL, relOrAbsURLString) : new URL(relOrAbsURLString);
                            projectBookmarks.add(new FileBookmarks(projectBookmarks, url, null, bookmarkInfos));
                        }
                        catch (URISyntaxException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        catch (MalformedURLException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                    catch (DOMException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    fileElem = BookmarksPersistence.skipNonElementNode(fileElem.getNextSibling());
                }
                return projectBookmarks;
            }
        });
    }

    static int parseLineIndex(Node lineElem) {
        assert ("line".equals(lineElem.getNodeName()));
        Node lineElemText = lineElem.getFirstChild();
        String lineIndexString = lineElemText.getNodeValue();
        return Integer.parseInt(lineIndexString);
    }

    private static Node skipNonElementNode(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return node;
    }

    private void saveProjectBookmarks(Project project, ProjectBookmarks projectBookmarks) {
        URI baseURI;
        if (project == null) {
            return;
        }
        if (!ProjectManager.getDefault().isValid(project)) {
            return;
        }
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        try {
            baseURI = new URI(project.getProjectDirectory().toURL().toExternalForm());
        }
        catch (URISyntaxException e) {
            baseURI = null;
        }
        boolean legacy = false;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            String namespaceURI = legacy ? EDITOR_BOOKMARKS_1_NAMESPACE_URI : EDITOR_BOOKMARKS_2_NAMESPACE_URI;
            Element bookmarksElem = document.createElementNS(namespaceURI, "editor-bookmarks");
            bookmarksElem.setAttribute("lastBookmarkId", String.valueOf(projectBookmarks.getLastBookmarkId()));
            for (URL url : projectBookmarks.allURLs()) {
                List<BookmarkInfo> bookmarkInfos = projectBookmarks.get(url).getBookmarks();
                if (bookmarkInfos.isEmpty()) continue;
                Element fileElem = document.createElementNS(namespaceURI, "file");
                Element urlElem = document.createElementNS(namespaceURI, "url");
                String url2 = url.toExternalForm();
                if (baseURI != null) {
                    try {
                        URI absoluteURI = new URI(url2);
                        URI relativeURI = baseURI.relativize(absoluteURI);
                        url2 = relativeURI.toString();
                    }
                    catch (URISyntaxException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                urlElem.appendChild(document.createTextNode(url2));
                fileElem.appendChild(urlElem);
                for (BookmarkInfo bookmarkInfo : bookmarkInfos) {
                    if (legacy) {
                        Element lineElem = document.createElementNS(namespaceURI, "line");
                        lineElem.appendChild(document.createTextNode(Integer.toString(bookmarkInfo.getLineIndex())));
                        fileElem.appendChild(lineElem);
                        continue;
                    }
                    Element nameElem = document.createElementNS(namespaceURI, "name");
                    nameElem.appendChild(document.createTextNode(bookmarkInfo.getName()));
                    Element lineElem = document.createElementNS(namespaceURI, "line");
                    lineElem.appendChild(document.createTextNode(Integer.toString(bookmarkInfo.getLineIndex())));
                    Element keyElem = document.createElementNS(namespaceURI, "key");
                    keyElem.appendChild(document.createTextNode(String.valueOf(bookmarkInfo.getKey())));
                    Element bookmarkElem = document.createElementNS(namespaceURI, "bookmark");
                    bookmarkElem.setAttribute("id", String.valueOf(bookmarkInfo.getId()));
                    bookmarkElem.appendChild(nameElem);
                    bookmarkElem.appendChild(lineElem);
                    bookmarkElem.appendChild(keyElem);
                    fileElem.appendChild(bookmarkElem);
                }
                bookmarksElem.appendChild(fileElem);
            }
            auxiliaryConfiguration.putConfigurationFragment(bookmarksElem, false);
        }
        catch (ParserConfigurationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    @Override
    public void run() {
        ProjectManager.mutex().writeAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList projectsToSave;
                List<Project> openProjects = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
                List list = BookmarksPersistence.this.lastOpenProjects;
                synchronized (list) {
                    BookmarksPersistence.this.lastOpenProjects.removeAll(openProjects);
                    projectsToSave = new ArrayList(BookmarksPersistence.this.lastOpenProjects);
                    BookmarksPersistence.this.lastOpenProjects.clear();
                    BookmarksPersistence.this.lastOpenProjects.addAll(openProjects);
                }
                BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
                try {
                    for (Project p : projectsToSave) {
                        ProjectBookmarks projectBookmarks = lockedBookmarkManager.getProjectBookmarks(p, false, false);
                        if (projectBookmarks == null) continue;
                        BookmarksPersistence.this.saveProjectBookmarks(p, projectBookmarks);
                        lockedBookmarkManager.removeProjectBookmarks(projectBookmarks);
                    }
                    if (BookmarksPersistence.this.ensureProjectsBookmarksLoadedUponProjectsLoad) {
                        BookmarksPersistence.this.ensureProjectsBookmarksLoadedUponProjectsLoad = false;
                        BookmarksPersistence.this.ensureAllOpenedProjectsBookmarksLoaded();
                    }
                }
                finally {
                    lockedBookmarkManager.unlock();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        RP.post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("Opened Projects:\n");
        List<Project> list = this.lastOpenProjects;
        synchronized (list) {
            for (Project p : this.lastOpenProjects) {
                sb.append("Project ").append(p).append('\n');
            }
        }
        sb.append("------------------------");
        return sb.toString();
    }
}

