/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.bookmarks.BookmarkChange;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManagerEvent;
import org.netbeans.modules.editor.bookmarks.BookmarkManagerListener;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.BookmarksPersistence;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.openide.filesystems.FileObject;

public class BookmarkManager {
    private static final BookmarkManager INSTANCE = new BookmarkManager();
    private final Map<URI, ProjectBookmarks> project2Bookmarks = new HashMap<URI, ProjectBookmarks>();
    private List<BookmarkManagerListener> listenerList = new CopyOnWriteArrayList<BookmarkManagerListener>();
    private Thread locker;
    private int lockDepth;
    private List<BookmarkChange> transactionChanges;

    public static BookmarkManager getLocked() {
        return INSTANCE.lock();
    }

    private BookmarkManager() {
    }

    synchronized BookmarkManager lock() {
        try {
            Thread currentThread = Thread.currentThread();
            while (this.locker != null) {
                if (currentThread == this.locker) {
                    ++this.lockDepth;
                    return this;
                }
                this.wait();
            }
            this.locker = currentThread;
            this.lockDepth = 1;
            this.transactionChanges = new ArrayList<BookmarkChange>();
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted lock attempt.");
        }
        return this;
    }

    public synchronized void unlock() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != this.locker) {
            throw new IllegalStateException("currentThread=" + currentThread + " != locker=" + this.locker);
        }
        if (--this.lockDepth <= 0) {
            this.locker = null;
            this.lockDepth = 0;
            if (!this.transactionChanges.isEmpty()) {
                this.fireChange(this.transactionChanges);
            }
            this.transactionChanges = null;
            this.notifyAll();
        }
    }

    public List<ProjectBookmarks> allLoadedProjectBookmarks() {
        return new ArrayList<ProjectBookmarks>(this.project2Bookmarks.values());
    }

    void ensureProjectBookmarksLoaded(List<Project> projects) {
        for (Project project : projects) {
            this.getProjectBookmarks(project, true, false);
        }
    }

    public BookmarkInfo findBookmarkByNameOrKey(String nameOrKey, boolean byKey) {
        for (ProjectBookmarks projectBookmarks : this.allLoadedProjectBookmarks()) {
            for (URL url : projectBookmarks.allURLs()) {
                FileBookmarks fileBookmarks = projectBookmarks.get(url);
                for (BookmarkInfo info : fileBookmarks.getBookmarks()) {
                    if (!nameOrKey.equals(info.getName())) continue;
                    return info;
                }
            }
        }
        return null;
    }

    public void addBookmarkManagerListener(BookmarkManagerListener l) {
        this.listenerList.add(l);
    }

    public void removeBookmarkManagerListener(BookmarkManagerListener l) {
        this.listenerList.remove(l);
    }

    void fireChange(List<BookmarkChange> changes) {
        BookmarkManagerEvent evt = new BookmarkManagerEvent(this, changes);
        for (BookmarkManagerListener l : this.listenerList) {
            l.bookmarksChanged(evt);
        }
    }

    public FileObject[] getSortedFileObjects(ProjectBookmarks projectBookmarks) {
        List<FileObject> foList;
        if (projectBookmarks != null) {
            Collection<FileBookmarks> allFileBookmarks = projectBookmarks.allFileBookmarks();
            foList = new ArrayList(allFileBookmarks.size());
            for (FileBookmarks fileBookmarks : allFileBookmarks) {
                FileObject fo = fileBookmarks.getFileObject();
                if (fo == null || !fileBookmarks.containsAnyBookmarks()) continue;
                foList.add(fo);
            }
            Collections.sort(foList, new Comparator<FileObject>(){

                @Override
                public int compare(FileObject fo1, FileObject fo2) {
                    return fo1.getNameExt().compareTo(fo2.getNameExt());
                }
            });
        } else {
            foList = Collections.emptyList();
        }
        return foList.toArray(new FileObject[foList.size()]);
    }

    public FileBookmarks getFileBookmarks(Document document) {
        FileObject fo;
        URL url;
        FileBookmarks fileBookmarks = null;
        ProjectBookmarks projectBookmarks = this.getProjectBookmarks(document);
        if (projectBookmarks != null && projectBookmarks != null && (fileBookmarks = projectBookmarks.get(url = (fo = NbEditorUtilities.getFileObject((Document)document)).toURL())) == null) {
            fileBookmarks = new FileBookmarks(projectBookmarks, url, fo, Collections.<BookmarkInfo>emptyList());
            projectBookmarks.add(fileBookmarks);
        }
        return fileBookmarks;
    }

    public ProjectBookmarks getProjectBookmarks(Document document) {
        FileObject fo = NbEditorUtilities.getFileObject((Document)document);
        return this.getProjectBookmarks(fo);
    }

    public ProjectBookmarks getProjectBookmarks(FileObject fo) {
        ProjectBookmarks projectBookmarks = null;
        if (fo != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)fo);
            projectBookmarks = this.getProjectBookmarks(project, true, true);
        }
        return projectBookmarks;
    }

    public ProjectBookmarks getProjectBookmarks(Project project, boolean load, boolean forceCreation) {
        return this.getProjectBookmarks(project, BookmarkUtils.toURI(project), load, forceCreation);
    }

    public ProjectBookmarks getProjectBookmarks(Project project, URI projectURI, boolean load, boolean forceCreation) {
        ProjectBookmarks projectBookmarks = this.project2Bookmarks.get(projectURI);
        if (projectBookmarks == null) {
            BookmarkChange change;
            if (load && (projectBookmarks = project != null ? BookmarksPersistence.get().loadProjectBookmarks(project) : new ProjectBookmarks(null)) != null) {
                change = new BookmarkChange(projectBookmarks.getProjectURI(), null);
                change.markAdded();
            }
            if (projectBookmarks == null && forceCreation) {
                projectBookmarks = new ProjectBookmarks(projectURI);
            }
            if (projectBookmarks != null) {
                this.project2Bookmarks.put(projectURI, projectBookmarks);
                change = new BookmarkChange(projectURI);
                change.markAdded();
                this.transactionChanges.add(change);
            }
        }
        return projectBookmarks;
    }

    public void removeProjectBookmarks(ProjectBookmarks projectBookmarks) {
        this.project2Bookmarks.remove(projectBookmarks.getProjectURI());
        projectBookmarks.markRemoved();
        BookmarkChange change = new BookmarkChange(projectBookmarks.getProjectURI());
        change.markRemoved();
        this.transactionChanges.add(change);
    }

    public void addBookmarkNotify(BookmarkInfo bookmark) {
        BookmarkChange change = new BookmarkChange(bookmark);
        change.markAdded();
        this.transactionChanges.add(change);
    }

    public void removeBookmarks(List<BookmarkInfo> bookmarks) {
        for (BookmarkInfo bookmark : bookmarks) {
            BookmarkChange change = new BookmarkChange(bookmark);
            FileBookmarks fileBookmarks = bookmark.getFileBookmarks();
            if (!fileBookmarks.remove(bookmark)) continue;
            change.markRemoved();
            this.transactionChanges.add(change);
        }
    }

    public void updateLineIndex(BookmarkInfo bookmark, int lineIndex) {
        if (bookmark.getLineIndex() != lineIndex) {
            BookmarkChange change = new BookmarkChange(bookmark);
            bookmark.setLineIndex(lineIndex);
            change.markLineIndexChanged();
            this.transactionChanges.add(change);
        }
    }

    public void updateNameOrKey(BookmarkInfo bookmark, boolean nameChanged, boolean keyChanged) {
        BookmarkChange change = new BookmarkChange(bookmark);
        if (nameChanged) {
            change.markNameChanged();
        }
        if (keyChanged) {
            change.markKeyChanged();
        }
        this.transactionChanges.add(change);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        for (ProjectBookmarks projectBookmarks : this.allLoadedProjectBookmarks()) {
            sb.append("Project ").append(projectBookmarks.getProjectURI()).append('\n');
            for (URL url : projectBookmarks.allURLs()) {
                sb.append("    ").append(url).append("\n");
                for (BookmarkInfo info : projectBookmarks.get(url).getBookmarks()) {
                    sb.append("        ").append(info).append('\n');
                }
            }
        }
        return sb.toString();
    }
}

