/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.util.Comparator;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class BookmarkInfo {
    public static BookmarkInfo BOOKMARKS_WINDOW = new BookmarkInfo(0, "Bookmarks Window", 0, "", null);
    public static final Comparator<BookmarkInfo> CURRENT_LINE_COMPARATOR = new Comparator<BookmarkInfo>(){

        @Override
        public int compare(BookmarkInfo bookmark1, BookmarkInfo bookmark2) {
            return bookmark1.getCurrentLineIndex() - bookmark2.getCurrentLineIndex();
        }
    };
    private final Integer id;
    private String name;
    private int lineIndex;
    private int currentLineIndex;
    private String key;
    private FileBookmarks fileBookmarks;

    public static BookmarkInfo create(int id, String name, int lineIndex, String key) {
        return BookmarkInfo.create(id, name, lineIndex, key, null);
    }

    public static BookmarkInfo create(int id, String name, int lineIndex, String key, FileBookmarks fileBookmarks) {
        return new BookmarkInfo(id, name, lineIndex, key, fileBookmarks);
    }

    private BookmarkInfo(Integer id, String name, int lineIndex, String key, FileBookmarks fileBookmarks) {
        this.id = id;
        if (name == null) {
            throw new IllegalArgumentException("Null name not allowed");
        }
        this.name = name;
        this.setLineIndex(lineIndex);
        if (key == null) {
            throw new IllegalArgumentException("Null key not allowed");
        }
        this.key = key;
        this.fileBookmarks = fileBookmarks;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.getDescription(false, true, true);
    }

    public int getLineIndex() {
        return this.lineIndex;
    }

    public void setLineIndex(int lineIndex) {
        this.lineIndex = lineIndex;
        this.setCurrentLineIndex(lineIndex);
    }

    public int getCurrentLineIndex() {
        return this.currentLineIndex;
    }

    public void setCurrentLineIndex(int currentLineIndex) {
        this.currentLineIndex = currentLineIndex;
    }

    public String getDescription(boolean fullPath, boolean useName, boolean useKey) {
        FileObject fo;
        String fileDescription = this != BOOKMARKS_WINDOW ? ((fo = this.getFileBookmarks().getFileObject()) != null ? (fullPath ? fo.getPath() : fo.getNameExt()) : NbBundle.getMessage(BookmarkInfo.class, (String)"LBL_NonExistentFile")) : null;
        return this.getDescription(fileDescription, useName, useKey, false);
    }

    public String getDescription(String fileDescription, boolean useName, boolean useKey, boolean forHtml) {
        StringBuilder description = new StringBuilder(100);
        if (this != BOOKMARKS_WINDOW) {
            description.append(NbBundle.getMessage(BookmarkInfo.class, (String)"CTL_BookmarkFileAndLine", (Object)fileDescription, (Object)(this.getCurrentLineIndex() + 1)));
            if (useName && this.name.length() > 0) {
                description.append(" \"").append(this.name).append("\"");
            }
            if (useKey && this.key.length() > 0) {
                description.append(' ').append(forHtml ? "&lt;" : "<");
                description.append(this.key).append(forHtml ? "&gt;" : ">");
            }
        } else {
            description.append(this.getBookmarksWindowDisplayName());
        }
        return description.toString();
    }

    public String getFullPathDescription() {
        return this != BOOKMARKS_WINDOW ? this.getFileBookmarks().getFileObject().getPath() : NbBundle.getMessage(BookmarkInfo.class, (String)"CTL_BookmarksWindowDescription");
    }

    private String getBookmarksWindowDisplayName() {
        return NbBundle.getMessage(BookmarkInfo.class, (String)"CTL_BookmarksWindowItem");
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        if (key.length() > 0) {
            if (!(key = key.substring(0, 1).toUpperCase()).matches("[0-9A-Z]")) {
                key = "";
            }
        } else {
            key = "";
        }
        this.key = key;
    }

    public FileBookmarks getFileBookmarks() {
        return this.fileBookmarks;
    }

    public void setFileBookmarks(FileBookmarks fileBookmarks) {
        this.fileBookmarks = fileBookmarks;
    }

    public String toString() {
        return "id=" + this.id + ", name=\"" + this.name + "\", key='" + this.key + "' at line=" + this.lineIndex + ", fileBookmarks-IHC=" + System.identityHashCode(this.fileBookmarks);
    }
}

