/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.URI;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;

public class BookmarkChange {
    private static final int ADDED = 1;
    private static final int REMOVED = 2;
    private static final int FILE_CHANGED = 4;
    private static final int NAME_CHANGED = 8;
    private static final int LINE_INDEX_CHANGED = 16;
    private static final int KEY_CHANGED = 32;
    private final URI projectURI;
    private final BookmarkInfo bookmark;
    private int statusBits;

    BookmarkChange(BookmarkInfo bookmark) {
        this(bookmark.getFileBookmarks().getProjectBookmarks().getProjectURI(), bookmark);
    }

    BookmarkChange(URI projectURI) {
        this(projectURI, null);
    }

    BookmarkChange(URI projectURI, BookmarkInfo bookmark) {
        this.projectURI = projectURI;
        this.bookmark = bookmark;
    }

    public BookmarkInfo getBookmark() {
        return this.bookmark;
    }

    public URI getProjectURI() {
        return this.projectURI;
    }

    public boolean isAdded() {
        return (this.statusBits & 1) != 0;
    }

    public boolean isRemoved() {
        return (this.statusBits & 2) != 0;
    }

    public boolean isFileChanged() {
        return (this.statusBits & 4) != 0;
    }

    public boolean isNameChanged() {
        return (this.statusBits & 8) != 0;
    }

    public boolean isLineIndexChanged() {
        return (this.statusBits & 0x10) != 0;
    }

    public boolean isKeyChanged() {
        return (this.statusBits & 0x20) != 0;
    }

    public boolean isNameKeyOrLineIndexChanged() {
        return (this.statusBits & 0x38) != 0;
    }

    void markAdded() {
        this.statusBits |= 1;
    }

    void markRemoved() {
        this.statusBits |= 2;
    }

    void markFileChanged() {
        this.statusBits |= 4;
    }

    void markNameChanged() {
        this.statusBits |= 8;
    }

    void markLineIndexChanged() {
        this.statusBits |= 0x10;
    }

    void markKeyChanged() {
        this.statusBits |= 0x20;
    }
}

