/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene.support;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public final class LowMemoryWatcher {
    private static float heapLimit = 0.8f;
    private static LowMemoryWatcher instance;
    private final MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();

    private LowMemoryWatcher() {
        assert (this.memBean != null);
    }

    public boolean isLowMemory() {
        MemoryUsage usage;
        if (this.memBean != null && (usage = this.memBean.getHeapMemoryUsage()) != null) {
            long max;
            long used = usage.getUsed();
            return (float)used > (float)(max = usage.getMax()) * heapLimit;
        }
        return false;
    }

    public void free() {
        System.gc();
    }

    public static synchronized LowMemoryWatcher getInstance() {
        if (instance == null) {
            instance = new LowMemoryWatcher();
        }
        return instance;
    }
}

