/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene;

import java.io.IOException;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NativeFSLockFactory;
import org.netbeans.api.annotations.common.CheckForNull;

class RecordOwnerLockFactory
extends NativeFSLockFactory {
    private volatile Thread owner;

    RecordOwnerLockFactory() throws IOException {
    }

    @CheckForNull
    Thread getOwner() {
        return this.owner;
    }

    public Lock makeLock(String lockName) {
        return new RecordOwnerLock(super.makeLock(lockName));
    }

    public void clearLock(String lockName) throws IOException {
        super.clearLock(lockName);
        this.owner = null;
    }

    private class RecordOwnerLock
    extends Lock {
        private final Lock delegate;

        private RecordOwnerLock(Lock delegate) {
            assert (delegate != null);
            this.delegate = delegate;
        }

        public boolean obtain() throws IOException {
            boolean result = this.delegate.obtain();
            if (result) {
                RecordOwnerLockFactory.this.owner = Thread.currentThread();
            }
            return result;
        }

        public void release() throws IOException {
            this.delegate.release();
            RecordOwnerLockFactory.this.owner = null;
        }

        public boolean isLocked() throws IOException {
            return this.delegate.isLocked();
        }
    }
}

