/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.stp.ui.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;

public class PreferredInstrFilterPanel
extends JPanel
implements HelpCtx.Provider {
    private static PreferredInstrFilterPanel defaultInstance;
    public JButton CLOSE_BUTTON;
    public JButton OPEN_IN_QUICKFILTER_BUTTON;
    private HTMLTextArea packagesArea;
    private JLabel label;
    private static final String HELP_CTX_KEY = "PreferredInstrFilterPanel.HelpCtx";
    private static final HelpCtx HELP_CTX;

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    private PreferredInstrFilterPanel() {
        this.initComponents();
    }

    public static PreferredInstrFilterPanel getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new PreferredInstrFilterPanel();
        }
        return defaultInstance;
    }

    public void init(final FilterResolver filterComputer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreferredInstrFilterPanel.this.OPEN_IN_QUICKFILTER_BUTTON.setEnabled(false);
                PreferredInstrFilterPanel.this.packagesArea.setText(Bundle.PreferredInstrFilterPanel_ComputingFilterString());
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        String[] packageNames = filterComputer.getFilterValues();
                        ArrayList<String> packageNamesList = new ArrayList<String>(packageNames.length);
                        for (String filterPart : packageNames) {
                            packageNamesList.add(filterPart);
                        }
                        Collections.sort(packageNamesList);
                        final StringBuffer packageNamesBuffer = new StringBuffer(packageNames.length);
                        Iterator it = packageNamesList.iterator();
                        while (it.hasNext()) {
                            packageNamesBuffer.append((String)it.next());
                            if (!it.hasNext()) continue;
                            packageNamesBuffer.append("<br>");
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PreferredInstrFilterPanel.this.packagesArea.setText(packageNamesBuffer.toString());
                                PreferredInstrFilterPanel.this.packagesArea.setCaretPosition(0);
                                PreferredInstrFilterPanel.this.OPEN_IN_QUICKFILTER_BUTTON.setEnabled(true);
                            }
                        });
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.OPEN_IN_QUICKFILTER_BUTTON = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.OPEN_IN_QUICKFILTER_BUTTON, (String)Bundle.PreferredInstrFilterPanel_ToQuickFilterString());
        this.OPEN_IN_QUICKFILTER_BUTTON.getAccessibleContext().setAccessibleDescription(Bundle.PreferredInstrFilterPanel_ToQuickFilterAccessDescr());
        this.CLOSE_BUTTON = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.CLOSE_BUTTON, (String)Bundle.PreferredInstrFilterPanel_CloseButtonString());
        this.label = new JLabel();
        this.packagesArea = new HTMLTextArea();
        this.setLayout(new GridBagLayout());
        this.label.setLabelFor((Component)this.packagesArea);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)Bundle.PreferredInstrFilterPanel_PreferredPackagesCaption());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.label, gridBagConstraints);
        JScrollPane packagesAreaScrollPane = new JScrollPane();
        packagesAreaScrollPane.setPreferredSize(new Dimension(420, 180));
        this.packagesArea.setText("");
        packagesAreaScrollPane.setViewportView((Component)this.packagesArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)packagesAreaScrollPane, gridBagConstraints);
    }

    static {
        HELP_CTX = new HelpCtx(HELP_CTX_KEY);
    }

    public static abstract class FilterResolver {
        private String[] filterValues;

        public synchronized String[] getFilterValues() {
            if (this.filterValues == null) {
                this.filterValues = this.computeFilterValues();
            }
            return this.filterValues;
        }

        protected abstract String[] computeFilterValues();
    }
}

