/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.ui.components.ComponentMorpher;
import org.netbeans.lib.profiler.ui.components.VerticalLayout;
import org.netbeans.lib.profiler.ui.components.XPStyleBorder;
import org.netbeans.modules.profiler.stp.Bundle;
import org.netbeans.modules.profiler.stp.SelectProfilingTask;
import org.openide.util.RequestProcessor;

public class TaskChooser
extends JPanel {
    private ArrayList items = new ArrayList();
    private Color parentColor;
    private ComponentMorpher expandedMorpher = null;
    private Item expandedItem = null;
    private Collection<Listener> listeners = new CopyOnWriteArraySet<Listener>();
    private boolean isSwitching = false;

    public TaskChooser() {
        this(UIManager.getColor("Panel.background"));
    }

    public TaskChooser(Color parentColor) {
        this.parentColor = parentColor;
        this.initComponents();
    }

    public void add(Item item) {
        this.items.add(item);
        super.add((Component)this.createItemMorpher(item));
    }

    @Override
    public Component add(Component comp) {
        throw new RuntimeException("Not implemented for this component");
    }

    @Override
    public Component add(Component comp, int index) {
        throw new RuntimeException("Not implemented for this component");
    }

    @Override
    public void add(Component comp, Object constraints) {
        throw new RuntimeException("Not implemented for this component");
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        throw new RuntimeException("Not implemented for this component");
    }

    @Override
    public Component add(String name, Component comp) {
        throw new RuntimeException("Not implemented for this component");
    }

    public void addItemListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void expand(Item item) {
        this.expandItem(item);
    }

    public void expandImmediately(Item item) {
        this.reset();
        if (item != null) {
            ComponentMorpher morpherToExpand = (ComponentMorpher)this.getComponent(this.items.indexOf(item));
            morpherToExpand.expand();
            morpherToExpand.setFocusable(false);
            ((XPStyleBorder)morpherToExpand.getBorder()).setSelected();
            this.refreshLayout();
            this.expandedMorpher = morpherToExpand;
            this.expandedItem = item;
        }
    }

    public void refreshLayout() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof ComponentMorpher)) continue;
            ((ComponentMorpher)component).refreshLayout();
        }
    }

    public void removeItemListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void reset() {
        if (this.expandedMorpher != null) {
            this.expandedMorpher.reset();
            ((XPStyleBorder)this.expandedMorpher.getBorder()).setDefault();
            this.refreshLayout();
            this.expandedMorpher = null;
            this.expandedItem = null;
        }
    }

    private ComponentMorpher createItemMorpher(final Item item) {
        JComponent itemSmallComponent = this.setupItemSmallComponent(item);
        JComponent itemLargeComponent = this.setupItemLargeComponent(item);
        final ComponentMorpher morpher = new ComponentMorpher(itemSmallComponent, itemLargeComponent, 6, 10);
        morpher.getAccessibleContext().setAccessibleName(Bundle.TaskChooser_MorpherAccessName());
        morpher.getAccessibleContext().setAccessibleDescription(Bundle.TaskChooser_MorpherAccessDescr());
        final XPStyleBorder morpherBorder = XPStyleBorder.getDefaultInstance((Color)SelectProfilingTask.BACKGROUND_COLOR_INACTIVE, (Color)this.parentColor);
        morpher.setBorder((Border)morpherBorder);
        morpher.setFocusable(true);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (morpherBorder.isSelected()) {
                    return;
                }
                morpherBorder.setFocused();
                morpher.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (morpherBorder.isSelected()) {
                    return;
                }
                morpherBorder.setDefault();
                morpher.repaint();
            }
        };
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TaskChooser.this.isEnabled()) {
                    return;
                }
                if (e.getButton() == 1 && !TaskChooser.this.isSwitching && morpher != TaskChooser.this.expandedMorpher) {
                    TaskChooser.this.expandItem(item);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!TaskChooser.this.isEnabled()) {
                    return;
                }
                if (morpherBorder.isSelected() || morpher.isFocusOwner()) {
                    return;
                }
                morpherBorder.setFocused();
                if (morpher != TaskChooser.this.expandedMorpher) {
                    morpher.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!TaskChooser.this.isEnabled()) {
                    return;
                }
                if (morpherBorder.isSelected() || morpher.isFocusOwner()) {
                    return;
                }
                morpherBorder.setDefault();
                if (morpher != TaskChooser.this.expandedMorpher) {
                    morpher.repaint();
                }
            }
        };
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && !TaskChooser.this.isSwitching && morpher != TaskChooser.this.expandedMorpher) {
                    TaskChooser.this.expandItem(item);
                }
            }
        };
        morpher.addFocusListener(focusListener);
        morpher.addMouseListener((MouseListener)mouseListener);
        morpher.addKeyListener((KeyListener)keyListener);
        itemSmallComponent.getComponent(0).addMouseListener(mouseListener);
        return morpher;
    }

    private void expandItem(final Item item) {
        final ComponentMorpher morpherToExpand = (ComponentMorpher)this.getComponent(this.items.indexOf(item));
        final ComponentMorpher morpherToCollapse = this.expandedMorpher;
        ((XPStyleBorder)morpherToExpand.getBorder()).setSelected();
        if (morpherToCollapse != null) {
            ((XPStyleBorder)morpherToCollapse.getBorder()).setDefault();
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                TaskChooser.this.isSwitching = true;
                morpherToExpand.setupMorphing();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            TaskChooser.this.fireItemWillExpand(item);
                        }
                    });
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (morpherToCollapse != null) {
                    morpherToCollapse.setupMorphing();
                }
                if (TaskChooser.this.expandedItem != null) {
                    TaskChooser.this.fireItemWillCollapse(TaskChooser.this.expandedItem);
                }
                while (morpherToExpand.isMorphing() || morpherToCollapse != null && morpherToCollapse.isMorphing()) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                morpherToExpand.morphingStep();
                                if (morpherToCollapse != null) {
                                    morpherToCollapse.morphingStep();
                                }
                            }
                        });
                        Thread.sleep(morpherToExpand.getMorphingDelay());
                    }
                    catch (Exception e) {}
                }
                final Item collapsedItem = TaskChooser.this.expandedItem;
                TaskChooser.this.expandedItem = item;
                TaskChooser.this.expandedMorpher = morpherToExpand;
                TaskChooser.this.isSwitching = false;
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (morpherToCollapse != null) {
                                morpherToCollapse.setFocusable(true);
                            }
                            TaskChooser.this.fireItemExpanded(item);
                            TaskChooser.this.fireItemCollapsed(collapsedItem);
                            morpherToExpand.setFocusable(false);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }, 0, 9);
    }

    private void fireItemCollapsed(Item item) {
        for (Listener l : this.listeners) {
            l.itemCollapsed(item);
        }
    }

    private void fireItemExpanded(Item item) {
        for (Listener l : this.listeners) {
            l.itemExpanded(item);
        }
    }

    private void fireItemWillCollapse(Item item) {
        for (Listener l : this.listeners) {
            l.itemWillCollapse(item);
        }
    }

    private void fireItemWillExpand(Item item) {
        for (Listener l : this.listeners) {
            l.itemWillExpand(item);
        }
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout((LayoutManager)new VerticalLayout());
        this.setFocusable(false);
    }

    private JComponent setupItemLargeComponent(Item item) {
        return item.getLargeComponent();
    }

    private JComponent setupItemSmallComponent(Item item) {
        JComponent itemSmallComponent = item.getSmallComponent();
        JPanel itemSmallComponentContainer = new JPanel();
        itemSmallComponentContainer.setLayout(new OverlayLayout(itemSmallComponentContainer));
        JPanel itemSmallComponentGlassPane = new JPanel();
        itemSmallComponentGlassPane.setOpaque(false);
        itemSmallComponentContainer.add(itemSmallComponentGlassPane);
        itemSmallComponentContainer.add(itemSmallComponent);
        itemSmallComponentContainer.setOpaque(true);
        itemSmallComponentContainer.setBackground(itemSmallComponent.getBackground());
        return itemSmallComponentContainer;
    }

    public static interface Item {
        public JComponent getLargeComponent();

        public JComponent getSmallComponent();
    }

    public static interface Listener {
        public void itemCollapsed(Item var1);

        public void itemExpanded(Item var1);

        public void itemWillCollapse(Item var1);

        public void itemWillExpand(Item var1);
    }
}

