/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedRadioButton;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.stp.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public class NewCustomConfiguration
extends JPanel
implements ChangeListener,
ListSelectionListener,
DocumentListener,
HelpCtx.Provider {
    private static final String HELP_CTX_KEY_NEW = "NewCustomConfiguration.HelpCtx";
    private static final String HELP_CTX_KEY_DUPLICATE = "DuplicateConfiguration.HelpCtx";
    private static final String HELP_CTX_KEY_RENAME = "RenameConfiguration.HelpCtx";
    private static final int MODE_NEW_ANY = 0;
    private static final int MODE_NEW_TYPE = 1;
    private static final int MODE_DUPLICATE = 2;
    private static final int MODE_RENAME = 4;
    private static NewCustomConfiguration defaultInstance;
    private static final Icon ICON_MONITOR;
    private static final Icon ICON_CPU;
    private static final Icon ICON_MEMORY;
    private DefaultListModel existingSettingsListModel;
    private JButton okButton;
    private JLabel nameLabel;
    private JLabel settingsLabel;
    private JLabel typeLabel;
    private JList existingSettingsList;
    private JPanel bottomRenameSpacer;
    private JRadioButton cpuTypeRadio;
    private JRadioButton defaultSettingsRadio;
    private JRadioButton existingSettingsRadio;
    private JRadioButton memoryTypeRadio;
    private JRadioButton monitorTypeRadio;
    private JScrollPane existingSettingsScrollPane;
    private JTextField nameTextfield;
    private ProfilingSettings originalSettings = null;
    private ProfilingSettings[] availableSettings;
    private int mode;
    private NotificationLineSupport notificationLineSupport;

    private NewCustomConfiguration() {
        this.initComponents();
    }

    public static ProfilingSettings createDuplicateConfiguration(ProfilingSettings originalConfiguration, ProfilingSettings[] availableConfigurations) {
        NewCustomConfiguration ncc = NewCustomConfiguration.getDefault();
        ncc.setupDuplicateConfiguration(originalConfiguration, availableConfigurations);
        String title = Bundle.NewCustomConfiguration_DuplicateConfigDialogCaption();
        return NewCustomConfiguration.displayDialog(ncc, title);
    }

    public static ProfilingSettings createNewConfiguration(ProfilingSettings[] availableConfigurations) {
        NewCustomConfiguration ncc = NewCustomConfiguration.getDefault();
        ncc.setupUniversalConfiguration(availableConfigurations);
        String title = Bundle.NewCustomConfiguration_NewConfigDialogCaption();
        return NewCustomConfiguration.displayDialog(ncc, title);
    }

    public static ProfilingSettings createNewConfiguration(int type, ProfilingSettings[] availableConfigurations) {
        NewCustomConfiguration ncc = NewCustomConfiguration.getDefault();
        ncc.setupTypeConfiguration(type, availableConfigurations);
        String typeString = "";
        if (ProfilingSettings.isMonitorSettings((int)type)) {
            typeString = " (" + Bundle.NewCustomConfiguration_MonitorString() + ")";
        } else if (ProfilingSettings.isCPUSettings((int)type)) {
            typeString = " (" + Bundle.NewCustomConfiguration_CpuString() + ")";
        } else if (ProfilingSettings.isMemorySettings((int)type)) {
            typeString = " (" + Bundle.NewCustomConfiguration_MemoryString() + ")";
        }
        typeString = typeString.replace("&", "");
        String title = Bundle.NewCustomConfiguration_NewConfigDialogCaption() + typeString;
        return NewCustomConfiguration.displayDialog(ncc, title);
    }

    public static ProfilingSettings renameConfiguration(ProfilingSettings originalConfiguration, ProfilingSettings[] availableConfigurations) {
        NewCustomConfiguration ncc = NewCustomConfiguration.getDefault();
        ncc.setupRenameConfiguration(originalConfiguration, availableConfigurations);
        String title = Bundle.NewCustomConfiguration_RenameConfigDialogCaption();
        return NewCustomConfiguration.displayDialog(ncc, title);
    }

    public HelpCtx getHelpCtx() {
        switch (this.mode) {
            case 0: 
            case 1: {
                return new HelpCtx(HELP_CTX_KEY_NEW);
            }
            case 2: {
                return new HelpCtx(HELP_CTX_KEY_DUPLICATE);
            }
            case 4: {
                return new HelpCtx(HELP_CTX_KEY_RENAME);
            }
        }
        return null;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.existingSettingsList.setEnabled(this.existingSettingsRadio.isSelected());
        if (this.existingSettingsRadio.isEnabled() && this.defaultSettingsRadio.isSelected()) {
            this.existingSettingsList.clearSelection();
        }
        this.updateOKButton();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateOKButton();
    }

    private static ProfilingSettings displayDialog(NewCustomConfiguration ncc, String title) {
        DialogDescriptor dd = new DialogDescriptor((Object)ncc, title, true, new Object[]{ncc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)ncc.okButton, 0, null, null);
        ncc.notificationLineSupport = dd.createNotificationLineSupport();
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        ProfilingSettings settings = null;
        if (dd.getValue() == ncc.okButton) {
            settings = ncc.getProfilingSettings();
        }
        return settings;
    }

    private static NewCustomConfiguration getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new NewCustomConfiguration();
        }
        return defaultInstance;
    }

    private ProfilingSettings getProfilingSettings() {
        ProfilingSettings newSettings = null;
        if (this.mode == 4) {
            newSettings = this.originalSettings;
        } else if (this.mode == 2 || (this.mode == 0 || this.mode == 1) && this.existingSettingsRadio.isSelected()) {
            newSettings = new ProfilingSettings();
            this.availableSettings[this.existingSettingsList.getSelectedIndex()].copySettingsInto(newSettings);
        } else if (this.monitorTypeRadio.isSelected()) {
            newSettings = ProfilingSettingsPresets.createMonitorPreset();
            newSettings.setIsPreset(false);
        } else if (this.cpuTypeRadio.isSelected()) {
            newSettings = ProfilingSettingsPresets.createCPUPreset();
            newSettings.setIsPreset(false);
        } else if (this.memoryTypeRadio.isSelected()) {
            newSettings = ProfilingSettingsPresets.createMemoryPreset();
            newSettings.setIsPreset(false);
        }
        newSettings.setSettingsName(this.nameTextfield.getText().trim());
        return newSettings;
    }

    private String createSettingsName(ProfilingSettings[] availableConfigurations) {
        String nameBasis = Bundle.NewCustomConfiguration_NewConfigString();
        if (this.monitorTypeRadio.isSelected()) {
            nameBasis = Bundle.NewCustomConfiguration_NewMonitorString();
        } else if (this.cpuTypeRadio.isSelected()) {
            nameBasis = Bundle.NewCustomConfiguration_NewCpuString();
        } else if (this.memoryTypeRadio.isSelected()) {
            nameBasis = Bundle.NewCustomConfiguration_NewMemoryString();
        }
        ArrayList<String> configurationsNames = new ArrayList<String>(availableConfigurations.length);
        for (ProfilingSettings settings : availableConfigurations) {
            configurationsNames.add(settings.getSettingsName());
        }
        int index = 0;
        String indexStr = "";
        while (configurationsNames.contains(nameBasis + indexStr)) {
            indexStr = " " + Integer.toString(++index);
        }
        return nameBasis + indexStr;
    }

    private void showTypeSettings() {
        this.typeLabel.setVisible(true);
        this.monitorTypeRadio.setVisible(true);
        this.cpuTypeRadio.setVisible(true);
        this.memoryTypeRadio.setVisible(true);
    }

    private void hideTypeSettings() {
        this.typeLabel.setVisible(false);
        this.monitorTypeRadio.setVisible(false);
        this.cpuTypeRadio.setVisible(false);
        this.memoryTypeRadio.setVisible(false);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup typeRadiosGroup = new ButtonGroup();
        ButtonGroup settingsRadiosGroup = new ButtonGroup();
        this.typeLabel = new JLabel(Bundle.NewCustomConfiguration_TypeLabelText());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.typeLabel, constraints);
        this.monitorTypeRadio = new JExtendedRadioButton(Bundle.NewCustomConfiguration_MonitorString(), ICON_MONITOR);
        Mnemonics.setLocalizedText((AbstractButton)this.monitorTypeRadio, (String)Bundle.NewCustomConfiguration_MonitorString());
        typeRadiosGroup.add(this.monitorTypeRadio);
        this.monitorTypeRadio.setSelected(true);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 0);
        this.add((Component)this.monitorTypeRadio, constraints);
        this.cpuTypeRadio = new JExtendedRadioButton(Bundle.NewCustomConfiguration_CpuString(), ICON_CPU);
        Mnemonics.setLocalizedText((AbstractButton)this.cpuTypeRadio, (String)Bundle.NewCustomConfiguration_CpuString());
        typeRadiosGroup.add(this.cpuTypeRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 0);
        this.add((Component)this.cpuTypeRadio, constraints);
        this.memoryTypeRadio = new JExtendedRadioButton(Bundle.NewCustomConfiguration_MemoryString(), ICON_MEMORY);
        Mnemonics.setLocalizedText((AbstractButton)this.memoryTypeRadio, (String)Bundle.NewCustomConfiguration_MemoryString());
        typeRadiosGroup.add(this.memoryTypeRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 10);
        this.add((Component)this.memoryTypeRadio, constraints);
        this.nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)Bundle.NewCustomConfiguration_NameLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.nameLabel, constraints);
        this.nameTextfield = new JTextField();
        this.nameTextfield.getDocument().addDocumentListener(this);
        this.nameTextfield.setPreferredSize(new Dimension(380, this.nameTextfield.getPreferredSize().height));
        this.nameTextfield.getAccessibleContext().setAccessibleDescription(Bundle.NewCustomConfiguration_NameLabelAccessDescr());
        this.nameLabel.setLabelFor(this.nameTextfield);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 5, 0, 10);
        this.add((Component)this.nameTextfield, constraints);
        this.settingsLabel = new JLabel(Bundle.NewCustomConfiguration_InitSettingsLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.settingsLabel, constraints);
        this.defaultSettingsRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.defaultSettingsRadio, (String)Bundle.NewCustomConfiguration_DefaultRadioText());
        settingsRadiosGroup.add(this.defaultSettingsRadio);
        this.defaultSettingsRadio.getAccessibleContext().setAccessibleDescription(Bundle.NewCustomConfiguration_DefaultRadioAccessDescr());
        this.defaultSettingsRadio.addChangeListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 10);
        this.add((Component)this.defaultSettingsRadio, constraints);
        this.existingSettingsRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.existingSettingsRadio, (String)Bundle.NewCustomConfiguration_ExistingRadioText());
        settingsRadiosGroup.add(this.existingSettingsRadio);
        this.existingSettingsRadio.getAccessibleContext().setAccessibleDescription(Bundle.NewCustomConfiguration_ExistingRadioAccessDescr());
        this.existingSettingsRadio.setSelected(true);
        this.existingSettingsRadio.addChangeListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(1, 5, 0, 10);
        this.add((Component)this.existingSettingsRadio, constraints);
        this.existingSettingsListModel = new DefaultListModel();
        this.existingSettingsList = new JList(this.existingSettingsListModel);
        this.existingSettingsList.setVisibleRowCount(5);
        this.existingSettingsList.addListSelectionListener(this);
        this.existingSettingsScrollPane = new JScrollPane(this.existingSettingsList, 20, 31);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(4, 5, 15, 10);
        this.add((Component)this.existingSettingsScrollPane, constraints);
        this.bottomRenameSpacer = UIUtils.createFillerPanel();
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.bottomRenameSpacer, constraints);
        this.okButton = new JButton(Bundle.NewCustomConfiguration_OkButtonText());
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && NewCustomConfiguration.this.isShowing()) {
                    NewCustomConfiguration.this.nameTextfield.requestFocusInWindow();
                    NewCustomConfiguration.this.nameTextfield.selectAll();
                }
            }
        });
    }

    private void setupDuplicateConfiguration(ProfilingSettings originalConfiguration, ProfilingSettings[] availableConfigurations) {
        this.mode = 2;
        this.originalSettings = originalConfiguration;
        this.availableSettings = availableConfigurations;
        this.monitorTypeRadio.setEnabled(ProfilingSettings.isMonitorSettings((ProfilingSettings)this.originalSettings));
        this.monitorTypeRadio.setSelected(this.monitorTypeRadio.isEnabled());
        this.cpuTypeRadio.setEnabled(ProfilingSettings.isCPUSettings((ProfilingSettings)this.originalSettings));
        this.cpuTypeRadio.setSelected(this.cpuTypeRadio.isEnabled());
        this.memoryTypeRadio.setEnabled(ProfilingSettings.isMemorySettings((ProfilingSettings)this.originalSettings));
        this.memoryTypeRadio.setSelected(this.memoryTypeRadio.isEnabled());
        this.hideTypeSettings();
        this.settingsLabel.setVisible(true);
        this.defaultSettingsRadio.setVisible(true);
        this.existingSettingsRadio.setVisible(true);
        this.existingSettingsScrollPane.setVisible(true);
        this.bottomRenameSpacer.setVisible(false);
        this.defaultSettingsRadio.setEnabled(false);
        this.existingSettingsRadio.setEnabled(false);
        this.existingSettingsRadio.setSelected(true);
        this.existingSettingsList.setEnabled(false);
        this.nameTextfield.setText(this.createSettingsName(availableConfigurations));
        this.updateAvailableSettings();
        for (int i = 0; i < availableConfigurations.length; ++i) {
            if (this.originalSettings != availableConfigurations[i]) continue;
            this.existingSettingsList.setSelectedIndex(i);
            return;
        }
        this.updateOKButton();
    }

    private void setupRenameConfiguration(ProfilingSettings originalConfiguration, ProfilingSettings[] availableConfigurations) {
        this.mode = 4;
        this.originalSettings = originalConfiguration;
        this.availableSettings = availableConfigurations;
        this.monitorTypeRadio.setEnabled(ProfilingSettings.isMonitorSettings((ProfilingSettings)this.originalSettings));
        this.monitorTypeRadio.setSelected(this.monitorTypeRadio.isEnabled());
        this.cpuTypeRadio.setEnabled(ProfilingSettings.isCPUSettings((ProfilingSettings)this.originalSettings));
        this.cpuTypeRadio.setSelected(this.cpuTypeRadio.isEnabled());
        this.memoryTypeRadio.setEnabled(ProfilingSettings.isMemorySettings((ProfilingSettings)this.originalSettings));
        this.memoryTypeRadio.setSelected(this.memoryTypeRadio.isEnabled());
        this.hideTypeSettings();
        this.settingsLabel.setVisible(false);
        this.defaultSettingsRadio.setVisible(false);
        this.existingSettingsRadio.setVisible(false);
        this.existingSettingsScrollPane.setVisible(false);
        this.bottomRenameSpacer.setVisible(true);
        this.nameTextfield.setText(originalConfiguration.getSettingsName());
        this.updateAvailableSettings();
        this.updateOKButton();
    }

    private void setupTypeConfiguration(int type, ProfilingSettings[] availableConfigurations) {
        this.mode = 1;
        this.originalSettings = null;
        this.availableSettings = availableConfigurations;
        this.monitorTypeRadio.setEnabled(ProfilingSettings.isMonitorSettings((int)type));
        this.monitorTypeRadio.setSelected(this.monitorTypeRadio.isEnabled());
        this.cpuTypeRadio.setEnabled(ProfilingSettings.isCPUSettings((int)type));
        this.cpuTypeRadio.setSelected(this.cpuTypeRadio.isEnabled());
        this.memoryTypeRadio.setEnabled(ProfilingSettings.isMemorySettings((int)type));
        this.memoryTypeRadio.setSelected(this.memoryTypeRadio.isEnabled());
        this.hideTypeSettings();
        this.settingsLabel.setVisible(true);
        this.defaultSettingsRadio.setVisible(true);
        this.existingSettingsRadio.setVisible(true);
        this.existingSettingsScrollPane.setVisible(true);
        this.bottomRenameSpacer.setVisible(false);
        this.defaultSettingsRadio.setEnabled(true);
        this.defaultSettingsRadio.setSelected(true);
        this.existingSettingsRadio.setEnabled(true);
        this.nameTextfield.setText(this.createSettingsName(availableConfigurations));
        this.updateAvailableSettings();
        this.updateOKButton();
    }

    private void setupUniversalConfiguration(ProfilingSettings[] availableConfigurations) {
        this.mode = 0;
        this.originalSettings = null;
        this.availableSettings = availableConfigurations;
        this.monitorTypeRadio.setEnabled(true);
        this.cpuTypeRadio.setEnabled(true);
        this.cpuTypeRadio.setSelected(true);
        this.memoryTypeRadio.setEnabled(true);
        this.showTypeSettings();
        this.settingsLabel.setVisible(true);
        this.defaultSettingsRadio.setVisible(true);
        this.existingSettingsRadio.setVisible(true);
        this.existingSettingsScrollPane.setVisible(true);
        this.bottomRenameSpacer.setVisible(false);
        this.defaultSettingsRadio.setEnabled(true);
        this.defaultSettingsRadio.setSelected(true);
        this.existingSettingsRadio.setEnabled(true);
        this.nameTextfield.setText(this.createSettingsName(availableConfigurations));
        this.updateAvailableSettings();
        this.updateOKButton();
    }

    private void updateAvailableSettings() {
        this.existingSettingsListModel.removeAllElements();
        for (ProfilingSettings settings : this.availableSettings) {
            this.existingSettingsListModel.addElement(settings.getSettingsName());
        }
    }

    private void updateOKButton() {
        String reason = null;
        String name = this.nameTextfield.getText().trim();
        boolean enabled = false;
        if (name.length() > 0) {
            switch (this.mode) {
                case 4: {
                    enabled = !name.equals(this.originalSettings.getSettingsName());
                    break;
                }
                case 0: 
                case 1: {
                    enabled = this.defaultSettingsRadio.isSelected() || this.existingSettingsList.getSelectedIndex() != -1;
                    break;
                }
                default: {
                    enabled = true;
                }
            }
        }
        if (enabled) {
            for (ProfilingSettings settings : this.availableSettings) {
                if (!name.equals(settings.getSettingsName())) continue;
                enabled = false;
                reason = Bundle.NewCustomConfiguration_Notification_DuplicateName();
                break;
            }
        }
        if (this.notificationLineSupport != null) {
            if (reason == null) {
                this.notificationLineSupport.clearMessages();
            } else {
                this.notificationLineSupport.setErrorMessage(reason);
            }
        }
        this.okButton.setEnabled(enabled);
    }

    static {
        ICON_MONITOR = Icons.getIcon((String)"ProfilerIcons.Monitoring");
        ICON_CPU = Icons.getIcon((String)"ProfilerIcons.Cpu");
        ICON_MEMORY = Icons.getIcon((String)"ProfilerIcons.Memory");
    }
}

