/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.stp.Bundle;
import org.netbeans.modules.profiler.stp.DefaultSettingsPanel;
import org.netbeans.modules.profiler.stp.ui.HyperlinkLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class MemorySettingsBasicPanel
extends DefaultSettingsPanel
implements HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "MemorySettings.Basic.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("MemorySettings.Basic.HelpCtx");
    private HyperlinkLabel profilingPointsLink;
    private JCheckBox profilingPointsCheckbox;
    private JCheckBox recordStackTraceCheckbox;
    private JLabel trackEveryLabel1;
    private JLabel trackEveryLabel2;
    private JRadioButton allocationsRadio;
    private JRadioButton livenessRadio;
    private JSpinner trackEverySpinner;
    private Lookup.Provider project;
    private Runnable profilingPointsDisplayer;

    public MemorySettingsBasicPanel() {
        this.initComponents();
    }

    public void setContext(Lookup.Provider project, Runnable profilingPointsDisplayer) {
        this.project = project;
        this.profilingPointsDisplayer = profilingPointsDisplayer;
        this.updateProject(project);
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setProfilingType(int profilingType) {
        this.allocationsRadio.setSelected(profilingType == 2);
        this.livenessRadio.setSelected(profilingType == 4);
    }

    public int getProfilingType() {
        if (this.allocationsRadio.isSelected()) {
            return 2;
        }
        return 4;
    }

    public void setRecordStackTrace(boolean record) {
        this.recordStackTraceCheckbox.setSelected(record);
    }

    public boolean getRecordStackTrace() {
        return this.recordStackTraceCheckbox.isSelected();
    }

    public void setTrackEvery(int trackEvery) {
        this.trackEverySpinner.setValue(trackEvery);
    }

    public int getTrackEvery() {
        return (Integer)this.trackEverySpinner.getValue();
    }

    public void setUseProfilingPoints(boolean use) {
        this.profilingPointsCheckbox.setSelected(use);
        this.updateEnabling();
    }

    public boolean getUseProfilingPoints() {
        return this.profilingPointsCheckbox.isSelected();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame frame = new JFrame("Tester Frame");
        MemorySettingsBasicPanel contents = new MemorySettingsBasicPanel();
        contents.setPreferredSize(new Dimension(375, 255));
        frame.getContentPane().add(contents);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup memoryModeRadios = new ButtonGroup();
        this.allocationsRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.allocationsRadio, (String)Bundle.MemorySettingsBasicPanel_AllocRadioText());
        this.allocationsRadio.setToolTipText(Bundle.StpAllocTooltip());
        this.allocationsRadio.setOpaque(false);
        this.allocationsRadio.setSelected(true);
        memoryModeRadios.add(this.allocationsRadio);
        this.allocationsRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        this.allocationsRadio.addActionListener(this.getSettingsChangeListener());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 30, 0, 0);
        this.add((Component)this.allocationsRadio, constraints);
        this.livenessRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.livenessRadio, (String)Bundle.MemorySettingsBasicPanel_LivenessRadioText());
        this.livenessRadio.setToolTipText(Bundle.StpLivenessTooltip());
        this.livenessRadio.setOpaque(false);
        this.livenessRadio.setSelected(true);
        memoryModeRadios.add(this.livenessRadio);
        this.livenessRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        this.livenessRadio.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 30, 0, 0);
        this.add((Component)this.livenessRadio, constraints);
        JPanel trackEveryContainer = new JPanel(new GridBagLayout());
        this.trackEveryLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.trackEveryLabel1, (String)Bundle.MemorySettingsBasicPanel_TrackEveryLabelText());
        this.trackEveryLabel1.setToolTipText(Bundle.StpTrackEveryTooltip());
        this.trackEveryLabel1.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 5);
        trackEveryContainer.add((Component)this.trackEveryLabel1, constraints);
        this.trackEverySpinner = new JExtendedSpinner(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(55, 3.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.trackEveryLabel1.setLabelFor(this.trackEverySpinner);
        this.trackEverySpinner.setToolTipText(Bundle.StpTrackEveryTooltip());
        this.trackEverySpinner.addChangeListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        trackEveryContainer.add((Component)this.trackEverySpinner, constraints);
        this.trackEveryLabel2 = new JLabel(Bundle.MemorySettingsBasicPanel_AllocLabelText());
        this.trackEveryLabel2.setToolTipText(Bundle.StpTrackEveryTooltip());
        this.trackEveryLabel2.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        trackEveryContainer.add((Component)this.trackEveryLabel2, constraints);
        trackEveryContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(20, 25, 0, 0);
        this.add((Component)trackEveryContainer, constraints);
        this.recordStackTraceCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.recordStackTraceCheckbox, (String)Bundle.MemorySettingsBasicPanel_RecordTracesCheckboxText());
        this.recordStackTraceCheckbox.setToolTipText(Bundle.StpStackTraceTooltip());
        this.recordStackTraceCheckbox.addActionListener(this.getSettingsChangeListener());
        this.recordStackTraceCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(20, 25, 0, 0);
        this.add((Component)this.recordStackTraceCheckbox, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)UIUtils.createFillerPanel(), constraints);
        JPanel profilingPointsContainer = new JPanel(new GridBagLayout());
        this.profilingPointsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.profilingPointsCheckbox, (String)Bundle.MemorySettingsBasicPanel_UsePpsCheckboxText());
        this.profilingPointsCheckbox.setToolTipText(Bundle.StpUsePpsTooltip());
        this.profilingPointsCheckbox.setOpaque(false);
        this.profilingPointsCheckbox.setSelected(true);
        this.profilingPointsCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MemorySettingsBasicPanel.this.updateEnabling();
            }
        });
        this.profilingPointsCheckbox.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 10);
        profilingPointsContainer.add((Component)this.profilingPointsCheckbox, constraints);
        Color linkColor = Color.RED;
        String colorText = "rgb(" + linkColor.getRed() + "," + linkColor.getGreen() + "," + linkColor.getBlue() + ")";
        this.profilingPointsLink = new HyperlinkLabel("<nobr><a href='#'>" + Bundle.MemorySettingsBasicPanel_ShowPpsString() + "</a></nobr>", "<nobr><a href='#' color=\"" + colorText + "\">" + Bundle.MemorySettingsBasicPanel_ShowPpsString() + "</a></nobr>", new Runnable(){

            @Override
            public void run() {
                MemorySettingsBasicPanel.this.performShowProfilingPointsAction();
            }
        });
        this.profilingPointsLink.setToolTipText(Bundle.StpShowPpsTooltip());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        profilingPointsContainer.add((Component)((Object)this.profilingPointsLink), constraints);
        profilingPointsContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(20, 25, 10, 0);
        this.add((Component)profilingPointsContainer, constraints);
    }

    private void performShowProfilingPointsAction() {
        this.profilingPointsDisplayer.run();
    }

    private void updateEnabling() {
        this.profilingPointsLink.setEnabled(this.profilingPointsCheckbox.isSelected() && this.profilingPointsCheckbox.isEnabled());
    }

    private void updateProject(Lookup.Provider project) {
        this.profilingPointsCheckbox.setEnabled(project != null);
    }
}

