/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.project.ProfilingSettingsSupport;
import org.netbeans.modules.profiler.api.project.ProjectContentsSupport;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsDisplayer;
import org.netbeans.modules.profiler.stp.CPUSettingsAdvancedPanel;
import org.netbeans.modules.profiler.stp.CPUSettingsBasicPanel;
import org.netbeans.modules.profiler.stp.MemorySettingsAdvancedPanel;
import org.netbeans.modules.profiler.stp.MemorySettingsBasicPanel;
import org.netbeans.modules.profiler.stp.MonitorSettingsBasicPanel;
import org.netbeans.modules.profiler.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.stp.SettingsContainerPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

final class DefaultSettingsConfigurator
implements SelectProfilingTask.SettingsConfigurator {
    public static final DefaultSettingsConfigurator SHARED_INSTANCE = new DefaultSettingsConfigurator();
    private CPUContents cpuContents = new CPUContents();
    private FileObject profiledFile;
    private MemoryContents memoryContents = new MemoryContents();
    private MonitorContents monitorContents = new MonitorContents();
    private ProfilingSettings settings;
    private Lookup.Provider project;
    private boolean isAttach;
    private boolean isModify;
    private boolean isPreset;

    DefaultSettingsConfigurator() {
    }

    @Override
    public SettingsContainerPanel.Contents getCPUConfigurator() {
        return this.cpuContents;
    }

    @Override
    public void setContext(Lookup.Provider project, FileObject profiledFile, boolean isAttach, boolean isModify, boolean enableOverride) {
        this.project = project;
        this.profiledFile = profiledFile;
        this.isAttach = isAttach;
        this.isModify = isModify;
        this.monitorContents.setContext(project, profiledFile, isAttach, isModify);
        this.cpuContents.setContext(project, profiledFile, isAttach, isModify);
        this.memoryContents.setContext(project, profiledFile, isAttach, isModify);
    }

    public JPanel getCustomSettingsPanel() {
        return null;
    }

    @Override
    public SettingsContainerPanel.Contents getMemoryConfigurator() {
        return this.memoryContents;
    }

    @Override
    public SettingsContainerPanel.Contents getMonitorConfigurator() {
        return this.monitorContents;
    }

    @Override
    public void setSettings(ProfilingSettings settings) {
        this.settings = settings;
        this.isPreset = settings.isPreset();
        if (ProfilingSettings.isMonitorSettings((ProfilingSettings)settings)) {
            this.monitorContents.setSettings(settings);
        } else if (ProfilingSettings.isCPUSettings((ProfilingSettings)settings)) {
            this.cpuContents.setSettings(settings);
        } else if (ProfilingSettings.isMemorySettings((ProfilingSettings)settings)) {
            this.memoryContents.setSettings(settings);
        }
    }

    @Override
    public ProfilingSettings getSettings() {
        return this.settings;
    }

    @Override
    public ProfilingSettings createFinalSettings() {
        if (ProfilingSettings.isMonitorSettings((ProfilingSettings)this.settings)) {
            return this.monitorContents.createFinalSettings();
        }
        if (ProfilingSettings.isCPUSettings((ProfilingSettings)this.settings)) {
            return this.cpuContents.createFinalSettings();
        }
        if (ProfilingSettings.isMemorySettings((ProfilingSettings)this.settings)) {
            return this.memoryContents.createFinalSettings();
        }
        return null;
    }

    public void loadCustomSettings(Properties properties) {
    }

    @Override
    public void reset() {
        this.settings = null;
        this.project = null;
        this.profiledFile = null;
        this.isAttach = false;
        this.isModify = false;
        this.isPreset = false;
        this.monitorContents.reset();
        this.cpuContents.reset();
        this.memoryContents.reset();
    }

    public void storeCustomSettings(Properties properties) {
    }

    @Override
    public void synchronizeSettings() {
        if (ProfilingSettings.isMonitorSettings((ProfilingSettings)this.settings)) {
            this.monitorContents.synchronizeSettings();
        } else if (ProfilingSettings.isCPUSettings((ProfilingSettings)this.settings)) {
            this.cpuContents.synchronizeSettings();
        } else if (ProfilingSettings.isMemorySettings((ProfilingSettings)this.settings)) {
            this.memoryContents.synchronizeSettings();
        }
    }

    protected boolean isAttach() {
        return this.isAttach;
    }

    protected boolean isModify() {
        return this.isModify;
    }

    protected boolean isPreset() {
        return this.isPreset;
    }

    protected FileObject getProfiledFile() {
        return this.profiledFile;
    }

    protected Lookup.Provider getProject() {
        return this.project;
    }

    public static class CPUContents
    implements SettingsContainerPanel.Contents,
    ChangeListener {
        private CPUSettingsAdvancedPanel advancedSettingsPanel;
        private CPUSettingsBasicPanel basicSettingsPanel;
        private FileObject profiledFile;
        private ProfilingSettings settings;
        private Lookup.Provider project;
        private ProfilingSettingsSupport pss;
        private Collection<ChangeListener> changeListeners = new CopyOnWriteArraySet<ChangeListener>();
        private boolean internalChange = false;
        private boolean isPreset;
        private static final boolean useCPUTimer = true;

        public CPUContents() {
            this.basicSettingsPanel = new CPUSettingsBasicPanel();
            this.advancedSettingsPanel = new CPUSettingsAdvancedPanel();
            this.basicSettingsPanel.addChangeListener(this);
            this.advancedSettingsPanel.addChangeListener(this);
        }

        @Override
        public JPanel getAdvancedSettingsPanel() {
            return this.advancedSettingsPanel;
        }

        @Override
        public JPanel getBasicSettingsPanel() {
            return this.basicSettingsPanel;
        }

        public void setContext(Lookup.Provider project, FileObject profiledFile, boolean isAttach, boolean isModify) {
            this.project = project;
            this.pss = ProfilingSettingsSupport.get((Lookup.Provider)project);
            this.profiledFile = profiledFile;
        }

        @Override
        public float getProfilingOverhead() {
            if (this.settings == null) {
                return 0.0f;
            }
            this.synchronizeSettings();
            return this.pss.getProfilingOverhead(this.settings);
        }

        public void setSettings(ProfilingSettings settings) {
            this.settings = settings;
            this.isPreset = settings.isPreset();
            this.internalChange = true;
            this.basicSettingsPanel.setContext(this.project, SelectProfilingTask.getDefault().getPredefinedInstrFilterKeys(), new Runnable(){

                @Override
                public void run() {
                    CPUContents.this.synchronizeSettings();
                    ProfilingPointsDisplayer.displayProfilingPoints((Lookup.Provider)CPUContents.this.project, (ProfilingSettings)CPUContents.this.settings);
                }
            });
            this.basicSettingsPanel.setProfilingType(settings.getProfilingType());
            this.basicSettingsPanel.setRootMethods(settings.getInstrumentationRootMethods());
            this.basicSettingsPanel.setQuickFilter(settings.getQuickFilter());
            this.basicSettingsPanel.setInstrumentationFilter(settings.getSelectedInstrumentationFilter());
            this.basicSettingsPanel.setUseProfilingPoints(settings.useProfilingPoints() && this.project != null);
            if (!settings.isPreset()) {
                this.advancedSettingsPanel.enableAll();
            }
            this.advancedSettingsPanel.setProfilingType(settings.getProfilingType());
            this.advancedSettingsPanel.setCPUProfilingType(settings.getCPUProfilingType());
            this.advancedSettingsPanel.setSamplingFrequency(settings.getSamplingFrequency());
            this.advancedSettingsPanel.setSamplingInterval(settings.getSamplingInterval());
            this.advancedSettingsPanel.setExcludeThreadTime(settings.getExcludeWaitTime());
            this.advancedSettingsPanel.setProfileSpawnedThreads(settings.getInstrumentSpawnedThreads());
            this.advancedSettingsPanel.setUseCPUTimer(settings.getThreadCPUTimerOn(), true);
            this.advancedSettingsPanel.setInstrumentMethodInvoke(settings.getInstrumentMethodInvoke());
            this.advancedSettingsPanel.setInstrumentGettersSetters(settings.getInstrumentGetterSetterMethods());
            this.advancedSettingsPanel.setInstrumentEmptyMethods(settings.getInstrumentEmptyMethods());
            this.advancedSettingsPanel.setInstrumentationScheme(settings.getInstrScheme());
            this.advancedSettingsPanel.setProfiledThreadsLimit(settings.getNProfiledThreadsLimit());
            this.advancedSettingsPanel.setProfileFramework(settings.getProfileUnderlyingFramework());
            this.advancedSettingsPanel.setThreadsMonitoring(settings.getThreadsMonitoringEnabled());
            this.advancedSettingsPanel.setThreadsSampling(settings.getThreadsSamplingEnabled());
            if (settings.isPreset()) {
                this.advancedSettingsPanel.disableAll();
            }
            this.internalChange = false;
            this.fireSettingsChanged();
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this.changeListeners.add(listener);
        }

        public ProfilingSettings createFinalSettings() {
            ProfilingSettings finalSettings = ProfilingSettingsPresets.createCPUPreset((int)this.settings.getProfilingType());
            finalSettings.setIsPreset(this.settings.isPreset());
            finalSettings.setSettingsName(this.settings.getSettingsName());
            finalSettings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            finalSettings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            finalSettings.setCPUProfilingType(this.advancedSettingsPanel.getCPUProfilingType());
            finalSettings.setSamplingFrequency(this.advancedSettingsPanel.getSamplingFrequency());
            finalSettings.setSamplingInterval(this.advancedSettingsPanel.getSamplingInterval());
            finalSettings.setExcludeWaitTime(this.advancedSettingsPanel.getExcludeThreadTime());
            finalSettings.setProfileUnderlyingFramework(this.advancedSettingsPanel.getProfileFramework());
            finalSettings.setInstrumentSpawnedThreads(this.advancedSettingsPanel.getProfileSpawnedThreads());
            finalSettings.setThreadCPUTimerOn(this.advancedSettingsPanel.getUseCPUTimer());
            finalSettings.setInstrumentMethodInvoke(this.advancedSettingsPanel.getInstrumentMethodInvoke());
            finalSettings.setInstrumentGetterSetterMethods(this.advancedSettingsPanel.getInstrumentGettersSetters());
            finalSettings.setInstrumentEmptyMethods(this.advancedSettingsPanel.getInstrumentEmptyMethods());
            finalSettings.setInstrScheme(this.advancedSettingsPanel.getInstrumentationScheme());
            finalSettings.setNProfiledThreadsLimit(this.advancedSettingsPanel.getProfiledThreadsLimit());
            finalSettings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            finalSettings.setThreadsSamplingEnabled(this.advancedSettingsPanel.getThreadsSampling());
            if (finalSettings.getProfileUnderlyingFramework()) {
                finalSettings.setInstrumentationRootMethods(new ClientUtils.SourceCodeSelection[0]);
            } else if (finalSettings.getProfilingType() == 8) {
                finalSettings.setInstrumentationRootMethods(ProjectContentsSupport.get((Lookup.Provider)this.project).getProfilingRoots(this.profiledFile, ProjectUtilities.hasSubprojects((Lookup.Provider)this.project)));
            } else {
                finalSettings.setInstrumentationRootMethods(this.basicSettingsPanel.getRootMethods());
            }
            Object selectedFilter = this.basicSettingsPanel.getInstrumentationFilter();
            if (SelectProfilingTask.getDefault().isPredefinedFilter(selectedFilter)) {
                finalSettings.setSelectedInstrumentationFilter((Object)SelectProfilingTask.getDefault().getResolvedPredefinedFilter((SimpleFilter)selectedFilter));
            } else {
                finalSettings.setSelectedInstrumentationFilter(selectedFilter);
            }
            return finalSettings;
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.changeListeners.remove(listener);
        }

        public void reset() {
            this.settings = null;
            this.project = null;
            this.pss = null;
            this.profiledFile = null;
            this.isPreset = false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireSettingsChanged();
        }

        @Override
        public void synchronizeBasicAdvancedPanels() {
            if (this.basicSettingsPanel.getProfilingType() == 8) {
                this.advancedSettingsPanel.setEntireAppDefaults(this.isPreset);
            } else {
                this.advancedSettingsPanel.setPartOfAppDefaults(this.isPreset);
            }
            this.advancedSettingsPanel.setProfilingType(this.basicSettingsPanel.getProfilingType());
        }

        public void synchronizeSettings() {
            this.synchronizeBasicAdvancedPanels();
            this.settings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            this.settings.setInstrumentationRootMethods(this.basicSettingsPanel.getRootMethods());
            this.settings.setQuickFilter(this.basicSettingsPanel.getQuickFilter());
            this.settings.setSelectedInstrumentationFilter(this.basicSettingsPanel.getInstrumentationFilter());
            this.settings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            this.settings.setCPUProfilingType(this.advancedSettingsPanel.getCPUProfilingType());
            this.settings.setSamplingFrequency(this.advancedSettingsPanel.getSamplingFrequency());
            this.settings.setSamplingInterval(this.advancedSettingsPanel.getSamplingInterval());
            this.settings.setExcludeWaitTime(this.advancedSettingsPanel.getExcludeThreadTime());
            this.settings.setProfileUnderlyingFramework(this.advancedSettingsPanel.getProfileFramework());
            this.settings.setInstrumentSpawnedThreads(this.advancedSettingsPanel.getProfileSpawnedThreads());
            this.settings.setThreadCPUTimerOn(this.advancedSettingsPanel.getUseCPUTimer());
            this.settings.setInstrumentMethodInvoke(this.advancedSettingsPanel.getInstrumentMethodInvoke());
            this.settings.setInstrumentGetterSetterMethods(this.advancedSettingsPanel.getInstrumentGettersSetters());
            this.settings.setInstrumentEmptyMethods(this.advancedSettingsPanel.getInstrumentEmptyMethods());
            this.settings.setInstrScheme(this.advancedSettingsPanel.getInstrumentationScheme());
            this.settings.setNProfiledThreadsLimit(this.advancedSettingsPanel.getProfiledThreadsLimit());
            this.settings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            this.settings.setThreadsSamplingEnabled(this.advancedSettingsPanel.getThreadsSampling());
        }

        private void fireSettingsChanged() {
            if (!this.internalChange) {
                for (ChangeListener listener : this.changeListeners) {
                    listener.stateChanged(new ChangeEvent(this));
                }
            }
        }
    }

    public static class MemoryContents
    implements SettingsContainerPanel.Contents,
    ChangeListener {
        private FileObject profiledFile;
        private MemorySettingsAdvancedPanel advancedSettingsPanel = new MemorySettingsAdvancedPanel();
        private MemorySettingsBasicPanel basicSettingsPanel = new MemorySettingsBasicPanel();
        private ProfilingSettings settings;
        private Lookup.Provider project;
        private ProfilingSettingsSupport pss;
        private Collection<ChangeListener> changeListeners = new CopyOnWriteArraySet<ChangeListener>();
        private boolean enableOverride;
        private boolean internalChange = false;
        private boolean isAttach;
        private boolean isModify;
        private boolean isPreset;

        public MemoryContents() {
            this.basicSettingsPanel = new MemorySettingsBasicPanel();
            this.advancedSettingsPanel = new MemorySettingsAdvancedPanel();
            this.basicSettingsPanel.addChangeListener(this);
            this.advancedSettingsPanel.addChangeListener(this);
        }

        @Override
        public JPanel getAdvancedSettingsPanel() {
            return this.advancedSettingsPanel;
        }

        @Override
        public JPanel getBasicSettingsPanel() {
            return this.basicSettingsPanel;
        }

        public void setContext(Lookup.Provider project, FileObject profiledFile, boolean isAttach, boolean isModify) {
            this.project = project;
            this.pss = ProfilingSettingsSupport.get((Lookup.Provider)project);
            this.profiledFile = profiledFile;
            this.enableOverride = this.enableOverride;
            this.isAttach = isAttach;
            this.isModify = isModify;
        }

        @Override
        public float getProfilingOverhead() {
            if (this.settings == null) {
                return 0.0f;
            }
            this.synchronizeSettings();
            return this.pss.getProfilingOverhead(this.settings);
        }

        public void setSettings(ProfilingSettings settings) {
            this.settings = settings;
            this.isPreset = settings.isPreset();
            this.internalChange = true;
            SelectProfilingTask.getDefault().enableSubmitButton();
            this.basicSettingsPanel.setContext(this.project, new Runnable(){

                @Override
                public void run() {
                    MemoryContents.this.synchronizeSettings();
                    ProfilingPointsDisplayer.displayProfilingPoints((Lookup.Provider)MemoryContents.this.project, (ProfilingSettings)MemoryContents.this.settings);
                }
            });
            this.basicSettingsPanel.setProfilingType(settings.getProfilingType());
            this.basicSettingsPanel.setTrackEvery(settings.getAllocTrackEvery());
            this.basicSettingsPanel.setRecordStackTrace(settings.getAllocStackTraceLimit() != 0);
            this.basicSettingsPanel.setUseProfilingPoints(settings.useProfilingPoints() && this.project != null);
            if (!settings.isPreset()) {
                this.advancedSettingsPanel.enableAll();
            }
            this.advancedSettingsPanel.setAllocStackTraceLimit(settings.getAllocStackTraceLimit());
            this.advancedSettingsPanel.setRunGC(settings.getRunGCOnGetResultsInMemoryProfiling());
            this.advancedSettingsPanel.setThreadsMonitoring(settings.getThreadsMonitoringEnabled());
            this.advancedSettingsPanel.setThreadsSampling(settings.getThreadsSamplingEnabled());
            if (settings.isPreset()) {
                this.advancedSettingsPanel.disableAll();
            }
            this.internalChange = false;
            this.fireSettingsChanged();
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this.changeListeners.add(listener);
        }

        public ProfilingSettings createFinalSettings() {
            ProfilingSettings finalSettings = ProfilingSettingsPresets.createMemoryPreset();
            finalSettings.setIsPreset(this.settings.isPreset());
            finalSettings.setSettingsName(this.settings.getSettingsName());
            finalSettings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            finalSettings.setAllocTrackEvery(this.basicSettingsPanel.getTrackEvery());
            finalSettings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            finalSettings.setAllocStackTraceLimit(this.basicSettingsPanel.getRecordStackTrace() ? this.advancedSettingsPanel.getAllocStackTraceLimit() : 0);
            finalSettings.setRunGCOnGetResultsInMemoryProfiling(this.advancedSettingsPanel.getRunGC());
            finalSettings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            finalSettings.setThreadsSamplingEnabled(this.advancedSettingsPanel.getThreadsSampling());
            return finalSettings;
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.changeListeners.remove(listener);
        }

        public void reset() {
            this.settings = null;
            this.project = null;
            this.pss = null;
            this.profiledFile = null;
            this.enableOverride = false;
            this.isAttach = false;
            this.isModify = false;
            this.isPreset = false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireSettingsChanged();
        }

        @Override
        public void synchronizeBasicAdvancedPanels() {
            boolean recordStackTrace = this.basicSettingsPanel.getRecordStackTrace();
            this.advancedSettingsPanel.setRecordStackTrace(recordStackTrace);
            this.advancedSettingsPanel.updateRunGC(this.basicSettingsPanel.getProfilingType() == 2);
        }

        public void synchronizeSettings() {
            this.synchronizeBasicAdvancedPanels();
            this.settings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            this.settings.setAllocTrackEvery(this.basicSettingsPanel.getTrackEvery());
            this.settings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            this.settings.setAllocStackTraceLimit(this.basicSettingsPanel.getRecordStackTrace() ? this.advancedSettingsPanel.getAllocStackTraceLimit() : 0);
            this.settings.setRunGCOnGetResultsInMemoryProfiling(this.advancedSettingsPanel.getRunGC());
            this.settings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            this.settings.setThreadsSamplingEnabled(this.advancedSettingsPanel.getThreadsSampling());
        }

        private void fireSettingsChanged() {
            if (!this.internalChange) {
                for (ChangeListener listener : this.changeListeners) {
                    listener.stateChanged(new ChangeEvent(this));
                }
            }
        }
    }

    public static class MonitorContents
    implements SettingsContainerPanel.Contents,
    ChangeListener {
        private FileObject profiledFile;
        private JPanel advancedSettingsPanel;
        private MonitorSettingsBasicPanel basicSettingsPanel;
        private ProfilingSettings settings;
        private Lookup.Provider project;
        private ProfilingSettingsSupport pss;
        private Collection<ChangeListener> changeListeners = new CopyOnWriteArraySet<ChangeListener>();
        private boolean internalChange = false;
        private boolean isAttach;
        private boolean isModify;
        private boolean isPreset;

        public MonitorContents() {
            this.basicSettingsPanel = new MonitorSettingsBasicPanel();
            this.advancedSettingsPanel = new JPanel();
            this.advancedSettingsPanel.setVisible(false);
            this.basicSettingsPanel.addChangeListener(this);
        }

        @Override
        public JPanel getAdvancedSettingsPanel() {
            return this.advancedSettingsPanel;
        }

        @Override
        public JPanel getBasicSettingsPanel() {
            return this.basicSettingsPanel;
        }

        public void setContext(Lookup.Provider project, FileObject profiledFile, boolean isAttach, boolean isModify) {
            this.project = project;
            this.pss = ProfilingSettingsSupport.get((Lookup.Provider)project);
            this.profiledFile = profiledFile;
            this.isAttach = isAttach;
            this.isModify = isModify;
        }

        @Override
        public float getProfilingOverhead() {
            if (this.settings == null) {
                return 0.0f;
            }
            this.synchronizeSettings();
            return this.pss.getProfilingOverhead(this.settings);
        }

        public void setSettings(ProfilingSettings settings) {
            this.settings = settings;
            this.isPreset = settings.isPreset();
            this.internalChange = true;
            SelectProfilingTask.getDefault().enableSubmitButton();
            this.basicSettingsPanel.setThreadsMonitoring(settings.getThreadsMonitoringEnabled());
            this.basicSettingsPanel.setThreadsSampling(settings.getThreadsSamplingEnabled());
            this.internalChange = false;
            this.fireSettingsChanged();
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this.changeListeners.add(listener);
        }

        public ProfilingSettings createFinalSettings() {
            ProfilingSettings finalSettings = ProfilingSettingsPresets.createMonitorPreset();
            finalSettings.setIsPreset(this.settings.isPreset());
            finalSettings.setSettingsName(this.settings.getSettingsName());
            finalSettings.setThreadsMonitoringEnabled(this.basicSettingsPanel.getThreadsMonitoring());
            finalSettings.setThreadsSamplingEnabled(this.basicSettingsPanel.getThreadsSampling());
            return finalSettings;
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.changeListeners.remove(listener);
        }

        public void reset() {
            this.settings = null;
            this.project = null;
            this.pss = null;
            this.profiledFile = null;
            this.isAttach = false;
            this.isModify = false;
            this.isPreset = false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireSettingsChanged();
        }

        @Override
        public void synchronizeBasicAdvancedPanels() {
        }

        public void synchronizeSettings() {
            this.synchronizeBasicAdvancedPanels();
            this.settings.setThreadsMonitoringEnabled(this.basicSettingsPanel.getThreadsMonitoring());
            this.settings.setThreadsSamplingEnabled(this.basicSettingsPanel.getThreadsSampling());
        }

        private void fireSettingsChanged() {
            if (!this.internalChange) {
                for (ChangeListener listener : this.changeListeners) {
                    listener.stateChanged(new ChangeEvent(this));
                }
            }
        }
    }
}

