/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.web.beans.api.model.DependencyInjectionResult;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.impl.model.AbstractObjectProvider;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.BindingQualifier;
import org.netbeans.modules.web.beans.impl.model.DecoratorInterceptorLogic;
import org.netbeans.modules.web.beans.impl.model.MemberCheckerFilter;
import org.netbeans.modules.web.beans.impl.model.PackagingFilter;
import org.netbeans.modules.web.beans.impl.model.ResultLookupStrategy;
import org.netbeans.modules.web.beans.impl.model.StereotypeChecker;
import org.netbeans.modules.web.beans.impl.model.StereotypedObject;
import org.netbeans.modules.web.beans.impl.model.StereotypedObjectProvider;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.openide.util.NbBundle;

public class WebBeansModelProviderImpl
extends DecoratorInterceptorLogic {
    private AtomicBoolean isDirty = new AtomicBoolean(true);
    private volatile boolean isIndexListenerAdded;
    private List<ElementHandle<? extends Element>> myNamedElement;

    protected WebBeansModelProviderImpl(WebBeansModelImplementation model) {
        super(model);
    }

    @Override
    public CompilationController getCompilationController() {
        return this.getModel().getHelper().getCompilationController();
    }

    @Override
    public TypeMirror resolveType(String fqn) {
        return this.getModel().getHelper().resolveType(fqn);
    }

    @Override
    public DependencyInjectionResult lookupInjectables(VariableElement element, DeclaredType parentType) {
        TypeMirror type = this.getParameterType(element, null, "javax.enterprise.inject.Instance");
        if (type != null) {
            return this.lookupInjectables(element, parentType, ResultLookupStrategy.MULTI_LOOKUP_STRATEGY);
        }
        return this.lookupInjectables(element, parentType, ResultLookupStrategy.SINGLE_LOOKUP_STRATEGY);
    }

    @Override
    public boolean isInjectionPoint(VariableElement element) throws InjectionPointDefinitionError {
        Element parent = element.getEnclosingElement();
        if (parent instanceof TypeElement) {
            List<? extends AnnotationMirror> annotations = this.getModel().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
            return this.getModel().getHelper().hasAnnotation(annotations, "javax.inject.Inject");
        }
        if (parent instanceof ExecutableElement) {
            return this.isMethodParameterInjection(element, (ExecutableElement)parent);
        }
        return false;
    }

    @Override
    public List<AnnotationMirror> getQualifiers(Element element, boolean all) {
        final boolean event = this.getParameterType(element, null, "javax.enterprise.event.Event") != null;
        final LinkedHashSet result = new LinkedHashSet();
        final AnnotationObjectProvider.AnnotationHandleStrategy strategy = new AnnotationObjectProvider.AnnotationHandleStrategy(){

            @Override
            public void handleAnnotation(AnnotationMirror annotationMirror, TypeElement annotation) {
                result.add(annotationMirror);
            }
        };
        AnnotationObjectProvider.findQualifiers(element, this.getModel().getHelper(), event, strategy);
        boolean isType = element instanceof TypeElement;
        boolean isMethod = element instanceof ExecutableElement;
        if (all && (isType || isMethod)) {
            AnnotationObjectProvider.SpecializeVisitor visitor = new AnnotationObjectProvider.SpecializeVisitor(){

                @Override
                public boolean visit(ExecutableElement overridenElement) {
                    this.collectQualifiers(overridenElement);
                    return false;
                }

                @Override
                public boolean visit(TypeElement superElement) {
                    this.collectQualifiers(superElement);
                    return false;
                }

                private void collectQualifiers(Element element) {
                    AnnotationObjectProvider.findQualifiers(element, WebBeansModelProviderImpl.this.getModel().getHelper(), event, strategy);
                }
            };
            if (isType) {
                AnnotationObjectProvider.visitSpecializes((TypeElement)element, this.getModel().getHelper(), visitor);
            } else if (isMethod) {
                MemberCheckerFilter.visitSpecializes((ExecutableElement)element, this.getModel().getHelper(), visitor);
            }
        }
        return new ArrayList<AnnotationMirror>(result);
    }

    @Override
    public boolean hasImplicitDefaultQualifier(Element element) {
        boolean event = this.getParameterType(element, null, "javax.enterprise.event.Event") != null;
        Set<String> qualifiers = AnnotationObjectProvider.getQualifiers(element, this.getModel().getHelper(), event);
        if (qualifiers.size() == 1) {
            String qualifier = qualifiers.iterator().next();
            return qualifier.equals("javax.inject.Named");
        }
        return qualifiers.size() == 0;
    }

    @Override
    public String getName(Element element) {
        String name = this.inspectSpecializes(element);
        if (name != null) {
            return name;
        }
        List<AnnotationMirror> allStereotypes = WebBeansModelProviderImpl.getAllStereotypes(element, this.getModel().getHelper().getHelper());
        for (AnnotationMirror annotationMirror : allStereotypes) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            TypeElement annotation = (TypeElement)annotationType.asElement();
            if (!AnnotationObjectProvider.hasAnnotation(annotation, "javax.inject.Named", this.getModel().getHelper())) continue;
            return this.getNamedName(element, null);
        }
        return null;
    }

    @Override
    public List<Element> getNamedElements() {
        List<Element> result;
        boolean dirty = this.isDirty.getAndSet(false);
        if (!this.isIndexListenerAdded) {
            this.addIndexListener();
        }
        if (!dirty) {
            result = this.getCachedNamedElements();
            if (!this.isDirty.get()) {
                return result;
            }
        }
        result = new LinkedList<Element>();
        Collection objects = this.getModel().getNamedManager().getObjects();
        for (BindingQualifier named : objects) {
            Element element = named.getTypeElement();
            if (element == null || element.getKind() == ElementKind.ANNOTATION_TYPE) continue;
            result.add(element);
        }
        List<Element> members = AbstractObjectProvider.getNamedMembers(this.getModel().getHelper());
        for (Element element : members) {
            if (element == null || element.getKind() != ElementKind.METHOD) continue;
            Set<Element> childSpecializes = this.getChildSpecializes(element, this.getModel());
            result.addAll(childSpecializes);
        }
        result.addAll(members);
        Set<String> stereotypeNames = this.getModel().adjustStereotypesManagers();
        for (String stereotype : stereotypeNames) {
            PersistentObjectManager<StereotypedObject> manager = this.getModel().getStereotypedManager(stereotype);
            Collection beans = manager.getObjects();
            for (StereotypedObject bean : beans) {
                TypeElement element = bean.getTypeElement();
                if (element == null || element.getKind() == ElementKind.ANNOTATION_TYPE) continue;
                result.add(element);
            }
            List<Element> stereotypedMembers = StereotypedObjectProvider.getAnnotatedMembers(stereotype, this.getModel().getHelper());
            result.addAll(stereotypedMembers);
        }
        PackagingFilter filter = new PackagingFilter(this.getModel());
        filter.filter(result);
        this.setCachedResult(result);
        return result;
    }

    public static List<AnnotationMirror> getAllStereotypes(Element element, AnnotationHelper helper) {
        HashSet<AnnotationMirror> result = new HashSet<AnnotationMirror>();
        StereotypeChecker checker = new StereotypeChecker(helper);
        WebBeansModelProviderImpl.doGetStereotypes(element, result, checker, helper);
        return new ArrayList<AnnotationMirror>(result);
    }

    public static boolean isStereotype(TypeElement annotationElement, StereotypeChecker checker) {
        checker.init(annotationElement);
        boolean result = checker.check();
        checker.clean();
        return result;
    }

    protected DependencyInjectionResult lookupInjectables(VariableElement element, DeclaredType parentType, ResultLookupStrategy strategy) {
        Element parent = element.getEnclosingElement();
        if (parent instanceof TypeElement) {
            return this.findVariableInjectable(element, parentType, strategy);
        }
        if (parent instanceof ExecutableElement) {
            return this.findParameterInjectable(element, parentType, strategy);
        }
        return null;
    }

    private boolean isMethodParameterInjection(VariableElement element, ExecutableElement parent) throws InjectionPointDefinitionError {
        List<? extends AnnotationMirror> annotations = this.getModel().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(parent);
        if (this.isDisposeParameter(element, parent, annotations)) {
            return true;
        }
        boolean hasObserves = AnnotationObjectProvider.hasAnnotation(element, "javax.enterprise.event.Observes", this.getModel().getHelper());
        if (!hasObserves && this.isObservesParameter(element, parent, annotations)) {
            return true;
        }
        return this.getModel().getHelper().hasAnnotation(annotations, "javax.inject.Inject") || this.getModel().getHelper().hasAnnotation(annotations, "javax.enterprise.inject.Produces");
    }

    private void setCachedResult(List<Element> list) {
        this.myNamedElement = new ArrayList<ElementHandle<? extends Element>>(list.size());
        for (Element element : list) {
            this.myNamedElement.add((ElementHandle<? extends Element>)ElementHandle.create((Element)element));
        }
    }

    private List<Element> getCachedNamedElements() {
        ArrayList<Element> result = new ArrayList<Element>(this.myNamedElement.size());
        for (ElementHandle<? extends Element> handle : this.myNamedElement) {
            Element element = handle.resolve((CompilationInfo)this.getModel().getHelper().getCompilationController());
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    private void addIndexListener() {
        this.isIndexListenerAdded = true;
        AnnotationModelHelper helper = this.getModel().getHelper();
        helper.getClasspathInfo().getClassIndex().addClassIndexListener(new ClassIndexListener(){

            public void typesAdded(TypesEvent event) {
                this.setDirty();
            }

            public void typesRemoved(TypesEvent event) {
                this.setDirty();
            }

            public void typesChanged(TypesEvent event) {
                this.setDirty();
            }

            public void rootsAdded(RootsEvent event) {
                this.setDirty();
            }

            public void rootsRemoved(RootsEvent event) {
                this.setDirty();
            }

            private void setDirty() {
                WebBeansModelProviderImpl.this.isDirty.set(true);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String inspectSpecializes(Element element) {
        if (element instanceof TypeElement) {
            String name = this.doGetName(element, element);
            if (name != null) {
                return name;
            }
            TypeElement superElement = AnnotationObjectProvider.checkSuper((TypeElement)element, "javax.inject.Named", this.getModel().getHelper());
            if (superElement == null) return null;
            return this.doGetName(element, superElement);
        }
        if (!(element instanceof ExecutableElement)) return this.doGetName(element, element);
        String name = this.doGetName(element, element);
        if (name != null) return name;
        Element specialized = MemberCheckerFilter.getSpecialized((ExecutableElement)element, this.getModel(), "javax.inject.Named");
        if (specialized == null) return null;
        return this.doGetName(element, specialized);
    }

    private String doGetName(Element original, Element element) {
        List<? extends AnnotationMirror> annotations = this.getModel().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : annotations) {
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement annotationElement = (TypeElement)type.asElement();
            if (!"javax.inject.Named".contentEquals(annotationElement.getQualifiedName())) continue;
            return this.getNamedName(original, annotationMirror);
        }
        return null;
    }

    private static void doGetStereotypes(Element element, Set<AnnotationMirror> result, final StereotypeChecker checker, AnnotationHelper helper) {
        DecoratorInterceptorLogic.TransitiveAnnotationHandler handler = new DecoratorInterceptorLogic.TransitiveAnnotationHandler(){

            @Override
            public boolean proceed(Element annotatedElement, TypeElement element, boolean isTargetAnnotation) {
                return isTargetAnnotation;
            }

            @Override
            public boolean isTargetAnotation(TypeElement element) {
                return WebBeansModelProviderImpl.isStereotype(element, checker);
            }
        };
        WebBeansModelProviderImpl.transitiveVisitAnnotatedElements(element, result, helper, handler);
    }

    private String getNamedName(Element element, AnnotationMirror namedAnnotation) {
        String name;
        if (namedAnnotation != null) {
            AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getModel().getHelper());
            parser.expectString("value", null);
            ParseResult result = parser.parse(namedAnnotation);
            String name2 = (String)result.get("value", String.class);
            if (name2 != null) {
                return name2;
            }
        }
        if (element instanceof TypeElement) {
            name = element.getSimpleName().toString();
            if (name.length() > 0) {
                return Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            return name;
        }
        if (element instanceof VariableElement) {
            return element.getSimpleName().toString();
        }
        if (element instanceof ExecutableElement) {
            name = element.getSimpleName().toString();
            if (name.startsWith("get") && name.length() > 3) {
                return this.getPropertyName(name, 3);
            }
            if (name.startsWith("is") && name.length() > 2) {
                return this.getPropertyName(name, 2);
            }
            return name;
        }
        return null;
    }

    private String getPropertyName(String methodName, int prefixLength) {
        String propertyName = methodName.substring(prefixLength);
        String propertyNameWithoutFL = propertyName.substring(1);
        if (propertyNameWithoutFL.length() > 0 && propertyNameWithoutFL.equals(propertyNameWithoutFL.toUpperCase())) {
            return propertyName;
        }
        return Character.toLowerCase(propertyName.charAt(0)) + propertyNameWithoutFL;
    }

    private boolean isObservesParameter(VariableElement element, ExecutableElement method, List<? extends AnnotationMirror> annotations) throws InjectionPointDefinitionError {
        List<? extends VariableElement> parameters = method.getParameters();
        boolean observesFound = false;
        for (VariableElement variableElement : parameters) {
            if (!AnnotationObjectProvider.hasAnnotation(variableElement, "javax.enterprise.event.Observes", this.getModel().getHelper())) continue;
            if (observesFound) {
                throw new InjectionPointDefinitionError(method, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_MultipleObserves", (Object)method.getSimpleName()));
            }
            observesFound = true;
        }
        if (!observesFound) {
            return false;
        }
        String badAnnotation = this.checkInjectProducers(annotations);
        if (badAnnotation != null) {
            throw new InjectionPointDefinitionError(method, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_ObserverHasInjectOrProduces", (Object)method.getSimpleName(), (Object)badAnnotation));
        }
        return observesFound;
    }

    private boolean isDisposeParameter(VariableElement element, ExecutableElement method, List<? extends AnnotationMirror> annotations) throws InjectionPointDefinitionError {
        List<? extends VariableElement> parameters = method.getParameters();
        boolean disposeFound = false;
        boolean observesFound = false;
        for (VariableElement variableElement : parameters) {
            if (AnnotationObjectProvider.hasAnnotation(variableElement, "javax.enterprise.inject.Disposes", this.getModel().getHelper())) {
                if (disposeFound) {
                    throw new InjectionPointDefinitionError(method, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_MultipleDisposes", (Object)method.getSimpleName()));
                }
                disposeFound = true;
            }
            if (!AnnotationObjectProvider.hasAnnotation(variableElement, "javax.enterprise.event.Observes", this.getModel().getHelper())) continue;
            observesFound = true;
        }
        if (!disposeFound) {
            return false;
        }
        if (observesFound) {
            throw new InjectionPointDefinitionError(method, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_DisposesHasObserves", (Object)method.getSimpleName()));
        }
        String badAnnotation = this.checkInjectProducers(annotations);
        if (badAnnotation != null) {
            throw new InjectionPointDefinitionError(method, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_DisposesHasInjectOrProduces", (Object)method.getSimpleName(), (Object)badAnnotation));
        }
        return disposeFound;
    }

    private String checkInjectProducers(List<? extends AnnotationMirror> annotations) {
        if (this.getModel().getHelper().hasAnnotation(annotations, "javax.inject.Inject")) {
            return "javax.inject.Inject";
        }
        if (this.getModel().getHelper().hasAnnotation(annotations, "javax.enterprise.inject.Produces")) {
            return "javax.enterprise.inject.Produces";
        }
        return null;
    }
}

