/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;

public abstract class RuntimeRetentionAnalyzer {
    private AnnotationHelper myHelper;
    private Element myElement;

    public void init(Element element, AnnotationHelper helper) {
        this.myHelper = helper;
        this.myElement = element;
    }

    public void init(Element element, CompilationInfo info) {
        this.init(element, new AnnotationHelper(info));
    }

    public boolean hasRuntimeRetention() {
        Map types = this.getHelper().getAnnotationsByType(this.getElement().getAnnotationMirrors());
        AnnotationMirror retention = (AnnotationMirror)types.get(Retention.class.getCanonicalName());
        if (retention == null) {
            this.handleNoRetention();
            return false;
        }
        AnnotationParser parser = AnnotationParser.create((AnnotationHelper)this.getHelper());
        parser.expectEnumConstant("value", this.getHelper().resolveType(RetentionPolicy.class.getCanonicalName()), null);
        String retentionPolicy = (String)parser.parse(retention).get("value", String.class);
        return RetentionPolicy.RUNTIME.toString().equals(retentionPolicy);
    }

    protected abstract void handleNoRetention();

    protected Element getElement() {
        return this.myElement;
    }

    protected AnnotationHelper getHelper() {
        return this.myHelper;
    }
}

