/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.ElementAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.method.AnnotationsAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.method.DelegateMethodAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.method.ProducerMethodAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.method.TypedMethodAnalyzer;

public class MethodElementAnalyzer
implements ElementAnalyzer {
    private static final List<MethodAnalyzer> ANALYZERS = new LinkedList<MethodAnalyzer>();

    @Override
    public void analyze(Element element, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        ExecutableElement method = (ExecutableElement)element;
        TypeMirror methodType = result.getInfo().getTypes().asMemberOf((DeclaredType)parent.asType(), method);
        if (methodType instanceof ExecutableType) {
            if (cancel.get()) {
                return;
            }
            TypeMirror returnType = ((ExecutableType)methodType).getReturnType();
            for (MethodAnalyzer analyzer : ANALYZERS) {
                if (cancel.get()) {
                    return;
                }
                analyzer.analyze(method, returnType, parent, cancel, result);
            }
        }
    }

    static {
        ANALYZERS.add(new TypedMethodAnalyzer());
        ANALYZERS.add(new AnnotationsAnalyzer());
        ANALYZERS.add(new DelegateMethodAnalyzer());
        ANALYZERS.add(new ProducerMethodAnalyzer());
    }

    public static interface MethodAnalyzer {
        public void analyze(ExecutableElement var1, TypeMirror var2, TypeElement var3, AtomicBoolean var4, CdiAnalysisResult var5);
    }
}

