/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.beans.MetaModelSupport;
import org.netbeans.modules.web.beans.analysis.AbstractAnalysisTask;
import org.netbeans.modules.web.beans.analysis.CdiEditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ClassModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.FieldModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.MethodModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.hints.EditorAnnotationsHelper;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;

public class WebBeansAnalysisTask
extends AbstractAnalysisTask {
    private static final Logger LOG = Logger.getLogger(WebBeansAnalysisTask.class.getName());
    private CdiEditorAwareJavaSourceTaskFactory myFactory;
    private static final Map<ElementKind, ModelAnalyzer> ANALIZERS = new HashMap<ElementKind, ModelAnalyzer>();

    public WebBeansAnalysisTask(CdiEditorAwareJavaSourceTaskFactory factory) {
        this.myFactory = factory;
    }

    protected ModelAnalyzer.Result createResult(CompilationInfo compInfo) {
        return new ModelAnalyzer.Result(compInfo, this.myFactory);
    }

    @Override
    protected ModelAnalyzer.Result getResult() {
        return (ModelAnalyzer.Result)super.getResult();
    }

    protected MetadataModel<WebBeansModel> getModel(CompilationInfo compInfo) {
        Project project = FileOwnerQuery.getOwner((FileObject)compInfo.getFileObject());
        if (project == null) {
            return null;
        }
        MetaModelSupport support = new MetaModelSupport(project);
        return support.getMetaModel();
    }

    @Override
    List<ErrorDescription> getProblems() {
        return this.getResult().getProblems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run(final CompilationInfo compInfo) {
        MetadataModel<WebBeansModel> metaModel;
        this.setResult(this.createResult(compInfo));
        List types = compInfo.getTopLevelElements();
        final ArrayList<ElementHandle> handles = new ArrayList<ElementHandle>(1);
        for (TypeElement typeElement : types) {
            if (this.isCancelled()) break;
            handles.add(ElementHandle.create((Element)typeElement));
        }
        if ((metaModel = this.getModel(compInfo)) == null) {
            return;
        }
        try {
            metaModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                public Void run(WebBeansModel model) throws Exception {
                    CompilationController controller = model.getCompilationController();
                    for (ElementHandle handle : handles) {
                        TypeElement type = (TypeElement)handle.resolve((CompilationInfo)controller);
                        if (type == null) continue;
                        WebBeansAnalysisTask.this.analyzeType(type, null, model, compInfo);
                    }
                    return null;
                }
            });
        }
        catch (MetadataModelException e) {
            LOG.log(Level.INFO, null, e);
        }
        catch (IOException e) {
            LOG.log(Level.INFO, null, e);
        }
        finally {
            EditorAnnotationsHelper helper = EditorAnnotationsHelper.getInstance(this.getResult());
            if (helper == null) {
                return;
            }
            helper.publish(this.getResult());
        }
    }

    private void analyzeType(TypeElement typeElement, TypeElement parent, WebBeansModel model, CompilationInfo info) {
        ElementKind kind = typeElement.getKind();
        ModelAnalyzer analyzer = ANALIZERS.get((Object)kind);
        if (analyzer != null) {
            analyzer.analyze(typeElement, parent, model, this.getCancel(), this.getResult());
        }
        if (this.isCancelled()) {
            return;
        }
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        List<TypeElement> types = ElementFilter.typesIn(enclosedElements);
        for (TypeElement innerType : types) {
            if (innerType == null) continue;
            this.analyzeType(innerType, typeElement, model, info);
        }
        HashSet<? extends Element> enclosedSet = new HashSet<Element>(enclosedElements);
        enclosedSet.removeAll(types);
        for (Element element : enclosedSet) {
            if (element == null) continue;
            this.analyze(typeElement, model, element, info);
        }
    }

    private void analyze(TypeElement typeElement, WebBeansModel model, Element element, CompilationInfo info) {
        if (this.isCancelled()) {
            return;
        }
        ModelAnalyzer analyzer = ANALIZERS.get((Object)element.getKind());
        if (analyzer == null) {
            return;
        }
        analyzer.analyze(element, typeElement, model, this.getCancel(), this.getResult());
    }

    static {
        ANALIZERS.put(ElementKind.CLASS, new ClassModelAnalyzer());
        ANALIZERS.put(ElementKind.FIELD, new FieldModelAnalyzer());
        ANALIZERS.put(ElementKind.METHOD, new MethodModelAnalyzer());
        ANALIZERS.put(ElementKind.ANNOTATION_TYPE, new AnnotationModelAnalyzer());
    }
}

