/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijdbc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.framework.BundleContext;
import org.osgi.service.jdbc.DataSourceFactory;

public class DataSourceFactoryImpl
implements DataSourceFactory {
    private Dictionary header;
    private BundleContext driverBundleContext;
    private static final Logger logger = Logger.getLogger(DataSourceFactoryImpl.class.getPackage().getName());

    public DataSourceFactoryImpl(BundleContext context) {
        this.header = context.getBundle().getHeaders();
        this.driverBundleContext = context;
    }

    public DataSource createDataSource(Properties props) throws SQLException {
        String dataSourceClass = (String)this.header.get("javax.sql.DataSource".replace('.', '_'));
        try {
            Class dsClass = this.driverBundleContext.getBundle().loadClass(dataSourceClass);
            DataSource ds = (DataSource)dsClass.newInstance();
            this.populateBean(props, dsClass, ds);
            return ds;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        String cpdsClassName = (String)this.header.get("javax.sql.ConnectionPoolDataSource".replace('.', '_'));
        try {
            Class cpdsClass = this.driverBundleContext.getBundle().loadClass(cpdsClassName);
            ConnectionPoolDataSource cpds = (ConnectionPoolDataSource)cpdsClass.newInstance();
            this.populateBean(props, cpdsClass, cpds);
            return cpds;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        String xadsClassName = (String)this.header.get("javax.sql.XADataSource".replace('.', '_'));
        try {
            Class xadsClass = this.driverBundleContext.getBundle().loadClass(xadsClassName);
            XADataSource xads = (XADataSource)xadsClass.newInstance();
            this.populateBean(props, xadsClass, xads);
            return xads;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public Driver createDriver(Properties props) throws SQLException {
        String driverClassName = (String)this.header.get("java.sql.Driver".replace('.', '_'));
        try {
            Class driverClass = this.driverBundleContext.getBundle().loadClass(driverClassName);
            Driver driver = (Driver)driverClass.newInstance();
            this.populateBean(props, driverClass, driver);
            Class.forName(driverClassName, false, driverClass.getClassLoader());
            return driver;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateBean(Properties properties, Class clazz, Object object) throws IntrospectionException, IllegalAccessException, InvocationTargetException, SQLException {
        if (properties == null) {
            return;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        Set<Object> keys = properties.keySet();
        for (String string : keys) {
            String value = properties.getProperty(string);
            boolean propertyFound = false;
            for (PropertyDescriptor desc : propertyDescriptors) {
                if (!desc.getName().equalsIgnoreCase(string)) continue;
                String type = desc.getPropertyType().getName();
                Object result = null;
                if (type == null) throw new SQLException("Unable to find the type of property [ " + string + " ]");
                type = type.toUpperCase();
                try {
                    if (type.endsWith("INT") || type.endsWith("INTEGER")) {
                        result = Integer.valueOf(value);
                    } else if (type.endsWith("LONG")) {
                        result = Long.valueOf(value);
                    } else if (type.endsWith("DOUBLE")) {
                        result = Double.valueOf(value);
                    } else if (type.endsWith("FLOAT")) {
                        result = Float.valueOf(value);
                    } else if (type.endsWith("CHAR") || type.endsWith("CHARACTER")) {
                        result = Character.valueOf(value.charAt(0));
                    } else if (type.endsWith("SHORT")) {
                        result = Short.valueOf(value);
                    } else if (type.endsWith("BYTE")) {
                        result = Byte.valueOf(value);
                    } else if (type.endsWith("BOOLEAN")) {
                        result = Boolean.valueOf(value);
                    } else if (type.endsWith("STRING")) {
                        result = value;
                    }
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
                Method setter = desc.getWriteMethod();
                if (setter == null) throw new SQLException("Unable to find the setter method for property [ " + string + " ]");
                propertyFound = true;
                DataSourceFactoryImpl.debug("invoking setter method [" + setter.getName() + "], value [" + result + "]");
                setter.invoke(object, result);
                break;
            }
            if (propertyFound) continue;
            throw new SQLException("No such property (" + string + ") in " + clazz.getName());
        }
    }

    public void preDestroy() {
        DataSourceFactoryImpl.debug("predestroy() called");
    }

    private static void debug(String s) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[osgi-jdbc] : " + s);
        }
    }
}

