/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.InvokeOperationCookie;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.actions.CompilerTask;
import org.netbeans.modules.websvc.core.jaxws.actions.DispatchClientMethodGenerator;
import org.netbeans.modules.websvc.core.jaxws.actions.DispatchCompilerTask;
import org.netbeans.modules.websvc.core.jaxws.actions.InsertTask;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsClientMethodGenerator;
import org.netbeans.modules.websvc.core.jaxws.actions.PolicyManager;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.OperationNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.IndentEngine;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JaxWsCodeGenerator {
    private static final String POLICY_MANAGER = "policyManager";
    private static final JaxWsCodeGenerator INSTANCE = new JaxWsCodeGenerator();
    private static final List IMPLICIT_JSP_OBJECTS = Arrays.asList("request", "response", "session", "out", "page", "config", "application", "pageContext");
    private static final String HINT_INIT_ARGUMENTS = " // TODO initialize WS operation arguments here\n";
    static final String JAVA_TRY = "\ntry '{' // Call Web Service Operation\n";
    static final String JAVA_SERVICE_DEF = "   {0} {7} = new {0}();\n";
    static final String JAVA_PORT_DEF = "   {1} port = {7}.{2}({9});\n";
    static final String JAVA_RESULT = "   {3}   // TODO process result here\n   {4} result = port.{5}({6});\n";
    static final String JAVA_VOID = "   {3}   port.{5}({6});\n";
    static final String JAVA_RESULT_1 = "   {3}   return port.{5}({6});\n";
    static final String JAVA_OUT = "   {8}.println(\"Result = \"+result);\n";
    static final String JAVA_CATCH = "'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    static final String JAVA_STATIC_STUB_ASYNC_POLLING = "\ntry '{' // Call Web Service Operation(async. polling)\n   {0} service = new {0}();\n   {1} port = service.{2}({9});\n   {3}   // TODO process asynchronous response here\n   {4} resp = port.{5}({6});\n   while(!resp.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n   System.out.println(\"Result = \"+resp.get());\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    static final String JAVA_STATIC_STUB_ASYNC_CALLBACK = "\ntry '{' // Call Web Service Operation(async. callback)\n   {0} service = new {0}();\n   {1} port = service.{2}({9});\n   {3}       public void handleResponse(javax.xml.ws.Response<{7}> response) '{'\n           try '{'\n               // TODO process asynchronous response here\n               System.out.println(\"Result = \"+ response.get());\n           '}' catch(Exception ex) '{'\n               // TODO handle exception\n           '}'\n       '}'\n   '}';\n   {4} result = port.{5}({6});\n   while(!result.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    private static final String JSP_STATIC_STUB = "    <%-- start web service invocation --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process result here\n\t{4} result = port.{5}({6});\n\tout.println(\"Result = \"+result);\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation --%><hr/>\n";
    private static final String JSP_STATIC_STUB_VOID = "    <%-- start web service invocation --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\tport.{5}({6});\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation --%><hr/>\n";
    private static final String JSP_STATIC_STUB_ASYNC_POLLING = "    <%-- start web service invocation(async. polling) --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process asynchronous response here\n\t{4} resp = port.{5}({6});\n\twhile(!resp.isDone()) '{'\n\t\t// do something\n\t\tThread.sleep(100);\n\t'}'\n\tout.println(\"Result = \"+resp.get());\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation(async. polling) --%><hr/>\n";
    private static final String JSP_STATIC_STUB_ASYNC_CALLBACK = "    <%-- start web service invocation(async. callback) --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process asynchronous response here\n\t{4} result = port.{5}({6});\n\twhile(!result.isDone()) '{'\n\t\t// do something\n\t\tThread.sleep(100);\n\t'}'\n\tout.println(\"Result = \"+asyncHandler.getResponse());\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation(async. callback) --%><hr/>\n";
    private static final String JSP_CALLBACK_HANDLER = "<%!\nclass {0} implements javax.xml.ws.AsyncHandler<{1}> '{'\n    private {1} output;\n\n    public void handleResponse(javax.xml.ws.Response<{1}> response) '{'\n        try '{'\n            output = response.get();\n        '}' catch(Exception ex) '{'\n            // TODO handle exception\n        '}'\n    '}'\n\n    {1} getResponse() '{'\n         return output;\n    '}'\n'}'\n%>\n";
    private static final String QNAME = "\nQName portQName = new QName(\"{0}\" , \"{1}\"); ";
    private static final String JSP_DISPATCH = "    <%-- start web service invocation --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\tjavax.xml.namespace.QName portQName = new javax.xml.namespace.QName(\"{1}\", \"{2}\");\n\tString req = \"{3}\";\n\tjavax.xml.ws.Dispatch<javax.xml.transform.Source> sourceDispatch = null;\n\tsourceDispatch = service.createDispatch(portQName, javax.xml.transform.Source.class, javax.xml.ws.Service.Mode.PAYLOAD);\n\tjavax.xml.transform.Source result = sourceDispatch.invoke(new javax.xml.transform.stream.StreamSource(new java.io.StringReader(req)));\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation --%><hr/>\n";

    public static void insertMethodCall(InvokeOperationCookie.TargetSourceType targetSourceType, DataObject dataObject, Lookup lookup) {
        Document document;
        int n;
        OperationNode operationNode;
        block7: {
            Object object;
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            operationNode = (OperationNode)((Object)lookup.lookup(OperationNode.class));
            boolean bl = InvokeOperationCookie.TargetSourceType.JSP == targetSourceType;
            Node node = operationNode.getParentNode();
            Node node2 = node.getParentNode();
            JaxWsCodeGenerator.addProjectReference(node2, dataObject);
            n = -1;
            if (bl) {
                document = editorCookie.getDocument();
                try {
                    object = document.getText(0, document.getLength());
                    n = ((String)object).lastIndexOf("</body>");
                    if (n < 0) {
                        n = ((String)object).lastIndexOf("</html>");
                    }
                    if (n >= 0) {
                        while (n > 0 && ((String)object).charAt(n - 1) != '\n' && ((String)object).charAt(n - 1) != '\r') {
                            --n;
                        }
                        break block7;
                    }
                    n = document.getLength();
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            } else {
                object = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                JEditorPane jEditorPane = object.getOpenedPanes()[0];
                document = jEditorPane.getDocument();
                n = jEditorPane.getCaretPosition();
            }
        }
        int n2 = n;
        JaxWsCodeGenerator.insertMethod(document, n2, operationNode);
    }

    private static void addProjectReference(Node node, DataObject dataObject) {
        Node node2 = node.getParentNode();
        FileObject fileObject = (FileObject)node2.getLookup().lookup(FileObject.class);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (dataObject != null) {
            FileObject fileObject2 = dataObject.getPrimaryFile();
            JaxWsUtils.addProjectReference(project, fileObject2);
        }
    }

    private static String resolveInitValue(String string, FileObject fileObject) {
        if ("int".equals(string)) {
            return "0;";
        }
        if ("long".equals(string)) {
            return "0L;";
        }
        if ("float".equals(string)) {
            return "0.0f;";
        }
        if ("double".equals(string)) {
            return "0.0d;";
        }
        if ("short".equals(string)) {
            return "(short)0;";
        }
        if ("byte".equals(string)) {
            return "(byte)0;";
        }
        if ("boolean".equals(string)) {
            return "false;";
        }
        if ("java.lang.String".equals(string)) {
            return "\"\";";
        }
        if ("java.lang.Integer".equals(string)) {
            return "Integer.valueOf(0);";
        }
        if ("java.lang.Long".equals(string)) {
            return "Long.valueOf(0L);";
        }
        if ("java.lang.Float".equals(string)) {
            return "Float.valueOf(0.0f);";
        }
        if ("java.lang.Double".equals(string)) {
            return "Double.valueOf(0.0d);";
        }
        if ("java.lang.Short".equals(string)) {
            return "Short.valueOf((short)0);";
        }
        if ("java.lang.Byte".equals(string)) {
            return "Byte.valueOf((byte)0);";
        }
        if ("java.lang.Boolean".equals(string)) {
            return "Boolean.FALSE;";
        }
        if (string.endsWith("CallbackHandler")) {
            return "new " + string + "();";
        }
        if (string.startsWith("javax.xml.ws.AsyncHandler")) {
            return "new " + string + "() {";
        }
        ResultHolder<String> resultHolder = new ResultHolder<String>("");
        JaxWsCodeGenerator.getInitValue(string, fileObject, resultHolder);
        String string2 = resultHolder.getResult();
        if (!string2.equals("")) {
            return string2;
        }
        return "null;";
    }

    private static void getInitValue(final String string, FileObject fileObject, final ResultHolder<String> resultHolder) {
        if (fileObject == null) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            resultHolder.setResult("null;");
            return;
        }
        CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                if (!JaxWsCodeGenerator.isEnum(compilationController, string) && JaxWsCodeGenerator.hasNoArgConstructor(compilationController, string)) {
                    resultHolder.setResult("new " + string + "();");
                }
            }

            public void cancel() {
            }
        };
        try {
            javaSource.runUserActionTask((Task)cancellableTask, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private static boolean isEnum(CompilationController compilationController, String string) {
        TypeElement typeElement = compilationController.getElements().getTypeElement(JaxWsCodeGenerator.getCanonicalClassName(string));
        if (typeElement != null) {
            return typeElement.getKind() == ElementKind.ENUM;
        }
        return false;
    }

    private static boolean hasNoArgConstructor(CompilationController compilationController, String string) {
        TypeElement typeElement = compilationController.getElements().getTypeElement(JaxWsCodeGenerator.getCanonicalClassName(string));
        if (typeElement != null) {
            List<ExecutableElement> list = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
            for (ExecutableElement executableElement : list) {
                if (executableElement.getParameters().size() != 0) continue;
                return true;
            }
        }
        return false;
    }

    private static String getCanonicalClassName(String string) {
        int n = string.indexOf("<");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private static String resolveResponseType(String string) {
        int n = string.indexOf("<");
        int n2 = string.indexOf(">");
        if (n > 0 && n2 > 0 && n < n2) {
            return string.substring(n + 1, n2);
        }
        return "javax.xml.ws.Response";
    }

    private static String pureJavaName(String string) {
        int n = string.lastIndexOf(".");
        return n >= 0 ? string.substring(n + 1) : string;
    }

    public static void insertMethod(final Document document, final int n, final OperationNode operationNode) {
        WsdlOperation wsdlOperation = (WsdlOperation)operationNode.getLookup().lookup(WsdlOperation.class);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JaxWsCodeGenerator.doInsertMethod(document, n, operationNode);
            }
        };
        ProgressUtils.showProgressDialogAndRun((Runnable)runnable, (String)NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"MSG_GenerateMethod", (Object)wsdlOperation.getName()));
    }

    public static void doInsertMethod(Document document, int n, OperationNode operationNode) {
        String string;
        Node node = operationNode.getParentNode();
        Node node2 = node.getParentNode();
        Node node3 = node2.getParentNode();
        WsdlOperation wsdlOperation = (WsdlOperation)operationNode.getLookup().lookup(WsdlOperation.class);
        WsdlPort wsdlPort = (WsdlPort)node.getLookup().lookup(WsdlPort.class);
        WsdlService wsdlService = (WsdlService)node2.getLookup().lookup(WsdlService.class);
        Client client = (Client)node3.getLookup().lookup(Client.class);
        JaxWsClientNode jaxWsClientNode = (JaxWsClientNode)((Object)node3.getLookup().lookup(JaxWsClientNode.class));
        FileObject fileObject = (FileObject)node3.getLookup().lookup(FileObject.class);
        JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)fileObject);
        FileObject fileObject2 = null;
        FileObject fileObject3 = jAXWSClientSupport.getLocalWsdlFolderForClient(client.getName(), false);
        if (fileObject3 != null && (string = client.getLocalWsdlFile()) != null) {
            fileObject2 = fileObject3.getFileObject(string);
        }
        string = NbEditorUtilities.getFileObject((Document)document);
        String string2 = JaxWsCodeGenerator.findWsdlLocation(client, (FileObject)string);
        Project project = FileOwnerQuery.getOwner((FileObject)string);
        HashMap<String, Object> hashMap = (HashMap<String, Object>)jaxWsClientNode.getValue("context");
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            jaxWsClientNode.setValue("context", hashMap);
        }
        JaxWsCodeGenerator.insertMethod(client, document, n, wsdlService, wsdlPort, wsdlOperation, fileObject2, string2, hashMap, project);
    }

    private static void insertMethod(Document document, int n, WsdlService wsdlService, WsdlPort wsdlPort, WsdlOperation wsdlOperation, FileObject fileObject, String string, PolicyManager policyManager) {
        String string2;
        String string3;
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        boolean bl = "text/x-jsp".equals(document.getProperty("mimeType"));
        String string10 = "Object";
        String string11 = "javax.xml.ws.AsyncHandler";
        try {
            string9 = "service";
            string8 = wsdlOperation.getJavaName();
            string7 = wsdlPort.getJavaName();
            string6 = wsdlPort.getPortGetter();
            string5 = wsdlService.getJavaName();
            List list = wsdlOperation.getParameters();
            string4 = wsdlOperation.getReturnTypeName();
            Iterator iterator = wsdlOperation.getExceptions();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                String string12 = ((WsdlParameter)list.get(i)).getTypeName();
                if (string12.startsWith("javax.xml.ws.AsyncHandler")) {
                    string10 = JaxWsCodeGenerator.resolveResponseType(string12);
                    if (bl) {
                        string12 = JaxWsCodeGenerator.pureJavaName(string7) + "CallbackHandler";
                    }
                    string11 = string12;
                }
                String string13 = ((WsdlParameter)list.get(i)).getName();
                if (bl && IMPLICIT_JSP_OBJECTS.contains(string13)) {
                    string13 = string13 + "_1";
                }
                stringBuffer.append("\t" + string12 + " " + string13 + " = " + JaxWsCodeGenerator.resolveInitValue(string12, NbEditorUtilities.getFileObject((Document)document)) + "\n");
                stringBuffer2.append(i > 0 ? ", " + string13 : string13);
                arrayList2.add(string12);
                arrayList3.add(string13);
            }
            stringArray3 = new String[n2];
            arrayList2.toArray(stringArray3);
            stringArray2 = new String[n2];
            arrayList3.toArray(stringArray2);
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            string3 = stringBuffer.length() > 0 ? "\t // TODO initialize WS operation arguments here\n" + stringBuffer.toString() : "";
            string2 = stringBuffer2.toString();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            String string14 = NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"ERR_FailedUnexpectedWebServiceDescriptionPattern");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string14, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        policyManager.chosePolicy();
        if (bl) {
            JaxWsCodeGenerator.insertJspMethod(document, n, wsdlOperation, string5, string7, string6, string8, string4, string10, string11, string3, string2);
        } else {
            JaxWsCodeGenerator.insertJavaMethod(document, n, wsdlOperation, string, policyManager, string5, string9, string7, string6, string8, string4, string10, string3, string2, stringArray2, stringArray3, stringArray);
        }
    }

    private static void insertJavaMethod(Document document, int n, WsdlOperation wsdlOperation, String string, PolicyManager policyManager, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        String string11 = string8;
        String[] stringArray4 = new String[]{string9};
        String[] stringArray5 = new String[]{string10};
        String[] stringArray6 = new String[]{string3};
        try {
            Object object;
            CompilerTask compilerTask = JaxWsCodeGenerator.getCompilerTask(string2, stringArray6, stringArray5, stringArray, stringArray4, policyManager);
            javaSource.runUserActionTask((Task)compilerTask, true);
            if (0 == wsdlOperation.getOperationType()) {
                object = compilerTask.getMethodBody(string4, string5, string7, string6);
                boolean bl = !compilerTask.isWsRefInjection() || Car.getCar((FileObject)fileObject) != null;
                JaxWsClientMethodGenerator jaxWsClientMethodGenerator = new JaxWsClientMethodGenerator(bl, string6, string7, stringArray2, stringArray, stringArray3, "{" + (String)object + "}");
                javaSource.runModificationTask((Task)jaxWsClientMethodGenerator).commit();
            } else {
                try {
                    object = IndentEngine.find((Document)document);
                    StringWriter stringWriter = new StringWriter();
                    Writer writer = object.createWriter(document, n, (Writer)stringWriter);
                    String string12 = compilerTask.getJavaInvocationBody(wsdlOperation, string4, string5, string7, string6, string11);
                    writer.write(string12);
                    writer.close();
                    String string13 = stringWriter.toString();
                    try {
                        document.insertString(n, string13, null);
                    }
                    catch (BadLocationException badLocationException) {
                        document.insertString(n + 1, string13, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                }
            }
            object = JaxWsCodeGenerator.getClassModificationTask(string2, stringArray6, string, policyManager, compilerTask.containsWsRefInjection());
            javaSource.runModificationTask((Task)object).commit();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    private static void insertJspMethod(final Document document, final int n, WsdlOperation wsdlOperation, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        Object[] objectArray = new Object[]{string, string2, string3, string8, string5, string4, string9};
        final String string10 = JaxWsCodeGenerator.getJSPInvocationBody(wsdlOperation, objectArray);
        try {
            if (2 == wsdlOperation.getOperationType()) {
                Object[] objectArray2 = new Object[]{string7, string6};
                final String string11 = MessageFormat.format(JSP_CALLBACK_HANDLER, objectArray2);
                NbDocument.runAtomic((StyledDocument)((StyledDocument)document), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            document.insertString(document.getLength(), string11, null);
                            document.insertString(n, string10, null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            } else {
                document.insertString(n, string10, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static InsertTask getClassModificationTask(String string, String[] stringArray, String string2, PolicyManager policyManager, boolean bl) {
        return new InsertTask(string, stringArray[0], string2, policyManager, bl);
    }

    private static CompilerTask getCompilerTask(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, PolicyManager policyManager) {
        return new CompilerTask(string, stringArray, stringArray2, stringArray3, stringArray4, policyManager);
    }

    private static String findWsdlLocation(Client client, FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && J2eeModule.Type.WAR.equals(j2eeModuleProvider.getJ2eeModule().getType())) {
            return "WEB-INF/wsdl/" + client.getLocalWsdlFile();
        }
        return "META-INF/wsdl/" + client.getLocalWsdlFile();
    }

    private static void insertMethod(Client client, Document document, int n, WsdlService wsdlService, WsdlPort wsdlPort, WsdlOperation wsdlOperation, FileObject fileObject, String string, Map<String, Object> map, Project project) {
        PolicyManager policyManager = (PolicyManager)map.get(POLICY_MANAGER);
        if (policyManager == null || !client.getWsdlUrl().equals(policyManager.getWsdlUrl())) {
            policyManager = new PolicyManager(client.getWsdlUrl(), fileObject, project);
            map.put(POLICY_MANAGER, policyManager);
        }
        policyManager.init(client);
        if (client.getUseDispatch().booleanValue()) {
            JaxWsCodeGenerator.insertDispatchMethod(document, n, wsdlService, wsdlPort, wsdlOperation, fileObject, string, policyManager);
        } else {
            JaxWsCodeGenerator.insertMethod(document, n, wsdlService, wsdlPort, wsdlOperation, fileObject, string, policyManager);
        }
    }

    private static String getJSPInvocationBody(WsdlOperation wsdlOperation, Object[] objectArray) {
        String string = "";
        switch (wsdlOperation.getOperationType()) {
            case 0: {
                if ("void".equals(objectArray[4])) {
                    string = MessageFormat.format(JSP_STATIC_STUB_VOID, objectArray);
                    break;
                }
                string = MessageFormat.format(JSP_STATIC_STUB, objectArray);
                break;
            }
            case 1: {
                string = MessageFormat.format(JSP_STATIC_STUB_ASYNC_POLLING, objectArray);
                break;
            }
            case 2: {
                string = MessageFormat.format(JSP_STATIC_STUB_ASYNC_CALLBACK, objectArray);
            }
        }
        return string;
    }

    static boolean foundImport(String string, CompilationUnitTree compilationUnitTree) {
        List<? extends ImportTree> list = compilationUnitTree.getImports();
        for (ImportTree importTree : list) {
            if (!string.equals(importTree.getQualifiedIdentifier().toString())) continue;
            return true;
        }
        return false;
    }

    public static String generateXMLMessage(WsdlPort wsdlPort, WsdlOperation wsdlOperation) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = wsdlOperation.getOperationName();
        String string2 = wsdlPort.getNamespaceURI();
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append("  xmlns=\\\"");
        stringBuffer.append(string2);
        stringBuffer.append("\\\">");
        List list = wsdlOperation.getParameters();
        for (WsdlParameter wsdlParameter : list) {
            String string3 = wsdlParameter.getName();
            stringBuffer.append("<");
            stringBuffer.append(string3);
            stringBuffer.append(">");
            stringBuffer.append("ENTER VALUE");
            stringBuffer.append("</");
            stringBuffer.append(string3);
            stringBuffer.append(">");
        }
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private static String getDispatchInvocationMethod(WsdlPort wsdlPort, WsdlOperation wsdlOperation) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(MessageFormat.format(QNAME, wsdlPort.getNamespaceURI(), wsdlPort.getName()));
        stringBuffer.append("\n");
        stringBuffer.append("String req = ");
        stringBuffer.append("\"");
        stringBuffer.append(JaxWsCodeGenerator.generateXMLMessage(wsdlPort, wsdlOperation));
        stringBuffer.append("\";\n");
        stringBuffer.append(MessageFormat.format(JAVA_TRY, new Object[0]));
        stringBuffer.append("\n");
        stringBuffer.append("Dispatch<Source> sourceDispatch = null;\n");
        stringBuffer.append("sourceDispatch = service.createDispatch(portQName, Source.class, Service.Mode.PAYLOAD);\n");
        stringBuffer.append("Source result = sourceDispatch.invoke(new StreamSource(new StringReader(req)));\n");
        stringBuffer.append(MessageFormat.format(JAVA_CATCH, new Object[0]));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private static String getJSPDispatchBody(Object[] objectArray) {
        return MessageFormat.format(JSP_DISPATCH, objectArray);
    }

    private static void insertDispatchMethod(Document document, int n, WsdlService wsdlService, WsdlPort wsdlPort, WsdlOperation wsdlOperation, FileObject fileObject, String string, PolicyManager policyManager) {
        boolean bl = "text/x-jsp".equals(document.getProperty("mimeType"));
        if (bl) {
            Object[] objectArray = new Object[]{wsdlService.getJavaName(), wsdlPort.getNamespaceURI(), wsdlPort.getJavaName(), JaxWsCodeGenerator.generateXMLMessage(wsdlPort, wsdlOperation)};
            String string2 = JaxWsCodeGenerator.getJSPDispatchBody(objectArray);
            try {
                document.insertString(n, string2, null);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            return;
        }
        try {
            JaxWsCodeGenerator.insertDispatchJavaMethod(document, n, wsdlService, wsdlPort, wsdlOperation, string, policyManager);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static void insertDispatchJavaMethod(Document document, int n, WsdlService wsdlService, WsdlPort wsdlPort, WsdlOperation wsdlOperation, String string, PolicyManager policyManager) throws IOException {
        Object object;
        Object object2;
        Object[] objectArray;
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        String string2 = wsdlService.getJavaName();
        String[] stringArray = new String[]{"service"};
        String[] stringArray2 = new String[]{""};
        String[] stringArray3 = new String[]{""};
        CompilerTask compilerTask = JaxWsCodeGenerator.getCompilerTask(string2, stringArray, stringArray2, new String[0], stringArray3, policyManager);
        javaSource.runUserActionTask((Task)compilerTask, true);
        IndentEngine indentEngine = IndentEngine.find((Document)document);
        StringWriter stringWriter = new StringWriter();
        Writer writer = indentEngine.createWriter(document, n, (Writer)stringWriter);
        StringBuilder stringBuilder = new StringBuilder();
        if (compilerTask.containsWsRefInjection()) {
            objectArray = new Object[]{wsdlService.getJavaName(), null, null, null, null, null, null, "service"};
            object2 = MessageFormat.format(JAVA_SERVICE_DEF, objectArray);
            stringBuilder.append((String)object2);
            writer.write((String)object2);
        }
        objectArray = JaxWsCodeGenerator.getDispatchInvocationMethod(wsdlPort, wsdlOperation);
        object2 = new DispatchClientMethodGenerator(wsdlOperation.getJavaName(), stringBuilder.append((String)objectArray).toString(), n);
        ModificationResult modificationResult = javaSource.runModificationTask((Task)object2);
        if (((DispatchClientMethodGenerator)object2).isMethodBody()) {
            writer.write((String)objectArray);
            writer.close();
            object = stringWriter.toString();
            try {
                document.insertString(n, (String)object, null);
            }
            catch (BadLocationException badLocationException) {
                try {
                    document.insertString(n + 1, (String)object, null);
                }
                catch (BadLocationException badLocationException2) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException2);
                }
            }
        } else {
            modificationResult.commit();
        }
        object = JaxWsCodeGenerator.getClassModificationTask(string2, stringArray, string, policyManager, compilerTask.containsWsRefInjection());
        javaSource.runModificationTask((Task)object).commit();
        DispatchCompilerTask dispatchCompilerTask = new DispatchCompilerTask();
        javaSource.runModificationTask((Task)dispatchCompilerTask).commit();
    }

    private static class ResultHolder<E> {
        private E result;

        public ResultHolder(E e) {
            this.result = e;
        }

        public E getResult() {
            return this.result;
        }

        public void setResult(E e) {
            this.result = e;
        }
    }
}

