/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.websvc.core.JaxWsUtils;

public class MethodVisitor {
    private String operationName;
    private ExecutableElement method;
    private CompilationInfo info;
    private boolean hasWebMethod;
    private boolean hasPublicMethod;
    private List<ExecutableElement> publicMethods;

    public MethodVisitor(CompilationInfo compilationInfo) {
        this.info = compilationInfo;
    }

    public ExecutableElement getMethod(String string) {
        this.operationName = string;
        new JavaMethodVisitor().scan(this.info.getCompilationUnit(), null);
        return this.method;
    }

    public boolean hasWebMethod() {
        new WebMethodVisitor().scan(this.info.getCompilationUnit(), null);
        return this.hasWebMethod;
    }

    public List<ExecutableElement> getPublicMethods() {
        new PublicMethodVisitor().scan(this.info.getCompilationUnit(), null);
        return this.publicMethods;
    }

    public boolean hasPublicMethod() {
        new PublicMethodVisitor().scan(this.info.getCompilationUnit(), null);
        return this.hasPublicMethod;
    }

    private boolean hasWebMethodAnnotation(ExecutableElement executableElement) {
        AnnotationMirror annotationMirror;
        boolean bl = false;
        List<? extends AnnotationMirror> list = executableElement.getAnnotationMirrors();
        Iterator<? extends AnnotationMirror> iterator = list.iterator();
        if (iterator.hasNext() && JaxWsUtils.hasFqn(annotationMirror = iterator.next(), "javax.jws.WebMethod")) {
            bl = true;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                String string;
                if (!entry.getKey().getSimpleName().contentEquals("exclude") || !"true".equals(string = (String)map.get(entry.getKey()).getValue())) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private boolean isMethodFor(ExecutableElement executableElement, String string) {
        if (executableElement.getSimpleName().toString().equals(string)) {
            return true;
        }
        List<? extends AnnotationMirror> list = executableElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : list) {
            if (!JaxWsUtils.hasFqn(annotationMirror, "javax.jws.WebMethod")) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                String string2;
                if (!entry.getKey().getSimpleName().contentEquals("operationName") || !string.equals(string2 = (String)map.get(entry.getKey()).getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private class JavaMethodVisitor
    extends TreePathScanner<Void, Void> {
        @Override
        public Void visitClass(ClassTree classTree, Void void_) {
            Element element = MethodVisitor.this.info.getTrees().getElement(this.getCurrentPath());
            if (element != null) {
                TypeElement typeElement = (TypeElement)element;
                List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
                for (ExecutableElement executableElement : list) {
                    if (!MethodVisitor.this.isMethodFor(executableElement, MethodVisitor.this.operationName)) continue;
                    MethodVisitor.this.method = executableElement;
                    break;
                }
            }
            return null;
        }
    }

    private class PublicMethodVisitor
    extends TreePathScanner<Void, Void> {
        public PublicMethodVisitor() {
            MethodVisitor.this.publicMethods = new ArrayList();
        }

        @Override
        public Void visitClass(ClassTree classTree, Void void_) {
            Element element = MethodVisitor.this.info.getTrees().getElement(this.getCurrentPath());
            if (element != null) {
                TypeElement typeElement = (TypeElement)element;
                List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
                for (ExecutableElement executableElement : list) {
                    if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                    MethodVisitor.this.hasPublicMethod = true;
                    MethodVisitor.this.publicMethods.add(executableElement);
                }
            }
            return null;
        }
    }

    private class WebMethodVisitor
    extends TreePathScanner<Void, Void> {
        private WebMethodVisitor() {
        }

        @Override
        public Void visitClass(ClassTree classTree, Void void_) {
            Element element = MethodVisitor.this.info.getTrees().getElement(this.getCurrentPath());
            if (element != null) {
                TypeElement typeElement = (TypeElement)element;
                List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
                for (ExecutableElement executableElement : list) {
                    if (!MethodVisitor.this.hasWebMethodAnnotation(executableElement)) continue;
                    MethodVisitor.this.hasWebMethod = true;
                    break;
                }
            }
            return null;
        }
    }
}

