/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.informations.java;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.nbheaven.sqe.core.java.utils.FileObjectUtilities;
import org.nbheaven.sqe.core.java.utils.ProjectUtilities;
import org.nbheaven.sqe.informations.ui.spi.SQEInformationComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class SQEInformationComponentImpl
implements SQEInformationComponent {
    private final Project project;
    private JPanel panel = new JPanel();

    public SQEInformationComponentImpl(Project project) {
        this.project = project;
    }

    public Component getComponent() {
        this.panel.removeAll();
        JScrollPane pane = new JScrollPane(new InfoPanel(this.project));
        pane.setBorder(null);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)pane, "Center");
        this.panel.revalidate();
        return this.panel;
    }

    public void refresh() {
        this.panel.removeAll();
        JScrollPane pane = new JScrollPane(new InfoPanel(this.project));
        pane.setBorder(null);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)pane, "Center");
        this.panel.revalidate();
    }

    private class InfoPanel
    extends JPanel {
        private Project project;

        private InfoPanel(Project project) {
            this.project = project;
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            JTextPane pane = new JTextPane();
            pane.setContentType("text/html");
            pane.setText(this.getText());
            this.add((Component)pane, "Center");
        }

        private String getText() {
            String begin = "<html>";
            String end = "</html>";
            String sources = this.getSourceDesc();
            String binaries = this.getBinariesDesc();
            return begin + sources + binaries + end;
        }

        private String getSourceDesc() {
            String source = "<p/><h2>Sources</h2><table><tr><th>Name</th><th>Location</th><th>Count</th></tr>";
            for (SourceGroup sourceGroup : ProjectUtilities.getJavaSourceGroups((Project)this.project)) {
                FileObject fileObject = sourceGroup.getRootFolder();
                source = source + "<tr><td>" + sourceGroup.getDisplayName() + "</td><td>" + FileUtil.getFileDisplayName((FileObject)fileObject) + "</td><td>" + FileObjectUtilities.collectAllJavaSourceFiles((FileObject)fileObject).size() + "</td></tr>";
            }
            source = source + "</table>";
            return source;
        }

        private String getBinariesDesc() {
            String source = "<p/><h2>Binaries</h2><ul>";
            for (String root : ProjectUtilities.findBinaryRoots((Project)this.project)) {
                source = source + "<li>" + root + "</li>";
            }
            source = source + "</ul>";
            return source;
        }
    }
}

