/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.modules.profiler.ui.stp.NewCustomConfiguration;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class ProfilingSettingsManager {
    private static final String PROFILING_SETTINGS_STORAGE_FILENAME = "configurations";
    private static final String PROFILING_SETTINGS_STORAGE_FILEEXT = "xml";
    private static final String PROP_LAST_SELECTED_SETTINGS_INDEX = "profiler.settings.lastselected";
    private static final int DEFAULT_SETTINGS_COUNT = 3;
    private static ProfilingSettingsManager defaultInstance;

    private ProfilingSettingsManager() {
    }

    public static ProfilingSettingsManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilingSettingsManager();
        }
        return defaultInstance;
    }

    public ProfilingSettingsDescriptor getProfilingSettings() {
        ProfilingSettings[] profilingSettingsArray;
        final LinkedList linkedList = new LinkedList();
        final int[] nArray = new int[]{-1};
        try {
            profilingSettingsArray = IDEUtils.getProjectSettingsFolder(false);
            if (profilingSettingsArray != null) {
                FileSystem fileSystem = profilingSettingsArray.getFileSystem();
                fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        FileObject fileObject = ProfilingSettingsManager.this.getProfilingSettingsStorage();
                        if (fileObject != null) {
                            Object object;
                            Properties properties = ProfilingSettingsManager.this.loadSettings(fileObject);
                            int n = 0;
                            while (properties.getProperty(n + "_" + "profiler.settings.settings.name") != null) {
                                object = new ProfilingSettings();
                                object.load((Map)properties, Integer.toString(n) + "_");
                                if (object != null) {
                                    linkedList.add(object);
                                }
                                ++n;
                            }
                            try {
                                nArray[0] = Integer.parseInt(properties.getProperty(ProfilingSettingsManager.PROP_LAST_SELECTED_SETTINGS_INDEX, "0"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            object = Utils.getSettingsConfigurator();
                            if (object != null) {
                                object.loadCustomSettings(properties);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(65536, exception.getMessage());
        }
        profilingSettingsArray = new ProfilingSettings[linkedList.size()];
        if (profilingSettingsArray.length < 3) {
            profilingSettingsArray = this.createDefaultSettings();
        } else {
            linkedList.toArray(profilingSettingsArray);
        }
        return new ProfilingSettingsDescriptor(profilingSettingsArray, nArray[0] == -1 ? null : profilingSettingsArray[nArray[0]]);
    }

    public ProfilingSettings createDuplicateSettings(ProfilingSettings profilingSettings, ProfilingSettings[] profilingSettingsArray) {
        return NewCustomConfiguration.createDuplicateConfiguration(profilingSettings, profilingSettingsArray);
    }

    public ProfilingSettings createNewSettings(ProfilingSettings[] profilingSettingsArray) {
        return NewCustomConfiguration.createNewConfiguration(profilingSettingsArray);
    }

    public ProfilingSettings createNewSettings(int n, ProfilingSettings[] profilingSettingsArray) {
        return NewCustomConfiguration.createNewConfiguration(n, profilingSettingsArray);
    }

    public ProfilingSettings renameSettings(ProfilingSettings profilingSettings, ProfilingSettings[] profilingSettingsArray) {
        return NewCustomConfiguration.renameConfiguration(profilingSettings, profilingSettingsArray);
    }

    public void storeProfilingSettings(ProfilingSettings[] profilingSettingsArray, ProfilingSettings profilingSettings) {
        try {
            FileObject fileObject;
            if (profilingSettingsArray == null || profilingSettingsArray.length < 3) {
                profilingSettingsArray = this.createDefaultSettings();
            }
            if (profilingSettings == null) {
                profilingSettings = profilingSettingsArray[0];
            }
            if ((fileObject = IDEUtils.getProjectSettingsFolder(true)) == null) {
                ErrorManager.getDefault().log(65536, "Cannot create project settings folder for , settings cannot be saved.");
                return;
            }
            final ProfilingSettings[] profilingSettingsArray2 = profilingSettingsArray;
            final ProfilingSettings profilingSettings2 = profilingSettings;
            FileSystem fileSystem = fileObject.getFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject fileObject = ProfilingSettingsManager.this.getProfilingSettingsStorage();
                    if (fileObject == null) {
                        fileObject = ProfilingSettingsManager.this.createProfilingSettingsStorage();
                    }
                    if (fileObject != null) {
                        Properties properties = new Properties();
                        int n = -1;
                        for (int i = 0; i < profilingSettingsArray2.length; ++i) {
                            ProfilingSettings profilingSettings = profilingSettingsArray2[i];
                            if (profilingSettings == profilingSettings2) {
                                n = i;
                            }
                            profilingSettings.store((Map)properties, Integer.toString(i) + "_");
                        }
                        properties.put(ProfilingSettingsManager.PROP_LAST_SELECTED_SETTINGS_INDEX, Integer.toString(n));
                        SelectProfilingTask.SettingsConfigurator settingsConfigurator = Utils.getSettingsConfigurator();
                        if (settingsConfigurator != null) {
                            settingsConfigurator.storeCustomSettings(properties);
                        }
                        ProfilingSettingsManager.this.storeSettings(fileObject, properties);
                    }
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(65536, exception.getMessage());
        }
    }

    private FileObject getProfilingSettingsStorage() throws IOException {
        FileObject fileObject = IDEUtils.getProjectSettingsFolder(true);
        FileObject fileObject2 = fileObject.getFileObject(PROFILING_SETTINGS_STORAGE_FILENAME, PROFILING_SETTINGS_STORAGE_FILEEXT);
        return fileObject2;
    }

    private ProfilingSettings[] createDefaultSettings() {
        return new ProfilingSettings[]{ProfilingSettingsPresets.createMonitorPreset(), ProfilingSettingsPresets.createCPUPreset(), ProfilingSettingsPresets.createMemoryPreset()};
    }

    private FileObject createProfilingSettingsStorage() throws IOException {
        FileObject fileObject = IDEUtils.getProjectSettingsFolder(true);
        FileObject fileObject2 = fileObject.createData(PROFILING_SETTINGS_STORAGE_FILENAME, PROFILING_SETTINGS_STORAGE_FILEEXT);
        return fileObject2;
    }

    private Properties loadSettings(FileObject fileObject) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = fileObject.getInputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        properties.loadFromXML(bufferedInputStream);
        bufferedInputStream.close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSettings(FileObject fileObject, Properties properties) throws IOException {
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            properties.storeToXML(outputStream, null);
            bufferedOutputStream.close();
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public static class ProfilingSettingsDescriptor {
        private ProfilingSettings lastSelectedProfilingSettings;
        private ProfilingSettings[] profilingSettings;

        public ProfilingSettingsDescriptor(ProfilingSettings[] profilingSettingsArray, ProfilingSettings profilingSettings) {
            this.profilingSettings = profilingSettingsArray;
            this.lastSelectedProfilingSettings = profilingSettings;
        }

        public ProfilingSettings getLastSelectedProfilingSettings() {
            return this.lastSelectedProfilingSettings;
        }

        public ProfilingSettings[] getProfilingSettings() {
            return this.profilingSettings;
        }
    }
}

