/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;

public class PrimitiveFieldNode
extends AbstractHeapWalkerNode
implements HeapWalkerFieldNode {
    private FieldValue fieldValue;

    public PrimitiveFieldNode(FieldValue fieldValue, HeapWalkerNode heapWalkerNode) {
        this(fieldValue, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
    }

    public PrimitiveFieldNode(FieldValue fieldValue, HeapWalkerNode heapWalkerNode, int n) {
        super(heapWalkerNode, n);
        this.fieldValue = fieldValue;
    }

    public FieldValue getFieldValue() {
        return this.fieldValue;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isStatic() {
        return this.fieldValue.getField().isStatic();
    }

    protected Icon computeIcon() {
        ImageIcon imageIcon = BrowserUtils.ICON_PRIMITIVE;
        if (this.isStatic()) {
            imageIcon = BrowserUtils.createStaticIcon(imageIcon);
        }
        return imageIcon;
    }

    protected String computeName() {
        return this.fieldValue.getField().getName();
    }

    protected String computeType() {
        return this.fieldValue.getField().getType().getName();
    }

    protected String computeValue() {
        return this.fieldValue.getValue();
    }

    protected String computeSize() {
        return "-";
    }

    protected String computeRetainedSize() {
        return "-";
    }

    public static class ArrayItem
    extends PrimitiveFieldNode
    implements org.netbeans.modules.profiler.heapwalk.model.ArrayItem {
        private String type;
        private String value;
        private int itemIndex;

        public ArrayItem(int n, String string, String string2, HeapWalkerNode heapWalkerNode) {
            this(n, string, string2, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
        }

        public ArrayItem(int n, String string, String string2, HeapWalkerNode heapWalkerNode, int n2) {
            super(null, heapWalkerNode, n2);
            this.itemIndex = n;
            this.type = string;
            this.value = string2;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        public boolean isStatic() {
            return false;
        }

        protected String computeName() {
            return "[" + this.itemIndex + "]";
        }

        protected String computeType() {
            return this.type;
        }

        protected String computeValue() {
            return this.value;
        }
    }
}

