/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.DispatchTargetsInfo;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsyncContextImpl
implements AsyncContext {
    private static final Logger log = Logger.getLogger(AsyncContextImpl.class.getName());
    private static final long DEFAULT_ASYNC_TIMEOUT_MILLIS = 30000L;
    private static final ExecutorService pool = Executors.newCachedThreadPool(new AsyncPoolThreadFactory());
    private static final StringManager STRING_MANAGER = StringManager.getManager("org.apache.catalina.connector");
    private Request origRequest;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private boolean isOriginalRequestAndResponse = false;
    private boolean isStartAsyncWithZeroArg = false;
    private AtomicBoolean isDispatchInProgress = new AtomicBoolean();
    private ThreadLocal<Boolean> isDispatchInScope = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private AtomicBoolean isOkToConfigure = new AtomicBoolean(true);
    private long asyncTimeoutMillis = 30000L;
    private final LinkedList<AsyncListenerContext> asyncListenerContexts = new LinkedList();
    private AtomicInteger startAsyncCounter = new AtomicInteger(0);
    private ThreadLocal<Boolean> isStartAsyncInScope = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    AsyncContextImpl(Request origRequest, ServletRequest servletRequest, Response origResponse, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.origRequest = origRequest;
        this.init(servletRequest, servletResponse, isStartAsyncWithZeroArg);
    }

    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    Request getOriginalRequest() {
        return this.origRequest;
    }

    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.isOriginalRequestAndResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch() {
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.getZeroArgDispatcher(this.origRequest, this.servletRequest, this.isStartAsyncWithZeroArg);
        this.isDispatchInScope.set(true);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException(STRING_MANAGER.getString("async.dispatchInProgress"));
            pool.execute(new Handler(this, dispatcher, this.origRequest));
            return;
        } else {
            log.warning("Unable to determine target of zero-arg dispatcher");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(path);
        this.isDispatchInScope.set(true);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException(STRING_MANAGER.getString("async.dispatchInProgress"));
            pool.execute(new Handler(this, dispatcher, this.origRequest));
            return;
        } else {
            log.warning("Unable to acquire RequestDispatcher for " + path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(ServletContext context, String path) {
        if (path == null || context == null) {
            throw new IllegalArgumentException("Null context or path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)context.getRequestDispatcher(path);
        this.isDispatchInScope.set(true);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException(STRING_MANAGER.getString("async.dispatchInProgress"));
            pool.execute(new Handler(this, dispatcher, this.origRequest));
            return;
        } else {
            log.warning("Unable to acquire RequestDispatcher for " + path + "in servlet context " + context.getContextPath());
        }
    }

    boolean isDispatchInScope() {
        return this.isDispatchInScope.get();
    }

    boolean getAndResetDispatchInScope() {
        boolean flag = this.isDispatchInScope.get();
        this.isDispatchInScope.set(Boolean.FALSE);
        return flag;
    }

    public void complete() {
        this.origRequest.asyncComplete();
    }

    public void start(Runnable run) {
        pool.execute(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException(STRING_MANAGER.getString("async.addListenerIllegalState"));
        }
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.add(new AsyncListenerContext(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (listener == null || servletRequest == null || servletResponse == null) {
            throw new IllegalArgumentException("Null listener, request, or response");
        }
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException(STRING_MANAGER.getString("async.addListenerIllegalState"));
        }
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.add(new AsyncListenerContext(listener, servletRequest, servletResponse));
        }
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        AsyncListener listener = null;
        StandardContext ctx = (StandardContext)this.origRequest.getContext();
        if (ctx != null) {
            try {
                listener = (AsyncListener)ctx.createListenerInstance(clazz);
            }
            catch (Throwable t) {
                throw new ServletException(t);
            }
        }
        return (T)listener;
    }

    public void setTimeout(long timeout) {
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException(STRING_MANAGER.getString("async.setTimeoutIllegalState"));
        }
        this.asyncTimeoutMillis = timeout;
        this.origRequest.setAsyncTimeout(timeout);
    }

    public long getTimeout() {
        return this.asyncTimeoutMillis;
    }

    void reinitialize(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.init(servletRequest, servletResponse, isStartAsyncWithZeroArg);
        this.isDispatchInProgress.set(false);
        this.setOkToConfigure(true);
        this.startAsyncCounter.incrementAndGet();
        this.notifyAsyncListeners(AsyncEventType.START_ASYNC, null);
    }

    void setOkToConfigure(boolean value) {
        this.isOkToConfigure.set(value);
    }

    private void init(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.isOriginalRequestAndResponse = !(!(servletRequest instanceof RequestFacade) && !(servletRequest instanceof ApplicationHttpRequest) || !(servletResponse instanceof ResponseFacade) && !(servletResponse instanceof ApplicationHttpResponse));
        this.isStartAsyncWithZeroArg = isStartAsyncWithZeroArg;
    }

    private RequestDispatcher getZeroArgDispatcher(Request origRequest, ServletRequest servletRequest, boolean isStartAsyncWithZeroArg) {
        String dispatchTarget = null;
        boolean isNamed = false;
        if (!isStartAsyncWithZeroArg && servletRequest instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            dispatchTarget = this.getCombinedPath(req);
        } else {
            DispatchTargetsInfo dtInfo = (DispatchTargetsInfo)origRequest.getAttribute("org.apache.catalina.core.ApplicationDispatcher.lastDispatchRequestPathAttr");
            if (dtInfo != null) {
                dispatchTarget = dtInfo.getLastDispatchTarget();
                isNamed = dtInfo.isLastNamedDispatchTarget();
            }
            if (dispatchTarget == null) {
                dispatchTarget = this.getCombinedPath(origRequest);
            }
        }
        RequestDispatcher dispatcher = null;
        if (dispatchTarget != null) {
            dispatcher = isNamed ? servletRequest.getServletContext().getNamedDispatcher(dispatchTarget) : servletRequest.getRequestDispatcher(dispatchTarget);
        }
        return dispatcher;
    }

    private String getCombinedPath(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        if (servletPath == null) {
            return null;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return servletPath;
        }
        return servletPath + pathInfo;
    }

    boolean isStartAsyncInScope() {
        return this.isStartAsyncInScope.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAsyncListeners(AsyncEventType asyncEventType, Throwable t) {
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            if (this.asyncListenerContexts.isEmpty()) {
                return;
            }
            LinkedList<AsyncListenerContext> clone = new LinkedList<AsyncListenerContext>(this.asyncListenerContexts);
            if (asyncEventType.equals((Object)AsyncEventType.START_ASYNC)) {
                this.asyncListenerContexts.clear();
            }
            for (AsyncListenerContext asyncListenerContext : clone) {
                AsyncListener asyncListener = asyncListenerContext.getAsyncListener();
                AsyncEvent asyncEvent = new AsyncEvent((AsyncContext)this, asyncListenerContext.getRequest(), asyncListenerContext.getResponse(), t);
                try {
                    switch (asyncEventType) {
                        case COMPLETE: {
                            asyncListener.onComplete(asyncEvent);
                            break;
                        }
                        case TIMEOUT: {
                            asyncListener.onTimeout(asyncEvent);
                            break;
                        }
                        case ERROR: {
                            asyncListener.onError(asyncEvent);
                            break;
                        }
                        case START_ASYNC: {
                            asyncListener.onStartAsync(asyncEvent);
                        }
                    }
                }
                catch (IOException ioe) {
                    log.log(Level.WARNING, "Error invoking AsyncListener", ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AsyncEventType {
        COMPLETE,
        TIMEOUT,
        ERROR,
        START_ASYNC;

    }

    private static class AsyncListenerContext {
        private AsyncListener listener;
        private ServletRequest request;
        private ServletResponse response;

        public AsyncListenerContext(AsyncListener listener) {
            this(listener, null, null);
        }

        public AsyncListenerContext(AsyncListener listener, ServletRequest request, ServletResponse response) {
            this.listener = listener;
            this.request = request;
            this.response = response;
        }

        public AsyncListener getAsyncListener() {
            return this.listener;
        }

        public ServletRequest getRequest() {
            return this.request;
        }

        public ServletResponse getResponse() {
            return this.response;
        }
    }

    private static final class AsyncPoolThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final AtomicInteger counter = new AtomicInteger(0);

        private AsyncPoolThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = this.defaultFactory.newThread(r);
            t.setName("glassfish-web-async-thread-" + this.counter.incrementAndGet());
            return t;
        }
    }

    static class Handler
    implements Runnable {
        private final AsyncContextImpl asyncContext;
        private final ApplicationDispatcher dispatcher;
        private final Request origRequest;

        Handler(AsyncContextImpl asyncContext, ApplicationDispatcher dispatcher, Request origRequest) {
            this.asyncContext = asyncContext;
            this.dispatcher = dispatcher;
            this.origRequest = origRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.asyncContext.isStartAsyncInScope.set(Boolean.TRUE);
            this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
            this.origRequest.setAsyncStarted(false);
            int startAsyncCurrent = this.asyncContext.startAsyncCounter.get();
            try {
                this.dispatcher.dispatch(this.asyncContext.getRequest(), this.asyncContext.getResponse(), DispatcherType.ASYNC);
                if (this.asyncContext.startAsyncCounter.compareAndSet(startAsyncCurrent, startAsyncCurrent)) {
                    this.asyncContext.complete();
                }
            }
            catch (Throwable t) {
                this.asyncContext.notifyAsyncListeners(AsyncEventType.ERROR, t);
                this.asyncContext.getOriginalRequest().errorDispatchAndComplete(t);
            }
            finally {
                this.asyncContext.isStartAsyncInScope.set(Boolean.FALSE);
            }
        }
    }
}

