/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicAuthenticator
extends AuthenticatorBase {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$authenticator$BasicAuthenticator == null ? (class$org$apache$catalina$authenticator$BasicAuthenticator = BasicAuthenticator.class$("org.apache.catalina.authenticator.BasicAuthenticator")) : class$org$apache$catalina$authenticator$BasicAuthenticator));
    protected static final String info = "org.apache.catalina.authenticator.BasicAuthenticator/1.0";
    static /* synthetic */ Class class$org$apache$catalina$authenticator$BasicAuthenticator;

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        Principal principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            if (ssoId != null) {
                this.associate(ssoId, this.getSession(request, true));
            }
            return true;
        }
        if (ssoId != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SSO Id " + ssoId + " set; attempting " + "reauthentication"));
            }
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return true;
            }
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String authorization = request.getAuthorization();
        String username = this.parseUsername(authorization);
        String password = this.parsePassword(authorization);
        principal = this.context.getRealm().authenticate(username, password);
        if (principal != null) {
            this.register(request, response, principal, "BASIC", username, password);
            return true;
        }
        String realmName = config.getRealmName();
        if (realmName == null) {
            realmName = hreq.getServerName() + ":" + hreq.getServerPort();
        }
        hres.setHeader("WWW-Authenticate", "Basic realm=\"" + realmName + "\"");
        hres.setStatus(401);
        return false;
    }

    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.toLowerCase().startsWith("basic ")) {
            return null;
        }
        String unencoded = new String(Base64.decode((authorization = authorization.substring(6).trim()).getBytes()));
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String username = unencoded.substring(0, colon).trim();
        return username;
    }

    protected String parsePassword(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Basic ")) {
            return null;
        }
        String unencoded = new String(Base64.decode((authorization = authorization.substring(6).trim()).getBytes()));
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String password = unencoded.substring(colon + 1).trim();
        return password;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

