/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartDecorator;
import org.netbeans.lib.profiler.charts.axis.AxisMark;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.swing.Utils;

public class AxisComponent
extends JComponent {
    public static final int NO_MESH = 0;
    public static final int MESH_BACKGROUND = 1;
    public static final int MESH_FOREGROUND = 2;
    private final int location;
    private final boolean horizontal;
    private final ChartComponent chart;
    private final AxisMarksComputer marksComputer;
    private final AxisMarksPainter marksPainter;
    private int maxExtent = 0;
    private final Paint meshPaint = Utils.checkedColor(new Color(80, 80, 80, 50));
    private final Stroke meshStroke = new BasicStroke(1.0f);

    public AxisComponent(ChartComponent chartComponent, AxisMarksComputer axisMarksComputer, AxisMarksPainter axisMarksPainter, int n, int n2) {
        this.location = n;
        this.horizontal = n == 1 || n == 5;
        this.chart = chartComponent;
        this.marksComputer = axisMarksComputer;
        this.marksPainter = axisMarksPainter;
        this.setOpaque(false);
        chartComponent.addConfigurationListener(new ChartListener());
        if (n2 == 1) {
            chartComponent.addPreDecorator(this.createMeshPainter());
        } else if (n2 == 2) {
            chartComponent.addPostDecorator(this.createMeshPainter());
        }
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        final Dimension dimension = this.getPreferredSize();
        final int n = this.getAxisBasisExtent();
        Rectangle rectangle2 = SwingUtilities.convertRectangle(this.chart.getParent(), this.chart.getBounds(), this);
        if (this.horizontal) {
            rectangle2.y = rectangle.y;
            rectangle2.height = rectangle.height;
        } else {
            rectangle2.x = rectangle.x;
            rectangle2.width = rectangle.width;
        }
        if (this.marksComputer instanceof AxisMarksComputer.Abstract) {
            ((AxisMarksComputer.Abstract)this.marksComputer).refreshConfiguration();
        }
        this.paintAxis(graphics, rectangle, rectangle2);
        if (this.horizontal) {
            if (dimension.height < this.maxExtent + n) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        dimension.height = AxisComponent.this.maxExtent + n;
                        AxisComponent.this.setPreferredSize(dimension);
                        AxisComponent.this.invalidate();
                        ((JComponent)AxisComponent.this.getParent()).revalidate();
                        AxisComponent.this.getParent().repaint();
                    }
                });
            }
        } else if (dimension.width < this.maxExtent + n) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    dimension.width = AxisComponent.this.maxExtent + n;
                    AxisComponent.this.setPreferredSize(dimension);
                    AxisComponent.this.invalidate();
                    ((JComponent)AxisComponent.this.getParent()).revalidate();
                    AxisComponent.this.getParent().repaint();
                }
            });
        }
    }

    protected void paintAxisMesh(Graphics2D graphics2D, Rectangle rectangle, Rectangle rectangle2) {
        if (this.horizontal) {
            this.paintHorizontalMesh(graphics2D, rectangle, rectangle2);
        } else {
            this.paintVerticalMesh(graphics2D, rectangle, rectangle2);
        }
    }

    protected void paintHorizontalMesh(Graphics2D graphics2D, Rectangle rectangle, Rectangle rectangle2) {
        Iterator<AxisMark> iterator = this.marksComputer.marksIterator(rectangle2.x, rectangle2.x + rectangle2.width);
        while (iterator.hasNext()) {
            AxisMark axisMark = iterator.next();
            int n = axisMark.getPosition();
            graphics2D.setPaint(this.meshPaint);
            graphics2D.setStroke(this.meshStroke);
            graphics2D.drawLine(n, rectangle2.y, n, rectangle2.y + rectangle2.height);
        }
    }

    protected void paintVerticalMesh(Graphics2D graphics2D, Rectangle rectangle, Rectangle rectangle2) {
        Iterator<AxisMark> iterator = this.marksComputer.marksIterator(rectangle2.y, rectangle2.y + rectangle2.height);
        while (iterator.hasNext()) {
            AxisMark axisMark = iterator.next();
            int n = axisMark.getPosition();
            graphics2D.setPaint(this.meshPaint);
            graphics2D.setStroke(this.meshStroke);
            graphics2D.drawLine(rectangle2.x, n, rectangle2.x + rectangle2.width, n);
        }
    }

    protected void paintAxis(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        if (this.horizontal) {
            this.paintHorizontalAxis(graphics, rectangle, rectangle2);
        } else {
            this.paintVerticalAxis(graphics, rectangle, rectangle2);
        }
    }

    protected int getAxisBasisExtent() {
        return 5;
    }

    protected void paintHorizontalBasis(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        graphics.setColor(this.getForeground());
        if (this.location == 1) {
            graphics.drawLine(rectangle3.x - 1, this.getHeight() - 1, rectangle3.x + rectangle3.width, this.getHeight() - 1);
        } else {
            graphics.drawLine(rectangle3.x, 0, rectangle3.x + rectangle3.width, 0);
        }
    }

    protected void paintHorizontalTick(Graphics graphics, AxisMark axisMark, int n, Rectangle rectangle, Rectangle rectangle2) {
        graphics.setColor(this.getForeground());
        if (this.location == 1) {
            graphics.drawLine(n, this.getHeight() - 2 - this.getAxisBasisExtent(), n, this.getHeight() - 2);
        } else {
            graphics.drawLine(n, 1, n, 1 + this.getAxisBasisExtent());
        }
    }

    protected void paintHorizontalAxis(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        int n;
        this.paintHorizontalBasis(graphics, rectangle, rectangle2);
        int n2 = SwingUtilities.convertPoint((Component)this, (int)rectangle2.x, (int)0, (Component)this.chart).x - 1;
        int n3 = n2 + rectangle2.width + 2;
        Iterator<AxisMark> iterator = this.marksComputer.marksIterator(n2, n3);
        int n4 = this.chart.isRightBased() ? 0 : 1;
        int n5 = n = this.chart.isRightBased() ? 1 : 0;
        while (iterator.hasNext()) {
            AxisMark axisMark = iterator.next();
            int n6 = SwingUtilities.convertPoint((Component)this.chart, (int)axisMark.getPosition(), (int)0, (Component)this).x;
            if (n6 < rectangle2.x - n4 || n6 >= rectangle2.x + rectangle2.width + n) continue;
            Component component = this.marksPainter.getPainter(axisMark);
            component.setSize(component.getPreferredSize());
            int n7 = component.getHeight();
            int n8 = component.getWidth() / 2;
            if (n6 + n8 < rectangle.x || n6 - n8 >= rectangle.x + rectangle.width) continue;
            this.maxExtent = Math.max(this.maxExtent, n7);
            this.paintHorizontalTick(graphics, axisMark, n6, rectangle, rectangle2);
            graphics.setColor(this.getForeground());
            if (this.location == 1) {
                graphics.translate(n6 - n8, 0);
                component.paint(graphics);
                graphics.translate(-n6 + n8, 0);
                continue;
            }
            graphics.translate(n6 - n8, this.getAxisBasisExtent());
            component.paint(graphics);
            graphics.translate(-n6 + n8, -this.getAxisBasisExtent());
        }
    }

    protected void paintVerticalBasis(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        graphics.setColor(this.getForeground());
        if (this.location == 7) {
            graphics.drawLine(this.getWidth() - 1, rectangle2.y - 1, this.getWidth() - 1, rectangle2.y + rectangle2.height);
        } else {
            graphics.drawLine(0, rectangle2.y, 0, rectangle2.y + rectangle2.height);
        }
    }

    protected void paintVerticalTick(Graphics graphics, AxisMark axisMark, int n, Rectangle rectangle, Rectangle rectangle2) {
        graphics.setColor(this.getForeground());
        if (this.location == 7) {
            graphics.drawLine(this.getWidth() - 2 - this.getAxisBasisExtent(), n, this.getWidth() - 2, n);
        } else {
            graphics.drawLine(1, n, 1 + this.getAxisBasisExtent(), n);
        }
    }

    protected void paintVerticalAxis(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.paintVerticalBasis(graphics, rectangle, rectangle2);
        int n = SwingUtilities.convertPoint((Component)this, (int)0, (int)rectangle2.y, (Component)this.chart).y;
        int n2 = n + rectangle2.height;
        Iterator<AxisMark> iterator = this.marksComputer.marksIterator(n, n2);
        int n3 = this.chart.isBottomBased() ? 0 : 1;
        int n4 = this.chart.isBottomBased() ? 1 : 0;
        int n5 = this.maxExtent;
        while (iterator.hasNext()) {
            AxisMark axisMark = iterator.next();
            int n6 = SwingUtilities.convertPoint((Component)this.chart, (int)0, (int)axisMark.getPosition(), (Component)this).y;
            if (n6 < rectangle2.y - n3 || n6 >= rectangle2.y + rectangle2.height + n4) continue;
            Component component = this.marksPainter.getPainter(axisMark);
            component.setSize(component.getPreferredSize());
            int n7 = component.getWidth();
            int n8 = component.getHeight() / 2;
            if (n6 + n8 < rectangle.y || n6 - n8 >= rectangle.y + rectangle.height) continue;
            this.maxExtent = Math.max(this.maxExtent, n7);
            this.paintVerticalTick(graphics, axisMark, n6, rectangle, rectangle2);
            graphics.setColor(this.getForeground());
            if (this.location == 7) {
                graphics.translate(n5 - n7, n6 - n8);
                component.paint(graphics);
                graphics.translate(-n5 + n7, -n6 + n8);
                continue;
            }
            graphics.translate(this.getAxisBasisExtent(), n6 - n8);
            component.paint(graphics);
            graphics.translate(-this.getAxisBasisExtent(), -n6 + n8);
        }
    }

    private ChartDecorator createMeshPainter() {
        return new ChartDecorator(){

            public void paint(Graphics2D graphics2D, Rectangle rectangle, ChartContext chartContext) {
                AxisComponent.this.paintAxisMesh(graphics2D, rectangle, rectangle);
            }
        };
    }

    private class ChartListener
    extends ChartConfigurationListener.Adapter {
        private boolean updateAxis;

        private ChartListener() {
        }

        public void contentsWillBeUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4) {
            if (AxisComponent.this.marksComputer instanceof AxisMarksComputer.Abstract) {
                AxisMarksComputer.Abstract abstract_ = (AxisMarksComputer.Abstract)AxisComponent.this.marksComputer;
                this.updateAxis = abstract_.refreshConfiguration();
            } else {
                this.updateAxis = true;
            }
        }

        public void contentsUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4, int n, int n2) {
            if (!this.updateAxis) {
                if (AxisComponent.this.horizontal) {
                    this.updateAxis = n != 0 || l3 != l || d3 != d;
                } else {
                    boolean bl = this.updateAxis = n2 != 0 || l4 != l2 || d4 != d2;
                }
            }
            if (this.updateAxis) {
                AxisComponent.this.repaint();
            }
        }
    }
}

