/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundItemPainter
implements ItemPainter {
    private ItemPainter painter1;
    private ItemPainter painter2;

    public CompoundItemPainter(ItemPainter itemPainter, ItemPainter itemPainter2) {
        this.painter1 = itemPainter;
        this.painter2 = itemPainter2;
    }

    @Override
    public LongRect getItemBounds(ChartItem chartItem) {
        LongRect longRect = this.painter1.getItemBounds(chartItem);
        LongRect.add(longRect, this.painter2.getItemBounds(chartItem));
        return longRect;
    }

    @Override
    public LongRect getItemBounds(ChartItem chartItem, ChartContext chartContext) {
        LongRect longRect = this.painter1.getItemBounds(chartItem, chartContext);
        LongRect.add(longRect, this.painter2.getItemBounds(chartItem, chartContext));
        return longRect;
    }

    @Override
    public boolean isBoundsChange(ChartItemChange chartItemChange) {
        return this.painter1.isBoundsChange(chartItemChange) || this.painter2.isBoundsChange(chartItemChange);
    }

    @Override
    public boolean isAppearanceChange(ChartItemChange chartItemChange) {
        return this.painter1.isAppearanceChange(chartItemChange) || this.painter2.isAppearanceChange(chartItemChange);
    }

    @Override
    public LongRect getDirtyBounds(ChartItemChange chartItemChange, ChartContext chartContext) {
        LongRect longRect = this.painter1.getDirtyBounds(chartItemChange, chartContext);
        LongRect.add(longRect, this.painter2.getDirtyBounds(chartItemChange, chartContext));
        return longRect;
    }

    @Override
    public boolean supportsHovering(ChartItem chartItem) {
        return this.painter1.supportsHovering(chartItem) || this.painter2.supportsHovering(chartItem);
    }

    @Override
    public boolean supportsSelecting(ChartItem chartItem) {
        return this.painter1.supportsSelecting(chartItem) || this.painter2.supportsSelecting(chartItem);
    }

    @Override
    public LongRect getSelectionBounds(ItemSelection itemSelection, ChartContext chartContext) {
        LongRect longRect = this.painter1.supportsHovering(itemSelection.getItem()) ? this.painter1.getSelectionBounds(itemSelection, chartContext) : new LongRect();
        LongRect longRect2 = this.painter2.supportsHovering(itemSelection.getItem()) ? this.painter2.getSelectionBounds(itemSelection, chartContext) : new LongRect();
        LongRect.add(longRect, longRect2);
        return longRect;
    }

    @Override
    public ItemSelection getClosestSelection(ChartItem chartItem, int n, int n2, ChartContext chartContext) {
        ItemSelection itemSelection;
        ItemSelection itemSelection2 = this.painter1.supportsHovering(chartItem) ? this.painter1.getClosestSelection(chartItem, n, n2, chartContext) : null;
        ItemSelection itemSelection3 = itemSelection = this.painter2.supportsHovering(chartItem) ? this.painter2.getClosestSelection(chartItem, n, n2, chartContext) : null;
        if (itemSelection2 == null) {
            return itemSelection;
        }
        if (itemSelection == null) {
            return itemSelection2;
        }
        if (itemSelection2.getDistance() < itemSelection.getDistance()) {
            return itemSelection2;
        }
        return itemSelection;
    }

    @Override
    public void paintItem(ChartItem chartItem, List<ItemSelection> list, List<ItemSelection> list2, Graphics2D graphics2D, Rectangle rectangle, ChartContext chartContext) {
        this.painter1.paintItem(chartItem, list, list2, graphics2D, rectangle, chartContext);
        this.painter2.paintItem(chartItem, list, list2, graphics2D, rectangle, chartContext);
    }

    protected ItemPainter getPainter1() {
        return this.painter1;
    }

    protected ItemPainter getPainter2() {
        return this.painter2;
    }
}

